<?php
// Model.php


/** 
 * Parent class for all data models.
 *
 * @author Matthew Lindberg
 */
class Model
{
	// DataAccess
	var $da;
	
	// boolean
	var $is_loaded;
	
	// boolean - Has updated model data been saved to the database?
	var $is_saved;
	
	// boolean - Is the model data for an entry already existing in the database?
	var $is_existing;
	
	/**
	 * Constructor.
	 *
	 * @param $data_access DataAccess
	 * @access public
	 */
	function Model(& $data_access)
	{
		global $__CS;
		$__CS->EnterMethod("Model");
		$__CS->SendObject($data_access,"data_access");
		
		$this->da =& $data_access;
		
		$__CS->ExitMethod("Model");
	}
	
	/**
	 * Sets a table's field value.
	 *
	 * @param $table string 
	 * @param $field string
	 * @param $value
	 * @access public 
	 */
	function setData($table,$field,$value)
	{
		$this->fields[$table][$field] = $value;
	}
	
	/**
	 * Gets a table field's value.
	 *
	 * @param $table
	 * @param $field
	 * @access public
	 */
	function getDataValue($table,$field)
	{
		return $this->fields[$table][$field];
	}
	
	/**
	 * Checks whether the model is currently loaded with real values.  
	 *
	 * @access public
	 * @return boolean
	 */
	function isLoaded()
	{
		return $this->is_loaded;
	}
	
	/**
	 * Sets the model's load status.  This should be called in a model child class to keep 
	 * track of whether a model has been loaded or not.
	 *
	 * @param $load_status boolean
	 * @access public
	 */
	function setLoaded($load_status)
	{
		$this->is_loaded = $load_status;
	}
	
	
	/**
	 * Checks whether the data exisitng in the model has been saved to the 
	 * database or not.  Anytime an update is made to the model setSaved(true)
	 * should be called to make sure the state of the model is known.
	 *
	 * @access public
	 */
	function isSaved()
	{
		return $this->is_saved;
	}
	
	/**
	 * Sets the saved state of the model.
	 *
	 * @param $save_status boolean
	 * @access public
	 */
	function setSaved($save_status)
	{
		$this->is_saved = $save_status;
	}
	
	/**
	 * Checks whether the data existing in the model represents an entry already
	 * exsiting in the database.  Anytime a model is loaded with existing database information
	 * setExisting(true) should be called to make sure the state of the model is known.
	 *
	 * @access public
	 */
	function isExisting()
	{
		return $this->is_existing;
	}
	
	
	/**
	 * Sets the database existence state of the model.
	 *
	 * @param $exists_status boolean
	 * @access public
	 */
	function setExisting($exists_status)
	{
		$this->is_existing = $exists_status;
	}
	
	/**
	 * Sets all data types and default values for this model.
	 *
	 * @access public
	 */
	function init()
	{
		trigger_error(__ERROR.": Must override Model:init() in subclass");
	}
}
?>