<?php
// Form.php
include_once('core/base/FormInput.php');

/**
 * Parent class for all forms.
 *
 * @author Matthew Lindberg
 * @todo Implement saveToSession()
 * @todo Implement loadFromSession()
 */
class Form
{
	// Session
	var $sess;
	
	// Request
	var $request;
	
	// form field attributes
	var $fields; 		// Each form field is stored as 
						//( <field value>, <form sequence number>, <error flag>, <error message> )
						// Error flags are set to 0 if no error, 1 if error
	
	
	/**
	 * Constructor.
	 *
	 * @param $session Session
	 * @access public
	 */
	function Form(& $session, & $request)
	{
		global $__CS; 
		$__CS->EnterMethod("Form");
		$__CS->SendObject($session,"Session");
		$__CS->SendObject($request,"Request");
		
		$this->sess 	=& $session;
		$this->request 	=& $request;
		$this->fields	= array();
		
		$__CS->ExitMethod("Form");
	}
	
	/**
	 * Sets a new form field and value.
	 *
	 * @param $name string
	 * @param $value 
	 * @param $sequence_num int
	 * @access public
	 */
	function setField($name,$value,$sequence_num=1)
	{
		global $__CS; 
		$__CS->EnterMethod("setField");
		$__CS->SendVar($name,"name");
		$__CS->SendVar($value,"value");
		$__CS->SendVar($sequence_num,"sequence_num");
		
		$this->fields[$name] = array( $value,$sequence_num,0,"");
		
		$__CS->ExitMethod("setField");
	}
	
	/**
	 * Gets the form field value.
	 *
	 * @param $name string
	 * @access public
	 */
	function getField($name)
	{
		global $__CS; 
		$__CS->EnterMethod("getField");
		$__CS->SendVar($name,"name");
		
		if( !array_key_exists($name,$this->fields) ) {
			//trigger_error(__ERROR.": Field key ".$name." does not exist in Form");
		}
		
		$__CS->ExitMethod("getField");
		return $this->fields[$name];
	}
	
	/**
	 * Gets the value of a form field.
	 *
	 * @param $name string
	 * @access public
	 */
	function getFieldValue($name)
	{
		global $__CS; 
		$__CS->EnterMethod("getFieldValue");
		$__CS->SendVar($name,"name");
		
		$field = $this->getField($name);
		
		$__CS->ExitMethod("getFieldValue");
		return $field[0];
	}
	
	/**
	 * Gets the current 
	 *
	 * @param $field
	 * @access public
	 */
	function & getFormInput($field)
	{
		global $__CS; 
		$__CS->EnterMethod("getFormInput");
		$__CS->SendVar($field,"field");
		
		$data = $this->getField($field);
		
		$input =& new FormInput($field, $data[0]);
		
		$__CS->ExitMethod("getFormInput");
		return $input;
	}
	
	/**
	 * Loads the fields for a particular section of a form sequence from 
	 * a form submit request.
	 *
	 * @param $sequence_num integer
	 * @access public
	 */
	function loadFromRequest($sequence_num=1)
	{
		global $__CS; 
		$__CS->EnterMethod("loadFromRequest:Form");
		$__CS->SendVar($sequence_num,"sequence_num");
		
		foreach( $this->fields as $name => $field ) {
			$num = $field[1];
			if( $num == $sequence_num ) {
				$this->setField($name,$this->request->get($name),$sequence_num);
			}
		}
		
		$__CS->ExitMethod("loadFromRequest:Form");
	}
	
	/**
	 * Loads the fields for a particular section of a form sequence from a 
	 * stored session.
	 *
	 * @param $sequence_num integer
	 * @access public
	 */
	function loadFromSession($sequence_num=1)
	{
	}
	
	/**
	 * Saves the fields for a particular section of a form sequence from a stored 
	 * session.
	 *
	 */
	function saveToSession($sequence_num=1)
	{
	}
	
	
	/**
	 * Loads all default values for this form.
	 *
	 * @access public
	 */
	function init()
	{
		trigger_error(__ERROR."Form:init() must be overridden in subclass");
	}
	
	
	/**
	 * Loads a from from a model.
	 *
	 * @param $model Model
	 * @access public
	 */
	function loadFromModel(& $model)
	{
		trigger_error(__ERROR.": Must override loadFromModel() in subclass");
	}
}
?>