import java.applet.*;
import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.border.*;

public class FGOS
{  private static final int WIDTH = 800;
   private static final int HEIGHT = 600;
   private static boolean display_NOT_enabled = true;
   protected static File myfile;
   protected static AudioThread currentMidi;
   protected static MainScreen ms;
   protected static JPanel displayArea;
   protected static JTextArea infoArea;
   protected static Box infoBox;
   protected static String message;
   protected static JScrollPane infoScrollPane;

   protected static final JFrame frame = new JFrame( "A Fighting Game of Sorts" );

   public static void main( String[] args )
   {  frame.addWindowListener( new WindowAdapter()
      {  public void windowClosing( WindowEvent e )
         {  // Clean up
            System.gc();
            System.exit( 0 );
         }
      } );

      // Construct a new thread to process the midi's.
      try
      {  currentMidi = new AudioThread( myfile = new File( "Music" + File.separator + "Opening.mid" ) );
      }
      catch ( Exception e )
      {  e.printStackTrace();
      }

      // Start the audio thread.
      currentMidi.start();

      // Setup the frame for the game.
      frame.setUndecorated( true );
      frame.setBackground( Color.black );
      frame.setSize( WIDTH, HEIGHT );
      frame.setResizable( false );
      frame.getContentPane().add( new StartUp(), BorderLayout.CENTER );
      frame.setVisible( true );
      update();

      // Setup for display area and info area.
      displayArea = new JPanel();
      displayArea.setBackground( Color.black );
      displayArea.setBounds( 224, 35, 353, 239 );

      message = "";

      infoArea = new JTextArea();
      Font myfont = new Font("SansSerif", Font.PLAIN, 12 );
      infoArea.setFont( myfont );
      infoArea.setLineWrap( true );
      infoArea.setWrapStyleWord( true );
      infoArea.setFocusable( false );
      infoArea.setEditable( false );
      infoArea.setMinimumSize( new Dimension ( 365, 80 ) );

      infoScrollPane = new JScrollPane( infoArea, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_NEVER );
      infoScrollPane.setPreferredSize( new Dimension ( 365, 80 ) );

      infoBox = Box.createHorizontalBox();
      infoBox.setBackground( Color.black );
      infoBox.add( infoScrollPane );
      infoBox.setMinimumSize( new Dimension ( 365, 80 ) );
      infoBox.setPreferredSize( infoBox.getMinimumSize() );
      infoBox.setMaximumSize( infoBox.getMinimumSize() );
      infoBox.setBounds( 219, 317, 365, 80 );
   }

   protected static void update()
   {  try
      {  EventQueue.invokeLater( new Runnable()
         {  public void run()
            {  frame.validate();
               frame.repaint();
            }
         } );
      }
      catch ( Exception e )
      {  System.err.println( "There was an Exception ERROR while calling FGOS.update()!" );
      }
   }

   protected static boolean display_NOT_added()
   {  return display_NOT_enabled;
   }

   protected static void set_display_NOT_added( boolean value )
   {  display_NOT_enabled = value;
   }

   protected static void resetDisplay()
   {  displayArea = null;
      // Reset the display area and info box.
      displayArea = new JPanel();
      displayArea.setBackground( Color.black );
      displayArea.setBounds( 224, 35, 353, 239 );

      infoBox = Box.createHorizontalBox();
      infoBox.setBackground( Color.black );
      infoBox.add( infoScrollPane );
      infoBox.setMinimumSize( new Dimension ( 365, 80 ) );
      infoBox.setPreferredSize( infoBox.getMinimumSize() );
      infoBox.setMaximumSize( infoBox.getMinimumSize() );
      infoBox.setBounds( 219, 317, 365, 80 );
   }

   protected static void playNewSong( String songFileName )
   {  myfile = new File( "Music" + File.separator + songFileName );
      currentMidi.play( myfile );
   }
}

class AudioThread extends Thread
{  protected static AudioClip myclip;
   private volatile boolean exit = false;

   // Constructor
   public AudioThread( File myfile ) throws Exception
   {  // Setup and loop the music
      try
      {  myclip = java.applet.Applet.newAudioClip( myfile.toURL() );
      }
      catch ( Exception e )
      {  e.printStackTrace();
      }
   }

   // Implement the run() method of the Runnable interface.
   public void run()
   {  myclip.loop();
      while ( !exit )
      {  try
         {  this.sleep( 1000 * 1 );
         }
         catch ( Exception e )
         {  System.err.println( "There was an Exception ERROR while calling sleep in AudioThread!" );
         }
      }
   }

   protected void quit()
   {  myclip.stop();
   }

   protected void play( File myfile )
   {  quit();
      // Setup and loop the new music music
      try
      {  myclip = java.applet.Applet.newAudioClip( myfile.toURL() );
      }
      catch ( Exception e )
      {  e.printStackTrace();
      }
      myclip.loop();
   }
}

class StartUp extends JPanel implements ActionListener
{  private JLabel pictureLabel, creditsLabel, highScoreLabel;
   private JButton startNewGame, continueGame;
   private JComboBox saveSlots;
   private Box highScoreBox;

   public StartUp()
   {  GridBagLayout gbLayout = new GridBagLayout();
      GridBagConstraints c = new GridBagConstraints();
      setBackground( Color.black );
      setLayout( gbLayout );

      try
      {  // Setup the picture label
         pictureLabel = new JLabel( new ImageIcon( "Startup" + File.separator + "GOKU1.jpg" ) );
         c.weighty = 100.0;
         c.weightx = 100.0;
         c.gridx = 0;
         c.gridy = 0;
         c.gridwidth = 1;
         c.gridheight = 2;
         c.insets = new Insets( 5, 5, 0, 0 );
         c.fill = GridBagConstraints.NONE;
         c.anchor = GridBagConstraints.WEST;
         add( pictureLabel, c );

         creditsLabel = new JLabel( new ImageIcon( "Startup" + File.separator + "Credits1.gif" ) );
         c.weighty = 100.0;
         c.weightx = 100.0;
         c.gridx = 1;
         c.gridy = 0;
         c.gridwidth = 1;
         c.gridheight = 1;
         c.insets = new Insets( 0, 10, 0, 0 );
         c.fill = GridBagConstraints.NONE;
         c.anchor = GridBagConstraints.NORTH;
         add( creditsLabel, c );

         highScoreLabel = new JLabel( "The Top Ten Fighting Masters", SwingConstants.LEFT );
         Font myfont = new Font( "SansSerif", Font.BOLD, 14 );
         highScoreLabel.setBackground( Color.black );
         highScoreLabel.setForeground( Color.yellow );
         // Associate the font with the label
         highScoreLabel.setFont( myfont );
         highScoreLabel.setHorizontalAlignment( JLabel.CENTER );
         highScoreLabel.setVerticalAlignment( JLabel.CENTER );
         highScoreLabel.setVerticalTextPosition( JLabel.CENTER );
         highScoreLabel.setHorizontalTextPosition( JLabel.CENTER );
         highScoreLabel.setMaximumSize( highScoreLabel.getPreferredSize() );

         highScoreBox = Box.createVerticalBox();
         highScoreBox.setBackground( Color.black );
         highScoreBox.add( highScoreLabel );
         highScoreBox.add( Box.createVerticalStrut( 5 ) );

         BufferedReader in = new BufferedReader( new FileReader ( "HighScore" + File.separator + "HighScore.fgos" ) );
         String highScoreString;
         highScoreString = in.readLine();
         StringTokenizer tokenizedData = new StringTokenizer( highScoreString, "|" );
         boolean isReal = new Boolean( tokenizedData.nextToken() ).booleanValue();
         if ( isReal )
         {  JLabel[] row = new JLabel[ 10 ];
            int i = 0;
            myfont = new Font( "SansSerif", Font.BOLD, 12 );
            while ( tokenizedData.hasMoreTokens() )
            { row[ i ] = new JLabel();
              row[ i ].setBackground( Color.black );
              row[ i ].setForeground( Color.orange );
              // Associate the font with the label
              row[ i ].setFont( myfont );
              row[ i ].setText( tokenizedData.nextToken() + "     " + getRank( Integer.parseInt( tokenizedData.nextToken() ) ) );
              row[ i ].setHorizontalAlignment( JLabel.CENTER );
              row[ i ].setVerticalAlignment( JLabel.CENTER );
              row[ i ].setVerticalTextPosition( JLabel.CENTER );
              row[ i ].setHorizontalTextPosition( JLabel.CENTER );
              row[ i ].setMaximumSize( row[ i ].getPreferredSize() );
              highScoreBox.add( row[ i ] );
              highScoreBox.add( Box.createVerticalStrut( 5 ) );
              ++i;
            }
         }
         in.close();

         c.weighty = 100.0;
         c.weightx = 100.0;
         c.gridx = 2;
         c.gridy = 0;
         c.gridwidth = 1;
         c.gridheight = 2;
         c.insets = new Insets( 0, 5, 10, 0 );
         c.fill = GridBagConstraints.NONE;
         c.anchor = GridBagConstraints.NORTH;
         add( highScoreBox, c );

         startNewGame = new JButton( "Start a New Game" );
         myfont = new Font( "SansSerif", Font.BOLD, 16 );
         startNewGame.setBackground( Color.black );
         startNewGame.setForeground( Color.yellow );
         // Associate the font with the JButton
         startNewGame.setFont( myfont );
         startNewGame.setBorderPainted( false );
         startNewGame.setMnemonic( KeyEvent.VK_S );
         startNewGame.setActionCommand( "New" );
         startNewGame.setMaximumSize( startNewGame.getPreferredSize() );

         Box startBox = Box.createHorizontalBox();
         startBox.setBackground( Color.black );
         startBox.add( startNewGame );

         continueGame = new JButton( "Continue Existing Game" );
         //myfont = new Font( "SansSerif", Font.BOLD, 16 );
         continueGame.setBackground( Color.black );
         continueGame.setForeground( Color.orange );
         // Associate the font with the JButton
         continueGame.setFont( myfont );
         continueGame.setBorderPainted( false );
         continueGame.setMnemonic( KeyEvent.VK_C );
         continueGame.setActionCommand( "Continue" );
         continueGame.setEnabled( false );
         continueGame.setMaximumSize( continueGame.getPreferredSize() );

         Box continueBox = Box.createHorizontalBox();
         continueBox.setBackground( Color.black );
         continueBox.add( continueGame );

         saveSlots = new JComboBox();
         saveSlots.setEditable( false );
         enableSlots();
         saveSlots.setMaximumSize( new Dimension( 86, 30 ) );

         Box slotBox = Box.createHorizontalBox();
         slotBox.setBackground( Color.black );
         slotBox.add( saveSlots );

         startNewGame.setToolTipText( "Click this button to start a new game." );
         continueGame.setToolTipText( "Click this button to continue an existing game." );
         saveSlots.setToolTipText( "Use this to select the saved game to continue." );

         startNewGame.addActionListener( this );
         continueGame.addActionListener( this );

         Box choiceBox = Box.createVerticalBox();
         choiceBox.setBackground( Color.black );
         choiceBox.add( startBox );
         choiceBox.add( continueBox );
         choiceBox.add( slotBox );
         c.weighty = 100.0;
         c.weightx = 100.0;
         c.gridx = 1;
         c.gridy = 1;
         c.gridwidth = 1;
         c.gridheight = 1;
         c.insets = new Insets( 0, 0, 0, 0 );
         c.fill = GridBagConstraints.NONE;
         c.anchor = GridBagConstraints.CENTER;
         add( choiceBox, c );
      }
      catch ( Exception e )
      {  e.printStackTrace();
      }
   }

   private void enableSlots()
   {  boolean slot1Exists = false, slot2Exists = false, slot3Exists = false;
      try
      {  BufferedReader in = new BufferedReader( new FileReader ( "SaveScreen" + File.separator + "SaveSlot1.fgos" ) );
         String data1;
         data1 = in.readLine();
         StringTokenizer tokenizedData = new StringTokenizer( data1, "|" );
         boolean isReal = new Boolean( tokenizedData.nextToken() ).booleanValue();
         slot1Exists = isReal;
         in.close();

         in = new BufferedReader( new FileReader ( "SaveScreen" + File.separator + "SaveSlot2.fgos" ) );
         String data2;
         data2 = in.readLine();
         tokenizedData = new StringTokenizer( data2, "|" );
         isReal = new Boolean( tokenizedData.nextToken() ).booleanValue();
         slot2Exists = isReal;
         in.close();

         in = new BufferedReader( new FileReader ( "SaveScreen" + File.separator + "SaveSlot3.fgos" ) );
         String data3;
         data3 = in.readLine();
         tokenizedData = new StringTokenizer( data3, "|" );
         isReal = new Boolean( tokenizedData.nextToken() ).booleanValue();
         slot3Exists = isReal;
         in.close();
      }
      catch ( Exception e )
      {  e.printStackTrace();
      }
      if( slot1Exists )
      {  saveSlots.addItem( "Slot 1" );
         continueGame.setEnabled( true );
      }
      if ( slot2Exists )
      {  saveSlots.addItem( "Slot 2" );
         continueGame.setEnabled( true );
      }
      if ( slot3Exists )
      {  saveSlots.addItem( "Slot 3" );
         continueGame.setEnabled( true );
      }
   }

   public void actionPerformed( ActionEvent e )
   {  if ( e.getActionCommand().equals( "New" ) )
      {  FGOS.frame.getContentPane().add( new CharacterCreation(), BorderLayout.CENTER );
         FGOS.frame.getContentPane().remove( this );
         FGOS.update();
      }
      else if ( e.getActionCommand().equals( "Continue" ) )
      {  String choice = ( String )saveSlots.getSelectedItem();
         loadGame( choice );
      }
   }

   private void loadGame( String name )
   {  if ( name.equals( "Slot 1" ) )
      {  try
         {  File temp = new File(  "SaveScreen" + File.separator + "SaveSlot1.fgos" );
            FGOS.ms = new MainScreen( temp );
            FGOS.frame.getContentPane().add( FGOS.ms, BorderLayout.CENTER );
            FGOS.frame.getContentPane().remove( this );
            FGOS.update();
         }
         catch ( Exception e )
         {  e.printStackTrace();
         }
      }
      else if ( name.equals( "Slot 2" ) )
      {  try
         {  File temp = new File(  "SaveScreen" + File.separator + "SaveSlot2.fgos" );
            FGOS.ms = new MainScreen( temp );
            FGOS.frame.getContentPane().add( FGOS.ms, BorderLayout.CENTER );
            FGOS.frame.getContentPane().remove( this );
            FGOS.update();
         }
         catch ( Exception e )
         {  e.printStackTrace();
         }
      }
      else if ( name.equals( "Slot 3" ) )
      {  try
         {  File temp = new File(  "SaveScreen" + File.separator + "SaveSlot3.fgos" );
            FGOS.ms = new MainScreen( temp );
            FGOS.frame.getContentPane().add( FGOS.ms, BorderLayout.CENTER );
            FGOS.frame.getContentPane().remove( this );
            FGOS.update();
         }
         catch ( Exception e )
         {  e.printStackTrace();
         }
      }
      else
      {  System.err.println( "An error has occured while loading the saved game." );
      }
   }

   private String getRank( int rank )
   {  if ( rank == 0 )
      {  return "Wimp!";
      }
      else if ( rank == 1 )
      {  return "Lucky Punk!";
      }
      else if ( rank == 2 )
      {  return "Thug!";
      }
      else if ( rank == 3 )
      {  return "Novice!";
      }
      else if ( rank == 4 )
      {  return "Initiate!";
      }
      else if ( rank == 5 )
      {  return "Adept!";
      }
      else if ( rank == 6 )
      {  return "Expert!";
      }
      else if ( rank == 7 )
      {  return "Specialist!";
      }
      else if ( rank == 8 )
      {  return "Master!";
      }
      else if ( rank == 9 )
      {  return "Grand Master!";
      }
      else if ( rank == 10 )
      {  return "Supreme Grand Master!";
      }
      else
      {  return "ERROR!";
      }
   }
}

class CharacterCreation extends JPanel implements ActionListener
{   private WholeNumberTextField strengthField, enduranceField, dexterityField, speedField, skillField, attacksField, eStrengthField;
    private JCheckBox x2, x3, x4;
    private static JTextField name, ccpLeft;
    private JPasswordField cheatCode;
    private JButton enabled, accept, restart;
    private static int ccp, startingCCP;
    private boolean cheater;
    private static boolean firstCall = true;

    CharacterCreation()
    {  cheater = false;

       if( firstCall )
       {  CCPRoller ccpTotal = new CCPRoller();
          ccp = ccpTotal.getResult();
          startingCCP = ccp;
          FGOS.playNewSong( "CharacterCreation.mid" );
       }

       setLayout( null );

       name = new JTextField( "Goku", 15 );
       name.setBackground( Color.white );
       name.setBounds( 198, 227, 135, 16 );
       name.addFocusListener( new FocusListener()
       {  public void focusGained( FocusEvent evt )
          {
          }
          public void focusLost( FocusEvent evt )
          {  if ( evt.isTemporary() )
             {  return;
             }
             else if ( name.getText().trim().length() > 6 )
             {  name.setText( "Goku" );
                name.requestFocus();
                JOptionPane.showMessageDialog( FGOS.frame, "The name for your character cannot be longer than 6 characters.", "Alert", JOptionPane.ERROR_MESSAGE );
             }
             else if ( name.getText().trim().length() < 1 )
             {  name.setText( "Goku" );
                name.requestFocus();
                JOptionPane.showMessageDialog( FGOS.frame, "You must pick a name for your character!", "Alert", JOptionPane.ERROR_MESSAGE );
             }
             name.setText( " " + name.getText() + " " );
             StringTokenizer tokenizer = new StringTokenizer( name.getText(), "|" );
             if ( tokenizer.countTokens() > 1 )
             {  name.setText( "Goku" );
                name.requestFocus();
                JOptionPane.showMessageDialog( FGOS.frame, "The name for your character cannot contain any \"|\".", "Alert", JOptionPane.ERROR_MESSAGE );
             }
             name.setText( name.getText().trim() );
          }
       }
       );

       ccpLeft = new JTextField( "" + ccp, 3 );
       ccpLeft.setEditable( false );
       ccpLeft.setFocusable( false );
       ccpLeft.setBackground( Color.white );
       ccpLeft.setBounds( 120, 248, 22, 19 );

       strengthField = new WholeNumberTextField( 1, 3 );
       strengthField.setBackground( Color.white );
       strengthField.setBounds( 152, 298, 29, 19 );
       strengthField.addFocusListener( new MyFocusListener() );

       enduranceField = new WholeNumberTextField( 1, 3 );
       enduranceField.setBackground( Color.white );
       enduranceField.setBounds( 152, 322, 29, 19 );
       enduranceField.addFocusListener( new MyFocusListener() );

       dexterityField = new WholeNumberTextField( 1, 3 );
       dexterityField.setBackground( Color.white );
       dexterityField.setBounds( 152, 346, 29, 19 );
       dexterityField.addFocusListener( new MyFocusListener() );

       speedField = new WholeNumberTextField( 1, 3 );
       speedField.setBackground( Color.white );
       speedField.setBounds( 152, 371, 29, 19 );
       speedField.addFocusListener( new MyFocusListener() );

       skillField = new WholeNumberTextField( 1, 3 );
       skillField.setBackground( Color.white );
       skillField.setBounds( 152, 395, 29, 19 );
       skillField.addFocusListener( new MyFocusListener() );

       attacksField = new WholeNumberTextField( 1, 3 );
       attacksField.setBackground( Color.white );
       attacksField.setBounds( 152, 418, 29, 19 );
       attacksField.addFocusListener( new MyFocusListener() );

       eStrengthField = new WholeNumberTextField( 1, 3 );
       eStrengthField.setBackground( Color.white );
       eStrengthField.setBounds( 281, 460, 31, 18 );
       eStrengthField.addFocusListener( new MyFocusListener() );

       x2 = new JCheckBox();
       x3 = new JCheckBox();
       x4 = new JCheckBox();
       x2.setBounds( 25, 516, 27, 15 );
       x2.setBackground( Color.white );
       x2.setActionCommand( "x2" );
       x2.addActionListener( this );
       x3.setBounds( 25, 542, 27, 15 );
       x3.setBackground( Color.white );
       x3.setActionCommand( "x3" );
       x3.addActionListener( this );
       x4.setBounds( 25, 567, 27, 15 );
       x4.setBackground( Color.white );
       x4.setActionCommand( "x4" );
       x4.addActionListener( this );

       cheatCode = new JPasswordField( "", 15 );
       cheatCode.setBackground( Color.white );
       cheatCode.setEchoChar( '*' );
       cheatCode.setBounds( 545, 469, 124, 23 );

       enabled = new JButton( new ImageIcon( "CharacterCreation" + File.separator + "enabled.jpg" ) );
       enabled.setPressedIcon( new ImageIcon( "CharacterCreation" + File.separator + "enabledPressed.jpg" ) );
       enabled.setMnemonic( KeyEvent.VK_E );
       enabled.setActionCommand( "Enabled" );
       enabled.setBounds( 677, 468, 104, 27 );
       enabled.addActionListener( this );

       accept = new JButton( new ImageIcon( "CharacterCreation" + File.separator + "accept.jpg" ) );
       accept.setPressedIcon( new ImageIcon( "CharacterCreation" + File.separator + "acceptPressed.jpg" ) );
       accept.setMnemonic( KeyEvent.VK_A );
       accept.setActionCommand( "Accept" );
       accept.setBounds( 416, 515, 177, 68 );
       accept.addActionListener( this );

       restart = new JButton( new ImageIcon( "CharacterCreation" + File.separator + "restart.jpg" ) );
       restart.setPressedIcon( new ImageIcon( "CharacterCreation" + File.separator + "restartPressed.jpg" ) );
       restart.setMnemonic( KeyEvent.VK_R );
       restart.setActionCommand( "Restart" );
       restart.setBounds( 609, 515, 173, 68 );
       restart.addActionListener( this );

       name.setToolTipText( "Enter the name for your character here.  Your name can be a maximum of 6 characters in length." );
       ccpLeft.setToolTipText( "This is number of CCPs you have left to spend." );
       strengthField.setToolTipText( "Strength is a primary determinate of the damage done with physical attacks.  It rates how strong your character is." );
       enduranceField.setToolTipText( "Endurance is used to resist damage.  It rates how tough your character is." );
       dexterityField.setToolTipText( "Dexterity is used to dodge attacks, and it also helps with aiming distance attacks.  It rates your character's reflexes and hand-eye coordination." );
       speedField.setToolTipText( "Speed is used to determine when your character gets to go.  It rates how fast your character is." );
       skillField.setToolTipText( "Skill is used for attack and defending.  It rates how skilled a martial artist your character is." );
       attacksField.setToolTipText( "# Attacks determines the base number of attacks your character has." );
       eStrengthField.setToolTipText( "Your Energy Attack Strength helps to determine the damage done by your energy attacks." );
       x2.setToolTipText( "Check this to purchase a two hit combo." );
       x3.setToolTipText( "Check this to purchase a three hit combo." );
       x4.setToolTipText( "Check this to purchase a four hit combo." );
       cheatCode.setToolTipText( "Enter the cheat code here." );
       enabled.setToolTipText( "Click this button to enabled the cheat code." );
       accept.setToolTipText( "Click this button to accept this character and continue." );
       restart.setToolTipText( "Click this button to start over." );

       JLabel background = new JLabel( new ImageIcon( "CharacterCreation" + File.separator + "background.jpg" ) );
       background.setBounds( 0, 0, 800, 600 );

       add( name );
       add( ccpLeft );
       add( strengthField );
       add( enduranceField );
       add( dexterityField );
       add( speedField );
       add( skillField );
       add( attacksField );
       add( eStrengthField );
       add( x2 );
       add( x3 );
       add( x4 );
       add( cheatCode );
       add( enabled );
       add( accept );
       add( restart );
       add( background );
       try
       {  EventQueue.invokeLater( new Runnable()
          {  public void run()
             {  name.requestFocus();
             }
          } );
       }
       catch ( Exception e )
       {  System.err.println( "There was an Exception ERROR while calling name.requestFocus()!" );
       }
    }
    /**
    Finalize the character by storing the values chosen.
    */
    private File finalizeCharacter()
    {  File temp = null;
       try
       {  int strength = Integer.parseInt( strengthField.getText().trim() );
          int endurance = Integer.parseInt( enduranceField.getText().trim() );
          int dexterity = Integer.parseInt( dexterityField.getText().trim() );
          int speed = Integer.parseInt( speedField.getText().trim() );
          int skill = Integer.parseInt( skillField.getText().trim() );
          int attacks = Integer.parseInt( attacksField.getText().trim() );
          int eStrength = Integer.parseInt( eStrengthField.getText().trim() );
          boolean hasx2 = x2.isSelected();
          boolean hasx3 = x3.isSelected();
          boolean hasx4 = x4.isSelected();
          int powerLevel = 0;
          if ( cheater )
          {  powerLevel = 1;
          }
          DiceRoller bones = new DiceRoller( endurance, true );
          int healthPoints = ( 100 + endurance + bones.getResult() );
          bones.rollDice( skill, true );
          int energyPoints = ( 33 + bones.getResult() );
          int stage = 1;
          String characterName = name.getText().trim();
          String theCharacter = ( "" + true + "|" + stage + "|" + characterName + "|" + healthPoints + "|" + energyPoints + "|" + powerLevel + "|" + strength + "|" + endurance + "|" + dexterity + "|" + speed + "|" + skill + "|" + attacks + "|" + eStrength + "|" + hasx2 + "|" + hasx3 + "|" + hasx4 );

          FileOutputStream myfile = new FileOutputStream( "CharacterCreation" + File.separator + "temp.fgos" );
          myfile.close();
          temp = new File( "CharacterCreation" + File.separator + "temp.fgos" );
          PrintWriter out = new PrintWriter( new FileWriter( temp ), true );
          out.println( theCharacter );
          out.close();
       }
       catch ( Exception e )
       {  // don't finalize the character if the input can't be parsed.
          e.printStackTrace();
       }
       return temp;
    }

    public void actionPerformed(ActionEvent e)
    {  if ( e.getActionCommand().equals( "Accept" ) )
       {  if ( ccp == 0 )
          {  FGOS.frame.getContentPane().add( new SaveScreen( finalizeCharacter() ), BorderLayout.CENTER );
             FGOS.frame.getContentPane().remove( this );
             FGOS.update();
          }
          else
          {  JOptionPane.showMessageDialog( FGOS.frame, "You must spend all of your CCPs before continuing.", "Alert", JOptionPane.ERROR_MESSAGE );
          }
       }
       else if ( e.getActionCommand().equals( "Restart" ) )
       {  firstCall = false;
          int num = startingCCP;
          FGOS.frame.getContentPane().remove( this );
          FGOS.frame.getContentPane().add( new CharacterCreation(), BorderLayout.CENTER );
          setCCP( num );
       }
       else if ( e.getActionCommand().equals( "Enabled" ) )
       {  char temp[] = cheatCode.getPassword();
          String tempString = new String( temp );

          if ( "Mark, I am your brother!".equals( tempString ) )
          {   cheater = true;
              int num = getCCP();
              num += 12;
              enabled.setEnabled( false );
              JOptionPane.showMessageDialog( FGOS.frame, "The cheat code has been enabled.", "Cheat Code Accepted", JOptionPane.PLAIN_MESSAGE );
              setCCP( num );
          }
          else
          {  JOptionPane.showMessageDialog( FGOS.frame, "Invalid cheat code.  The cheat code is not enabled.", "Alert", JOptionPane.ERROR_MESSAGE );
          }
       }
       else if ( e.getActionCommand().equals( "x2" ) )
       {  if ( x2.isSelected() )
          {  if ( ccp < 2 )
             {  x2.setSelected( false );
                // Regain the focus
                x2.requestFocus();
                JOptionPane.showMessageDialog( FGOS.frame, "You don't have the two CCPs it takes to purchase this combo. ", "Alert", JOptionPane.ERROR_MESSAGE );
             }
             else
             {  ccp -= 2;
                setCCP( ccp );
             }
          }
          else
          {  ccp += 2;
             setCCP( ccp );
          }
       }
       else if ( e.getActionCommand().equals( "x3" ) )
       {  if ( x3.isSelected() )
          {  if ( ccp < 3 )
             {  x3.setSelected( false );
                // Regain the focus
                x3.requestFocus();
                JOptionPane.showMessageDialog( FGOS.frame, "You don't have the three CCPs it takes to purchase this combo. ", "Alert", JOptionPane.ERROR_MESSAGE );
             }
             else
             {  ccp -= 3;
                setCCP( ccp );
             }
          }
          else
          {  ccp += 3;
             setCCP( ccp );
          }
       }
       else if ( e.getActionCommand().equals( "x4" ) )
       {  if ( x4.isSelected() )
          {  if ( ccp < 4 )
             {  x4.setSelected( false );
                // Regain the focus
                x4.requestFocus();
                JOptionPane.showMessageDialog( FGOS.frame, "You don't have the four CCPs it takes to purchase this combo. ", "Alert", JOptionPane.ERROR_MESSAGE );
             }
             else
             {  ccp -= 4;
                setCCP( ccp );
             }
          }
          else
          {  ccp += 4;
             setCCP( ccp );
          }
       }
    }

    protected static int getCCP()
    {  return ccp;
    }

    protected static void setCCP( int num )
    {  ccp = num;
       ccpLeft.setText( "" + ccp );
       FGOS.update();
    }
}

class MyFocusListener extends FocusAdapter
{  private int entered, exited;
   private JTextComponent copy;

   public void focusGained( FocusEvent evt )
   {  final JTextComponent c = ( JTextComponent )evt.getSource();
      int rating = Integer.parseInt( c.getText().trim() );
      entered = rating;
   }

   public void focusLost( FocusEvent evt )
   {  if ( evt.isTemporary() )
      {  return;
      }

      final JTextComponent c = ( JTextComponent )evt.getSource();
      int rating = Integer.parseInt( c.getText().trim() );
      exited = rating;
      int change = entered - exited;
      if ( change == 0 )
      {  return;
      }

      copy = c;
      int ccp = CharacterCreation.getCCP();

      int cost = cost( exited ) - cost( entered );
      ccp -= cost;
      if( ccp < 0 )
      {  c.setText( "" + entered );
         showError( 1 );
         return;
      }
      else if ( rating == 0 )
      {  c.setText( "" + entered );
         showError( 0 );
         return;
      }
      else if ( rating > 9 )
      {  c.setText( "" + entered );
         showError( 2 );
         return;
      }
      else
      {  CharacterCreation.setCCP( ccp );
         return;
      }
   }

   private void showError( int num )
   {  // Create and display an error message
      if ( num == 0 )
      {  // Regain the focus
         copy.requestFocus();
         JOptionPane.showMessageDialog( FGOS.frame, "The minimum value is one.", "Alert", JOptionPane.ERROR_MESSAGE );
      }
      else if ( num == 1 )
      {  // Regain the focus
         copy.requestFocus();
         JOptionPane.showMessageDialog( FGOS.frame, "You don't have enough CCPs left to purchase a rating of " + exited + ".", "Alert", JOptionPane.ERROR_MESSAGE );
      }
      else if ( num == 2 )
      {  // Regain the focus
         copy.requestFocus();
         JOptionPane.showMessageDialog( FGOS.frame, "The maximum rating is nine, therefore you can't possibly have enough CCPs left to purchase a rating of " + exited + ".", "Alert", JOptionPane.ERROR_MESSAGE );
      }
      else
      {  JOptionPane.showMessageDialog( FGOS.frame, "An unknown error has occured.", "Error", JOptionPane.ERROR_MESSAGE );
      }
   }

   private int cost( int rate )
   {  if ( rate == 0 || rate == 1 )
      {  return 0;
      }
      else if ( rate == 2 )
      {  return 1;
      }
      else if ( rate == 3 )
      {  return 3;
      }
      else if ( rate == 4 )
      {  return 6;
      }
      else if ( rate == 5 )
      {  return 10;
      }
      else if ( rate == 6 )
      {  return 15;
      }
      else if ( rate == 7 )
      {  return 21;
      }
      else if ( rate == 8 )
      {  return 28;
      }
      else if ( rate == 9 )
      {  return 36;
      }
      else
      {  return 0;
      }
   }
}

class SaveScreen extends JPanel implements ActionListener
{  private JTextField hp, ep, pl, strength, endurance, dexterity, speed, skill, attacks;
   private boolean charHasBeenSaved, slot1Exists, slot2Exists, slot3Exists, isReal, has_x2, has_x3, has_x4;
   private int base_attacks, eStrength, nextStage;
   private JButton continueGame, saveGame;
   private JComboBox saveSlots;
   private Font myfont;
   private String currentGameString, name;
   private File currentGame;
   private JLabel backgroundPic, gokuFace;

   SaveScreen( File saveFile )
   {  // Clean up
      System.gc();

      if ( FGOS.display_NOT_added() )
      {  add( FGOS.displayArea );
         add( FGOS.infoBox );
         FGOS.set_display_NOT_added( false );
      }

      FGOS.playNewSong( "Save.mid" );

      charHasBeenSaved = false;
      currentGame = saveFile;

      setLayout( null );
      setBackground( Color.black );

      try
      {  BufferedReader in = new BufferedReader( new FileReader( saveFile ) );
         String data = in.readLine();
         currentGameString = data;
         StringTokenizer tokenizedData = new StringTokenizer( data, "|" );
         isReal = new Boolean( tokenizedData.nextToken() ).booleanValue();
         nextStage = Integer.parseInt( tokenizedData.nextToken() );
         name = tokenizedData.nextToken();
         hp = new JTextField( "" + tokenizedData.nextToken(), 10 );
         ep = new JTextField( "" + tokenizedData.nextToken(), 10 );
         pl = new JTextField( "" + tokenizedData.nextToken(), 3 );
         strength = new JTextField( "" + tokenizedData.nextToken(), 3 );
         endurance = new JTextField( "" + tokenizedData.nextToken(), 3 );
         dexterity = new JTextField( "" + tokenizedData.nextToken(), 3 );
         speed = new JTextField( "" + tokenizedData.nextToken(), 3 );
         skill = new JTextField( "" + tokenizedData.nextToken(), 3 );
         attacks = new JTextField( "" + tokenizedData.nextToken(), 8 );
         eStrength = Integer.parseInt( tokenizedData.nextToken() );
         has_x2 = new Boolean( tokenizedData.nextToken() ).booleanValue();
         has_x3 = new Boolean( tokenizedData.nextToken() ).booleanValue();
         has_x4 = new Boolean( tokenizedData.nextToken() ).booleanValue();
         in.close();

         in = new BufferedReader( new FileReader ( "SaveScreen" + File.separator + "SaveSlot1.fgos" ) );
         String data1;
         data1 = in.readLine();
         tokenizedData = new StringTokenizer( data1, "|" );
         isReal = new Boolean( tokenizedData.nextToken() ).booleanValue();
         slot1Exists = isReal;
         in.close();

         in = new BufferedReader( new FileReader ( "SaveScreen" + File.separator + "SaveSlot2.fgos" ) );
         String data2;
         data2 = in.readLine();
         tokenizedData = new StringTokenizer( data2, "|" );
         isReal = new Boolean( tokenizedData.nextToken() ).booleanValue();
         slot2Exists = isReal;
         in.close();

         in = new BufferedReader( new FileReader ( "SaveScreen" + File.separator + "SaveSlot3.fgos" ) );
         String data3;
         data3 = in.readLine();
         tokenizedData = new StringTokenizer( data3, "|" );
         isReal = new Boolean( tokenizedData.nextToken() ).booleanValue();
         slot3Exists = isReal;
         in.close();
      }
      catch ( Exception e )
      {  e.printStackTrace();
      }

      if ( nextStage > 5 )
      {  gokuFace = new JLabel( new ImageIcon( "SaveScreen" + File.separator + "SGokuFace.gif" ) );
      }
      else
      {  gokuFace = new JLabel( new ImageIcon( "SaveScreen" + File.separator + "GokuFace.gif" ) );
      }
      gokuFace.setBounds( 123, 327, 50, 50 );

      base_attacks = ( Integer.parseInt( pl.getText().trim() ) + Integer.parseInt( attacks.getText().trim() ) );

      /*
      100%
      green on black
      66%
      yellow on black
      33%
      red on black
      0
      black on white
      */
      hp.setEditable( false );
      hp.setFocusable( false );
      hp.setBackground( Color.black );
      hp.setForeground( Color.green );
      hp.setBounds( 81, 334, 28, 18 );

      ep.setEditable( false );
      ep.setFocusable( false );
      ep.setBackground( Color.black );
      ep.setForeground( Color.green );
      ep.setBounds( 81, 358, 28, 18 );

      pl.setEditable( false );
      pl.setFocusable( false );
      pl.setBackground( Color.black );
      pl.setForeground( Color.green );
      pl.setBounds( 144, 389, 28, 18 );

      strength.setEditable( false );
      strength.setFocusable( false );
      strength.setBackground( Color.black );
      strength.setForeground( Color.white );
      strength.setBounds( 144, 419, 28, 18 );

      endurance.setEditable( false );
      endurance.setFocusable( false );
      endurance.setBackground( Color.black );
      endurance.setForeground( Color.white );
      endurance.setBounds( 144, 443, 28, 18 );

      dexterity.setEditable( false );
      dexterity.setFocusable( false );
      dexterity.setBackground( Color.black );
      dexterity.setForeground( Color.white );
      dexterity.setBounds( 144, 467, 28, 18 );

      speed.setEditable( false );
      speed.setFocusable( false );
      speed.setBackground( Color.black );
      speed.setForeground( Color.white );
      speed.setBounds( 144, 491, 28, 18 );

      skill.setEditable( false );
      skill.setFocusable( false );
      skill.setBackground( Color.black );
      skill.setForeground( Color.white );
      skill.setBounds( 144, 515, 28, 18 );

      attacks.setText( "" + base_attacks );
      attacks.setEditable( false );
      attacks.setFocusable( false );
      attacks.setBackground( Color.black );
      attacks.setForeground( Color.green );
      attacks.setBounds( 144, 539, 28, 18 );

      FGOS.message += ( "\n" + name + ", before proceeding to stage " + nextStage + " perhaps you should save the game.\n\n\n" );
      FGOS.infoArea.setText( FGOS.message );
      FGOS.infoScrollPane.getViewport().setViewPosition( new Point ( 10000000, 10000000 ) );
      FGOS.update();

      saveGame = new JButton( "Save Game" );
      saveGame.setBackground( Color.black );
      saveGame.setForeground( Color.red.brighter().brighter().brighter() );
      myfont = new Font( "SansSerif", Font.BOLD, 20 );
      saveGame.setFont( myfont );
      saveGame.setBorderPainted( false );
      saveGame.setMnemonic( KeyEvent.VK_S );
      saveGame.setActionCommand( "Save" );
      saveGame.setMaximumSize( saveGame.getPreferredSize() );
      saveGame.addActionListener( this );

      Box saveBox = Box.createHorizontalBox();
      saveBox.setBackground( Color.black );
      saveBox.add( saveGame );

      continueGame = new JButton( "  Continue  " );
      continueGame.setBackground( Color.black );
      continueGame.setForeground( Color.orange );
      continueGame.setFont( myfont );
      continueGame.setBorderPainted( false );
      continueGame.setMnemonic( KeyEvent.VK_C );
      continueGame.setActionCommand( "Continue" );
      continueGame.setMaximumSize( saveGame.getPreferredSize() );
      continueGame.addActionListener( this );

      Box continueBox = Box.createHorizontalBox();
      continueBox.setBackground( Color.black );
      continueBox.add( continueGame );

      saveSlots = new JComboBox();
      saveSlots.setEditable( false );
      saveSlots.addItem( "Slot 1" );
      saveSlots.addItem( "Slot 2" );
      saveSlots.addItem( "Slot 3" );
      saveSlots.setMaximumSize( new Dimension( 86, 30 ) );

      Box saveSlotsBox = Box.createHorizontalBox();
      saveSlotsBox.setBackground( Color.black );
      saveSlotsBox.add( saveSlots );

      continueGame.setToolTipText( "Click this button to continue." );
      saveSlots.setToolTipText( "Use this to select the save slot to use." );
      saveGame.setToolTipText( "Click this button to save the game in the slot sleceted." );

      if ( FGOS.display_NOT_added() )
      {  add( FGOS.displayArea );
         add( FGOS.infoBox );
         FGOS.set_display_NOT_added( false );
      }

      Box choiceBox = Box.createVerticalBox();
      choiceBox.setBackground( Color.black );
      choiceBox.add( Box.createVerticalStrut( 15 ) );
      choiceBox.add( continueBox );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( saveBox );
      choiceBox.add( Box.createVerticalStrut( 10 ) );
      choiceBox.add( saveSlotsBox );
      choiceBox.add( Box.createVerticalStrut( 50 ) );
      choiceBox.setBounds( 219, 394, 365, 257 );

      if ( nextStage > 5 )
      {  backgroundPic = new JLabel( new ImageIcon( "SaveScreen" + File.separator + "SsaveScreen.jpg" ) );
      }
      else
      {  backgroundPic = new JLabel( new ImageIcon( "SaveScreen" + File.separator + "saveScreen.jpg" ) );
      }
      backgroundPic.setBounds( 0, 0, 800, 600 );

      add( gokuFace );
      add( hp );
      add( ep );
      add( pl );
      add( strength );
      add( endurance );
      add( dexterity );
      add( speed );
      add( skill );
      add( attacks );
      add( choiceBox );
      add( backgroundPic );
      try
      {  EventQueue.invokeLater( new Runnable()
         {  public void run()
            {  continueGame.requestFocus();
            }
         } );
      }
      catch ( Exception e )
      {  System.err.println( "There was an Exception ERROR while calling continueGame.requestFocus()!" );
      }
   }

   public void actionPerformed( ActionEvent e )
   {  if ( e.getActionCommand().equals( "Continue" ) )
      {  if ( charHasBeenSaved )
         {  remove( FGOS.displayArea );
            remove( FGOS.infoBox );
            FGOS.resetDisplay();
            FGOS.set_display_NOT_added( true );
            loadStage();
         }
         else
         {  int n = JOptionPane.showConfirmDialog( FGOS.frame, "The game has not been saved.\nAre you sure you wish to proceed?", "Warning:", JOptionPane.YES_NO_OPTION );
            if ( n == JOptionPane.YES_OPTION )
            {  loadStage();
            }
            else if ( n == JOptionPane.NO_OPTION )
            {
            }
            else
            {
            }
         }
      }
      else if ( e.getActionCommand().equals( "Save" ) )
      {  String choice = ( String )saveSlots.getSelectedItem();
         if ( choice.equals( "Slot 1" ) && slot1Exists )
         {  showWarning( choice );
         }
         else if ( choice.equals( "Slot 2" ) && slot2Exists )
         {  showWarning( choice );
         }
         else if ( choice.equals( "Slot 3" ) && slot3Exists )
         {  showWarning( choice );
         }
         else
         {  saveGame( choice );
         }
      }
   }

   private void loadStage()
   {  FGOS.set_display_NOT_added( true );
      FGOS.ms = new MainScreen( currentGame );
      FGOS.frame.getContentPane().add( FGOS.ms, BorderLayout.CENTER );
      FGOS.frame.getContentPane().remove( this );
      FGOS.update();
   }

   private void showWarning( String choice )
   {  int n = JOptionPane.showConfirmDialog( FGOS.frame, "This file already exists and will be overwritten.\nIs this what you intended?", "Warning:", JOptionPane.YES_NO_OPTION );
      if ( n == JOptionPane.YES_OPTION )
      {  saveGame( choice );
      }
      else if ( n == JOptionPane.NO_OPTION )
      {
      }
      else
      {
      }
   }

   private void saveGame( String name )
   {  if ( name.equals( "Slot 1" ) )
      {  try
         {  FileOutputStream myfile = new FileOutputStream( "SaveScreen" + File.separator + "SaveSlot1.fgos" );
            myfile.close();
            File temp = new File( "SaveScreen" + File.separator + "SaveSlot1.fgos" );
            PrintWriter out = new PrintWriter( new FileWriter( temp ), true );
            out.println( currentGameString );
            out.close();
            charHasBeenSaved = true;
         }
         catch ( Exception e )
         {  e.printStackTrace();
         }
      }
      else if ( name.equals( "Slot 2" ) )
      {  try
         {  FileOutputStream myfile = new FileOutputStream( "SaveScreen" + File.separator + "SaveSlot2.fgos" );
            myfile.close();
            File temp = new File( "SaveScreen" + File.separator + "SaveSlot2.fgos" );
            PrintWriter out = new PrintWriter( new FileWriter( temp ), true );
            out.println( currentGameString );
            out.close();
            charHasBeenSaved = true;
         }
         catch ( Exception e )
         {  e.printStackTrace();
         }
      }
      else if ( name.equals( "Slot 3" ) )
      {  try
         {  FileOutputStream myfile = new FileOutputStream( "SaveScreen" + File.separator + "SaveSlot3.fgos" );
            myfile.close();
            File temp = new File( "SaveScreen" + File.separator + "SaveSlot3.fgos" );
            PrintWriter out = new PrintWriter( new FileWriter( temp ), true );
            out.println( currentGameString );
            out.close();
            charHasBeenSaved = true;
         }
         catch ( Exception e )
         {  e.printStackTrace();
         }
      }
      else
      {  System.err.println( "An error has occured while saving the game." );
      }
   }
}

class HighScore extends JPanel implements ActionListener
{  private JTextField hp, ep, pl, strength, endurance, dexterity, speed, skill, attacks;
   private boolean isReal, slot1Exists, slot2Exists, slot3Exists;
   private int base_attacks, eStrength, currentStage, rank;
   private JButton loadGame, quit;
   private JComboBox saveSlots;
   private Font myfont;
   private String name, highScoreString;
   private File currentGame;
   private NameStack nameStack, highNameStack;
   private RankStack rankStack, highRankStack;
   private JLabel backgroundPic, gokuFace;

   HighScore( File saveFile )
   {  // Clean up
      System.gc();

      if ( FGOS.display_NOT_added() )
      {  add( FGOS.displayArea );
         add( FGOS.infoBox );
         FGOS.set_display_NOT_added( false );
      }

      setLayout( null );
      setBackground( Color.black );

      highScoreString = "" + true + "|";
      nameStack = new NameStack();
      rankStack = new RankStack();
      highNameStack = new NameStack();
      highRankStack = new RankStack();

      try
      {  BufferedReader in = new BufferedReader( new FileReader( saveFile ) );
         String data = in.readLine();
         StringTokenizer tokenizedData = new StringTokenizer( data, "|" );
         isReal = new Boolean( tokenizedData.nextToken() ).booleanValue();
         currentStage = Integer.parseInt( tokenizedData.nextToken() );
         name = tokenizedData.nextToken();
         hp = new JTextField( "" + tokenizedData.nextToken(), 10 );
         ep = new JTextField( "" + tokenizedData.nextToken(), 10 );
         pl = new JTextField( "" + tokenizedData.nextToken(), 3 );
         strength = new JTextField( "" + tokenizedData.nextToken(), 3 );
         endurance = new JTextField( "" + tokenizedData.nextToken(), 3 );
         dexterity = new JTextField( "" + tokenizedData.nextToken(), 3 );
         speed = new JTextField( "" + tokenizedData.nextToken(), 3 );
         skill = new JTextField( "" + tokenizedData.nextToken(), 3 );
         attacks = new JTextField( "" + tokenizedData.nextToken(), 8 );
         eStrength = Integer.parseInt( tokenizedData.nextToken() );
         in.close();

         in = new BufferedReader( new FileReader ( "SaveScreen" + File.separator + "SaveSlot1.fgos" ) );
         String data1;
         data1 = in.readLine();
         tokenizedData = new StringTokenizer( data1, "|" );
         isReal = new Boolean( tokenizedData.nextToken() ).booleanValue();
         slot1Exists = isReal;
         in.close();

         in = new BufferedReader( new FileReader ( "SaveScreen" + File.separator + "SaveSlot2.fgos" ) );
         String data2;
         data2 = in.readLine();
         tokenizedData = new StringTokenizer( data2, "|" );
         isReal = new Boolean( tokenizedData.nextToken() ).booleanValue();
         slot2Exists = isReal;
         in.close();

         in = new BufferedReader( new FileReader ( "SaveScreen" + File.separator + "SaveSlot3.fgos" ) );
         String data3;
         data3 = in.readLine();
         tokenizedData = new StringTokenizer( data3, "|" );
         isReal = new Boolean( tokenizedData.nextToken() ).booleanValue();
         slot3Exists = isReal;
         in.close();

         in = new BufferedReader( new FileReader ( "HighScore" + File.separator + "HighScore.fgos" ) );
         String scoreData;
         scoreData = in.readLine();
         tokenizedData = new StringTokenizer( scoreData, "|" );
         isReal = new Boolean( tokenizedData.nextToken() ).booleanValue();
         if ( isReal )
         {  while ( tokenizedData.hasMoreTokens() )
            {  nameStack.push( tokenizedData.nextToken() );
               rankStack.push( Integer.parseInt( tokenizedData.nextToken() ) );
            }
         }
         while ( !nameStack.isEmpty() )
         {  highNameStack.push( nameStack.pop() );
            highRankStack.push( rankStack.pop() );
         }
         nameStack = null;
         rankStack = null;
      }
      catch ( Exception e )
      {  e.printStackTrace();
      }

      rank = ( --currentStage );

      if ( rank == 10 )
      {  FGOS.playNewSong( "SGrandChampion.mid" );
      }
      else
      {  FGOS.playNewSong( "HighScore.mid" );
      }

      sortScore();
      try
      {  FileOutputStream myfile = new FileOutputStream( "HighScore" + File.separator + "HighScore.fgos" );
         myfile.close();
         File temp = new File(  "HighScore" + File.separator + "HighScore.fgos" );
         PrintWriter out = new PrintWriter( new FileWriter( temp ), true );
         out.println( highScoreString );
         out.close();
      }
      catch ( Exception e )
      {  e.printStackTrace();
      }

      if ( rank > 3 )
      {  gokuFace = new JLabel( new ImageIcon( "SaveScreen" + File.separator + "SGokuFace.gif" ) );
      }
      else
      {  gokuFace = new JLabel( new ImageIcon( "SaveScreen" + File.separator + "GokuFace.gif" ) );
      }
      gokuFace.setBounds( 123, 327, 50, 50 );

      base_attacks = ( Integer.parseInt( pl.getText().trim() ) + Integer.parseInt( attacks.getText().trim() ) );

      /*
      100%
      green on black
      66%
      yellow on black
      33%
      red on black
      0
      black on white
      */
      hp.setEditable( false );
      hp.setFocusable( false );
      hp.setBackground( Color.black );
      hp.setForeground( Color.white );
      hp.setBounds( 81, 334, 28, 18 );

      ep.setEditable( false );
      ep.setFocusable( false );
      ep.setBackground( Color.black );
      ep.setForeground( Color.white );
      ep.setBounds( 81, 358, 28, 18 );

      pl.setEditable( false );
      pl.setFocusable( false );
      pl.setBackground( Color.black );
      pl.setForeground( Color.white );
      pl.setBounds( 144, 389, 28, 18 );

      strength.setEditable( false );
      strength.setFocusable( false );
      strength.setBackground( Color.black );
      strength.setForeground( Color.white );
      strength.setBounds( 144, 419, 28, 18 );

      endurance.setEditable( false );
      endurance.setFocusable( false );
      endurance.setBackground( Color.black );
      endurance.setForeground( Color.white );
      endurance.setBounds( 144, 443, 28, 18 );

      dexterity.setEditable( false );
      dexterity.setFocusable( false );
      dexterity.setBackground( Color.black );
      dexterity.setForeground( Color.white );
      dexterity.setBounds( 144, 467, 28, 18 );

      speed.setEditable( false );
      speed.setFocusable( false );
      speed.setBackground( Color.black );
      speed.setForeground( Color.white );
      speed.setBounds( 144, 491, 28, 18 );

      skill.setEditable( false );
      skill.setFocusable( false );
      skill.setBackground( Color.black );
      skill.setForeground( Color.white );
      skill.setBounds( 144, 515, 28, 18 );

      attacks.setText( "" + base_attacks );
      attacks.setEditable( false );
      attacks.setFocusable( false );
      attacks.setBackground( Color.black );
      attacks.setForeground( Color.white );
      attacks.setBounds( 144, 539, 28, 18 );

      if ( rank == 10 )
      {  FGOS.message += ( "\n\nCongratulations!  You did it!  You beat the game and will now be immortalized in the history books as the greatest martial artist of all time.  You will be known as the: \"Supreme Grand Master\" and all will tremble before your insufferable might, for you are the:" );
         Image image = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "Celebration.gif" );
         JLabel currentImage = new JLabel( new ImageIcon( image ) );
         FGOS.displayArea.add( currentImage, BorderLayout.CENTER );
         FGOS.displayArea.revalidate();
         FGOS.displayArea.repaint();
      }
      else
      {  FGOS.message += ( "\n" + name + ", having completed stage " + rank + " before ending the game, you have achieved the fighting rank of:\n\n\n" );
      }
      FGOS.infoArea.setText( FGOS.message );
      FGOS.infoScrollPane.getViewport().setViewPosition( new Point ( 10000000, 10000000 ) );
      FGOS.update();

      JLabel rankLabel = new JLabel();
      myfont = new Font("SansSerif", Font.BOLD, 16 );
      rankLabel.setFont( myfont );
      rankLabel.setBackground( Color.black );
      rankLabel.setForeground( Color.white );
      rankLabel.setHorizontalAlignment( JLabel.CENTER );
      rankLabel.setVerticalAlignment( JLabel.CENTER );
      rankLabel.setVerticalTextPosition( JLabel.CENTER );
      rankLabel.setHorizontalTextPosition( JLabel.CENTER );
      rankLabel.setText( getRank( rank ) );

      Box rankBox = Box.createHorizontalBox();
      rankBox.setBackground( Color.black );
      rankBox.add( rankLabel );

      loadGame = new JButton( "Load Game" );
      loadGame.setBackground( Color.black );
      loadGame.setForeground( Color.orange );
      myfont = new Font( "SansSerif", Font.BOLD, 20 );
      loadGame.setFont( myfont );
      loadGame.setBorderPainted( false );
      loadGame.setMnemonic( KeyEvent.VK_S );
      loadGame.setActionCommand( "Load" );
      loadGame.setMaximumSize( loadGame.getPreferredSize() );
      loadGame.setEnabled( false );

      Box loadBox = Box.createHorizontalBox();
      loadBox.setBackground( Color.black );
      loadBox.add( loadGame );

      quit = new JButton( "  Quit  " );
      quit.setBackground( Color.black );
      quit.setForeground( Color.red.brighter().brighter().brighter() );
      quit.setFont( myfont );
      quit.setBorderPainted( false );
      quit.setMnemonic( KeyEvent.VK_C );
      quit.setActionCommand( "Quit" );
      quit.setMaximumSize( loadGame.getPreferredSize() );
      quit.addActionListener( this );

      Box quitBox = Box.createHorizontalBox();
      quitBox.setBackground( Color.black );
      quitBox.add( quit );

      saveSlots = new JComboBox();
      saveSlots.setEditable( false );
      enableSlots();
      saveSlots.setMaximumSize( new Dimension( 86, 30 ) );

      Box saveSlotsBox = Box.createHorizontalBox();
      saveSlotsBox.setBackground( Color.black );
      saveSlotsBox.add( saveSlots );

      quit.setToolTipText( "Click this button to quit the game." );
      loadGame.setToolTipText( "Click this button to load the selected game." );
      saveSlots.setToolTipText( "Use this to select the game to load." );

      Box choiceBox = Box.createVerticalBox();
      choiceBox.setBackground( Color.black );
      choiceBox.add( FGOS.infoBox );
      choiceBox.add( Box.createVerticalStrut( 15 ) );
      choiceBox.add( rankBox );
      choiceBox.add( Box.createVerticalStrut( 10 ) );
      choiceBox.add( quitBox );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( loadBox );
      choiceBox.add( Box.createVerticalStrut( 10 ) );
      choiceBox.add( saveSlotsBox );
      choiceBox.add( Box.createVerticalStrut( 50 ) );
      choiceBox.setBounds( 219, 317, 365, 334 );

      if ( rank == 10 )
      {  backgroundPic = new JLabel( new ImageIcon( "SaveScreen" + File.separator + "WishScreen.jpg" ) );
      }
      else if ( rank > 3 )
      {  backgroundPic = new JLabel( new ImageIcon( "SaveScreen" + File.separator + "SsaveScreen.jpg" ) );
      }
      else
      {  backgroundPic = new JLabel( new ImageIcon( "SaveScreen" + File.separator + "saveScreen.jpg" ) );
      }
      backgroundPic.setBounds( 0, 0, 800, 600 );

      add( gokuFace );
      add( hp );
      add( ep );
      add( pl );
      add( strength );
      add( endurance );
      add( dexterity );
      add( speed );
      add( skill );
      add( attacks );
      add( choiceBox );
      add( backgroundPic );

      if ( loadGame.isEnabled() )
      {  loadGame.addActionListener( this );
         try
         {  EventQueue.invokeLater( new Runnable()
            {  public void run()
               {  loadGame.requestFocus();
               }
            } );
         }
         catch ( Exception e )
         {  System.err.println( "There was an Exception ERROR while calling loadGame.requestFocus()!" );
         }
      }
      if ( !loadGame.hasFocus() )
      {  try
         {  EventQueue.invokeLater( new Runnable()
            {  public void run()
               {  quit.requestFocus();
               }
            } );
         }
         catch ( Exception e )
         {  System.err.println( "There was an Exception ERROR while calling quit.requestFocus()!" );
         }
      }
   }

   private void sortScore()
   {  int newRank = rank;
      boolean newRank_NOT_Added = true;

      do
      {  if ( highRankStack.isEmpty() )
         {  if ( newRank_NOT_Added )
            {  highScoreString += ( name + "|" + newRank + "|" );
               newRank_NOT_Added = false;
            }
         }
         else if( newRank >= highRankStack.top() && newRank_NOT_Added )
         {  highScoreString += ( name + "|" + newRank + "|" );
            newRank_NOT_Added = false;
         }
         else
         {  highScoreString += ( highNameStack.pop() + "|" + highRankStack.pop() + "|" );
         }
      } while ( !highRankStack.isEmpty() );

      if ( newRank_NOT_Added )
      {  highScoreString += ( name + "|" + newRank + "|" );
         newRank_NOT_Added = false;
      }
   }

   private void enableSlots()
   {  if( slot1Exists )
      {  saveSlots.addItem( "Slot 1" );
         loadGame.setEnabled( true );
      }
      if ( slot2Exists )
      {  saveSlots.addItem( "Slot 2" );
         loadGame.setEnabled( true );
      }
      if ( slot3Exists )
      {  saveSlots.addItem( "Slot 3" );
         loadGame.setEnabled( true );
      }
   }

   private String getRank( int rank )
   {  if ( rank == 0 )
      {  return "Wimp!";
      }
      else if ( rank == 1 )
      {  return "Lucky Punk!";
      }
      else if ( rank == 2 )
      {  return "Thug!";
      }
      else if ( rank == 3 )
      {  return "Novice!";
      }
      else if ( rank == 4 )
      {  return "Initiate!";
      }
      else if ( rank == 5 )
      {  return "Adept!";
      }
      else if ( rank == 6 )
      {  return "Expert!";
      }
      else if ( rank == 7 )
      {  return "Specialist!";
      }
      else if ( rank == 8 )
      {  return "Master!";
      }
      else if ( rank == 9 )
      {  return "Grand Master!";
      }
      else if ( rank == 10 )
      {  return "Supreme Grand Master!";
      }
      else
      {  return "ERROR!";
      }
   }

   public void actionPerformed( ActionEvent e )
   {  if ( e.getActionCommand().equals( "Load" ) )
      {  String choice = ( String )saveSlots.getSelectedItem();
         remove( FGOS.displayArea );
         remove( FGOS.infoBox );
         FGOS.resetDisplay();
         FGOS.set_display_NOT_added( true );
         loadGame( choice );
      }
      else if ( e.getActionCommand().equals( "Quit" ) )
      {  System.gc();
         System.exit( 0 );
      }
      else
      {
      }
   }

   private void loadGame( String name )
   {  if ( name.equals( "Slot 1" ) )
      {  try
         {  File temp = new File( "SaveScreen" + File.separator + "SaveSlot1.fgos" );
            FGOS.ms = new MainScreen( temp );
            FGOS.frame.getContentPane().add( FGOS.ms, BorderLayout.CENTER );
            FGOS.frame.getContentPane().remove( this );
            FGOS.update();
         }
         catch ( Exception e )
         {  e.printStackTrace();
         }
      }
      else if ( name.equals( "Slot 2" ) )
      {  try
         {  File temp = new File( "SaveScreen" + File.separator + "SaveSlot2.fgos" );
            FGOS.ms = new MainScreen( temp );
            FGOS.frame.getContentPane().add( FGOS.ms, BorderLayout.CENTER );
            FGOS.frame.getContentPane().remove( this );
            FGOS.update();
         }
         catch ( Exception e )
         {  e.printStackTrace();
         }
      }
      else if ( name.equals( "Slot 3" ) )
      {  try
         {  File temp = new File( "SaveScreen" + File.separator + "SaveSlot3.fgos" );
            FGOS.ms = new MainScreen( temp );
            FGOS.frame.getContentPane().add( FGOS.ms, BorderLayout.CENTER );
            FGOS.frame.getContentPane().remove( this );
            FGOS.update();
         }
         catch ( Exception e )
         {  e.printStackTrace();
         }
      }
      else
      {  System.err.println( "An error has occured while loading the saved game." );
      }
   }
}

class Sync
{  private volatile static boolean heroHas_NOT_chosen;
   private volatile static boolean done;

   public Sync( boolean value )
   {  heroHas_NOT_chosen = value;
   }

   protected synchronized void setDone( boolean value )
   {  done = value;
      notifyAll();
   }

   protected synchronized void waitTillDone()
   {  try
      {  while ( !done )
         {  wait();
         }
      }
      catch ( InterruptedException e )
      {  System.err.println( "An InterruptedException ERROR occured while in the waitTillDone() method of class Sync!" );
      }
   }

   protected synchronized void setHeroHas_NOT_Chosen( boolean value )
   {  heroHas_NOT_chosen = value;
      notifyAll();
   }

   protected synchronized void heroHasChosen()
   {  try
      {  while ( heroHas_NOT_chosen )
         {  wait();
         }
      }
      catch ( InterruptedException e )
      {  System.err.println( "An InterruptedException ERROR occured while in the heroHasChosen() method of class Sync!" );
      }
   }
}

class FightThread extends Thread
{  private volatile Sync sync;
   private volatile boolean fight_NOT_over, round_NOT_over, first_call, hero_did_something = false, boss_did_something = false;

   // Constructor
   public FightThread( Sync sync_in )
   {  sync = sync_in;
   }

   // Implement the run() method of the Runnable interface.
   public void run()
   {  setFight_NOT_Over( true );
      // The entire "fight"
      fight();
   }

   private void heroAction()
   {  sync.setHeroHas_NOT_Chosen( true );
      setFirstCall( true );
      try
      {  EventQueue.invokeAndWait( new Runnable()
         {  public void run()
            {  FGOS.ms.actionOptions();
            }
         } );
      }
      catch ( Exception e )
      {  System.err.println( "There was an Exception ERROR while calling actionOptions from the EventQueue!" );
      }
      sync.heroHasChosen();
   }

   private void fight()
   {  FGOS.ms.currentAction = "FS";
      FGOS.ms.boss.currentAction = "FS";
      setFight_NOT_Over( true );
      while ( getFight_NOT_Over() )
      {  // Setup for a round of fighting
         FGOS.ms.rejuvenate();
         FGOS.ms.calculateSpeed();
         FGOS.ms.numActions_Spent = 0;
         FGOS.ms.boss.numActions_Spent = 0;
         if ( ( FGOS.ms.boss.get_hp() == 0 ) || ( FGOS.ms.get_hp() == 0 ) )
         {  setRound_NOT_Over( false );
            setFight_NOT_Over( false );
         }
         else
         {  setRound_NOT_Over( true );
         }
         // One round of fighting
         fightRound();
         // Setup for next round ( assuming there is one )
         //FGOS.ms.remainderTime = FGOS.ms.initiative;
         //FGOS.ms.boss.remainderTime = FGOS.ms.boss.initiative;
         FGOS.ms.remainderTime = 0;
         FGOS.ms.boss.remainderTime = 0;
      }
      determineWinner();
   }

   private void fightRound()
   {  // One "round" of fighting
      while ( getRound_NOT_Over() )
      {  if ( ( FGOS.ms.initiative > FGOS.ms.boss.initiative ) && ( FGOS.ms.get_attacks() > 0 ) )
         {  if ( !( get_hero_has_done_something() ) )
            {  set_hero_has_done_something( true );
               heroAction();
               FGOS.ms.initiative -= ( FGOS.ms.numActions_Spent * FGOS.ms.actionTime );
            }
         }
         else if ( FGOS.ms.initiative == FGOS.ms.boss.initiative )
         {  if ( FGOS.ms.boss.get_attacks() > 0 )
            {  if ( !( get_boss_has_done_something() ) )
               {  set_boss_has_done_something( true );
                  FGOS.ms.boss.action();
                  FGOS.ms.boss.initiative -= ( FGOS.ms.boss.numActions_Spent * FGOS.ms.boss.actionTime );
               }
            }
            if ( FGOS.ms.get_attacks() > 0 )
            {  if ( !( get_hero_has_done_something() ) )
               {  set_hero_has_done_something( true );
                  heroAction();
                  FGOS.ms.initiative -= ( FGOS.ms.numActions_Spent * FGOS.ms.actionTime );
               }
            }
         }
         else if ( ( FGOS.ms.initiative < FGOS.ms.boss.initiative ) && ( FGOS.ms.boss.get_attacks() > 0 ) )
         {  if ( !( get_boss_has_done_something() ) )
            {  set_boss_has_done_something( true );
               FGOS.ms.boss.action();
               FGOS.ms.boss.initiative -= ( FGOS.ms.boss.numActions_Spent * FGOS.ms.boss.actionTime );
            }
         }

         sync.setDone( false );
         resolveAction();
         sync.waitTillDone();

         System.out.println( "Completely finished resolveAction!  About to check if there are no attacks left for either figher, or if anyone is KO'd." );

         nap( 10 );
         clearEventQueue();
         checkUpOnFight();
      }
   }

   private void resolveAction()
   {  if ( ( FGOS.ms.initiative - ( FGOS.ms.numActions_Spent * FGOS.ms.actionTime ) ) > ( FGOS.ms.boss.initiative - ( FGOS.ms.boss.numActions_Spent * FGOS.ms.boss.actionTime ) ) )
      {  if ( get_hero_has_done_something() )
         {  // resolve hero action now.
            System.err.println( "Resolving Hero action now. 1" );
            FGOS.ms.resolveHeroAction();
            set_hero_has_done_something( false );
            if ( !( FGOS.ms.currentAction.equals( "D" ) ) )
            {  FGOS.ms.currentAction = "FS";
            }
         }
         else
         {  if ( FGOS.ms.get_attacks() > 0 )
            {  set_hero_has_done_something( true );
               heroAction();
               FGOS.ms.initiative -= ( FGOS.ms.numActions_Spent * FGOS.ms.actionTime );
               sync.setDone( true );
            }
            else
            {  FGOS.ms.initiative--;
               sync.setDone( true );
            }
         }
      }
      else if ( ( FGOS.ms.initiative - ( FGOS.ms.numActions_Spent * FGOS.ms.actionTime ) ) == ( FGOS.ms.boss.initiative - ( FGOS.ms.boss.numActions_Spent * FGOS.ms.boss.actionTime ) ) )
      {  if ( !( get_hero_has_done_something() ) )
         {  if ( FGOS.ms.get_attacks() > 0 )
            {  System.err.println( "Hero equal but hasn't moved yet." );
               set_hero_has_done_something( true );
               heroAction();
               FGOS.ms.initiative -= ( FGOS.ms.numActions_Spent * FGOS.ms.actionTime );
               sync.setDone( true );
            }
            else
            {  FGOS.ms.initiative--;
               sync.setDone( true );
            }
         }
         else if ( !( get_boss_has_done_something() ) )
         {  if ( FGOS.ms.boss.get_attacks() > 0 )
            {  System.err.println( "Boss equal but hasn't moved yet." );
               set_boss_has_done_something( true );
               FGOS.ms.boss.action();
               FGOS.ms.boss.initiative -= ( FGOS.ms.boss.numActions_Spent * FGOS.ms.boss.actionTime );
               sync.setDone( true );
            }
            else
            {  FGOS.ms.boss.initiative--;
               sync.setDone( true );
            }
         }
         else if ( ( get_hero_has_done_something() ) && ( get_boss_has_done_something() ) )
         {  // resolve both actions now.
            System.err.println( "Resolving Boss action now. 1" );
            FGOS.ms.resolveBossAction();
            sync.setDone( false );
            System.err.println( "Resolving Hero action now. 2" );
            FGOS.ms.resolveHeroAction();

            set_boss_has_done_something( false );
            if ( !( FGOS.ms.boss.currentAction.equals( "D" ) ) )
            {  FGOS.ms.boss.currentAction = "FS";
            }
            set_hero_has_done_something( false );
            if ( !( FGOS.ms.currentAction.equals( "D" ) ) )
            {  FGOS.ms.currentAction = "FS";
            }
         }
      }
      else if ( ( FGOS.ms.initiative - ( FGOS.ms.numActions_Spent * FGOS.ms.actionTime ) ) < ( FGOS.ms.boss.initiative - ( FGOS.ms.boss.numActions_Spent * FGOS.ms.boss.actionTime ) ) )
      {  if ( get_boss_has_done_something() )
         {  // resolve boss action now.
            System.err.println( "Resolving Boss action now. 2" );
            FGOS.ms.resolveBossAction();
            set_boss_has_done_something( false );
            if ( !( FGOS.ms.boss.currentAction.equals( "D" ) ) )
            {  FGOS.ms.boss.currentAction = "FS";
            }
         }
         else
         {  if ( FGOS.ms.boss.get_attacks() > 0 )
            {  System.err.println( "Boss higher initiative because Boss hasn't moved yet." );
               set_boss_has_done_something( true );
               FGOS.ms.boss.action();
               FGOS.ms.boss.initiative -= ( FGOS.ms.boss.numActions_Spent * FGOS.ms.boss.actionTime );
               sync.setDone( true );
            }
            else
            {  FGOS.ms.boss.initiative--;
               sync.setDone( true );
            }
         }
      }
      else
      {  System.err.println( "Something did not add up while resolving the actions." );
      }
   }

   private void checkUpOnFight()
   {  rePaintAll( true );
      if ( ( FGOS.ms.boss.get_hp() == 0 ) || ( FGOS.ms.get_hp() == 0 ) )
      {  setRound_NOT_Over( false );
         setFight_NOT_Over( false );
      }
      if ( ( FGOS.ms.get_attacks() == 0 ) && ( FGOS.ms.boss.get_attacks() == 0 ) )
      {  if ( !( get_hero_has_done_something() ) && !( get_boss_has_done_something() ) )
         {  setRound_NOT_Over( false );
         }
      }
      System.out.println( "Determined if anyone is KO'd or if everyone has finished attacking." );
   }

   private void determineWinner()
   {  rePaintAll( false );
      if ( FGOS.ms.get_hp() == 0 && FGOS.ms.boss.get_hp() == 0 )
      {  nap( 1 * 1000 );
         FGOS.ms.loadDraw( false );
      }
      else if ( FGOS.ms.get_hp() > 0 )
      {  nap( 1 * 1000 );
         FGOS.ms.loadWin();
      }
      else if ( FGOS.ms.boss.get_hp() > 0 )
      {  nap( 1 * 1000 );
         FGOS.ms.loadLoss( false );
      }
      else
      {  System.err.println( "Didn't find a winner!" );
         System.exit( -1 );
      }
   }

   private void rePaintAll( boolean attacks )
   {  FGOS.ms.hp.repaint( 0 );
      FGOS.ms.boss.hp.repaint( 0 );
      if ( attacks )
      {  FGOS.ms.attacks.repaint( 0 );
         FGOS.ms.boss.attacks.repaint( 0 );
      }
   }

   private synchronized boolean getFight_NOT_Over()
   {  return fight_NOT_over;
   }

   private synchronized void setFight_NOT_Over( boolean state )
   {  fight_NOT_over = state;
   }

   private synchronized boolean getRound_NOT_Over()
   {  return round_NOT_over;
   }

   private synchronized void setRound_NOT_Over( boolean state )
   {  round_NOT_over = state;
   }

   protected synchronized boolean firstCall()
   {  return first_call;
   }

   protected synchronized void setFirstCall( boolean value )
   {  first_call = value;
   }

   private void set_hero_has_done_something( boolean value )
   {  hero_did_something = value;
   }

   private synchronized boolean get_hero_has_done_something()
   {  return hero_did_something;
   }

   private synchronized void set_boss_has_done_something( boolean value )
   {  boss_did_something = value;
   }

   private synchronized boolean get_boss_has_done_something()
   {  return boss_did_something;
   }

   private void clearEventQueue()
   {  try
      {  EventQueue.invokeAndWait( new Runnable()
         {  public void run()
            {  FGOS.ms.update();
            }
         } );
      }
      catch ( Exception e )
      {  System.err.println( "There was an Exception ERROR while calling paused!" );
      }
   }

   protected void nap( int duration )
   {  if ( Thread.currentThread().equals( FGOS.ms.fightThread ) )
      {  try
         {  sleep( duration );
         }
         catch ( InterruptedException e )
         {  System.err.println( "An InterruptedException ERROR occured while napping!" );
         }
         finally
         {  System.out.println( "Finished napping." );
         }
      }
      else
      {  System.err.println( "Avoided napping because called from the EventQueue!" );
      }
   }

   private synchronized int getProb()
   {  return ( ( int )( Math.random() * 100 + 1 ) );
   }

   /*
   100%
   green on black
   66%
   yellow on black
   33%
   red on black
   0
   black on white
   */
   protected synchronized void setHP( final boolean hero, final int change, final boolean increase )
   {  if ( change <= 0 )
      {  return;
      }
      if ( hero )
      {  synchronized ( FGOS.ms.hp )
         {  int currentHP;
            if ( increase )
            {  currentHP = ( FGOS.ms.get_hp() + change );
               if ( currentHP > FGOS.ms.hpMAX )
               {  currentHP = FGOS.ms.hpMAX;
               }
            }
            else
            {  currentHP = ( FGOS.ms.get_hp() - change );
               if ( currentHP < 0 )
               {  currentHP = 0;
               }
            }
            if ( currentHP == 0 )
            {  FGOS.ms.hp.setBackground( Color.white );
               FGOS.ms.hp.setForeground( Color.black );
            }
            else if ( ( currentHP > 0 ) && ( currentHP <= ( FGOS.ms.hpMAX / 3 ) ) )
            {  FGOS.ms.hp.setForeground( Color.red );
            }
            else if ( ( currentHP > ( FGOS.ms.hpMAX / 3 ) ) && ( currentHP <= ( ( FGOS.ms.hpMAX / 3 ) * 2 ) ) )
            {  FGOS.ms.hp.setForeground( Color.yellow );
            }
            else // if ( ( currentHP > ( ( FGOS.ms.hpMAX / 3 ) * 2 ) ) && ( currentHP <= FGOS.ms.hpMAX ) )
            {  FGOS.ms.hp.setForeground( Color.green );
            }
            FGOS.ms.hp.setText( currentHP + "" );
            FGOS.ms.hp.repaint( 0 );
         }
      }
      else
      {  synchronized ( FGOS.ms.boss.hp )
         {  int currentHP;
            if ( increase )
            {  currentHP = ( FGOS.ms.boss.get_hp() + change );
               if ( currentHP > FGOS.ms.boss.hpMAX )
               {  currentHP = FGOS.ms.boss.hpMAX;
               }
            }
            else
            {  currentHP = ( FGOS.ms.boss.get_hp() - change );
               if ( currentHP < 0 )
               {  currentHP = 0;
               }
            }
            if ( currentHP == 0 )
            {  FGOS.ms.boss.hp.setBackground( Color.white );
               FGOS.ms.boss.hp.setForeground( Color.black );
            }
            else if ( ( currentHP > 0 ) && ( currentHP <= ( FGOS.ms.boss.hpMAX / 3 ) ) )
            {  FGOS.ms.boss.hp.setForeground( Color.red );
            }
            else if ( ( currentHP > ( FGOS.ms.boss.hpMAX / 3 ) ) && ( currentHP <= ( ( FGOS.ms.boss.hpMAX / 3 ) * 2 ) ) )
            {  FGOS.ms.boss.hp.setForeground( Color.yellow );
            }
            else // if ( ( currentHP > ( ( FGOS.ms.boss.hpMAX / 3 ) * 2 ) ) && ( currentHP <= FGOS.ms.boss.hpMAX ) )
            {  FGOS.ms.boss.hp.setForeground( Color.green );
            }
            FGOS.ms.boss.hp.setText( currentHP + "" );
            FGOS.ms.boss.hp.repaint( 0 );
         }
      }
   }

   protected synchronized void setEP( final boolean hero, final int change, final boolean increase )
   {  if ( change <= 0 )
      {  return;
      }
      if ( hero )
      {  synchronized ( FGOS.ms.ep )
         {  int currentEP;
            if ( increase )
            {  currentEP = ( FGOS.ms.get_ep() + change );
               if ( currentEP > FGOS.ms.epMAX )
               {  currentEP = FGOS.ms.epMAX;
               }
            }
            else
            {  currentEP = ( FGOS.ms.get_ep() - change );
               if ( currentEP < 0 )
               {  currentEP = 0;
               }
            }
            if ( currentEP == 0 )
            {  FGOS.ms.ep.setBackground( Color.white );
               FGOS.ms.ep.setForeground( Color.black );
            }
            else if ( ( currentEP > 0 ) && ( currentEP <= ( FGOS.ms.epMAX / 3 ) ) )
            {  FGOS.ms.ep.setBackground( Color.black );
               FGOS.ms.ep.setForeground( Color.red );
            }
            else if ( ( currentEP > ( FGOS.ms.epMAX / 3 ) ) && ( currentEP <= ( ( FGOS.ms.epMAX / 3 ) * 2 ) ) )
            {  FGOS.ms.ep.setBackground( Color.black );
               FGOS.ms.ep.setForeground( Color.yellow );
            }
            else // if ( ( currentEP > ( ( FGOS.ms.epMAX / 3 ) * 2 ) ) && ( currentEP <= FGOS.ms.epMAX ) )
            {  FGOS.ms.ep.setBackground( Color.black );
               FGOS.ms.ep.setForeground( Color.green );
            }
            FGOS.ms.ep.setText( currentEP + "" );
            FGOS.ms.ep.repaint( 0 );
         }
      }
      else
      {  synchronized ( FGOS.ms.boss.ep )
         {  int currentEP;
            if ( increase )
            {  currentEP = ( FGOS.ms.boss.get_ep() + change );
                if ( currentEP > FGOS.ms.boss.epMAX )
                {  currentEP = FGOS.ms.boss.epMAX;
                }
            }
            else
            {  currentEP = ( FGOS.ms.boss.get_ep() - change );
               if ( currentEP < 0 )
               {  currentEP = 0;
               }
            }
            if ( currentEP == 0 )
            {  FGOS.ms.boss.ep.setBackground( Color.white );
               FGOS.ms.boss.ep.setForeground( Color.black );
            }
            else if ( ( currentEP > 0 ) && ( currentEP <= ( FGOS.ms.boss.epMAX / 3 ) ) )
            {  FGOS.ms.boss.ep.setBackground( Color.black );
               FGOS.ms.boss.ep.setForeground( Color.red );
            }
            else if ( ( currentEP > ( FGOS.ms.boss.epMAX / 3 ) ) && ( currentEP <= ( ( FGOS.ms.boss.epMAX / 3 ) * 2 ) ) )
            {  FGOS.ms.boss.ep.setBackground( Color.black );
               FGOS.ms.boss.ep.setForeground( Color.yellow );
            }
            else // if ( ( currentEP > ( ( FGOS.ms.boss.epMAX / 3 ) * 2 ) ) && ( currentEP <= FGOS.ms.boss.epMAX ) )
            {  FGOS.ms.boss.ep.setBackground( Color.black );
               FGOS.ms.boss.ep.setForeground( Color.green );
            }
            FGOS.ms.boss.ep.setText( currentEP + "" );
            FGOS.ms.boss.ep.repaint( 0 );
         }
      }
   }

   protected synchronized void powerUp( final boolean hero )
   {  if ( hero )
      {  synchronized ( FGOS.ms.pl )
         {  if ( ( FGOS.ms.get_pl() + 1 ) > ( FGOS.ms.base_pl + ( FGOS.ms.get_endurance() * 2 ) ) )
            {  if ( getProb() <= 80 )
               {  FGOS.ms.pl.setForeground( Color.white );
                  FGOS.ms.pl.setBackground( Color.black );
                  FGOS.ms.pl.setText( ( FGOS.ms.get_pl() + 1 ) + "" );
                  FGOS.ms.pl.repaint( 0 );
               }
            }
            else if ( ( FGOS.ms.get_pl() + 1 ) > ( FGOS.ms.base_pl + FGOS.ms.get_endurance() ) )
            {  if ( getProb() <= 40 )
               {  FGOS.ms.pl.setForeground( Color.red );
                  FGOS.ms.pl.setText( ( FGOS.ms.get_pl() + 1 ) + "" );
                  FGOS.ms.pl.repaint( 0 );
               }
            }
            else if ( ( FGOS.ms.get_pl() + 1 ) > ( FGOS.ms.base_pl ) )
            {  if ( ( getProb() ) <= ( 50 ) )
               {  FGOS.ms.pl.setForeground( Color.yellow );
                  FGOS.ms.pl.setText( ( FGOS.ms.get_pl() + 1 ) + "" );
                  FGOS.ms.pl.repaint( 0 );
               }
            }

            FGOS.ms.dice.rollDice( ( FGOS.ms.get_pl() ), true );
            setEP( true, FGOS.ms.dice.getResult(), true );
         }
      }
      else
      {  synchronized ( FGOS.ms.boss.pl )
          {  if ( ( FGOS.ms.boss.get_pl() + 1 ) > ( FGOS.ms.boss.base_pl + ( FGOS.ms.boss.get_endurance() * 2 ) ) )
             {  if ( ( getProb() ) <= ( 80 + ( 1 * FGOS.ms.currentStage ) ) )
                {  FGOS.ms.boss.pl.setForeground( Color.white );
                   FGOS.ms.boss.pl.setBackground( Color.black );
                   FGOS.ms.boss.pl.setText( ( FGOS.ms.boss.get_pl() + 1 ) + "" );
                   FGOS.ms.boss.pl.repaint( 0 );
                }
             }
             else if ( ( FGOS.ms.boss.get_pl() + 1 ) > ( FGOS.ms.boss.base_pl + FGOS.ms.boss.get_endurance() ) )
             {  if ( ( getProb() ) <= ( 40 + ( 2 * FGOS.ms.currentStage ) ) )
                {  FGOS.ms.boss.pl.setForeground( Color.red );
                   FGOS.ms.boss.pl.setText( ( FGOS.ms.boss.get_pl() + 1 ) + "" );
                   FGOS.ms.boss.pl.repaint( 0 );
                }
             }
             else if ( ( FGOS.ms.boss.get_pl() + 1 ) > ( FGOS.ms.boss.base_pl ) )
             {  if ( ( getProb() ) <= ( 50 + ( 3 * FGOS.ms.currentStage ) ) )
                {  FGOS.ms.boss.pl.setForeground( Color.yellow );
                   FGOS.ms.boss.pl.setText( ( FGOS.ms.boss.get_pl() + 1 ) + "" );
                   FGOS.ms.boss.pl.repaint( 0 );
                }
             }

             FGOS.ms.boss.dice.rollDice( ( FGOS.ms.boss.get_pl() ), true );
             setEP( false, FGOS.ms.boss.dice.getResult(), true );
         }
      }
   }

   protected synchronized void setActions( final boolean hero, final int change )
   {  if ( change <= 0 )
      {  return;
      }
      if ( hero )
      {  synchronized ( FGOS.ms.attacks )
         {  int currentActions;
            currentActions = ( FGOS.ms.get_attacks() - change );
            if ( currentActions < 0 )
            {  currentActions = 0;
            }

            if ( currentActions == 0 )
            {  FGOS.ms.attacks.setBackground( Color.white );
               FGOS.ms.attacks.setForeground( Color.black );
            }
            else if ( ( currentActions > 0 ) && ( currentActions <= ( FGOS.ms.attacksMAX / 3 ) ) )
            {  FGOS.ms.attacks.setBackground( Color.black );
               FGOS.ms.attacks.setForeground( Color.red );
            }
            else if ( ( currentActions > ( FGOS.ms.attacksMAX / 3 ) ) && ( currentActions <= ( ( FGOS.ms.attacksMAX / 3 ) * 2 ) ) )
            {  FGOS.ms.attacks.setBackground( Color.black );
               FGOS.ms.attacks.setForeground( Color.yellow );
            }
            else // if ( ( currentActions > ( ( FGOS.ms.attacksMAX / 3 ) * 2 ) ) && ( currentActions <= FGOS.ms.attacksMAX ) )
            {  FGOS.ms.attacks.setBackground( Color.black );
               FGOS.ms.attacks.setForeground( Color.green );
            }
            FGOS.ms.attacks.setText( currentActions + "" );
            FGOS.ms.attacks.repaint( 0 );
         }
      }
      else
      {  synchronized ( FGOS.ms.boss.attacks )
         {  int currentActions;
            currentActions = ( FGOS.ms.boss.get_attacks() - change );
            if ( currentActions < 0 )
            {  currentActions = 0;
            }

            if ( currentActions == 0 )
            {  FGOS.ms.boss.attacks.setBackground( Color.white );
               FGOS.ms.boss.attacks.setForeground( Color.black );
            }
            else if ( ( currentActions > 0 ) && ( currentActions <= ( FGOS.ms.boss.attacksMAX / 3 ) ) )
            {  FGOS.ms.boss.attacks.setBackground( Color.black );
               FGOS.ms.boss.attacks.setForeground( Color.red );
            }
            else if ( ( currentActions > ( FGOS.ms.boss.attacksMAX / 3 ) ) && ( currentActions <= ( ( FGOS.ms.boss.attacksMAX / 3 ) * 2 ) ) )
            {  FGOS.ms.boss.attacks.setBackground( Color.black );
               FGOS.ms.boss.attacks.setForeground( Color.yellow );
            }
            else // if ( ( currentActions > ( ( FGOS.ms.boss.attacksMAX / 3 ) * 2 ) ) && ( currentActions <= FGOS.ms.boss.attacksMAX ) )
            {  FGOS.ms.boss.attacks.setBackground( Color.black );
               FGOS.ms.boss.attacks.setForeground( Color.green );
            }
            FGOS.ms.boss.attacks.setText( currentActions + "" );
            FGOS.ms.boss.attacks.repaint( 0 );
         }
      }
   }
}

class MainScreen extends JPanel implements ActionListener
{  protected volatile JTextField hp, ep, pl, strength, endurance, dexterity, speed, skill, attacks;
   protected boolean isReal, has_x2, has_x3, has_x4;
   private volatile boolean selfishWish, wait = false, failedTest = false;
   protected volatile int hpMAX, epMAX, base_pl, base_attacks, attacksMAX, ep_cost, eStrength, currentStage, initiative, actionTime, remainderTime, numActions_Spent, tempResult, tempResultTwo, bossNum = 1, storyPart = 1, fightResult = 0;
   protected Font myfont;
   protected volatile String currentGameString, name, currentAction = "FS";
   protected File currentGame;
   protected Boss boss;
   protected JLabel backgroundPic, gokuFace;
   protected Box choiceBox;
   protected DiceRoller dice;
   protected JButton attack, defend, specialMove, powerUp, normalAttack, powerAttack, energyAttack, comboAttack, launchEnergyAttack, cancel, continueGame, quit;
   protected JComboBox selectCombo;
   protected WholeNumberTextField epSpent;
   protected volatile FightThread fightThread;
   private volatile Sync sync;
   private Image iNA, iPA, iD, iFS, iE, iEC, iEMC, ix2P, ix3P, ix4P, ix2E, ix3E, ix4E, iPU, iExplode, iWin;
   private volatile JLabel currentImage = null;

   MainScreen ( File saveGame )
   {  // Clean up
      System.gc();

      if ( FGOS.display_NOT_added() )
      {  add( FGOS.displayArea );
         add( FGOS.infoBox );
         FGOS.set_display_NOT_added( false );
      }

      // Construct a Sync object to synchronize events
      sync = new Sync( true );

      setLayout( null );
      setBackground( Color.black );

      currentGame = saveGame;

      try
      {  BufferedReader in = new BufferedReader( new FileReader( currentGame ) );
         String data = in.readLine();
         currentGameString = data;
         StringTokenizer tokenizedData = new StringTokenizer( data, "|" );
         isReal = new Boolean( tokenizedData.nextToken() ).booleanValue();
         currentStage = Integer.parseInt( tokenizedData.nextToken() );
         name = tokenizedData.nextToken();
         hpMAX = Integer.parseInt( tokenizedData.nextToken() );
         epMAX = Integer.parseInt( tokenizedData.nextToken() );
         base_pl = Integer.parseInt( tokenizedData.nextToken() );
         strength = new JTextField( "" + tokenizedData.nextToken(), 3 );
         endurance = new JTextField( "" + tokenizedData.nextToken(), 3 );
         dexterity = new JTextField( "" + tokenizedData.nextToken(), 3 );
         speed = new JTextField( "" + tokenizedData.nextToken(), 3 );
         skill = new JTextField( "" + tokenizedData.nextToken(), 3 );
         base_attacks = Integer.parseInt( tokenizedData.nextToken() );
         eStrength = Integer.parseInt( tokenizedData.nextToken() );
         has_x2 = new Boolean( tokenizedData.nextToken() ).booleanValue();
         has_x3 = new Boolean( tokenizedData.nextToken() ).booleanValue();
         has_x4 = new Boolean( tokenizedData.nextToken() ).booleanValue();
         in.close();
      }
      catch ( Exception e )
      {  e.printStackTrace();
      }

      FGOS.playNewSong( ( "Stage" + currentStage + ".mid" ) );

      if ( currentStage > 5 )
      {  gokuFace = new JLabel( new ImageIcon( "SaveScreen" + File.separator + "SGokuFace.gif" ) );
      }
      else
      {  gokuFace = new JLabel( new ImageIcon( "SaveScreen" + File.separator + "GokuFace.gif" ) );
      }
      gokuFace.setBounds( 123, 327, 50, 50 );

      if ( currentStage > 4 )
      {  iNA = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "SNA.gif" );
      }
      else
      {  iNA = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "NA.gif" );
      }

      if ( currentStage > 4 )
      {  iPA = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "SPA.gif" );
      }
      else
      {  iPA = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "PA.gif" );
      }

      if ( currentStage > 4 )
      {  iD = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "SD.gif" );
      }
      else
      {  iD = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "D.gif" );
      }

      if ( currentStage > 4 )
      {  iFS = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "SFS.gif" );
      }
      else
      {  iFS = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "FS.gif" );
      }

      if ( currentStage > 4 )
      {  iE = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "SE.gif" );
      }
      else
      {  iE = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "E.gif" );
      }

      if ( currentStage > 4 )
      {  iEC = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "SEC.gif" );
      }
      else
      {  iEC = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "EC.gif" );
      }

      if ( currentStage > 4 )
      {  iEMC = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "SEMC.gif" );
      }
      else
      {  iEMC = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "EMC.gif" );
      }

      if ( has_x2 )
      {  if ( currentStage > 4 )
         {  ix2P = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Sx2P.gif" );
         }
         else
         {  ix2P = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "x2P.gif" );
         }

         if ( currentStage > 4 )
         {  ix2E = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Sx2E.gif" );
         }
         else
         {  ix2E = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "x2E.gif" );
         }
      }

      if ( has_x3 )
      {  if ( currentStage > 4 )
         {  ix3P = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Sx3P.gif" );
         }
         else
         {  ix3P = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "x3P.gif" );
         }

         if ( currentStage > 4 )
         {  ix3E = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Sx3E.gif" );
         }
         else
         {  ix3E = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "x3E.gif" );
         }
      }

      if ( has_x4 )
      {  if ( currentStage > 4 )
         {  ix4P = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Sx4P.gif" );
         }
         else
         {  ix4P = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "x4P.gif" );
         }

         if ( currentStage > 4 )
         {  ix4E = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Sx4E.gif" );
         }
         else
         {  ix4E = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "x4E.gif" );
         }
      }

      if ( currentStage > 4 )
      {  iPU = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "SPU.gif" );
      }
      else
      {  iPU = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "PU.gif" );
      }

      if ( currentStage > 4 )
      {  iExplode = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "SExplode.gif" );
      }
      else
      {  iExplode = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Explode.gif" );
      }

      if ( currentStage > 4 )
      {  iWin = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "SWin.gif" );
      }
      else
      {  iWin = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Win.gif" );
      }

      attacksMAX = ( base_pl + base_attacks );

      /*
      100%
      green on black
      66%
      yellow on black
      33%
      red on black
      0
      black on white
      */
      hp = new JTextField( "" + hpMAX );
      hp.setFocusable( false );
      hp.setBackground( Color.black );
      hp.setForeground( Color.green );
      hp.setBounds( 81, 334, 28, 18 );

      ep = new JTextField( "" + epMAX );
      ep.setFocusable( false );
      ep.setBackground( Color.black );
      ep.setForeground( Color.green );
      ep.setBounds( 81, 358, 28, 18 );

      pl = new JTextField( "" + base_pl );
      pl.setFocusable( false );
      pl.setBackground( Color.black );
      pl.setForeground( Color.green );
      pl.setBounds( 144, 389, 28, 18 );

      strength.setFocusable( false );
      strength.setBackground( Color.black );
      strength.setForeground( Color.white );
      strength.setBounds( 144, 419, 28, 18 );

      endurance.setFocusable( false );
      endurance.setBackground( Color.black );
      endurance.setForeground( Color.white );
      endurance.setBounds( 144, 443, 28, 18 );

      dexterity.setFocusable( false );
      dexterity.setBackground( Color.black );
      dexterity.setForeground( Color.white );
      dexterity.setBounds( 144, 467, 28, 18 );

      speed.setFocusable( false );
      speed.setBackground( Color.black );
      speed.setForeground( Color.white );
      speed.setBounds( 144, 491, 28, 18 );

      skill.setFocusable( false );
      skill.setBackground( Color.black );
      skill.setForeground( Color.white );
      skill.setBounds( 144, 515, 28, 18 );

      attacks = new JTextField( "" + attacksMAX );
      attacks.setFocusable( false );
      attacks.setBackground( Color.black );
      attacks.setForeground( Color.green );
      attacks.setBounds( 144, 539, 28, 18 );

      FGOS.message += ( "\n\n" + name + ", you are on stage " + currentStage + ".\n\n" );
      FGOS.infoArea.setText( FGOS.message );

      if ( currentStage > 5 )
      {  backgroundPic = new JLabel( new ImageIcon( "SaveScreen" + File.separator + "SsaveScreen.jpg" ) );
      }
      else
      {  backgroundPic = new JLabel( new ImageIcon( "SaveScreen" + File.separator + "saveScreen.jpg" ) );
      }
      backgroundPic.setBounds( 0, 0, 800, 600 );

      add( gokuFace );
      add( hp );
      add( ep );
      add( pl );
      add( strength );
      add( endurance );
      add( dexterity );
      add( speed );
      add( skill );
      add( attacks );
      add( backgroundPic );

      remainderTime = 0;
      dice = new DiceRoller( 0, false );

      setupStart();
   }

   private void setupStart()
   {  quit = new JButton( "Quit" );
      quit.setBackground( Color.black );
      quit.setForeground( Color.red.brighter().brighter().brighter() );
      myfont = new Font( "SansSerif", Font.BOLD, 20 );
      quit.setFont( myfont );
      quit.setBorderPainted( false );
      quit.setMnemonic( KeyEvent.VK_S );
      quit.setActionCommand( "Quit" );
      quit.setMaximumSize( quit.getPreferredSize() );
      quit.addActionListener( this );

      Box quitBox = Box.createHorizontalBox();
      quitBox.setBackground( Color.black );
      quitBox.add( quit );

      continueGame = new JButton( "  Continue  " );
      continueGame.setBackground( Color.black );
      continueGame.setForeground( Color.orange );
      continueGame.setFont( myfont );
      continueGame.setBorderPainted( false );
      continueGame.setMnemonic( KeyEvent.VK_C );
      continueGame.setActionCommand( "Continue" );
      continueGame.setMaximumSize( continueGame.getPreferredSize() );
      continueGame.addActionListener( this );

      Box continueBox = Box.createHorizontalBox();
      continueBox.setBackground( Color.black );
      continueBox.add( continueGame );

      continueGame.setToolTipText( "Click this button to continue." );
      quit.setToolTipText( "Click this button to quit the game." );

      choiceBox = Box.createVerticalBox();
      choiceBox.setBackground( Color.black );
      choiceBox.add( Box.createVerticalStrut( 15 ) );
      choiceBox.add( continueBox );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( quitBox );
      choiceBox.add( Box.createVerticalStrut( 50 ) );
      choiceBox.setBounds( 219, 394, 365, 257 );
      remove( backgroundPic );
      add( choiceBox );
      add( backgroundPic );
      update();
      continueGameFocus();
   }

   protected void update()
   {  try
      {  EventQueue.invokeLater( new Runnable()
         {  public void run()
            {  FGOS.ms.revalidate();
               FGOS.ms.repaint();
            }
         } );
      }
      catch ( Exception anException )
      {  System.err.println( "There was an Exception ERROR while calling update()!" );
      }
      FGOS.update();
   }

   private void continueGameFocus()
   {  try
      {  EventQueue.invokeLater( new Runnable()
         {  public void run()
            {  continueGame.requestFocus();
            }
         } );
      }
      catch ( Exception e )
      {  System.err.println( "There was an Exception ERROR while calling continueGame.requestFocus()!" );
      }
   }

   private void continueGameDoClick()
   {  try
      {  EventQueue.invokeLater( new Runnable()
         {  public void run()
            {  continueGame.doClick();
            }
         } );
      }
      catch ( Exception e )
      {  System.err.println( "There was an Exception ERROR while calling continueGame.requestFocus()!" );
      }
   }

   public void actionPerformed( ActionEvent e )
   {  if ( e.getActionCommand().equals( "Continue" ) )
      {  if ( storyLine() )
         {  boss = new Boss( bossNum, currentStage, sync );
            continueGame.removeActionListener( this );
            quit.removeActionListener( this );
            remove( choiceBox );
            addBoss( bossNum );
            // For storyline purposes.
            if ( currentStage == 4 && bossNum == 3 )
            {  dice.rollDice( 4, true );
               fightThread.setEP( false, 59, false );
               fightThread.setEP( false, dice.getResult(), true );
            }
            update();

            // Clean up any old Threads and other junk still hanging around.
            System.gc();

            // Construct a new thread to process the fighting.
            fightThread = new FightThread( sync );

            // Start the fight/fightThread.
            try
            {  EventQueue.invokeLater( new Runnable()
               {  public void run()
                  {  fightThread.start();
                  }
               } );
            }
            catch ( Exception anException )
            {  System.err.println( "There was an Exception ERROR while calling fightThread.start()!" );
            }
         }
      }
      else if ( e.getActionCommand().equals( "Quit" ) )
      {  System.gc();
         System.exit( 0 );
      }
      else if ( e.getActionCommand().equals( "Attack" ) )
      {  attack.removeActionListener( this );
         defend.removeActionListener( this );
         specialMove.removeActionListener( this );
         powerUp.removeActionListener( this );
         remove( choiceBox );
         setupAttack();
         update();
      }
      else if ( e.getActionCommand().equals( "Defend" ) )
      {  attack.removeActionListener( this );
         defend.removeActionListener( this );
         specialMove.removeActionListener( this );
         powerUp.removeActionListener( this );
         remove( choiceBox );

         if ( currentAction.equals( "D" ) )
         {  waitForImage( iD, 15 );
            FGOS.message += ( "\n" + name + ", you maintain a defensive stance.\n\n\n\n" );
         }
         else
         {  currentAction = "D";
            waitForImage( iD, 15 );
            FGOS.message += ( "\n" + name + " you assume an active defensive position.\n\n\n\n" );
         }
         updateInfo();
         numActions_Spent = 1;
         fightThread.setActions( true, numActions_Spent );
         sync.setHeroHas_NOT_Chosen( false );
      }
      else if ( e.getActionCommand().equals( "SpecialMove" ) )
      {  attack.removeActionListener( this );
         defend.removeActionListener( this );
         specialMove.removeActionListener( this );
         powerUp.removeActionListener( this );
         remove( choiceBox );
         setupSpecialMove();
         update();
      }
      else if ( e.getActionCommand().equals( "PowerUp" ) )
      {  boolean poweringUp = true;
         if ( ( get_pl() + 1 ) > ( base_pl + ( get_endurance() * 2 ) ) )
         {  int n = JOptionPane.showConfirmDialog( FGOS.frame, "If you continue with this option you will explode!.\nAre you sure you wish to proceed?", "Warning:", JOptionPane.YES_NO_OPTION );
            if ( n == JOptionPane.YES_OPTION )
            {
            }
            else if ( n == JOptionPane.NO_OPTION )
            {  poweringUp = false;
            }
            else
            {
            }
         }

         if ( poweringUp )
         {  attack.removeActionListener( this );
            defend.removeActionListener( this );
            specialMove.removeActionListener( this );
            powerUp.removeActionListener( this );
            remove( choiceBox );
            currentAction = "PU";
            waitForImage( iPU, 16 );
            FGOS.message += ( "\n\n\n" + name + " you channel your fighting spirit in an attempt to power up.\n\n" );
            updateInfo();
            numActions_Spent = ( get_pl() + 1 );
            fightThread.powerUp( true );
            fightThread.setActions( true, numActions_Spent );
            sync.setHeroHas_NOT_Chosen( false );
         }
      }
      else if ( e.getActionCommand().equals( "NormalAttack" ) )
      {  normalAttack.removeActionListener( this );
         powerAttack.removeActionListener( this );
         cancel.removeActionListener( this );
         remove( choiceBox );
         currentAction = "NA";
         numActions_Spent = 1;
         fightThread.setActions( true, numActions_Spent );
         sync.setHeroHas_NOT_Chosen( false );
      }
      else if ( e.getActionCommand().equals( "PowerAttack" ) )
      {  normalAttack.removeActionListener( this );
         powerAttack.removeActionListener( this );
         cancel.removeActionListener( this );
         remove( choiceBox );
         currentAction = "PA";
         numActions_Spent = 2;
         fightThread.setActions( true, numActions_Spent );
         sync.setHeroHas_NOT_Chosen( false );
      }
      else if ( e.getActionCommand().equals( "A_Cancel" ) )
      {  normalAttack.removeActionListener( this );
         powerAttack.removeActionListener( this );
         cancel.removeActionListener( this );
         remove( choiceBox );
         actionOptions();
         update();
      }
      else if ( e.getActionCommand().equals( "EnergyAttack" ) )
      {  energyAttack.removeActionListener( this );
         comboAttack.removeActionListener( this );
         cancel.removeActionListener( this );
         remove( choiceBox );
         fightThread.setEP( true, eStrength, false );
         setupEnergyAttack();
         update();
      }
      else if ( e.getActionCommand().equals( "ComboAttack" ) )
      {  String choice = ( String )selectCombo.getSelectedItem();
         if ( choice.equals( "x2 Physical" ) )
         {  currentAction = "x2P";
            numActions_Spent = 1;
            fightThread.setActions( true, 2 );
            fightThread.setEP( true, 4, false );
         }
         else if ( choice.equals( "x3 Physical" ) )
         {  currentAction = "x3P";
            numActions_Spent = 1;
            fightThread.setActions( true, 3 );
            fightThread.setEP( true, 9, false );
         }
         else if ( choice.equals( "x4 Physical" ) )
         {  currentAction = "x4P";
            numActions_Spent = 1;
            fightThread.setActions( true, 4 );
            fightThread.setEP( true, 16, false );
         }
         else if ( choice.equals( "x2 Energy" ) )
         {  currentAction = "x2E";
            numActions_Spent = 1;
            fightThread.setActions( true, 2 );
            fightThread.setEP( true, ( 4 + ( 2 * eStrength ) ), false );
         }
         else if ( choice.equals( "x3 Energy" ) )
         {  currentAction = "x3E";
            numActions_Spent = 1;
            fightThread.setActions( true, 3 );
            fightThread.setEP( true, ( 9 + ( 3 * eStrength ) ), false );
         }
         else if ( choice.equals( "x4 Energy" ) )
         {  currentAction = "x4E";
            numActions_Spent = 1;
            fightThread.setActions( true, 4 );
            fightThread.setEP( true, ( 16 + ( 4 * eStrength ) ), false );
         }
         energyAttack.removeActionListener( this );
         comboAttack.removeActionListener( this );
         cancel.removeActionListener( this );
         remove( choiceBox );
         sync.setHeroHas_NOT_Chosen( false );
      }
      else if ( e.getActionCommand().equals( "SA_Cancel" ) )
      {  energyAttack.removeActionListener( this );
         comboAttack.removeActionListener( this );
         cancel.removeActionListener( this );
         remove( choiceBox );
         actionOptions();
         update();
      }
      else if ( e.getActionCommand().equals( "LaunchEnergyAttack" ) )
      {  boolean okay = true;
         ep_cost = ( Integer.parseInt( epSpent.getText().trim() ) + eStrength );
         if ( ep_cost > ( ( ( eStrength + get_skill() + get_pl() ) * 6 ) * 2 ) )
         {  int n = JOptionPane.showConfirmDialog( FGOS.frame, "This will take at least 3 actions to complete!\nAre you sure you wish to proceed?", "Warning:", JOptionPane.YES_NO_OPTION );
            if ( n == JOptionPane.YES_OPTION )
            {
            }
            else if ( n == JOptionPane.NO_OPTION )
            {  okay = false;
            }
            else
            {
            }
         }
         else if ( ep_cost > ( ( eStrength + get_skill() + get_pl() ) * 6 ) )
         {  int n = JOptionPane.showConfirmDialog( FGOS.frame, "This will take at least 2 actions to complete!\nAre you sure you wish to proceed?", "Warning:", JOptionPane.YES_NO_OPTION );
            if ( n == JOptionPane.YES_OPTION )
            {
            }
            else if ( n == JOptionPane.NO_OPTION )
            {  okay = false;
            }
            else
            {
            }
         }
         else if ( ep_cost > ( eStrength + get_skill() + get_pl() ) )
         {  int n = JOptionPane.showConfirmDialog( FGOS.frame, "This might take more than 1 action to complete.\nAre you sure you wish to proceed?", "Warning:", JOptionPane.YES_NO_OPTION );
            if ( n == JOptionPane.YES_OPTION )
            {
            }
            else if ( n == JOptionPane.NO_OPTION )
            {  okay = false;
            }
            else
            {
            }
         }
         else
         {  //Do nothing.
         }

         if ( okay )
         {   numActions_Spent = calculateTime( ep_cost );
             if ( numActions_Spent <= get_attacks() )
             {  if ( numActions_Spent >= 3 || ep_cost >= ( epMAX - ( epMAX / 10 ) ) )
                {  currentAction = "EMC";
                }
                else if ( numActions_Spent == 2 || ep_cost >= ( epMAX / 2 ) )
                {  currentAction = "EC";
                }
                else if ( numActions_Spent == 1 )
                {  currentAction = "E";
                }
                else
                {  currentAction = "Undefined";
                }

                launchEnergyAttack.removeActionListener( this );
                cancel.removeActionListener( this );
                remove( choiceBox );
                fightThread.setActions( true, numActions_Spent );
                fightThread.setEP( true, ( ep_cost - eStrength ), false );
                sync.setHeroHas_NOT_Chosen( false );
             }
             else
             {  JOptionPane.showMessageDialog( FGOS.frame, "It would have taken " + numActions_Spent + " attacks to channel that much power into the attack.\nBut you only have " + get_attacks() + " attacks left this round to use,\ntherefore this attack cannot be used.", "Alert", JOptionPane.ERROR_MESSAGE );
                numActions_Spent = 0;
             }
         }
      }
      else if ( e.getActionCommand().equals( "EA_Cancel" ) )
      {  launchEnergyAttack.removeActionListener( this );
         cancel.removeActionListener( this );
         remove( choiceBox );
         fightThread.setEP( true, eStrength, true );
         actionOptions();
         update();
      }
      else if ( e.getActionCommand().equals( "PowerAttackTest" ) )
      {  powerAttack.removeActionListener( this );
         energyAttack.removeActionListener( this );
         remove( choiceBox );
         currentAction = "PA";
         setupStart();
         continueGameDoClick();
      }
      else if ( e.getActionCommand().equals( "LaunchEnergyTest") )
      {  powerAttack.removeActionListener( this );
         energyAttack.removeActionListener( this );
         remove( choiceBox );
         fightThread.setEP( true, eStrength, false );
         setupEnergyAttackTest();
         update();
      }
      else if ( e.getActionCommand().equals( "LaunchEnergyAttackTest" ) )
      {  ep_cost = ( Integer.parseInt( epSpent.getText().trim() ) + eStrength );
         numActions_Spent = calculateTime( ep_cost );
         if ( numActions_Spent >= 3 || ep_cost == epMAX )
         {  currentAction = "EMC";
         }
         else if ( numActions_Spent == 2 || ep_cost >= ( ( epMAX / 2 ) + 1 ) )
         {  currentAction = "EC";
         }
         else if ( numActions_Spent == 1 )
         {  currentAction = "E";
         }
         else
         {  currentAction = "Undefined";
         }

         launchEnergyAttack.removeActionListener( this );
         cancel.removeActionListener( this );
         remove( choiceBox );
         fightThread.setEP( true, ( ep_cost - eStrength ), false );
         setupStart();
         continueGameDoClick();
      }
      else if ( e.getActionCommand().equals( "Test_Cancel" ) )
      {  launchEnergyAttack.removeActionListener( this );
         cancel.removeActionListener( this );
         remove( choiceBox );
         fightThread.setEP( true, eStrength, true );
         setupTest();
         update();
      }
      else if ( e.getActionCommand().equals( "Youth" ) )
      {  continueGame.removeActionListener( this );
         quit.removeActionListener( this );
         remove( choiceBox );
         setupStart();
         selfishWish = true;
         storyLine();
      }
      else if ( e.getActionCommand().equals( "Peace" ) )
      {  continueGame.removeActionListener( this );
         quit.removeActionListener( this );
         remove( choiceBox );
         setupStart();
         selfishWish = false;
         storyLine();
      }
   }

   protected boolean storyLine()
   {  Image story;
      boolean time_to_fight = false;
      if ( currentStage == 1 )
      {  if ( storyPart == 1 )
         {  FGOS.message += "\nTen years have passed since the last World's Strongest Tournament, and the time has finally come to determine a new World Champion.  As a born fighter, you have trained your entire life for this moment; the moment that you would enter the Tournament and prove to the world that you are indeed the best.\n\nOnce again, many great fighters from all around the world and of all different fighting styles have gathered to compete in the tournament.  But as only eight may compete in the tournament, a simple elimination round has been devised.\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage1" + File.separator + "Story" + File.separator + "Part" + storyPart + ".gif" );
            waitForImage( story, 101 );
         }
         else if ( storyPart == 2 )
         {  FGOS.message += "\nIn order to enter the tournament each contender must past a \"simple\" test of strength.  The difficulty of the test depends on the strength of the fighters involved.  A special hitting machine has been set up that will measures the power of an attack.  The prospective fighters will each in turn hit the machine with their strongest attack.  The top eight rated fighters will then advance to fight in the World's Strongest Tournament.\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage1" + File.separator + "Story" + File.separator + "Part" + storyPart + ".gif" );
            waitForImage( story, 102 );
         }
         else if ( storyPart == 3 )
         {  FGOS.message += "\nHercule, as the reigning champion of the last World's Strongest Tournament, has been asked to \"test\" out the machine.  Tradition dictates that the reigning champion need only fight in the final round, so this \"test\" is merely for show.\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage1" + File.separator + "Story" + File.separator + "Part" + storyPart + ".gif" );
            waitForImage( story, 101 );
         }
         else if ( storyPart == 4 )
         {  do
            {  dice.rollDice( 8, true );
            }  while ( dice.getResult() < 28 );
            tempResult = ( dice.getResult() * 5 );
            FGOS.message += "\nWith tremendous force, Hercule slams his huge fist into the hitting machine!\nHe scores an incredible " + tempResult + "!  This is a new tournament record!  Obviously, Hercule will be a formidable opponent in this year's World's Strongest Tournament!";
            story = Toolkit.getDefaultToolkit().getImage( "Stage1" + File.separator + "Story" + File.separator + "Part" + storyPart + ".gif" );
            waitForImage( story, 103 );
         }
         else if ( storyPart == 5 )
         {  FGOS.message += "\n\nAfter Hercule's incredible demonstration of power, the remaining fighters form a line and each takes his or her turn at the hitting machine.  Eventually it is you turn to go.  Although some have come close, no one has yet to topple Hercule's new record.";
            story = Toolkit.getDefaultToolkit().getImage( "Stage1" + File.separator + "Story" + File.separator + "blank.gif" );
            waitForImage( story, 104 );
         }
         else if ( storyPart == 6 )
         {  FGOS.message += "\n\nIt looks like you are going to have to break the one hundred mark in order to reserve a seat in the tournament.  You now stand before the hitting machine, will you use a power attack or an energy blast?\n";
            continueGame.removeActionListener( this );
            quit.removeActionListener( this );
            setupTest();
         }
         else if ( storyPart == 7 )
         {  if ( currentAction.equals( "PA" ) )
            {  dice.rollDice( get_strength() + ( ( get_strength() / 2 ) + 1 ) + get_pl(), true );
               tempResultTwo = ( dice.getResult() * 5 );
               FGOS.message += "\nYou strike the hitting machine with all your might!  You score a " + tempResultTwo +  "!\n\n\n";
               story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "PA.gif" );
               waitForImage( story, 105 );
            }
            else
            {  dice.rollDice( eStrength + get_pl(), true );
               tempResultTwo = ( ( dice.getResult() + ( ep_cost - eStrength ) ) * 5 );
               FGOS.message += "\nYou channel your power into a blast of pure energy aimed straight for the hitting machine!  You hit and score a " + tempResultTwo + "!\n\n\n";
               story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + currentAction + ".gif" );
               waitForImage( story, 106 );
            }
         }
         else if ( storyPart == 8 )
         {  if ( tempResultTwo > tempResult )
            {  FGOS.message += "Unbelievable!  Your rating of " + tempResultTwo + " is a new tournament record!  You are even stronger than the mighty Hercule!  If the World's Strongest Tournament was based on strength alone, you'd have it in the bag!\n";
               story = Toolkit.getDefaultToolkit().getImage( "Stage1" + File.separator + "Story" + File.separator + "RecordBreakingH.gif" );
               waitForImage( story, 400 );
            }
            else if ( tempResult == tempResultTwo )
            {  FGOS.message += "Incredible!  You mananged to tie the mighty Hercule's new record!  Your seat in the tournament is assured!\n\n\n";
               story = Toolkit.getDefaultToolkit().getImage( "Stage1" + File.separator + "Story" + File.separator + "RecordBreakingH.gif" );
               waitForImage( story, 400 );
            }
            else if ( tempResult <= ( tempResultTwo + 25 ) )
            {  FGOS.message += "Amazing!  You nearly beat the mighty Hercule's new record!  Your seat in the tournament is assured!\n\n\n";
               story = Toolkit.getDefaultToolkit().getImage( "Stage1" + File.separator + "Story" + File.separator + "AlmostBeatH.gif" );
               waitForImage( story, 401 );
            }
            else if ( tempResultTwo > 100 )
            {  FGOS.message += "Well it wasn't record braking, but it ought to do.  Besides, it'll take more than just strength to win the World's Strongest Tournament.\n\n";
               story = Toolkit.getDefaultToolkit().getImage( "Stage1" + File.separator + "Story" + File.separator + "NotEvenCloseH.gif" );
               waitForImage( story, 402 );
            }
            else
            {  FGOS.message += "Oh, no!  Your rating was too low to make it into the World's Strongest Tournament!  At least your entry fee doubles as front row seating.  And besides there's always the next tournament, and it's only a decade away!  Perhaps you better hit the gym!\n";
               story = Toolkit.getDefaultToolkit().getImage( "Stage1" + File.separator + "Story" + File.separator + "NotEvenCloseH.gif" );
               waitForImage( story, 402 );
               failedTest = true;
            }
         }
         else if ( storyPart == 9 )
         {  if ( failedTest )
            {  File temp = null;
               try
               {  String theCharacter = ( "" + true + "|" + ( currentStage ) + "|" + name + "|" + get_hp() + "|" + get_ep() + "|" + get_pl() + "|" + get_strength() + "|" + get_endurance() + "|" + get_dexterity() + "|" + get_speed() + "|" + get_skill() + "|" + ( base_attacks + get_pl() ) + "|" + eStrength + "|" + has_x2 + "|" + has_x3 + "|" + has_x4 );
                  FileOutputStream myfile = new FileOutputStream( "CharacterCreation" + File.separator + "temp.fgos" );
                  myfile.close();
                  temp = new File( "CharacterCreation" + File.separator + "temp.fgos" );
                  PrintWriter out = new PrintWriter( new FileWriter( temp ), true );
                  out.println( theCharacter );
                  out.close();
               }
               catch ( Exception e )
               {  e.printStackTrace();
               }
               FGOS.frame.getContentPane().add( new HighScore( temp ), BorderLayout.CENTER );
               FGOS.frame.getContentPane().remove( this );
               FGOS.update();
            }
            else
            {  FGOS.message += "Soon afterwards all the fighters have had a shot at the hitting machine.  The judges have tallied the rankings and the eight fighters to make it into this decades World's Strongest Tournament are, as follows: Cammy, Chunli, Dan, Dejay, Feilong, Gen, Sagat, and " + name + "!";
               story = Toolkit.getDefaultToolkit().getImage( "Stage1" + File.separator + "Story" + File.separator + "Part" + storyPart + ".gif" );
               waitForImage( story, 107 );
            }
         }
         else if ( storyPart == 10 )
         {  FGOS.message += "\nAfter examining the seatings, it looks like your first fight is with Dan.  His fighting style is known as Saikyo-Ryu (\"The Strongest Style\"), and he invented it himself.  It is rumored that Dan entered the tournament in hopes of fighting with Sagat for reasons unknown.  Also, Dan is bit of a showoff.";
            story = Toolkit.getDefaultToolkit().getImage( "Stage1" + File.separator + "Story" + File.separator + "blank.gif" );
            waitForImage( story, 104 );
         }
         else if ( storyPart == 11 )
         {  FGOS.message += "\n\nFinally, the time has come for your first match.  You enter the tournament arena admidst the roar of the crowd.  This place is packed!  You see that Dan is already here, and being \"sporting\" has decided to write you an autograph.  Dan: \"Here you go.  Wouldn't want you walking away empty handed!\"";
            story = Toolkit.getDefaultToolkit().getImage( "Stage1" + File.separator + "Dan.gif" );
            waitForImage( story, 108 );
         }
         else if ( storyPart == 12 )
         {  FGOS.message += "\n\nSuddenly you hear the announcer boom out: \"Let the game begin!\"  With that the gong rings.  The match has begun!\n\n\n";
            FGOS.playNewSong( "Stage1Dan.mid" );
         }
         else if ( storyPart == 13 )
         {  time_to_fight = true;
         }
         else if ( storyPart == 14 )
         {  checkResult( 1 );
         }
         else if ( storyPart == 15 )
         {  checkResult( 2 );
         }
         ++storyPart;
         updateInfo();
      }
      else if ( currentStage == 2 )
      {  if ( storyPart == 1 )
         {  FGOS.message += "You've beaten you first opponent and made it into the quarter finals.  Great job!  But you must remember not to get too cocky, or you may find yourself ending up like Dan!\n\n";
            waitForImage( iWin, 41 );
         }
         else if ( storyPart == 2 )
         {  FGOS.message += "It looks like your next opponent is Chunli.  She is known for her powerful kicks and even more powerful fireballs.  You'd better be carefull with this one.  She might not look it, but can be an extremely dangerous opponent in a fight!\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage2" + File.separator + "ChunliIntro.gif" );
            waitForImage( story, 109 );
         }
         else if ( storyPart == 3 )
         {  FGOS.message += "Once again you are led out to the arena amidst the roar of the crowd.  You see your opponent Chunli standing alone across from you.    She bows to you in respect.  She says to you: \"I won't go easy on you, so don't go easy on me!\"\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage2" + File.separator + "Chunli.gif" );
            waitForImage( story, 110 );
         }
         else if ( storyPart == 4 )
         {  FGOS.message += "\n\nSuddenly you hear the announcer boom out: \"Let the game begin!\"  With that the gong rings.  Your second match in the World's Strongest Tournament has begun!\n\n";
         }
         else if ( storyPart == 5 )
         {  time_to_fight = true;
         }
         else if ( storyPart == 6 )
         {  checkResult( 1 );
         }
         else if ( storyPart == 7 )
         {  checkResult( 2 );
         }
         ++storyPart;
         updateInfo();
      }
      else if ( currentStage == 3 )
      {  if ( storyPart == 1 )
         {  FGOS.message += "Incredible!  You've made it into the semi-finals!  Chunli was one of the highest ranked fighters too!  However, your rejoicing may be short lived, for Sagat is your next opponent and he is the person favored to win the tournament.\n";
            waitForImage( iWin, 41 );
         }
         else if ( storyPart == 2 )
         {  FGOS.message += "Rumor has it the Sagat would have won the last World's Strongest Tournament had he not suffered from a mysterious injury that left him hospitalized for the duration of the Tournament.\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage1" + File.separator + "Story" + File.separator + "blank.gif" );
            waitForImage( story, 104 );
         }
         else if ( storyPart == 3 )
         {  FGOS.message += "Yet again you are led out to the arena amidst the roar of the crowd.  You see Sagat standing alone across from you.  He's huge!  He stands there looking at you with hate filled eyes waiting for the match to begin.\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage3" + File.separator + "Sagat.gif" );
            waitForImage( story, 110 );
         }
         else if ( storyPart == 4 )
         {  FGOS.message += "\n\nSuddenly you hear the announcer boom out: \"Let the game begin!\"  With that the gong rings.  The semi-final match of this decade's World's Strongest Tournament has begun!\n\n";
         }
         else if ( storyPart == 5 )
         {  time_to_fight = true;
         }
         else if ( storyPart == 6 )
         {  checkResult( 1 );
         }
         else if ( storyPart == 7 )
         {  checkResult( 2 );
         }
         ++storyPart;
         updateInfo();
      }
      else if ( currentStage == 4 )
      {  if ( storyPart == 1 )
         {  FGOS.message += "\n\nIt was tough, but you did it!  With Sagat out of the way only one man stands between you and your goal of achieving the title of the World's Strongest.\n\n";
            waitForImage( iWin, 41 );
         }
         else if ( storyPart == 2 )
         {  FGOS.message += "\n\nHowever, Hercule is that man, and he means to keep the title for himself!\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage1" + File.separator + "Story" + File.separator + "blank.gif" );
            waitForImage( story, 104 );
         }
         else if ( storyPart == 3 )
         {  FGOS.message += "\n\nFor the final time this decade you are led out to the arena.  It's almost hard to believe, but the roar of the crowd is louder than ever.  Then you see him, Hercule, the man, the champ, posing for the crowd.\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage4" + File.separator + "HerculeIntro.gif" );
            waitForImage( story, 111 );
         }
         else if ( storyPart == 4 )
         {  FGOS.message += "\n\nSuddenly you hear the announcer boom out: \"Let the game begin!\"  With that the gong rings.  The final match of this decade's World's Strongest Tournament has begun!  This is it!\n\n";
         }
         else if ( storyPart == 5 )
         {  time_to_fight = true;
         }
         else if ( storyPart == 6 )
         {  checkResult( 1 );
         }
         else if ( storyPart == 7 )
         {  checkResult( 2 );
            if ( get_hp() > 0 )
            {  ++storyPart;
            }
            continueGameFocus();
         }
         // Done for storyline purposes.
         if ( storyPart == 8 )
         {  FGOS.message += "\n\nIncredible!  You've defeated the mighty Hercule, and now you are the World's Strongest!\n\n\n";
            waitForImage( iWin, 41 );
            // setup for next fight.
            dice.rollDice( get_pl(), false );
            fightThread.setEP( true, dice.getResult(), true );
            pl.setText( base_pl + "" );
            pl.setForeground( Color.green );
            FGOS.playNewSong( "TournamentWin.mid" );
         }
         else if ( storyPart == 9 )
         {  FGOS.message += "\n\nThere is a colossal celebration in your name as you are crowned the World's Strongest Warrior.  Fame and fortune are now yours.\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage4" + File.separator + "SuperFireworks.gif" );
            waitForImage( story, 112 );
         }
         else if ( storyPart == 10 )
         {  FGOS.message += "\n\nAfter the ceremony, an old man accosts you.  Old man: \"Hey there sonny!  Saw you during the tournament.  You did a pretty good job!\" " + name + ": \"Not just pretty good, old man, I won.\"\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage4" + File.separator + "Roshi.gif" );
            waitForImage( story, 113 );
         }
         else if ( storyPart == 11 )
         {  FGOS.message += "\n\nOld man: \"Yeah, well maybe if you'd had some real competition that wouldn't have happened.\"  " + name + ": \"Humph.  Are you saying you know of any?\"  Old man: \"Actually you're looking at him.\"  " + name + ": \"What you?\"  Old man: \"Don't sound so surprised sonny.\"";
         }
         else if ( storyPart == 12 )
         {  FGOS.message += "\n\n\"I'll have you know that I won this tournament myself, back in my day.\"  " + name + ": \"Back in your day, eh, when was that, before I was born?\" Old man: \"Come to think of it, yes, I have been kicking butt since before you could walk or talk, and after I'm done with you, you won't be able to do either.\"";
         }
         else if ( storyPart == 13 )
         {  FGOS.message += "\n\n" + name + ": \"Put your money where your mouth is old man. I don't fight for free.\"  Old man: \"Okay then, if you beat me I'll give you my most valued possession, and if you lose you give me yours.\"  " + name + ": \"I don't need your junk old man, but if you want to pay me for a beating I'll gladly oblige.\"";
         }
         else if ( storyPart == 14 )
         {  FGOS.message += "\n\nWith that the fight was on!\n\n\n\n";
            FGOS.playNewSong( "Stage4Roshi.mid" );
         }
         else if ( storyPart == 15 )
         {  time_to_fight = true;
         }
         else if ( storyPart == 16 )
         {  checkResult( 1 );
         }
         else if ( storyPart == 17 )
         {  checkResult( 2 );
            if ( get_hp() > 0 )
            {  ++storyPart;
            }
            continueGameFocus();
         }
         // Done for storyline purposes.
         if ( storyPart == 18 )
         {  FGOS.message += "\n\n" + name + ": \"Face it old man, I've won.\"  Old man: \"It ain't over yet sonny!\"\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage4" + File.separator + "SRoshi.gif" );
            waitForImage( story, 114 );
            // setup for next fight.
            dice.rollDice( get_pl(), false );
            fightThread.setEP( true, dice.getResult(), true );
            pl.setText( base_pl + "" );
            pl.setForeground( Color.green );
            FGOS.playNewSong( "Stage4SRoshi.mid" );
         }
         else if ( storyPart == 19 )
         {  FGOS.message += "\n\n" + name + ": \"What the...\"  Old man: \"KAAAAA MEEEEE HAAAAA\"\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage4" + File.separator + "SRoshiIntro.gif" );
            waitForImage( story, 115 );
         }
         if ( storyPart == 20 )
         {  FGOS.message += "\n\nOld man: \"MEEEEE HAAAAA!\"\n";
            FGOS.message += "After channeling monstrous amounts of power into this next attack, SRoshi unleashes its incredible might upon you and hits!\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage4" + File.separator + "SRoshiEMC.gif" );
            waitForImage( story, 116 );
         }
         else if ( storyPart == 21 )
         {  dice.rollDice( 4, false );
            int ep = dice.getResult();
            dice.rollDice( 8, true );
            int damage = ( dice.getResult() + ep );
            FGOS.ms.resistDamage( damage );
         }
         else if ( storyPart == 22 )
         {  time_to_fight = true;
         }
         else if ( storyPart == 23 )
         {  checkResult( 1 );
         }
         else if ( storyPart == 24 )
         {  checkResult( 2 );
            if ( get_hp() > 0 )
            {  ++storyPart;
            }
            continueGameFocus();
         }
         // Done for storyline purposes.
         if ( storyPart == 25 )
         {  FGOS.message += "\n\n" + name + ": \"You were right old man.  I've never fought ANYBODY as strong as you!\"  Old man: \"Heh, you aren't so bad yourself, and as promised here is my most prized possession, a Dragon Ball. " + name + ": \"What's a Dragon Ball?\"\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage4" + File.separator + "DragonBall1.gif" );
            waitForImage( story, 117 );
            // setup for next fight.
            dice.rollDice( get_pl(), false );
            fightThread.setEP( true, dice.getResult(), true );
            pl.setText( base_pl + "" );
            pl.setForeground( Color.green );
            FGOS.playNewSong( "Stage4Story.mid" );
         }
         else if ( storyPart == 26 )
         {  FGOS.message += "\n\nOld man: \"A Dragon Ball is a mystical artifact.  When all seven are brought together it summons the eternal dragon Shenlong and forces him to grant the summoner any two wishes.\"\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage4" + File.separator + "DragonBalls.gif" );
            waitForImage( story, 501 );
         }
         else if ( storyPart == 27 )
         {  FGOS.message += "\n\n" + name + ": \"Sounds kind of hokey, if you ask me.\"  Old man: \"I can assure you that the legend is real and these Dragon Balls are for real.  I was appointed guardian of this Dragon Ball many years ago.  You can imagine what kind of damage could be dealt if all seven were to fall into the wrong hands.\"";
         }
         else if ( storyPart == 28 )
         {  FGOS.message += "\n\n\"That is why I am asking you to guard this Dragon Ball for me.  I'm getting too old for this, especially if someone like you could beat me.\"" + name + ": \"Hey!  I'm not exactly a push over!\"  Old man: \"True, true, I sense you have the potential to become a great warrior someday.\"";
            story = Toolkit.getDefaultToolkit().getImage( "Stage4" + File.separator + "DragonBall1.gif" );
            waitForImage( story, 117 );
         }
         else if ( storyPart == 29 )
         {  FGOS.message += "\n\n\"But first you must overcome your weakness and learn to tap into your inner strength!\"" + name + ": \"Yeah, well, even without this \"inner strength\" I was able to kick your butt!\"  Old man: \"Yes, but I am past my prime.  The fighter's you will soon face will not be.\"\n";
         }
         else if ( storyPart == 30 )
         {  FGOS.message += "\n\n" + name + ": \"What makes you think I'll say yes?\"  Old man: \"The thought of a challenge.  I've been watching you for quite some time, and you never could turn one down.  This is the perfect chance for you to tap into your untapped potential.\"\n";
         }
         else if ( storyPart == 31 )
         {  FGOS.message += "\n\n\"And this is the only chance you'll have of truly fighting against the world's strongest warriors.\"  " + name + ": \"And what if I decide to collect all seven Dragon Ball's for myself?\"  Old man: \"Do what you feel you must, but finding all seven Dragon Ball's is no easy task.\"";
         }
         else if ( storyPart == 32 )
         {  FGOS.message += "\n\n\"I know of only one other, and it is guarded by the star pupil of my arch nemesis.  The pupil's name is Tien, and his is a master of the martial arts and a master assassin.\"  " + name + ": \"Just point me in the right direction.\"  Old man: \"I can do better than that.  I can tell you where to find him.\"";
         }
         else if ( storyPart == 33 )
         {  FGOS.message += "\n\nWith that the old man hands you the precious Dragon Ball and tells you of the secret mountain top location where Tien is sure to be found.  Your quest to collect the seven Dragon Balls has begun!\n";
         }
         else if ( storyPart == 34 )
         {  story = Toolkit.getDefaultToolkit().getImage( "Stage1" + File.separator + "Story" + File.separator + "blank.gif" );
            waitForImage( story, 104 );
            levelUp( false );
         }
         ++storyPart;
         updateInfo();
      }
      else if ( currentStage == 5 )
      {  if ( storyPart == 1 )
         {  FGOS.message += "\n\nYou set off on your quest to collect the Dragon Balls.  Suddenly you get the feeling that you are not alone!  You realize that you are being followed and shout out: \"I know you're there so you might as well show yourself!\"\n";
         }
         else if ( storyPart == 2 )
         {  FGOS.message += "\n\nA mean looking monk steps out of the shadows.  Nothing about him seems out of the ordinary except for the murderous look in his eyes.  The shadowy man speaks: \"My name is Krillin and I've come to retrieve what's rightfully mine!\"  With that he attacks!\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage5" + File.separator + "Story" + File.separator + "KrillinAttacks.gif" );
            waitForImage( story, 118 );
         }
         else if ( storyPart == 3 )
         {  FGOS.message += "\n\nYou easily block his attack.  " + name + ": \"And what would that be?\"  Krillin: \"Why the Dragon Ball of course!\"  " + name + ": \"Sorry, but it's mine.  The old man gave it to me fair and square.\"  Krillin: \"Yeah, well maybe it wasn't the old man's to give.\"\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuBlock.gif" );
            waitForImage( story, 200 );
         }
         else if ( storyPart == 4 )
         {  FGOS.message += "\n\n" + name + ": \"What do you mean?\"  Krillin: \"I mean, I didn't spend the last eighteen years of my life training with the old geezer just so he could give the Dragon Ball to somebody else.\"  " + name + ": \"Hey, any problems you have with the old man you can take up with him.\"";
         }
         else if ( storyPart == 5 )
         {  FGOS.message += "\n\nKrillin: \"Oh, he's already been dealt with.  I should have killed the old geezer long ago and taken the ball from him.  Oh well, guess I'll just have to take it from you instead.\"  " + name + ": \"Over my dead body.\"  Krillin: \"That was the idea.\"\n";
         }
         else if ( storyPart == 6 )
         {  FGOS.message += "\n\n\"Besides this way I can prove that I should have been the successor to the Dragon Ball all along!\"  Suddenly the thought of this man killing the old man makes the old man's words come rushing back: \"you must overcome your weakness and learn to tap into your inner strength!\"";
            story = Toolkit.getDefaultToolkit().getImage( "Stage5" + File.separator + "KrillinIntro.gif" );
            waitForImage( story, 201 );
         }
         else if ( storyPart == 7 )
         {  FGOS.message += "\n\nA rush of anger and adrenalin hits you.  Suddenly more power than you have ever felt before begins coursing through your body.  A transformation is taking place!\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuPU.gif" );
            remove( gokuFace );
            remove( choiceBox );
            remove( backgroundPic );
            gokuFace = new JLabel( new ImageIcon( "SaveScreen" + File.separator + "GokuFaceP.gif" ) );
            gokuFace.setBounds( 123, 327, 50, 50 );
            add( gokuFace );
            add ( choiceBox );
            add ( backgroundPic );
            waitForImage( story, 119 );
            update();
            continueGameFocus();
         }
         else if ( storyPart == 8 )
         {  story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuTransform2.gif" );
            remove( gokuFace );
            remove( choiceBox );
            remove( backgroundPic );
            gokuFace = new JLabel( new ImageIcon( "SaveScreen" + File.separator + "GokuPUFace.gif" ) );
            gokuFace.setBounds( 123, 327, 50, 50 );
            add( gokuFace );
            add ( choiceBox );
            add ( backgroundPic );
            waitForImage( story, 120 );
            update();
            continueGameFocus();
         }
         else if ( storyPart == 9 )
         {  story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuTransform1.gif" );
            remove( gokuFace );
            remove( choiceBox );
            remove( backgroundPic );
            gokuFace = new JLabel( new ImageIcon( "SaveScreen" + File.separator + "SGokuFace.gif" ) );
            gokuFace.setBounds( 123, 327, 50, 50 );
            backgroundPic = new JLabel( new ImageIcon( "SaveScreen" + File.separator + "SsaveScreen.jpg" ) );
            backgroundPic.setBounds( 0, 0, 800, 600 );
            add( gokuFace );
            add ( choiceBox );
            add ( backgroundPic );
            waitForImage( story, 121 );
            update();
            continueGameFocus();
         }
         else if ( storyPart == 10 )
         {  FGOS.message += "\n\nKrillin: \"Neat trick, but it still won't save you.  I trained with the old man, remember.\"  " + name + ": \"Yes, and now you will join him in the grave!\"  With that the battle was on!\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage5" + File.separator + "Story" + File.separator + "KrillinAttack.gif" );
            waitForImage( story, 777 );
         }
         else if ( storyPart == 11 )
         {  time_to_fight = true;
         }
         else if ( storyPart == 12 )
         {  checkResult( 1 );
         }
         else if ( storyPart == 13 )
         {  checkResult( 2 );
         }
         ++storyPart;
         updateInfo();
      }
      else if ( currentStage == 6 )
      {  if ( storyPart == 1 )
         {  FGOS.message += "\n\nHaving dealt with Krillin, you continued on with your quest.  You contemplate how funny things sometimes work out.  Krillin came to kill you, but in the end he simply made you stronger by helping to unlock your hidden potential.\n";
            waitForImage( iWin, 41 );
         }
         else if ( storyPart == 2 )
         {  FGOS.message += "\n\nFinally, you made it to Tien's supposed hiding place, and you find him there training with the most bizarre technique you have ever seen.  There are three of him battling it out amongst themselves!\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage6" + File.separator + "Story" + File.separator + "TienMultiForm.gif" );
            waitForImage( story, 122 );
         }
         else if ( storyPart == 3 )
         {  FGOS.message += "\n\nAfter he finishes training he sees you.  Tien: \"You have come for my Dragon Ball I presume.\"  " + name + ": \"Don't suppose you'll just hand it over?\"  Tien: \"Nope, you'll have to pry it from my cold dead fingers if you really want it.\"  " + name + ": \"Thought so.\"\n";
         }
         else if ( storyPart == 4 )
         {  FGOS.message += "\n\n\"Well, lets get this over with.\"  And with that that battle was on!\n\n\n\n";
            FGOS.playNewSong( "Stage6Tien.mid" );
         }
         else if ( storyPart == 5 )
         {  time_to_fight = true;
         }
         else if ( storyPart == 6 )
         {  checkResult( 1 );
         }
         else if ( storyPart == 7 )
         {  checkResult( 2 );
         }
         ++storyPart;
         updateInfo();
      }
      else if ( currentStage == 7 )
      {  if ( storyPart == 1 )
         {  FGOS.message += "\n\nHaving defeated the master assassin Tien, you take his Dragon Ball bringing your total up to two.  Only five more to go you tell yourself.\n\n";
            waitForImage( iWin, 41 );
         }
         else if ( storyPart == 2 )
         {  FGOS.message += "\n\nJust then a tall cloaked figured appears before you.  " + name + ": \"Who are you?\"\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage7" + File.separator + "Story" + File.separator + "PiccoloPose.jpg" );
            waitForImage( story, 800 );
         }
         else if ( storyPart == 3 )
         {  FGOS.message += "\n\nCloaked figure: \"I was thinking of asking you the same.  My name is Piccolo and I've come to battle Tien for his Dragon Ball.  But I see you've already taken care of that!\"\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage7" + File.separator + "Story" + File.separator + "PiccoloWind1.gif" );
            waitForImage( story, 123 );
         }
         else if ( storyPart == 4 )
         {  FGOS.message += "\n" + name + ": \"Well then Piccolo, unless you want to end up like Tien I suggest you leave.\"\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuTalk.gif" );
            waitForImage( story, 125 );
         }
         else if ( storyPart == 5 )
         {  FGOS.message += "\n\nPiccolo: \"Ha! Tien was a weakling compared to me.  I suggest that you hand over all of your Dragon Balls unless you want to join him!\"\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage7" + File.separator + "Story" + File.separator + "PiccoloWind2.gif" );
            waitForImage( story, 124 );
         }
         else if ( storyPart == 6 )
         {  FGOS.message += "\n" + name + ": \"Sorry, no can do.  But if you happen to have any Dragon Balls I'll gladly take them from you!\"\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuTalk.gif" );
            waitForImage( story, 125 );
         }
         else if ( storyPart == 7 )
         {  FGOS.message += "\nPiccolo: \"Well then it seems both of us are unwilling to part with our Dragon Balls.  Guess we're going to have to settle this the old fashioned way.  Winner takes all!\"\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage7" + File.separator + "Story" + File.separator + "PiccoloTalk.gif" );
            waitForImage( story, 126 );
         }
         else if ( storyPart == 8 )
         {  FGOS.message += "\n" + name + ": \"Sounds good to me.  But I should warn you, I always win!\"\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuTalk.gif" );
            waitForImage( story, 125 );
         }
         else if ( storyPart == 9 )
         {  FGOS.message += "\nPiccolo: \"Not this time, I watched your fight with Tien, so I've studied all your moves.  You can't possibly beat me.  Also I noticed that you never had the pleasure of experiencing Tien's multi-form technique in battle.\"\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage7" + File.separator + "Story" + File.separator + "PiccoloIntro.gif" );
            waitForImage( story, 127 );
         }
         else if ( storyPart == 10 )
         {  FGOS.message += "\n\"Luckily, I have mastered it myself and I willing to allow you a taste of its power!\"  Just then Piccolo splits into three different Piccolos!\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage7" + File.separator + "Story" + File.separator + "PiccoloMultiForm.gif" );
            waitForImage( story, 128 );
         }
         else if ( storyPart == 11 )
         {  FGOS.message += "\n\"Now your going to have to beat us all at once!\"  And with that the battle was on!\n\n\n";
            FGOS.playNewSong( "Stage7Piccolo1.mid" );
         }
         else if ( storyPart == 12 )
         {  time_to_fight = true;
         }
         else if ( storyPart == 13 )
         {  checkResult( 1 );
         }
         else if ( storyPart == 14 )
         {  checkResult( 2 );
            if ( get_hp() > 0 )
            {  ++storyPart;
            }
            continueGameFocus();
         }
         // Done for storyline purposes.
         if ( storyPart == 15 )
         {  FGOS.message += "\n\nYou did it, you won!  You realize that although the multi-form technique looks cool, it's really more flash than substance.\n\n\n";
            waitForImage( iWin, 41 );
            // setup for next fight.
            dice.rollDice( get_pl(), false );
            fightThread.setEP( true, dice.getResult(), true );
            pl.setText( base_pl + "" );
            pl.setForeground( Color.green );
         }
         else if ( storyPart == 16 )
         {  FGOS.message += "\n\nSuddenly one of the Piccolo's regenerates his arm!\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage7" + File.separator + "Story" + File.separator + "PiccoloRegeneration.gif" );
            waitForImage( story, 129 );
         }
         else if ( storyPart == 17 )
         {  FGOS.message += "\n\nThen he stands over the two fallen Piccolo's and re-absorbs them!\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage7" + File.separator + "Story" + File.separator + "PiccoloFuse.gif" );
            waitForImage( story, 130 );
         }
         else if ( storyPart == 18 )
         {  FGOS.message += "\n\nPiccolo: \"Humph.  You got lucky, but that was just a warm up.  Get ready for round two!\"\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage7" + File.separator + "Story" + File.separator + "PiccoloStretch.gif" );
            waitForImage( story, 131 );
         }
         else if ( storyPart == 19 )
         {  FGOS.message += "\n\nPiccolo charges up to attack!\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage7" + File.separator + "Story" + File.separator + "PiccoloCharge.jpg" );
            waitForImage( story, 720 );
         }
         else if ( storyPart == 20 )
         {  FGOS.message += "\n\nAnd with that the battle was on, again!\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage7" + File.separator + "Story" + File.separator + "PiccoloCharging.gif" );
            waitForImage( story, 531 );
            FGOS.playNewSong( "Stage7Piccolo2.mid" );
         }
         else if ( storyPart == 21 )
         {  time_to_fight = true;
         }
         else if ( storyPart == 22 )
         {  checkResult( 1 );
         }
         else if ( storyPart == 23 )
         {  checkResult( 2 );
         }
         ++storyPart;
         updateInfo();
      }
      else if ( currentStage == 8 )
      {  if ( storyPart == 1 )
         {  FGOS.message += "\n\nWow, Piccolo was a lot tougher the second time around.  But you managed to defeat him yet again, and this time you made sure that no amount of regeneration would save him!\n\n";
            waitForImage( iWin, 41 );
         }
         else if ( storyPart == 2 )
         {  FGOS.message += "\n\nAfter searching Piccolo's scattered remains, you manage to find a Dragon Ball among all the debris.  Hmm, you think to yourself.  This brings my Dragon Ball count up to three, but there are still four more to go and I haven't the foggiest idea of where to look for them.";
            story = Toolkit.getDefaultToolkit().getImage( "Stage1" + File.separator + "Story" + File.separator + "blank.gif" );
            waitForImage( story, 104 );
         }
         else if ( storyPart == 3 )
         {  FGOS.message += "\n\nJust then three beings drop from the sky, two guys and a girl.  Beings: \"Hand over your three Dragon Balls right now, we know you have them!\"  " + name + ": \"What the... How could you know such a thing and what makes you think that I'd just hand them over to you?\"";
            story = Toolkit.getDefaultToolkit().getImage( "Stage8" + File.separator + "Story" + File.separator + "Androids.gif" );
            waitForImage( story, 500 );
         }
         else if ( storyPart == 4 )
         {  FGOS.message += "\n\nBeings: \"Look human, we are androids, I am 17, my sister here is 18, and that guys name is 16.  We have been sent by Dr. Gero to collect the Dragon Ball's and he only needs six more.  The three we've already collected, and the three you are holding.  Now give them up!\"";
            story = Toolkit.getDefaultToolkit().getImage( "Stage8" + File.separator + "Story" + File.separator + "AndroidsFaces.gif" );
            waitForImage( story, 510 );
         }
         else if ( storyPart == 5 )
         {  FGOS.message += "\n\n" + name + ": \"I don't care what you are or who sent you.  I'm not handing over my Dragon Balls.  But kindly hand over your three and tell me where to find this Gero character and I'll let you live.\"\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuTalk.gif" );
            waitForImage( story, 125 );
         }
         else if ( storyPart == 6 )
         {  FGOS.message += "\n\nAndroid17:  \"Look human, you're in no position to bargain.  Isn't it obvious?  Your outclassed and outnumbered.  Now hand over your three Dragon Balls and we might let you live.\"\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage8" + File.separator + "Story" + File.separator + "Android17Talk.jpg" );
            waitForImage( story, 132 );
         }
         else if ( storyPart == 7 )
         {  FGOS.message += "\n\n" + name + ": \"What obvious is the fact that you three don't know who you messing with!  Well, you can't say I didn't warn you.\"  Android17: \"I'm going to enjoy wiping that smirk off your face.  In fact, while I'm at it, I think I'll just take the whole thing off!\"\n";
         }
         else if ( storyPart == 8 )
         {  FGOS.message += "\n\n" + name + ": \"Bring it on!\"  And with that the battle with Android17 began!\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuDetermined.gif" );
            waitForImage( story, 133 );
         }
         else if ( storyPart == 9 )
         {  time_to_fight = true;
         }
         else if ( storyPart == 10 )
         {  checkResult( 1 );
         }
         else if ( storyPart == 11 )
         {  checkResult( 2 );
            if ( get_hp() > 0 )
            {  ++storyPart;
            }
            continueGameFocus();
         }
         // Done for storyline purposes.
         if ( storyPart == 12 )
         {  FGOS.message += "\n\n" + name + ": \"Hmm... I thought you guys said I was outclassed and outnumbered.  So far it looks like I'm just outnumbered, and even that is quickly becoming false.\"\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuTalk.gif" );
            waitForImage( story, 125 );
            // setup for next fight.
            dice.rollDice( get_pl(), false );
            fightThread.setEP( true, dice.getResult(), true );
            pl.setText( base_pl + "" );
            pl.setForeground( Color.green );
         }
         else if ( storyPart == 13 )
         {  FGOS.message += "\n\nAndroid18: \"What can I say, my brother fights like a girl.\"  " + name + ": \"And you don't?\"  Android18: \"Your about to find out!\"\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage8" + File.separator + "Story" + File.separator + "Android18Intro.gif" );
            waitForImage( story, 134 );
         }
         else if ( storyPart == 14 )
         {  FGOS.message += "\nAnd with that your battle with Android18 began!\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage8" + File.separator + "Story" + File.separator + "Androids18n16.gif" );
            waitForImage( story, 550 );
            FGOS.playNewSong( "Stage818.mid" );
         }
         else if ( storyPart == 15 )
         {  time_to_fight = true;
         }
         else if ( storyPart == 16 )
         {  checkResult( 1 );
         }
         else if ( storyPart == 17 )
         {  checkResult( 2 );
            if ( get_hp() > 0 )
            {  ++storyPart;
            }
            continueGameFocus();
         }
         // Done for storyline purposes.
         if ( storyPart == 18 )
         {  FGOS.message += "\n\n" + name + ": \"Well how about it big guy, you next?\"  Android16: \"You may have defeated the others, but you won't defeat me.  I am invincible!\"  " + name + ": \"Yeah, well save it for the fight.\"  Android16: \"Prepare to be Terminated!\"\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage8" + File.separator + "Story" + File.separator + "Android16Stare.jpg" );
            waitForImage( story, 520 );
            // setup for next fight.
            dice.rollDice( get_pl(), false );
            fightThread.setEP( true, dice.getResult(), true );
            pl.setText( base_pl + "" );
            pl.setForeground( Color.green );
         }
         else if ( storyPart == 19 )
         {   FGOS.message += "\nAnd with that the final fight against the Androids began!\n\n\n\n";
             story = Toolkit.getDefaultToolkit().getImage( "Stage8" + File.separator + "Story" + File.separator + "Android16Ready.jpg" );
             waitForImage( story, 530 );
             FGOS.playNewSong( "Stage816.mid" );
         }
         else if ( storyPart == 20 )
         {  time_to_fight = true;
         }
         else if ( storyPart == 21 )
         {  checkResult( 1 );
         }
         else if ( storyPart == 22 )
         {  checkResult( 2 );
         }
         ++storyPart;
         updateInfo();
      }
      else if ( currentStage == 9 )
      {  if ( storyPart == 1 )
         {  FGOS.message += "\n\nYou did it!  Those three turned out to be the toughest opponents yet!  But now you have six of the seven Dragon Balls, so there is only one more to go!\n\n";
            waitForImage( iWin, 41 );
         }
         else if ( storyPart == 2 )
         {  FGOS.message += "\n\nUnfortunately, you never did get them to reveal the whereabouts of this Dr. Gero character.  But at least you have a name to go on.  And besides, if this Dr. really is looking for the Dragon Balls, since you have six of them, maybe he'll just find you again.";
            story = Toolkit.getDefaultToolkit().getImage( "Stage8" + File.separator + "Story" + File.separator + "AndroidsStanding.gif" );
            waitForImage( story, 540 );
         }
         else if ( storyPart == 3 )
         {  FGOS.message += "\n\nJust then another being drops from the sky.\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage9" + File.separator + "Story" + File.separator + "VegetaStand.jpg" );
            waitForImage( story, 900 );
         }
         else if ( storyPart == 4 )
         {  FGOS.message += "\nSuddenly the being powers up!\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage9" + File.separator + "Story" + File.separator + "VegetaTransform.gif" );
            waitForImage( story, 141 );
         }
         else if ( storyPart == 5 )
         {  FGOS.message += "\nBeing: \"I am Vegeta, prince of the Saiyins, and I have come for your Dragon Balls!\"\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage9" + File.separator + "Story" + File.separator + "VegetaPose.jpg" );
            waitForImage( story, 910 );
         }
         else if ( storyPart == 6 )
         {  FGOS.message += "\n" + name + ": \"Let me guess, Dr. Gero sent you?\"\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuTalk.gif" );
            waitForImage( story, 125 );
         }
         else if ( storyPart == 7 )
         {  FGOS.message += "\n\nVegeta: \"Bah, I am no ones mere lacky!  And if you are referring to that pathetic robotic weakling, I eradicated him a couple of hours ago in order to get his Dragon Ball.  Now I suggest you hand over yours unless you wish to meet the same fate!\"\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage9" + File.separator + "Story" + File.separator + "VegetaStand2.jpg" );
            waitForImage( story, 920 );
         }
         else if ( storyPart == 8 )
         {  FGOS.message += "\n\nWow, I thought the old man said that it was going to be difficult to gather all seven Dragon Balls.  It looks to me that they've all practically landed in my lap!  " + name + ": \"Sorry, Vegeta no can do.  But if you give me your Dragon Ball I won't have to kill you.\"\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuTalk.gif" );
            waitForImage( story, 125 );
         }
         else if ( storyPart == 9 )
         {  FGOS.message += "\n\nVegeta: \"Crazy earthling, you don't know what your getting yourself into.  Even if you did manage to defeat me, even as we speak Freeza and Cell are on there way to this pathetic planet and if I don't use the Dragon Ball's to make myself immortal, nothing will stop them!\"";
            story = Toolkit.getDefaultToolkit().getImage( "Stage9" + File.separator + "Story" + File.separator + "VegetaPU.gif" );
            waitForImage( story, 142 );
         }
         else if ( storyPart == 10 )
         {  FGOS.message += "\n\n" + name + ": \"How do I know I can trust you?  Even if what you are saying is true, it seems to me that I should be the one to wish for immortality and stop them.  After all, I do hold the vast majority of the Dragon Balls\"\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuDetermined.gif" );
            waitForImage( story, 143 );
         }
         else if ( storyPart == 11 )
         {  FGOS.message += "\nVegeta: \"That will soon change!\"\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage9" + File.separator + "Story" + File.separator + "VegetaMean.gif" );
            waitForImage( story, 144 );
         }
         else if ( storyPart == 12 )
         {  FGOS.message += "\nAnd with that Vegeta attacks!  The battle against the Prince of the Saiyins has begun!\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage9" + File.separator + "Story" + File.separator + "GokuVSVegeta.jpg" );
            waitForImage( story, 800 );
            FGOS.playNewSong( "Stage9Vegeta.mid" );
         }
         else if ( storyPart == 13 )
         {  time_to_fight = true;
         }
         else if ( storyPart == 14 )
         {  checkResult( 1 );
         }
         else if ( storyPart == 15 )
         {  checkResult( 2 );
            if ( get_hp() > 0 )
            {  ++storyPart;
            }
            continueGameFocus();
         }
         // Done for storyline purposes.
         if ( storyPart == 16 )
         {  FGOS.message += "\nBut then your underlying superiority shines through, and slowly the tide of battle turns in your favor.  Try as he might, Vegeta is powerless to stop the tables from turning.\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage9" + File.separator + "Story" + File.separator + "VegetaLosing.gif" );
            waitForImage( story, 810 );
         }
         else if ( storyPart == 17 )
         {  FGOS.message += "\nFilled to bursting with rage, Vegeta screams out in frustration and pain.\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage9" + File.separator + "Story" + File.separator + "VegetaScream.jpg" );
            waitForImage( story, 820 );
         }
         else if ( storyPart == 18 )
         {  FGOS.message += "\nSeizing upon the opportunity, you move in for the kill.  You beat Vegeta into unconsciousness and then send him flying into the next dimension with a powerful series of energy blasts.\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage9" + File.separator + "Story" + File.separator + "VegetaDeath.gif" );
            waitForImage( story, 830 );
         }
         else if ( storyPart == 19 )
         {  FGOS.message += "\nYou did it!  You've defeated Vegeta and collected all seven Dragon Balls!  Now you can finally summon the eternal dragon and make your two wishes!\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage9" + File.separator + "Story" + File.separator + "VegetaExplode.gif" );
            waitForImage( story, 840 );
            // setup for next fight.
            dice.rollDice( get_pl(), false );
            fightThread.setEP( true, dice.getResult(), true );
            pl.setText( base_pl + "" );
            pl.setForeground( Color.green );
         }
         else if ( storyPart == 20 )
         {  levelUp( false );
         }
         ++storyPart;
         updateInfo();
      }
      else if ( currentStage == 10 )
      {  if ( storyPart == 1 )
         {  FGOS.message += "\n\nHoly crap, what was that guy on?!  Man, that battle was tough, but at least you have all seven Dragon Balls and can now make your two wishes, so it was all worth it!\n\n";
            waitForImage( iWin, 41 );
         }
         else if ( storyPart == 2 )
         {  FGOS.message += "\n\nBut before you can summon the eternal dragon, two more figures drop from the sky.  Figures: \"Bow down before us earthling.  We have come for the Dragon Balls.  Hand them over and we may decide to let this puny planet live.  Otherwise, you and everybody else on this planet dies!\"";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "FreezaTalk.jpg" );
            waitForImage( story, 600 );
         }
         else if ( storyPart == 3 )
         {  FGOS.message += "\n\nGive me a break already!  How many of these guys to I have to beat before I can use these freaking Dragon Balls to summon the eternal dragon!  " + name + ": \"No, I had to fight for these Dragon Balls fair and square, if you want them you'll just have to do the same, but first I must warn you, I've never been defeated!\"";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuTalk.gif" );
            waitForImage( story, 125 );
         }
         else if ( storyPart == 4 )
         {  FGOS.message += "\n\nFigures: \"Hahahahaha!  An empty threat from an empty headed earthling.  Lord Freeza and I fear no one!\"  \"Yes, my brother Cell, and I are unstoppable, and after we have finished with you, we will be immortal as well!\"\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "CellBow.gif" );
            waitForImage( story, 610 );
         }
         else if ( storyPart == 5 )
         {  FGOS.message += "\n\n" + name + ": \"Vegeta said you two would be coming.  I didn't think you would get here so quickly though.  Guess our fight must have taken longer than I thought!\"\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuTalk.gif" );
            waitForImage( story, 125 );
         }
         else if ( storyPart == 6 )
         {  FGOS.message += "\n\nFreeza: \"Vegeta, that imbecile, perhaps we should reward you for killing him for us.\"  Cell: \"Yes, brother, I think a quick death should be ample payment for his services.  Don't you think?\"  Freeza: \"How right you are brother!\"\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "FreezaGaze.gif" );
            waitForImage( story, 620 );
         }
         else if ( storyPart == 7 )
         {  FGOS.message += "\n" + name + ": \"Spare me the details.  Come on lets get this thing over with.  I've an eternal dragon to summon before dinner.\"\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuTalk.gif" );
            waitForImage( story, 125 );
         }
         else if ( storyPart == 8 )
         {  FGOS.message += "\n\nCell: \"Come now brother, wouldn't want to keep the impatient earthling waiting.  Never know what he'll do!\"  Freeza: \"Hahahaha!  Good one brother.  Let me take this one.\"  Cell: \"Oh, but you got the last one.  Vegeta, remember?  And if I recall, you even let him get away!\"";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "CellBow.gif" );
            waitForImage( story, 610 );
         }
         else if ( storyPart == 9 )
         {  FGOS.message += "\nFreeza: \"It's a mistake I will not let happen again!\"  " + name + ": \"Show me what you got!\"\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "FreezaGaze.gif" );
            waitForImage( story, 620 );
         }
         else if ( storyPart == 10 )
         {  FGOS.message += "\n\nFreeza: \"Gladly!\"  Suddenly Freeza goes through a startling series of transformations!\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "FreezaTransform.gif" );
            waitForImage( story, 145 );
         }
         else if ( storyPart == 11 )
         {  FGOS.message += "\nFreeza: ( with deeper voice ) \"Wahahahaha.\"\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "FreezaIntro.gif" );
            waitForImage( story, 300 );
         }
         else if ( storyPart == 12 )
         {  FGOS.message += "\nSuddenly Freeza Powers up!\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "FreezaPU.gif" );
            waitForImage( story, 660 );
         }
         else if ( storyPart == 13 )
         {  story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "FreezaPowerUp.gif" );
            waitForImage( story, 670 );
         }
         else if ( storyPart == 14 )
         {  FGOS.message += "\nFreeza: \"Now you die puny earthling!\"\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "FreezaFace.gif" );
            waitForImage( story, 680 );
         }
         else if ( storyPart == 15 )
         {  FGOS.message += "\nFreeza charges into battle, and with that the battle begins!\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "FreezaAttacks.gif" );
            waitForImage( story, 301 );
         }
         else if ( storyPart == 16 )
         {  time_to_fight = true;
         }
         else if ( storyPart == 17 )
         {  checkResult( 1 );
         }
         else if ( storyPart == 18 )
         {  checkResult( 2 );
            if ( get_hp() > 0 )
            {  ++storyPart;
            }
            continueGameFocus();
         }
         // Done for storyline purposes.
         if ( storyPart == 19 )
         {  FGOS.message += "\n\n" + name + ": \"Guess you guys should have listen to me, but wait you still can!  Just leave this place and never come back Cell and I'll let you live.  Otherwise, prepare to join your recently deceased brother!\"\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuTalk.gif" );
            waitForImage( story, 125 );
            // setup for next fight.
            dice.rollDice( get_pl(), false );
            fightThread.setEP( true, dice.getResult(), true );
            pl.setText( base_pl + "" );
            pl.setForeground( Color.green );
         }
         else if ( storyPart == 20 )
         {  FGOS.message += "\nSuddenly Cell undergoes a radical transformation.\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "CellTransform.gif" );
            waitForImage( story, 147 );
         }
         else if ( storyPart == 21 )
         {  FGOS.message += "\nCell, in his new incarnation, turns to face you.\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "CellFace.gif" );
            waitForImage( story, 690 );
         }
         else if ( storyPart == 22 )
         {  FGOS.message += "\nCell: \"Ha!  You just don't get it do you!  I'm not the one who is going to die!  You are!\"\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "CellFace.jpg" );
            waitForImage( story, 700 );
         }
         else if ( storyPart == 23 )
         {  FGOS.message += "\n" + name + ": \"I've heard that line a thousand times before, and look at me, I'm still standing.\"\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuTalk.gif" );
            waitForImage( story, 125 );
         }
         else if ( storyPart == 24 )
         {  FGOS.message += "\nCell: \"To prove my overwhelming superiority I won't even kill you myself.  I'll merely have CellJr do it for me!\"\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "CellTalk.gif" );
            waitForImage( story, 148 );
         }
         else if ( storyPart == 25 )
         {  FGOS.message += "\nCell suddenly spits out a miniature version of himself!\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "CellCreatesCellJr.gif" );
            waitForImage( story, 149 );
         }
         else if ( storyPart == 26 )
         {  FGOS.message += "\n" + name + ": \"Well, that's definitely the most disgusting move I've ever seen!\"\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuTalk.gif" );
            waitForImage( story, 125 );
         }
         else if ( storyPart == 27 )
         {  FGOS.message += "\nCellJr: \"You want disgusting, go look in the mirror!\"\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "CellJrTalk.gif" );
            waitForImage( story, 150 );
         }
         else if ( storyPart == 28 )
         {  FGOS.message += "\n" + name + ": \"Looks like you need to learn some manners, and it looks like I'm the one who's going to have to teach you them.\"\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuTalk.gif" );
            waitForImage( story, 125 );
         }
         else if ( storyPart == 29 )
         {  FGOS.message += "\nCellJr: \"Bring it on!\"\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "CellJrTalk.gif" );
            waitForImage( story, 150 );
         }
         else if ( storyPart == 30 )
         {  FGOS.message += "\n" + name + ": \"Hey, that's my line!\"  And with that the battle with the CellJr began!\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuTalk.gif" );
            waitForImage( story, 125 );
            FGOS.playNewSong( "Stage10CellJr.mid" );
         }
         else if ( storyPart == 31 )
         {  time_to_fight = true;
         }
         else if ( storyPart == 32 )
         {  checkResult( 1 );
         }
         else if ( storyPart == 33 )
         {  checkResult( 2 );
            if ( get_hp() > 0 )
            {  ++storyPart;
            }
            continueGameFocus();
         }
         // Done for storyline purposes.
         if ( storyPart == 34 )
         {  FGOS.message += "\n" + name + ": \"You know what they say, like father like son.  Looks like Jr. didn't known when he was outclassed!\"\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuTalk.gif" );
            waitForImage( story, 125 );
            // setup for next fight.
            dice.rollDice( get_pl(), false );
            fightThread.setEP( true, dice.getResult(), true );
            pl.setText( base_pl + "" );
            pl.setForeground( Color.green );
         }
         else if ( storyPart == 35 )
         {  FGOS.message += "Cell walks menacingly towards you.\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "CellWalk.gif" );
            waitForImage( story, 710 );
         }
         else if ( storyPart == 36 )
         {  FGOS.message += "\n\nCell: \"Insolent fool!  You will pay for what you have done.  You will pay for it with your life, and with the lives of all those you hold dear.  After I'm done with you and have made my two wishes, I'm going to blow this entire planet up!\"\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "CellPowerUp.jpg" );
            waitForImage( story, 720 );
         }
         if ( storyPart == 37 )
         {  FGOS.message += "\n" + name + ": \"Bring it on!\"\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "SGokuPU.gif" );
            waitForImage( story, 151 );
         }
         else if ( storyPart == 38 )
         {  FGOS.message += "\nCell: \"Die!\"  And with that the final battle began!\n\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "CellPU.gif" );
            waitForImage( story, 152 );
            FGOS.playNewSong( "FinalFight.mid" );
         }
         else if ( storyPart ==  39 )
         {  time_to_fight = true;
         }
         else if ( storyPart == 40 )
         {  checkResult( 1 );
         }
         else if ( storyPart == 41 )
         {  checkResult( 2 );
            if ( get_hp() > 0 )
            {  ++storyPart;
            }
            continueGameFocus();
         }
         // Done for storyline purposes.
         if ( storyPart == 42 )
         {  FGOS.message += "\nCell: \"Wahahahahaha!\"  " + name + ": \"Wanna bet!\"  Cell: \"What the?  NOOOOO!!!\"\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Stage10" + File.separator + "Story" + File.separator + "CellDeath.gif" );
            waitForImage( story, 153 );
         }
         else if ( storyPart == 43 )
         {  FGOS.message += "\nYou did it!  You've defeated everybody, and now you can finally summon the eternal dragon and make your two wishes!\n\n\n";
            waitForImage( iWin, 41 );
            // setup for next fight.
            dice.rollDice( get_pl(), false );
            fightThread.setEP( true, dice.getResult(), true );
            pl.setText( base_pl + "" );
            pl.setForeground( Color.green );
         }
         else if ( storyPart == 44 )
         {  FGOS.message += "\nYou gather all the Dragon Balls together and summon the mighty eternal dragon.\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "DragonBalls.gif" );
            waitForImage( story, 154 );
            FGOS.playNewSong( "SummonDragon.mid" );
         }
         else if ( storyPart == 45 )
         {  FGOS.message += "\nEternal Dragon: \"Speak now, you who have summoned me, what are your wishes?\"\n\n\n";
            story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "EternalDragon.gif" );
            waitForImage( story, 155 );
         }
         else if ( storyPart == 46 )
         {  FGOS.message += "\nThis is it.  Do you want to wish for eternal youth and immortality or will you wish for eternal peace and prosperity throughout the entire universe?\n\n";
            setupWishes();
         }
         else if ( storyPart == 47 )
         {  if ( selfishWish )
            {  FGOS.message += "\n\n" + name + ": \"Eternal Dragon, I wish for eternal youth and immortality!\"  Eternal Dragon: \"Your wishes are granted!\"  Suddenly you feel incredible power surging through your viens!  You've never felt better in your life!\n";
               story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "UltimatePU.gif" );
               waitForImage( story, 156 );
               FGOS.playNewSong( "WishImmortal.mid" );
            }
            else
            {  FGOS.message += "\n\n" + name + ": \"Eternal Dragon, I wish for eternal peace and prosperity throughout the entire universe!\"  Eternal Dragon: \"Your wishes are granted!\"  Suddenly an incredible feeling of peace overtakes you, and you realize that you will never need to fight again, as a new age of peace and prosperity begins.";
               story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuPeace1.gif" );
               waitForImage( story, 157 );
               FGOS.playNewSong( "WishPeace.mid" );
            }
         }
         else if ( storyPart == 48 )
         {  if ( selfishWish )
            {  FGOS.message += "\n\nUsing your new found power, you go on to take over the entire universe!  Try as they might, no one can stop you, and eventually nobody tries to anymore.  You rule is universal and absolute, and as you are immortal it is also unending.\n\"All hail " + name + ", eternal ruler of the universe!\"";
               story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuRuler.gif" );
               waitForImage( story, 158 );
            }
            else
            {  FGOS.message += "\n\nHappiness spreads across the lands as famine, pestilence, and war are completely wiped out.  People everywhere learn the value of sharing with and caring for others.  Soon the entire universe is embraced in a single large utopian society, and it's all thanks to you!";
               story = Toolkit.getDefaultToolkit().getImage( "Hero" + File.separator + "Story" + File.separator + "GokuPeace2.gif" );
               waitForImage( story, 159 );
            }
         }
         else if ( storyPart == 49 )
         {  levelUp( true );
         }
         ++storyPart;
         updateInfo();
      }
      else
      {
      }
      return time_to_fight;
   }

   private void checkResult( int whichResult )
   {  if ( whichResult == 1 )
      {  if ( fightResult == 1 )
         {  waitForImage( boss.iLose, 38 );
            if ( currentStage == 4 )
            {  if ( bossNum == 1 )
               {  FGOS.message += ( "\nYou did it!  You defeated " + boss.name + "!  You are unstoppable!\n\n\n\n" );
               }
               else if ( bossNum == 2 )
               {  FGOS.message += ( "\nYou did it!  You defeated the Old man!  You are unstoppable!\n\n\n\n" );
               }
               else if ( bossNum == 3 )
               {  FGOS.message += ( "\nYou did it!  You defeated the Old man, again!  You are truly unstoppable!\n\n\n" );
               }
            }
            else if ( currentStage == 9 )
            {  FGOS.message += ( "\n\nVegeta starts the fight off strong and for a while it looks like he will win.\n\n\n" );
            }
            else if ( currentStage == 10 && bossNum == 3 )
            {  FGOS.message += ( "\n\nCell: \"Stupid earthling!  When will you get it through your head!  I can't be beat!\n\n\n" );
            }
            else
            {  FGOS.message += ( "\nYou did it!  You defeated " + boss.name + "!  You are unstoppable!\n\n\n\n" );
            }
         }
         else if ( fightResult == 2 )
         {  waitForImage( boss.iLose, 38 );
            FGOS.message += ( "\nYou didn't win the fight, but at least " + boss.name + " didn't win either!\n\n\n\n" );
         }
         else if ( fightResult == 3 )
         {  waitForImage( boss.iWin, 40 );
            FGOS.message += ( "\n\n" + boss.name + " looks down at your broken form and says: " + getTaunt() + "\n\n\n" );
         }
         else
         {  System.err.println( "There was an error in determining the result of the fight!" );
            System.err.println( "The fightResult = " + fightResult + "!" );
         }
      }
      else if ( whichResult == 2 )
      {  if ( fightResult == 1 )
         {  if ( currentStage == 4 || currentStage == 9 || currentStage == 10 )
            {  removeBoss();
               ++bossNum;
            }
            else if ( currentStage == 7 )
            {  if ( bossNum == 2 )
               {  levelUp( false );
               }
               else
               {  removeBoss();
                  ++bossNum;
               }
            }
            else if ( currentStage == 8 )
            {  if ( bossNum == 3 )
               {  levelUp( false );
               }
               else
               {  removeBoss();
                  ++bossNum;
               }
            }
            else
            {  levelUp( false );
            }
         }
         else if ( fightResult == 2 )
         {  loadDraw( true );
         }
         else if ( fightResult == 3 )
         {  loadLoss( true );
         }
         else
         {  System.err.println( "There was an error in determining the result of the fight!" );
            System.err.println( "The fightResult = " + fightResult + "!" );
         }
      }
      else
      {  System.err.println( "There was an error while calling checkResult( int whichResult )!" );
         System.err.println( "checkResult( " + whichResult + " ) was called!" );
      }
   }

   private String getTaunt()
   {  int tauntNum = ( ( int )( Math.random() * 4 + 1 ) );
      if ( currentStage == 1 )
      {  if ( tauntNum == 1 )
         {  return "Don't even try to get up!";
         }
         else if ( tauntNum == 2 )
         {  return "For a loser, you did pretty well.";
         }
         else if ( tauntNum == 3 )
         {  return "Keep your day job!";
         }
         else if ( tauntNum == 4 )
         {  return "My dad could beat you, and he's dead!";
         }
      }
      else if ( currentStage == 2 )
      {  if ( tauntNum == 1 )
         {  return "I don't have time for amateurs!";
         }
         else if ( tauntNum == 2 )
         {  return "I expected better.";
         }
         else if ( tauntNum == 3 )
         {  return "If you're gonna fight, fight for real.";
         }
         else if ( tauntNum == 4 )
         {  return "You don't have the skills to beat me!";
         }
      }
      else if ( currentStage == 3 )
      {  if ( tauntNum == 1 )
         {  return "Accept you weakness. Never come here again.";
         }
         else if ( tauntNum == 2 )
         {  return "Do not challenge what you cannot defeat!";
         }
         else if ( tauntNum == 3 )
         {  return "It will take more then you to best me!";
         }
         else if ( tauntNum == 4 )
         {  return "Now who is the strongest?";
         }
      }
      else if ( currentStage == 4 )
      {  if ( bossNum == 1 )
         {  if ( tauntNum == 1 )
            {  return "Oh, YEAH!!! I am the World's Strongest!";
            }
            else if ( tauntNum == 2 )
            {  return "Yeah, baby! I can't be beat!";
            }
            else if ( tauntNum == 3 )
            {  return "My reign will last forever!";
            }
            else if ( tauntNum == 4 )
            {  return "You can't beat the champ, chump!";
            }
         }
         else if ( bossNum >= 2 )
         {  if ( tauntNum == 1 )
            {  return "And I thought you had so much potential! Guess I was wrong!";
            }
            else if ( tauntNum == 2 )
            {  return "Oh yeah, baby! I still got it!";
            }
            else if ( tauntNum == 3 )
            {  return "I might be old, but at least I'm not weak!";
            }
            else if ( tauntNum == 4 )
            {  return "You call yourself a fighter?  Guess they don't make em like they use to.";
            }
         }
      }
      else if ( currentStage == 5 )
      {  if ( tauntNum == 1 )
         {  return "Now I'll take what should have rightfully been mine.";
         }
         else if ( tauntNum == 2 )
         {  return "I don't know what the old geezer saw in you. 'Cause all I see is a weakling!";
         }
         else if ( tauntNum == 3 )
         {  return "Hey, I thought you were supposed to be \"The World's Strongest\"! Ha!";
         }
         else if ( tauntNum == 4 )
         {  return "And to think, people actually paid money to see you fight! What a ripoff!";
         }
      }
      else if ( currentStage == 6 )
      {  if ( tauntNum == 1 )
         {  return "This was Master Roshi's \"best and brightest\"? Guess he must be senile.";
         }
         else if ( tauntNum == 2 )
         {  return "You were so predictable I could beat you with all three eyes shut!";
         }
         else if ( tauntNum == 3 )
         {  return "Hey, thanks for the Dragon Ball!";
         }
         else if ( tauntNum == 4 )
         {  return "Perhaps you should quit blocking my hits with your face!";
         }
      }
      else if ( currentStage == 7 )
      {  if ( tauntNum == 1 )
         {  return "What can I say, I'm one mean green fighting machine!";
         }
         else if ( tauntNum == 2 )
         {  return "You will not interfere with my plans!";
         }
         else if ( tauntNum == 3 )
         {  return "Now I only need four more!";
         }
         else if ( tauntNum == 4 )
         {  return "If you thought I was ugly, go take a look in the mirror!";
         }
      }
      else if ( currentStage == 8 )
      {  if ( bossNum == 1 )
         {  if ( tauntNum == 1 )
            {  return "Hmph.  Humans are so weak!";
            }
            else if ( tauntNum == 2 )
            {  return "Is that all you got!";
            }
            else if ( tauntNum == 3 )
            {  return "I can't believe a weakling like you managed to collect so many of the Dragon Balls!";
            }
            else if ( tauntNum == 4 )
            {  return "Man versus machine. Machine wins.";
            }
         }
         else if ( bossNum == 2 )
         {  if ( tauntNum == 1 )
            {  return "You were kinda cute, for a weakling.";
            }
            else if ( tauntNum == 2 )
            {  return "I think you managed to mess up my hair.";
            }
            else if ( tauntNum == 3 )
            {  return "Guess your mom must of taught you not to hit girls. *Giggle*";
            }
            else if ( tauntNum == 4 )
            {  return "Thanks for the Dragon Balls, tough guy.";
            }
         }
         else if ( bossNum == 3 )
         {  if ( tauntNum == 1 )
            {  return "I am invincible!";
            }
            else if ( tauntNum == 2 )
            {  return "Mission accomplished.  All 7 Dragon Balls have been retrieved.";
            }
            else if ( tauntNum == 3 )
            {  return "You never stood a chance against me!";
            }
            else if ( tauntNum == 4 )
            {  return "Opponent status: \"Terminated\"!";
            }
         }
      }
      else if ( currentStage == 9 )
      {  if ( bossNum == 1 )
         {  if ( tauntNum == 1 )
            {  return "Now I will take my rightful place as ruler of the Universe!";
            }
            else if ( tauntNum == 2 )
            {  return "All who oppose me shall perish!";
            }
            else if ( tauntNum == 3 )
            {  return "You call yourself a fighter? Pathetic!";
            }
            else if ( tauntNum == 4 )
            {  return "Only the strong survive!";
            }
         }
         else if ( bossNum == 2 )  // used for Brolly, but Brolly does not appear in this version of the game.
         {  if ( tauntNum == 1 )
            {  return "Selfishness and greed will always lead to death!";
            }
            else if ( tauntNum == 2 )
            {  return "I am the eternal guardian. All who oppose me shall die!";
            }
            else if ( tauntNum == 3 )
            {  return "Your greed was your undoing!";
            }
            else if ( tauntNum == 4 )
            {  return "I am power made flesh! You were just flesh, and now you're just dust!";
            }
         }
      }
      else if ( currentStage == 10 )
      {  if ( bossNum == 1 )
         {  if ( tauntNum == 1 )
            {  return "Hahahahaha! Was that the best this pitiful planet can offer!";
            }
            else if ( tauntNum == 2 )
            {  return "No one can defeat me! I am unstoppable!";
            }
            else if ( tauntNum == 3 )
            {  return "Now we shall rule the entire Universe forever!";
            }
            else if ( tauntNum == 4 )
            {  return "Nothing can stop us now!";
            }
         }
         else if ( bossNum == 2 )
         {  if ( tauntNum == 1 )
            {  return "Hahahahahahaha!";
            }
            else if ( tauntNum == 2 )
            {  return "Your so weak a child could beat you!  Oh, wait.  I already did!";
            }
            else if ( tauntNum == 3 )
            {  return "Two words: you suck!";
            }
            else if ( tauntNum == 4 )
            {  return "Sometimes I even surpise myself with my strength!";
            }
         }
         else if ( bossNum == 3 )
         {  if ( tauntNum == 1 )
            {  return "And to think that a weakling like you managed to defeat my brother!";
            }
            else if ( tauntNum == 2 )
            {  return "It was inevitable that I would achieve immortality. Just as it was inevitable that a weakling like you would die!";
            }
            else if ( tauntNum == 3 )
            {  return "I should thank you for killing my brother, as it saved me the trouble! But I won't! Muhahahahaha!";
            }
            else if ( tauntNum == 4 )
            {  return "Fool! Did you really think you could defeat me!?!";
            }
         }
         else if ( bossNum == 4 )  // used for Brolly, but Brolly does not appear in this version of the game.
         {  if ( tauntNum == 1 )
            {  return "Selfishness and greed will always lead to death!";
            }
            else if ( tauntNum == 2 )
            {  return "I am the eternal guardian. All who oppose me shall die!";
            }
            else if ( tauntNum == 3 )
            {  return "Your greed was your undoing!";
            }
            else if ( tauntNum == 4 )
            {  return "I am power made flesh! You were just flesh, and now you're just dust!";
            }
         }
      }
      else
      {  System.err.println( "There was an error while resolving the taunts!  The game thinks that the currentStage is " + currentStage + "!" );
      }
      return "Error!";
   }

   protected void updateInfo()
   {  FGOS.infoArea.setText( FGOS.message );
      FGOS.infoScrollPane.getViewport().setViewPosition( new Point ( 10000000, 10000000 ) );
      try
      {  EventQueue.invokeLater( new Runnable()
         {  public void run()
            {  FGOS.infoScrollPane.revalidate();
            }
         } );
      }
      catch ( Exception e )
      {  System.err.println( "There was an Exception ERROR while calling FGOS.infoScrollPane.revalidate()!" );
      }
   }

   private void setupTest()
   {  remove( choiceBox );
      powerAttack = new JButton("Power Attack");
      powerAttack.setBackground( Color.black );
      powerAttack.setForeground( Color.orange );
      myfont = new Font( "SansSerif", Font.BOLD, 20 );
      powerAttack.setFont( myfont );
      powerAttack.setBorderPainted( false );
      powerAttack.setMnemonic( KeyEvent.VK_P );
      powerAttack.setActionCommand( "PowerAttackTest" );
      powerAttack.setMaximumSize( powerAttack.getPreferredSize() );
      powerAttack.addActionListener( this );

      energyAttack = new JButton("Energy Attack");
      energyAttack.setBackground( Color.black );
      energyAttack.setForeground( Color.yellow );
      energyAttack.setFont( myfont );
      energyAttack.setBorderPainted( false );
      energyAttack.setMnemonic( KeyEvent.VK_E );
      energyAttack.setActionCommand( "LaunchEnergyTest" );
      energyAttack.setMaximumSize( energyAttack.getPreferredSize() );
      energyAttack.addActionListener( this );

      Box powerAttackBox = Box.createHorizontalBox();
      powerAttackBox.setBackground( Color.black );
      powerAttackBox.add( powerAttack );

      Box energyAttackBox = Box.createHorizontalBox();
      energyAttackBox.setBackground( Color.black );
      energyAttackBox.add( energyAttack );

      choiceBox = Box.createVerticalBox();
      choiceBox.setBackground( Color.black );
      choiceBox.add( Box.createVerticalStrut( 15 ) );
      choiceBox.add( powerAttackBox );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( energyAttackBox );
      choiceBox.add( Box.createVerticalStrut( 50 ) );
      choiceBox.setBounds( 219, 394, 365, 257 );

      remove( backgroundPic );
      add( choiceBox );
      add( backgroundPic );
      update();
      try
      {  EventQueue.invokeLater( new Runnable()
         {  public void run()
            {  powerAttack.requestFocus();
            }
         } );
      }
      catch ( Exception e )
      {  System.err.println( "There was an Exception ERROR while calling powerAttack.requestFocus()!" );
      }
   }

   private void setupWishes()
   {  remove( choiceBox );
      powerAttack = new JButton("Youth and Immortality");
      powerAttack.setBackground( Color.black );
      powerAttack.setForeground( Color.orange );
      myfont = new Font( "SansSerif", Font.BOLD, 20 );
      powerAttack.setFont( myfont );
      powerAttack.setBorderPainted( false );
      powerAttack.setMnemonic( KeyEvent.VK_Y );
      powerAttack.setActionCommand( "Youth" );
      powerAttack.setMaximumSize( powerAttack.getPreferredSize() );
      powerAttack.addActionListener( this );

      energyAttack = new JButton("Peace and Prosperity");
      energyAttack.setBackground( Color.black );
      energyAttack.setForeground( Color.yellow );
      energyAttack.setFont( myfont );
      energyAttack.setBorderPainted( false );
      energyAttack.setMnemonic( KeyEvent.VK_P );
      energyAttack.setActionCommand( "Peace" );
      energyAttack.setMaximumSize( energyAttack.getPreferredSize() );
      energyAttack.addActionListener( this );

      Box powerAttackBox = Box.createHorizontalBox();
      powerAttackBox.setBackground( Color.black );
      powerAttackBox.add( powerAttack );

      Box energyAttackBox = Box.createHorizontalBox();
      energyAttackBox.setBackground( Color.black );
      energyAttackBox.add( energyAttack );

      choiceBox = Box.createVerticalBox();
      choiceBox.setBackground( Color.black );
      choiceBox.add( Box.createVerticalStrut( 15 ) );
      choiceBox.add( powerAttackBox );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( energyAttackBox );
      choiceBox.add( Box.createVerticalStrut( 50 ) );
      choiceBox.setBounds( 219, 394, 365, 257 );

      remove( backgroundPic );
      backgroundPic = new JLabel( new ImageIcon( "Stage10" + File.separator + "Story" + File.separator + "WishScreen.jpg" ) );
      backgroundPic.setBounds( 0, 0, 800, 600 );
      add( choiceBox );
      add( backgroundPic );
      update();
      try
      {  EventQueue.invokeLater( new Runnable()
         {  public void run()
            {  powerAttack.requestFocus();
            }
         } );
      }
      catch ( Exception e )
      {  System.err.println( "There was an Exception ERROR while calling powerAttack.requestFocus()!" );
      }
   }

   private void addBoss( int whichBoss )
   {  remove( backgroundPic );
      String stage = "Stage" + currentStage;
      String backgroundScreen = "BackgroundScreen" + whichBoss + ".jpg";
      backgroundPic = new JLabel( new ImageIcon( stage + File.separator + backgroundScreen ) );
      backgroundPic.setBounds( 0, 0, 800, 600 );
      add( boss.bossFace );
      add( boss.hp );
      add( boss.ep );
      add( boss.pl );
      add( boss.strength );
      add( boss.endurance );
      add( boss.dexterity );
      add( boss.speed );
      add( boss.skill );
      add( boss.attacks );
      add( backgroundPic );
   }

   private void removeBoss()
   {  remove( boss.bossFace );
      remove( boss.hp );
      remove( boss.ep );
      remove( boss.pl );
      remove( boss.strength );
      remove( boss.endurance );
      remove( boss.dexterity );
      remove( boss.speed );
      remove( boss.skill );
      remove( boss.attacks );
      remove( backgroundPic );
      remove( choiceBox );
      if ( currentStage > 5 )
      {  backgroundPic = new JLabel( new ImageIcon( "SaveScreen" + File.separator + "SsaveScreen.jpg" ) );
      }
      else
      {  backgroundPic = new JLabel( new ImageIcon( "SaveScreen" + File.separator + "saveScreen.jpg" ) );
      }
      backgroundPic.setBounds( 0, 0, 800, 600 );
      add ( choiceBox );
      add ( backgroundPic );
   }

   private String perceived_EnemyAction()
   {  String enemyAction = ( "\n\n" + name + " it's your move.  " + "It looks like " + boss.name + " " );
      if ( boss.currentAction.equals( "FS" ) )
      {  enemyAction += "has taken a fighting stance.  ";
      }
      else if ( ( boss.currentAction.equals( "NA" ) ) || ( boss.currentAction.equals( "x2P" ) ) || ( boss.currentAction.equals( "x3P" ) ) || ( boss.currentAction.equals( "x4P" ) ) )
      {  enemyAction += "is lunging into an attack!  ";
      }
      else if ( boss.currentAction.equals( "PA" ) )
      {  enemyAction += "is lunging into a power attack!  ";
      }
      else if ( boss.currentAction.equals( "E" ) )
      {  enemyAction += "is launching an energy attack!  ";
      }
      else if ( boss.currentAction.equals( "EC" ) )
      {  enemyAction += "is channeling energy into an energy attack!  ";
      }
      else if ( boss.currentAction.equals( "EMC" ) )
      {  enemyAction += "is channeling extensive energy into an energy attack!  ";
      }
      else if ( boss.currentAction.equals( "PU" ) )
      {  if ( boss.get_pl() > ( boss.base_pl + ( boss.get_endurance() * 2 ) ) )
         {  enemyAction += "is powering up to explode!  ";
         }
         else
         {  enemyAction += "is powering up!  ";
         }
      }
      else if ( ( boss.currentAction.equals( "x2E" ) ) || ( boss.currentAction.equals( "x3E" ) ) || ( boss.currentAction.equals( "x4E" ) ) )
      {  enemyAction += "is launching a barrage of energy attacks!  ";
      }
      else if ( boss.currentAction.equals( "D" ) )
      {  enemyAction += "has taken a defensive stance.  ";
      }
      else
      {  enemyAction += "ERROR!  The boss's action is undefined!  ";
         System.err.println( "ERROR!  The boss's action is undefined!" );
      }

      return enemyAction;
   }

   protected void actionOptions()
   {  if ( fightThread.firstCall() )
      {  String enemyAction = perceived_EnemyAction();
         FGOS.message += ( enemyAction + "What do you want to do?\n\n\n" );
         fightThread.setFirstCall( false );
         updateInfo();
      }

      attack = new JButton( "Attack" );
      attack.setBackground( Color.black );
      attack.setForeground( Color.red.brighter().brighter().brighter() );
      myfont = new Font( "SansSerif", Font.BOLD, 20 );
      attack.setFont( myfont );
      attack.setBorderPainted( false );
      attack.setMnemonic( KeyEvent.VK_A );
      attack.setActionCommand( "Attack" );
      attack.setMaximumSize( attack.getPreferredSize() );
      attack.addActionListener( this );

      Box attackBox = Box.createHorizontalBox();
      attackBox.setBackground( Color.black );
      attackBox.add( attack );

      defend = new JButton( "Defend" );
      defend.setBackground( Color.black );
      defend.setForeground( Color.red.brighter().brighter().brighter() );
      //myfont = new Font( "SansSerif", Font.BOLD, 20 );
      defend.setFont( myfont );
      defend.setBorderPainted( false );
      defend.setMnemonic( KeyEvent.VK_D );
      defend.setActionCommand( "Defend" );
      defend.setMaximumSize( defend.getPreferredSize() );
      defend.addActionListener( this );

      Box defendBox = Box.createHorizontalBox();
      defendBox.setBackground( Color.black );
      defendBox.add( defend );

      specialMove = new JButton( "Use Special Move" );
      specialMove.setBackground( Color.black );
      specialMove.setForeground( Color.orange );
      specialMove.setFont( myfont );
      specialMove.setBorderPainted( false );
      specialMove.setMnemonic( KeyEvent.VK_U );
      specialMove.setActionCommand( "SpecialMove" );
      specialMove.setMaximumSize( specialMove.getPreferredSize() );
      specialMove.setEnabled( false );
      if ( get_ep() >= eStrength )
      {  specialMove.setEnabled( true );
         specialMove.addActionListener( this );
      }
      if ( has_x2 && ( get_ep() >= 4 ) && ( get_attacks() >= 2 ) )
      {  if ( !specialMove.isEnabled() )
         {  specialMove.setEnabled( true );
            specialMove.addActionListener( this );
         }
      }
      if ( has_x3 && ( get_ep() >= 9 ) && ( get_attacks() >= 3 ) )
      {  if ( !specialMove.isEnabled() )
         {  specialMove.setEnabled( true );
            specialMove.addActionListener( this );
         }
      }
      if ( has_x4 && ( get_ep() >= 16 ) && ( get_attacks() >= 4 ) )
      {  if ( !specialMove.isEnabled() )
         {  specialMove.setEnabled( true );
            specialMove.addActionListener( this );
         }
      }

      Box specialMoveBox = Box.createHorizontalBox();
      specialMoveBox.setBackground( Color.black );
      specialMoveBox.add( specialMove );

      powerUp = new JButton( "Power Up" );
      powerUp.setBackground( Color.black );
      powerUp.setForeground( Color.orange );
      powerUp.setFont( myfont );
      powerUp.setBorderPainted( false );
      powerUp.setMnemonic( KeyEvent.VK_P );
      powerUp.setActionCommand( "PowerUp" );
      powerUp.setMaximumSize( powerUp.getPreferredSize() );
      if ( ( get_pl() + 1 ) > ( get_attacks() ) )
      {  powerUp.setEnabled( false );
      }
      else
      {  powerUp.addActionListener( this );
      }

      Box powerUpBox = Box.createHorizontalBox();
      powerUpBox.setBackground( Color.black );
      powerUpBox.add( powerUp );

      attack.setToolTipText( "Click this button to launch a physical attack!" );
      defend.setToolTipText( "Click this button to actively defend against enemy attacks." );
      specialMove.setToolTipText( "Click this button to use a special move." );
      powerUp.setToolTipText( "Click this button to power up!" );

      choiceBox = Box.createVerticalBox();
      choiceBox.setBackground( Color.black );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( attackBox );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( defendBox );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( specialMoveBox );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( powerUpBox );
      choiceBox.add( Box.createVerticalStrut( 50 ) );
      choiceBox.setBounds( 219, 394, 365, 257 );
      remove( backgroundPic );
      add( choiceBox );
      add( backgroundPic );
      attack.requestFocus();
      update();
   }

   private void setupAttack()
   {  normalAttack = new JButton( "Attack" );
      normalAttack.setBackground( Color.black );
      normalAttack.setForeground( Color.yellow.brighter().brighter().brighter() );
      myfont = new Font( "SansSerif", Font.BOLD, 20 );
      normalAttack.setFont( myfont );
      normalAttack.setBorderPainted( false );
      normalAttack.setMnemonic( KeyEvent.VK_N );
      normalAttack.setActionCommand( "NormalAttack" );
      normalAttack.setMaximumSize( normalAttack.getPreferredSize() );
      normalAttack.addActionListener( this );

      Box normalAttackBox = Box.createHorizontalBox();
      normalAttackBox.setBackground( Color.black );
      normalAttackBox.add( normalAttack );

      powerAttack = new JButton( "Power Attack" );
      powerAttack.setBackground( Color.black );
      powerAttack.setForeground( Color.orange.brighter().brighter().brighter() );
      //myfont = new Font( "SansSerif", Font.BOLD, 20 );
      powerAttack.setFont( myfont );
      powerAttack.setBorderPainted( false );
      powerAttack.setMnemonic( KeyEvent.VK_P );
      powerAttack.setActionCommand( "PowerAttack" );
      powerAttack.setMaximumSize( powerAttack.getPreferredSize() );
      if ( get_attacks() < 2 )
      {  powerAttack.setEnabled( false );
      }
      else
      {  powerAttack.addActionListener( this );
      }

      Box powerAttackBox = Box.createHorizontalBox();
      powerAttackBox.setBackground( Color.black );
      powerAttackBox.add( powerAttack );

      cancel = new JButton( "Cancel" );
      cancel.setBackground( Color.black );
      cancel.setForeground( Color.red.brighter().brighter().brighter() );
      cancel.setFont( myfont );
      cancel.setBorderPainted( false );
      cancel.setMnemonic( KeyEvent.VK_C );
      cancel.setActionCommand( "A_Cancel" );
      cancel.setMaximumSize( cancel.getPreferredSize() );
      cancel.addActionListener( this );

      Box cancelBox = Box.createHorizontalBox();
      cancelBox.setBackground( Color.black );
      cancelBox.add( cancel );

      normalAttack.setToolTipText( "Click this button to launch an attack!" );
      powerAttack.setToolTipText( "Click this button to launch a power attack!" );
      cancel.setToolTipText( "Click this button to return to the options menu." );

      choiceBox = Box.createVerticalBox();
      choiceBox.setBackground( Color.black );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( normalAttackBox );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( powerAttackBox );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( cancelBox );
      choiceBox.add( Box.createVerticalStrut( 50 ) );
      choiceBox.setBounds( 219, 394, 365, 257 );
      remove( backgroundPic );
      add( choiceBox );
      add( backgroundPic );
      update();
      try
      {  EventQueue.invokeLater( new Runnable()
         {  public void run()
            {  normalAttack.requestFocus();
            }
         } );
      }
      catch ( Exception e )
      {  System.err.println( "There was an Exception ERROR while calling normalAttack.requestFocus()!" );
      }
   }

   private void setupSpecialMove()
   {  energyAttack = new JButton( "Energy Attack" );
      myfont = new Font( "SansSerif", Font.BOLD, 20 );
      energyAttack.setBackground( Color.black );
      energyAttack.setForeground( Color.yellow );
      // Associate the font with the JButton
      energyAttack.setFont( myfont );
      energyAttack.setBorderPainted( false );
      energyAttack.setMnemonic( KeyEvent.VK_E );
      energyAttack.setActionCommand( "EnergyAttack" );
      energyAttack.setMaximumSize( energyAttack.getPreferredSize() );
      if ( get_ep() < eStrength )
      {  energyAttack.setEnabled( false );
      }
      else
      {  energyAttack.addActionListener( this );
      }

      Box energyAttackBox = Box.createHorizontalBox();
      energyAttackBox.setBackground( Color.black );
      energyAttackBox.add( energyAttack );

      comboAttack = new JButton( "Combo Attack" );
      //myfont = new Font( "SansSerif", Font.BOLD, 16 );
      comboAttack.setBackground( Color.black );
      comboAttack.setForeground( Color.orange );
      // Associate the font with the JButton
      comboAttack.setFont( myfont );
      comboAttack.setBorderPainted( false );
      comboAttack.setMnemonic( KeyEvent.VK_C );
      comboAttack.setActionCommand( "ComboAttack" );
      comboAttack.setEnabled( false );
      comboAttack.setMaximumSize( comboAttack.getPreferredSize() );

      Box comboAttackBox = Box.createHorizontalBox();
      comboAttackBox.setBackground( Color.black );
      comboAttackBox.add( comboAttack );

      selectCombo = new JComboBox();
      selectCombo.setEditable( false );
      enableComboAttacks();
      selectCombo.setMaximumSize( new Dimension( 110, 25 ) );

      Box selectComboBox = Box.createHorizontalBox();
      selectComboBox.setBackground( Color.black );
      selectComboBox.add( selectCombo );
      selectComboBox.setMaximumSize( new Dimension( 110, 25 ) );

      cancel = new JButton( "Cancel" );
      cancel.setBackground( Color.black );
      cancel.setForeground( Color.red.brighter().brighter().brighter() );
      cancel.setFont( myfont );
      cancel.setBorderPainted( false );
      cancel.setMnemonic( KeyEvent.VK_C );
      cancel.setActionCommand( "SA_Cancel" );
      cancel.setMaximumSize( cancel.getPreferredSize() );
      cancel.addActionListener( this );

      Box cancelBox = Box.createHorizontalBox();
      cancelBox.setBackground( Color.black );
      cancelBox.add( cancel );

      energyAttack.setToolTipText( "Click this button to launch an energy attack!" );
      comboAttack.setToolTipText( "Click this button to launch the selected combo attack!" );
      selectCombo.setToolTipText( "Use this to select the combo to attack with." );
      cancel.setToolTipText( "Click this button to return to the options menu." );

      choiceBox = Box.createVerticalBox();
      choiceBox.setBackground( Color.black );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( energyAttackBox );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( comboAttackBox );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( selectComboBox );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( cancelBox );
      choiceBox.add( Box.createVerticalStrut( 50 ) );
      choiceBox.setBounds( 219, 394, 365, 257 );
      remove( backgroundPic );
      add( choiceBox );
      add( backgroundPic );
      update();
      try
      {  EventQueue.invokeLater( new Runnable()
         {  public void run()
            {  energyAttack.requestFocus();
            }
         } );
      }
      catch ( Exception e )
      {  System.err.println( "There was an Exception ERROR while calling energyAttack.requstFocus()!" );
      }
   }

   private void enableComboAttacks()
   {  boolean enabled = false;
      if( has_x2 )
      {  if ( get_attacks() >= 2 )
         {  if ( get_ep() >= 4 )
            {  selectCombo.addItem( "x2 Physical" );
               enabled = true;
            }
            if ( get_ep() >= ( 4 + ( 2 * eStrength ) ) )
            {  selectCombo.addItem( "x2 Energy" );
               enabled = true;
            }
         }
      }
      if ( has_x3 )
      {  if ( get_attacks() >= 3 )
         {  if ( get_ep() >= 9 )
            {  selectCombo.addItem( "x3 Physical" );
               enabled = true;
            }
            if ( get_ep() >= ( 9 + ( 3 * eStrength ) ) )
            {  selectCombo.addItem( "x3 Energy" );
               enabled = true;
            }
         }
      }
      if ( has_x4 )
      {  if ( get_attacks() >= 4 )
         {  if ( get_ep() >= 16 )
            {  selectCombo.addItem( "x4 Physical" );
               enabled = true;
            }
            if ( get_ep() >= ( 16 + ( 4 * eStrength ) ) )
            {  selectCombo.addItem( "x4 Energy" );
               enabled = true;
            }
         }
      }
      if ( enabled )
      {  comboAttack.setEnabled( true );
         comboAttack.addActionListener( this );
         update();
      }
   }

   private void loadStage( boolean alive )
   {  if( alive )
      {  levelUp( false );
      }
      else
      {  FGOS.frame.getContentPane().add( new HighScore( currentGame ), BorderLayout.CENTER );
         FGOS.frame.getContentPane().remove( this );
         FGOS.update();
      }
   }

   private void setupEnergyAttack()
   {  JTextArea question = new JTextArea( "How many additional energy points would\n you like to pump into the energy attack?" );
      question.setBackground( Color.black );
      question.setForeground( Color.white );
      question.setEditable( false );
      question.setFocusable( false );
      question.setMaximumSize( question.getPreferredSize() );

      Box questionBox = Box.createHorizontalBox();
      questionBox.setBackground( Color.black );
      questionBox.add( question );

      epSpent = new WholeNumberTextField( 0, 3 );
      epSpent.setMaximumSize( new Dimension( 30, 20 ) );
      epSpent.addFocusListener( new FocusListener()
      {  public void focusGained( FocusEvent evt )
         {
         }
         public void focusLost( FocusEvent evt )
         {  if ( evt.isTemporary() )
            {  return;
            }
            else if ( ( Integer.parseInt( epSpent.getText().trim() ) ) > get_ep() )
            {  epSpent.setText( "0" );
               epSpent.requestFocus();
               JOptionPane.showMessageDialog( FGOS.frame, "This is more than the number of energy points you have left to spend!", "Alert", JOptionPane.ERROR_MESSAGE );
            }
            else
            {  //Do nothing.
            }
         }
      } );

      Box epSpentBox = Box.createHorizontalBox();
      epSpentBox.setBackground( Color.black );
      epSpentBox.add( epSpent );

      launchEnergyAttack = new JButton( "Launch Energy Attack" );
      launchEnergyAttack.setBackground( Color.black );
      launchEnergyAttack.setForeground( Color.yellow.brighter().brighter().brighter() );
      myfont = new Font( "SansSerif", Font.BOLD, 20 );
      launchEnergyAttack.setFont( myfont );
      launchEnergyAttack.setBorderPainted( false );
      launchEnergyAttack.setMnemonic( KeyEvent.VK_L );
      launchEnergyAttack.setActionCommand( "LaunchEnergyAttack" );
      launchEnergyAttack.setMaximumSize( launchEnergyAttack.getPreferredSize() );
      launchEnergyAttack.addActionListener( this );

      Box launchEnergyAttackBox = Box.createHorizontalBox();
      launchEnergyAttackBox.setBackground( Color.black );
      launchEnergyAttackBox.add( launchEnergyAttack );

      cancel = new JButton( "Cancel" );
      cancel.setBackground( Color.black );
      cancel.setForeground( Color.red.brighter().brighter().brighter() );
      cancel.setFont( myfont );
      cancel.setBorderPainted( false );
      cancel.setMnemonic( KeyEvent.VK_C );
      cancel.setActionCommand( "EA_Cancel" );
      cancel.setMaximumSize( cancel.getPreferredSize() );
      cancel.addActionListener( this );

      Box cancelBox = Box.createHorizontalBox();
      cancelBox.setBackground( Color.black );
      cancelBox.add( cancel );

      epSpent.setToolTipText( "Enter the amount of additional energy points to channel into the energy attack here." );
      launchEnergyAttack.setToolTipText( "Click this button to launch the energy attack!" );
      cancel.setToolTipText( "Click this button to return to the options menu." );

      choiceBox = Box.createVerticalBox();
      choiceBox.setBackground( Color.black );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( questionBox );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( epSpentBox );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( launchEnergyAttackBox );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( cancelBox );
      choiceBox.add( Box.createVerticalStrut( 40 ) );
      choiceBox.setBounds( 219, 394, 365, 257 );
      remove( backgroundPic );
      add( choiceBox );
      add( backgroundPic );
      update();
      try
      {  EventQueue.invokeLater( new Runnable()
         {  public void run()
            {  launchEnergyAttack.requestFocus();
            }
         } );
      }
      catch ( Exception e )
      {  System.err.println( "There was an Exception ERROR while calling launchEnergyAttack.requestFocues()!" );
      }
   }

   private void setupEnergyAttackTest()
   {  JTextArea question = new JTextArea( "How many additional energy points would\n you like to pump into the energy attack?" );
      question.setBackground( Color.black );
      question.setForeground( Color.white );
      question.setEditable( false );
      question.setFocusable( false );
      question.setMaximumSize( question.getPreferredSize() );

      Box questionBox = Box.createHorizontalBox();
      questionBox.setBackground( Color.black );
      questionBox.add( question );

      epSpent = new WholeNumberTextField( 0, 3 );
      epSpent.setMaximumSize( new Dimension( 30, 20 ) );
      epSpent.addFocusListener( new FocusListener()
      {  public void focusGained( FocusEvent evt )
         {
         }
         public void focusLost( FocusEvent evt )
         {  if ( evt.isTemporary() )
            {  return;
            }
            else if ( ( Integer.parseInt( epSpent.getText().trim() ) ) > get_ep() )
            {  epSpent.setText( "0" );
               epSpent.requestFocus();
               JOptionPane.showMessageDialog( FGOS.frame, "This is more than the number of energy points you have left to spend!", "Alert", JOptionPane.ERROR_MESSAGE );
            }
            else
            {  ep_cost = ( Integer.parseInt( epSpent.getText().trim() ) + eStrength );
            }
         }
      } );

      Box epSpentBox = Box.createHorizontalBox();
      epSpentBox.setBackground( Color.black );
      epSpentBox.add( epSpent );

      launchEnergyAttack = new JButton( "Launch Energy Attack" );
      launchEnergyAttack.setBackground( Color.black );
      launchEnergyAttack.setForeground( Color.yellow.brighter().brighter().brighter() );
      myfont = new Font( "SansSerif", Font.BOLD, 20 );
      launchEnergyAttack.setFont( myfont );
      launchEnergyAttack.setBorderPainted( false );
      launchEnergyAttack.setMnemonic( KeyEvent.VK_L );
      launchEnergyAttack.setActionCommand( "LaunchEnergyAttackTest" );
      launchEnergyAttack.setMaximumSize( launchEnergyAttack.getPreferredSize() );
      launchEnergyAttack.addActionListener( this );

      Box launchEnergyAttackBox = Box.createHorizontalBox();
      launchEnergyAttackBox.setBackground( Color.black );
      launchEnergyAttackBox.add( launchEnergyAttack );

      cancel = new JButton( "Cancel" );
      cancel.setBackground( Color.black );
      cancel.setForeground( Color.red.brighter().brighter().brighter() );
      cancel.setFont( myfont );
      cancel.setBorderPainted( false );
      cancel.setMnemonic( KeyEvent.VK_C );
      cancel.setActionCommand( "Test_Cancel" );
      cancel.setMaximumSize( cancel.getPreferredSize() );
      cancel.addActionListener( this );

      Box cancelBox = Box.createHorizontalBox();
      cancelBox.setBackground( Color.black );
      cancelBox.add( cancel );

      epSpent.setToolTipText( "Enter the amount of additional energy points to channel into the energy attack here." );
      launchEnergyAttack.setToolTipText( "Click this button to launch the energy attack!" );
      cancel.setToolTipText( "Click this button to return to the options menu." );

      choiceBox = Box.createVerticalBox();
      choiceBox.setBackground( Color.black );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( questionBox );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( epSpentBox );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( launchEnergyAttackBox );
      choiceBox.add( Box.createVerticalStrut( 5 ) );
      choiceBox.add( cancelBox );
      choiceBox.add( Box.createVerticalStrut( 40 ) );
      choiceBox.setBounds( 219, 394, 365, 257 );
      remove( backgroundPic );
      add( choiceBox );
      add( backgroundPic );
      update();
      try
      {  EventQueue.invokeLater( new Runnable()
         {  public void run()
            {  launchEnergyAttack.requestFocus();
            }
         } );
      }
      catch ( Exception e )
      {  System.err.println( "There was an Exception ERROR while calling launchEnergyAttack.requestFocues!" );
      }
   }

   private void levelUp( boolean ending )
   {  dice.rollDice( ( base_pl + 1 ), true );
      hp.setText( ( hpMAX + dice.getResult() + ( base_pl + 1 ) ) + "" );
      ep.setText( ( epMAX + ( base_pl + 1 ) ) + "" );
      pl.setText( ( base_pl + 1 ) + "" );
      update();
      File temp = null;
      try
      {  String theCharacter = ( "" + true + "|" + ( currentStage + 1 ) + "|" + name + "|" + get_hp() + "|" + get_ep() + "|" + get_pl() + "|" + get_strength() + "|" + get_endurance() + "|" + get_dexterity() + "|" + get_speed() + "|" + get_skill() + "|" + base_attacks + "|" + eStrength + "|" + has_x2 + "|" + has_x3 + "|" + has_x4 );
         FileOutputStream myfile = new FileOutputStream( "CharacterCreation" + File.separator + "temp.fgos" );
         myfile.close();
         temp = new File( "CharacterCreation" + File.separator + "temp.fgos" );
         PrintWriter out = new PrintWriter( new FileWriter( temp ), true );
         out.println( theCharacter );
         out.close();
      }
      catch ( Exception e )
      {  e.printStackTrace();
      }
      finally
      {  remove( FGOS.displayArea );
         remove( FGOS.infoBox );
         FGOS.resetDisplay();
         FGOS.set_display_NOT_added( true );
         fightThread = null;
      }
      if ( ending )
      {  FGOS.frame.getContentPane().add( new HighScore( temp ), BorderLayout.CENTER );
         FGOS.frame.getContentPane().remove( this );
         FGOS.update();
      }
      else
      {  FGOS.frame.getContentPane().add( new SaveScreen( temp ), BorderLayout.CENTER );
         FGOS.frame.getContentPane().remove( this );
         FGOS.update();
      }
   }

   protected void loadWin()
   {  System.out.println( "You won! =)" );
      fightResult = 1;
      setupStart();
      continueGameDoClick();
   }

   protected void loadDraw( boolean loadGame )
   {  if ( !loadGame )
      {  System.out.println( "It's a tie! =(" );
         fightResult = 2;
         setupStart();
         continueGameDoClick();
      }
      else
      {  File temp = null;
         try
         {  String theCharacter = ( "" + true + "|" + ( currentStage + 1 ) + "|" + name + "|" + get_hp() + "|" + get_ep() + "|" + get_pl() + "|" + get_strength() + "|" + get_endurance() + "|" + get_dexterity() + "|" + get_speed() + "|" + get_skill() + "|" + ( base_attacks + get_pl() ) + "|" + eStrength + "|" + has_x2 + "|" + has_x3 + "|" + has_x4 );
            FileOutputStream myfile = new FileOutputStream( "CharacterCreation" + File.separator + "temp.fgos" );
            myfile.close();
            temp = new File( "CharacterCreation" + File.separator + "temp.fgos" );
            PrintWriter out = new PrintWriter( new FileWriter( temp ), true );
            out.println( theCharacter );
            out.close();
         }
         catch ( Exception e )
         {  e.printStackTrace();
         }
         fightThread = null;
         FGOS.frame.getContentPane().add( new HighScore( temp ), BorderLayout.CENTER );
         FGOS.frame.getContentPane().remove( this );
         FGOS.update();
      }
   }

   protected void loadLoss( boolean loadGame )
   {  if ( !loadGame )
      {  System.out.println( "You lost! =(" );
         fightResult = 3;
         setupStart();
         continueGameDoClick();
      }
      else
      {  File temp = null;
         try
         {  String theCharacter = ( "" + true + "|" + ( currentStage ) + "|" + name + "|" + get_hp() + "|" + get_ep() + "|" + get_pl() + "|" + get_strength() + "|" + get_endurance() + "|" + get_dexterity() + "|" + get_speed() + "|" + get_skill() + "|" + ( base_attacks + get_pl() ) + "|" + eStrength + "|" + has_x2 + "|" + has_x3 + "|" + has_x4 );
            FileOutputStream myfile = new FileOutputStream( "CharacterCreation" + File.separator + "temp.fgos" );
            myfile.close();
            temp = new File( "CharacterCreation" + File.separator + "temp.fgos" );
            PrintWriter out = new PrintWriter( new FileWriter( temp ), true );
            out.println( theCharacter );
            out.close();
         }
         catch ( Exception e )
         {  e.printStackTrace();
         }
         fightThread = null;
         FGOS.frame.getContentPane().add( new HighScore( temp ), BorderLayout.CENTER );
         FGOS.frame.getContentPane().remove( this );
         FGOS.update();
      }
   }

   protected void waitForImage( Image image, int id )
   {  if ( wait )
      {  fightThread.nap( 2 * 1500 );
      }

      image.flush();
      MediaTracker tracker = new MediaTracker( this );
      tracker.addImage( image, id );
      try
      {  tracker.waitForID( id );
      }
      catch ( InterruptedException e )
      {  System.err.println( "There was an InterruptedException while waiting for the image to load!" );
      }

      if ( currentImage != null )
      {  FGOS.displayArea.remove( currentImage );
      }

      currentImage = new JLabel( new ImageIcon( image ) );
      try
      {  EventQueue.invokeLater( new Runnable()
         {  public void run()
            {  FGOS.displayArea.add( currentImage, BorderLayout.CENTER );
               FGOS.displayArea.revalidate();
               FGOS.displayArea.repaint();
            }
         } );
      }
      catch ( Exception e )
      {  System.err.println( "There was an Exception ERROR while adding image to displayArea!" );
      }

      if ( ( id == 15 ) || ( id == 16 ) )
      {  wait = true;
      }
      else
      {  wait = false;
      }
   }

   protected void resolveHeroAction()
   {  int defense;
      if ( boss.currentAction.equals( "D" ) )
      {  dice.rollDice( ( boss.get_dexterity() + boss.get_skill() + boss.get_pl() ), true );
         defense = dice.getResult();
      }
      else if ( boss.currentAction.equals( "PA" ) || boss.currentAction.equals( "E" ) || boss.currentAction.equals( "EC" ) || boss.currentAction.equals( "EMC" ) || boss.currentAction.equals( "PU" ) )
      {  defense = 0;
      }
      else
      {  defense = ( boss.get_dexterity() + boss.get_skill() + boss.get_pl() );
      }

      int accuracy;
      if ( currentAction.equals( "NA" ) )
      {  waitForImage( iNA, 0 );
         FGOS.message += ( "\n" + name + " you lash out at " + boss.name + " with incredible force and " );
         dice.rollDice( ( get_strength() + get_skill() + get_pl() ), false );
         if ( ( dice.getResult() - defense ) > 0 )
         {  FGOS.message += ( "hit!\n\n\n\n" );
            updateInfo();
            fightThread.nap( 1 * 1050 );
            accuracy = ( ( dice.getResult() - defense ) / 4 );
            dice.rollDice( ( get_strength() + get_pl() ), false );
            boss.resistDamage( ( dice.getResult() + accuracy ) );
         }
         else
         {  // miss
            FGOS.message += ( "miss!\n\n\n\n" );
            updateInfo();
            fightThread.nap( 1 * 1050 );
         }
      }
      else if ( currentAction.equals( "PA" ) )
      {  waitForImage( iPA, 1 );
         FGOS.message += ( "\n" + name + " you lash out at " + boss.name + " with all your might and " );
         dice.rollDice( ( ( get_strength() + get_skill() + get_pl() ) - 1 ), false );
         if ( ( dice.getResult() - defense ) > 0 )
         {  FGOS.message += ( "hit!\n\n\n\n" );
            updateInfo();
            fightThread.nap( 1 * 1050 );
            accuracy = ( ( dice.getResult() - defense ) / 4 );
            dice.rollDice( ( get_strength() + get_pl() + ( ( get_strength() + 1 ) / 2 ) ), true );
            boss.resistDamage( ( dice.getResult() + accuracy ) );
         }
         else
         {  // miss
            FGOS.message += ( "miss!\n\n\n\n" );
            fightThread.nap( 1 * 1050 );
            updateInfo();
         }
      }
      else if ( currentAction.equals( "E" ) )
      {  waitForImage( iE, 2 );
         FGOS.message += ( "\n" + name + " you channel your power into an energy blast aimed straight at " + boss.name + " and " );
         dice.rollDice( ( get_dexterity() + get_skill() + get_pl() ), false );
         if ( ( dice.getResult() - defense ) > 0 )
         {  FGOS.message += ( "hit!\n\n\n" );
            updateInfo();
            fightThread.nap( 2 * 1050 );
            accuracy = ( ( dice.getResult() - defense ) / 4 );
            dice.rollDice( ( eStrength + get_pl() ), true );
            boss.resistDamage( ( dice.getResult() + accuracy + ( ep_cost - eStrength ) ) );
         }
         else
         {  // miss
            FGOS.message += ( "miss!\n\n\n" );
            updateInfo();
            fightThread.nap( 2 * 1050 );
         }
      }
      else if ( currentAction.equals( "EC" ) )
      {  waitForImage( iEC, 3 );
         FGOS.message += ( "\n" + name + " after channeling massive amounts of your power into an energy blast, you unleash its might upon " + boss.name + " and " );
         if ( numActions_Spent > 1 )
         {  dice.rollDice( ( get_dexterity() + get_skill() + get_pl() ), true );
         }
         else
         {  dice.rollDice( ( get_dexterity() + get_skill() + get_pl() ), false );
         }

         if ( ( ( dice.getResult() + numActions_Spent - 1 ) - defense ) > 0 )
         {  FGOS.message += ( "hit!\n\n\n" );
            updateInfo();
            fightThread.nap( 2 * 1050 );
            accuracy = ( ( ( dice.getResult() + numActions_Spent - 1 ) - defense ) / 4 );
            dice.rollDice( ( eStrength + get_pl() ), true );
            boss.resistDamage( ( dice.getResult() + accuracy + ( ep_cost - eStrength ) ) );
         }
         else
         {  // miss
            FGOS.message += ( "miss!\n\n\n" );
            updateInfo();
            fightThread.nap( 2 * 1050 );
         }
      }
      else if ( currentAction.equals( "EMC" ) )
      {  waitForImage( iEMC, 4 );
         FGOS.message += ( "\n" + name + " after channeling monstrous amounts of your power into an energy blast, you unleash its incredible might upon " + boss.name + " and " );
         if ( numActions_Spent > 1 )
         {  dice.rollDice( ( get_dexterity() + get_skill() + get_pl() ), true );
         }
         else
         {  dice.rollDice( ( get_dexterity() + get_skill() + get_pl() ), false );
         }

         if ( ( ( dice.getResult() + numActions_Spent - 1 ) - defense ) > 0 )
         {  FGOS.message += ( "hit!\n\n" );
            updateInfo();
            fightThread.nap( 3 * 1050 );
            accuracy = ( ( ( dice.getResult() + numActions_Spent - 1 ) - defense ) / 4 );
            dice.rollDice( ( eStrength + get_pl() ), true );
            boss.resistDamage( ( dice.getResult() + accuracy + ( ep_cost - eStrength ) ) );
         }
         else
         {  // miss
            FGOS.message += ( "miss!\n\n" );
            updateInfo();
            fightThread.nap( 2 * 1050 );
         }
      }
      else if ( currentAction.equals( "x2P" ) )
      {  waitForImage( ix2P, 5 );
         FGOS.message += ( "\n" + name + " with incredible speed and force you lash out twice at " + boss.name + " and:\n\n\n" );
         updateInfo();
         fightThread.nap( 2 * 1050 );
         for ( int i = 0; i < 2; ++i )
         {  dice.rollDice( ( get_strength() + get_skill() + get_pl() - 1 ), true );
            if ( ( dice.getResult() - defense ) > 0 )
            {  FGOS.message += ( "\n\nHit!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
               accuracy = ( ( dice.getResult() - defense ) / 4 );
               dice.rollDice( ( get_strength() + get_pl() ), false );
               boss.resistDamage( ( dice.getResult() + accuracy ) );
            }
            else
            {  // miss
               FGOS.message += ( "\n\nMiss!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
            }
         }
      }
      else if ( currentAction.equals( "x3P" ) )
      {  waitForImage( ix3P, 6 );
         FGOS.message += ( "\n" + name + " with incredible speed and force you lash out three times at " + boss.name + " and:\n\n\n" );
         updateInfo();
         fightThread.nap( 2 * 1050 );
         for ( int i = 0; i < 3; ++i )
         {  dice.rollDice( ( get_strength() + get_skill() + get_pl() - 2 ), true );
            if ( ( dice.getResult() - defense ) > 0 )
            {  FGOS.message += ( "\n\nHit!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
               accuracy = ( ( dice.getResult() - defense ) / 4 );
               dice.rollDice( ( get_strength() + get_pl() ), false );
               boss.resistDamage( ( dice.getResult() + accuracy ) );
            }
            else
            {  // miss
               FGOS.message += ( "\n\nMiss!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
            }
         }
      }
      else if ( currentAction.equals( "x4P" ) )
      {  waitForImage( ix4P, 7 );
         FGOS.message += ( "\n" + name + " with incredible speed and force you lash out four times at " + boss.name + " and:\n\n\n" );
         updateInfo();
         fightThread.nap( 2 * 1050 );
         for ( int i = 0; i < 4; ++i )
         {  dice.rollDice( ( get_strength() + get_skill() + get_pl() - 3 ), true );
            if ( ( dice.getResult() - defense ) > 0 )
            {  FGOS.message += ( "\n\nHit!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
               accuracy = ( ( dice.getResult() - defense ) / 4 );
               dice.rollDice( ( get_strength() + get_pl() ), false );
               boss.resistDamage( ( dice.getResult() + accuracy ) );
            }
            else
            {  // miss
               FGOS.message += ( "\n\nMiss!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
            }
         }
      }
      else if ( currentAction.equals( "x2E" ) )
      {  waitForImage( ix2E, 8 );
         FGOS.message += ( "\n" + name + " you channel your power into two energy blasts both aimed straight at " + boss.name + " and:\n\n\n" );
         updateInfo();
         fightThread.nap( 2 * 1050 );
         for ( int i = 0; i < 2; ++i )
         {  dice.rollDice( ( get_dexterity() + get_skill() + get_pl() - 1 ), true );
            if ( ( dice.getResult() - defense ) > 0 )
            {  FGOS.message += ( "\n\nHit!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
               accuracy = ( ( dice.getResult() - defense ) / 4 );
               dice.rollDice( ( eStrength + get_pl() ), true );
               boss.resistDamage( ( dice.getResult() + accuracy ) );
            }
            else
            {  // miss
               FGOS.message += ( "\n\nMiss!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
            }
         }
      }
      else if ( currentAction.equals( "x3E" ) )
      {  waitForImage( ix3E, 9 );
         FGOS.message += ( "\n" + name + " you channel your power into three energy blasts all aimed straight at " + boss.name + " and:\n\n\n" );
         updateInfo();
         fightThread.nap( 2 * 1050 );
         for ( int i = 0; i < 3; ++i )
         {  dice.rollDice( ( get_dexterity() + get_skill() + get_pl() - 2 ), true );
            if ( ( dice.getResult() - defense ) > 0 )
            {  FGOS.message += ( "\n\nHit!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
               accuracy = ( ( dice.getResult() - defense ) / 4 );
               dice.rollDice( ( eStrength + get_pl() ), true );
               boss.resistDamage( ( dice.getResult() + accuracy ) );
            }
            else
            {  // miss
               FGOS.message += ( "\n\nMiss!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
            }
         }
      }
      else if ( currentAction.equals( "x4E" ) )
      {  waitForImage( ix4E, 10 );
         FGOS.message += ( "\n" + name + " you channel your power into four energy blasts all aimed straight at " + boss.name + " and:\n\n\n" );
         updateInfo();
         fightThread.nap( 2 * 1050 );
         for ( int i = 0; i < 4; ++i )
         {  dice.rollDice( ( get_dexterity() + get_skill() + get_pl() - 3 ), true );
            if ( ( dice.getResult() - defense ) > 0 )
            {  FGOS.message += ( "\n\nHit!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
               accuracy = ( ( dice.getResult() - defense ) / 4 );
               dice.rollDice( ( eStrength + get_pl() ), true );
               boss.resistDamage( ( dice.getResult() + accuracy ) );
            }
            else
            {  // miss
               FGOS.message += ( "\n\nMiss!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
            }
         }
      }
      else if ( currentAction.equals( "PU" ) )
      {  if ( get_pl() > ( base_pl + ( get_endurance() * 2 ) ) )
         {  waitForImage( iExplode, 11 );
            FGOS.message += ( "\n" + name + " you have managed to channel more power than your body can possibly contain or control.  You explode!\n\n\n\n" );
            updateInfo();
            fightThread.nap( 1 * 1050 );
            boss.resistDamage( explode() );
         }
         else
         {  waitForImage( iFS, 12 );
            FGOS.message += ( "\n" + name + ", you resume a fighting stance.\n\n\n\n" );
            updateInfo();
            fightThread.nap( 1 * 1500 );
         }
      }
      else if ( currentAction.equals( "D" ) )
      {  waitForImage( iD, 13 );
         FGOS.message += ( "\n" + name + ", you maintain a defensive stance.\n\n\n\n" );
         updateInfo();
         fightThread.nap( 1 * 1500 );
      }
      else if ( currentAction.equals( "FS" ) )
      {  waitForImage( iFS, 14 );
         FGOS.message += ( "\n" + name + ", you maintain a fighting stance.\n\n\n\n" );
         updateInfo();
         fightThread.nap( 1 * 1500 );
      }
      else
      {  System.err.println( "ERROR resolving hero's action!  It is undefined!" );
      }

      sync.setDone( true );
   }

   protected void resolveBossAction()
   {  int defense;
      if ( currentAction.equals( "D" ) )
      {  dice.rollDice( ( get_dexterity() + get_skill() + get_pl() ), true );
         defense = dice.getResult();
      }
      else if ( currentAction.equals( "PA" ) || currentAction.equals( "E" ) || currentAction.equals( "EC" ) || currentAction.equals( "EMC" ) || currentAction.equals( "PU" ) )
      {  defense = 0;
      }
      else
      {  defense = ( get_dexterity() + get_skill() + get_pl() );
      }

      int accuracy;
      if ( boss.currentAction.equals( "NA" ) )
      {  waitForImage( boss.iNA, 17 );
         FGOS.message += ( "\n" + boss.name + " lashes out at you with incredible force and " );
         dice.rollDice( ( boss.get_strength() + boss.get_skill() + boss.get_pl() ), false );
         if ( ( dice.getResult() - defense ) > 0 )
         {  FGOS.message += ( "hits!\n\n\n\n" );
            updateInfo();
            fightThread.nap( 1 * 1050 );
            accuracy = ( ( dice.getResult() - defense ) / 4 );
            dice.rollDice( ( boss.get_strength() + boss.get_pl() ), false );
            resistDamage( ( dice.getResult() + accuracy ) );
         }
         else
         {  // miss
            FGOS.message += ( "misses!\n\n\n\n" );
            updateInfo();
            fightThread.nap( 1 * 1050 );
         }
      }
      else if ( boss.currentAction.equals( "PA" ) )
      {  waitForImage( boss.iPA, 18 );
         FGOS.message += ( "\nThrowing caution to the wind, " + boss.name + " lashes out at you with incredible might and " );
         dice.rollDice( ( ( boss.get_strength() + boss.get_skill() + boss.get_pl() ) - 1 ), false );
         if ( ( dice.getResult() - defense ) > 0 )
         {  FGOS.message += ( "hits!\n\n\n" );
            updateInfo();
            fightThread.nap( 1 * 1050 );
            accuracy = ( ( dice.getResult() - defense ) / 4 );
            dice.rollDice( ( boss.get_strength() + boss.get_pl() + ( ( boss.get_strength() + 1 ) / 2 ) ), true );
            resistDamage( ( dice.getResult() + accuracy ) );
         }
         else
         {  // miss
            FGOS.message += ( "misses!\n\n\n" );
            updateInfo();
            fightThread.nap( 1 * 1050 );
         }
      }
      else if ( boss.currentAction.equals( "E" ) )
      {  waitForImage( boss.iE, 19 );
         FGOS.message += ( "\n" + boss.name + " channels power into an energy blast aimed straight at you and " );
         dice.rollDice( ( boss.get_dexterity() + boss.get_skill() + boss.get_pl() ), false );
         if ( ( dice.getResult() - defense ) > 0 )
         {  FGOS.message += ( "hits!\n\n\n" );
            updateInfo();
            fightThread.nap( 2 * 1050 );
            accuracy = ( ( dice.getResult() - defense ) / 4 );
            dice.rollDice( ( boss.eStrength + boss.get_pl() ), true );
            resistDamage( ( dice.getResult() + accuracy + ( boss.ep_cost - boss.eStrength ) ) );
         }
         else
         {  // miss
            FGOS.message += ( "misses!\n\n\n" );
            updateInfo();
            fightThread.nap( 2 * 1050 );
         }
      }
      else if ( boss.currentAction.equals( "EC" ) )
      {  waitForImage( boss.iEC, 20 );
         FGOS.message += ( "\n\nAfter channeling massive amounts of power into an energy blast, " + boss.name + " unleashes its might upon you and " );
         if ( boss.numActions_Spent > 1 )
         {  dice.rollDice( ( boss.get_dexterity() + boss.get_skill() + boss.get_pl() ), true );
         }
         else
         {  dice.rollDice( ( boss.get_dexterity() + boss.get_skill() + boss.get_pl() ), false );
         }

         if ( ( ( dice.getResult() + boss.numActions_Spent - 1 ) - defense ) > 0 )
         {  FGOS.message += ( "hits!\n\n\n" );
            updateInfo();
            fightThread.nap( 2 * 1500 );
            accuracy = ( ( ( dice.getResult() + boss.numActions_Spent - 1 ) - defense ) / 4 );
            dice.rollDice( ( boss.eStrength + boss.get_pl() ), true );
            resistDamage( ( dice.getResult() + accuracy + ( boss.ep_cost - boss.eStrength ) ) );
         }
         else
         {  // miss
            FGOS.message += ( "misses!\n\n\n" );
            updateInfo();
            fightThread.nap( 2 * 1050 );
         }
      }
      else if ( boss.currentAction.equals( "EMC" ) )
      {  waitForImage( boss.iEMC, 21 );
         FGOS.message += ( "\n\nAfter channeling monstrous amounts of power into this next attack, " + boss.name + " unleashes its incredible might upon you and " );
         if ( boss.numActions_Spent > 1 )
         {  dice.rollDice( ( boss.get_dexterity() + boss.get_skill() + boss.get_pl() ), true );
         }
         else
         {  dice.rollDice( ( boss.get_dexterity() + boss.get_skill() + boss.get_pl() ), false );
         }

         if ( ( ( dice.getResult() + boss.numActions_Spent - 1 ) - defense ) > 0 )
         {  if ( currentStage == 7 || currentStage == 8 )
            {  FGOS.message += ( "hits!\n\n" );
            }
            else
            {  FGOS.message += ( "hits!\n\n\n" );
            }

            updateInfo();
            fightThread.nap( 2 * 1500 );
            accuracy = ( ( ( dice.getResult() + boss.numActions_Spent - 1 ) - defense ) / 4 );
            dice.rollDice( ( boss.eStrength + boss.get_pl() ), true );
            resistDamage( ( dice.getResult() + accuracy + ( boss.ep_cost - boss.eStrength ) ) );
         }
         else
         {  // miss
            if ( currentStage == 7 || currentStage == 8 )
            {  FGOS.message += ( "misses!\n\n" );
            }
            else
            {  FGOS.message += ( "misses!\n\n\n" );
            }

            updateInfo();
            fightThread.nap( 2 * 1050 );
         }
      }
      else if ( boss.currentAction.equals( "x2P" ) )
      {  waitForImage( boss.ix2P, 22 );
         FGOS.message += ( "\nWith incredible speed and force " + boss.name + " lashes out twice at you and:\n\n\n" );
         updateInfo();
         fightThread.nap( 2 * 1050 );
         for ( int i = 0; i < 2; ++i )
         {  dice.rollDice( ( boss.get_strength() + boss.get_skill() + boss.get_pl() - 1 ), true );
            if ( ( dice.getResult() - defense ) > 0 )
            {  FGOS.message += ( "\n\nHits!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
               accuracy = ( ( dice.getResult() - defense ) / 4 );
               dice.rollDice( ( boss.get_strength() + boss.get_pl() ), false );
               resistDamage( ( dice.getResult() + accuracy ) );
            }
            else
            {  // miss
               FGOS.message += ( "\n\nMisses!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
            }
         }
      }
      else if ( boss.currentAction.equals( "x3P" ) )
      {  waitForImage( boss.ix3P, 23 );
         FGOS.message += ( "\nWith incredible speed and force " + boss.name + " lashes out three times at you and:\n\n\n" );
         updateInfo();
         fightThread.nap( 2 * 1050 );
         for ( int i = 0; i < 3; ++i )
         {  dice.rollDice( ( boss.get_strength() + boss.get_skill() + boss.get_pl() - 2 ), true );
            if ( ( dice.getResult() - defense ) > 0 )
            {  FGOS.message += ( "\n\nHits!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
               accuracy = ( ( dice.getResult() - defense ) / 4 );
               dice.rollDice( ( boss.get_strength() + boss.get_pl() ), false );
               resistDamage( ( dice.getResult() + accuracy ) );
            }
            else
            {  // miss
               FGOS.message += ( "\n\nMisses!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
            }
         }
      }
      else if ( boss.currentAction.equals( "x4P" ) )
      {  waitForImage( boss.ix4P, 24 );
         FGOS.message += ( "\nWith incredible speed and force " + boss.name + " lashes out four times at you and:\n\n\n" );
         updateInfo();
         fightThread.nap( 2 * 1050 );
         for ( int i = 0; i < 4; ++i )
         {  dice.rollDice( ( boss.get_strength() + boss.get_skill() + boss.get_pl() - 3 ), true );
            if ( ( dice.getResult() - defense ) > 0 )
            {  FGOS.message += ( "\n\nHits!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
               accuracy = ( ( dice.getResult() - defense ) / 4 );
               dice.rollDice( ( boss.get_strength() + boss.get_pl() ), false );
               resistDamage( ( dice.getResult() + accuracy ) );
            }
            else
            {  // miss
               FGOS.message += ( "\n\nMisses!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
            }
         }
      }
      else if ( boss.currentAction.equals( "x2E" ) )
      {  waitForImage( boss.ix2E, 25 );
         FGOS.message += ( "\n" + boss.name + " channels power into two energy blasts both aimed straight at you and:\n\n\n" );
         updateInfo();
         fightThread.nap( 2 * 1050 );
         for ( int i = 0; i < 2; ++i )
         {  dice.rollDice( ( boss.get_dexterity() + boss.get_skill() + boss.get_pl() - 1 ), true );
            if ( ( dice.getResult() - defense ) > 0 )
            {  FGOS.message += ( "\n\nHits!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
               accuracy = ( ( dice.getResult() - defense ) / 4 );
               dice.rollDice( ( boss.eStrength + boss.get_pl() ), true );
               resistDamage( ( dice.getResult() + accuracy ) );
            }
            else
            {  // miss
               FGOS.message += ( "\n\nMisses!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
            }
        }
      }
      else if ( boss.currentAction.equals( "x3E" ) )
      {  waitForImage( boss.ix3E, 26 );
         FGOS.message += ( "\n" + boss.name + " channels power into three energy blasts all aimed straight at you and:\n\n\n" );
         updateInfo();
         fightThread.nap( 2 * 1050 );
         for ( int i = 0; i < 3; ++i )
         {  dice.rollDice( ( boss.get_dexterity() + boss.get_skill() + boss.get_pl() - 2 ), true );
            if ( ( dice.getResult() - defense ) > 0 )
            {  FGOS.message += ( "\n\nHits!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
               accuracy = ( ( dice.getResult() - defense ) / 4 );
               dice.rollDice( ( boss.eStrength + boss.get_pl() ), true );
               resistDamage( ( dice.getResult() + accuracy ) );
            }
            else
            {  // miss
               FGOS.message += ( "\n\nMisses!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
            }
         }
      }
      else if ( boss.currentAction.equals( "x4E" ) )
      {  waitForImage( boss.ix4E, 27 );
         FGOS.message += ( "\n" + boss.name + " channels power into four energy blasts all aimed straight at you and:\n\n\n" );
         updateInfo();
         fightThread.nap( 2 * 1050 );
         for ( int i = 0; i < 4; ++i )
         {  dice.rollDice( ( boss.get_dexterity() + boss.get_skill() + boss.get_pl() - 3 ), true );
            if ( ( dice.getResult() - defense ) > 0 )
            {  FGOS.message += ( "\n\nHits!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
               accuracy = ( ( dice.getResult() - defense ) / 4 );
               dice.rollDice( ( boss.eStrength + boss.get_pl() ), true );
               resistDamage( ( dice.getResult() + accuracy ) );
            }
            else
            {  // miss
               FGOS.message += ( "\n\nMisses!\n\n" );
               updateInfo();
               fightThread.nap( 1 * 1050 );
            }
         }
      }
      else if ( boss.currentAction.equals( "PU" ) )
      {  if ( boss.get_pl() > ( boss.base_pl + ( boss.get_endurance() * 2 ) ) )
         {  waitForImage( boss.iExplode, 28 );
            FGOS.message += ( "\nAfter channeling massive amounts of power, " + boss.name + " explodes!\n\n\n\n" );
            updateInfo();
            fightThread.nap( 2 * 1500 );
            resistDamage( boss.explode() );
         }
         else
         {  waitForImage( boss.iFS, 29 );
            FGOS.message += ( "\n" + boss.name + " resumes a fighting stance.\n\n\n\n" );
            updateInfo();
            fightThread.nap( 1 * 1500 );
         }
      }
      else if ( boss.currentAction.equals( "D" ) )
      {  waitForImage( boss.iD, 30 );
         FGOS.message += ( "\n" + boss.name + " maintains a defensive stance.\n\n\n\n" );
         updateInfo();
         fightThread.nap( 1 * 1500 );
      }
      else if ( boss.currentAction.equals( "FS" ) )
      {  waitForImage( boss.iFS, 31 );
         FGOS.message += ( "\n" + boss.name + " maintains a fighting stance.\n\n\n\n" );
         updateInfo();
         fightThread.nap( 1 * 1500 );
      }
      else
      {  System.err.println( "ERROR resolving boss's action!  It is undefined!" );
      }
      sync.setDone( true );
   }

   private void resistDamage( int amount )
   {  if ( currentAction.equals( "D" ) )
      {  dice.rollDice( ( get_endurance() + get_pl() + get_skill() ), true );
      }
      else
      {  dice.rollDice( ( get_endurance() + get_pl() ) , true );
      }

      if ( ( amount - dice.getResult() ) > 0 )
      {  fightThread.setHP( true, ( amount - dice.getResult() ), false );
      }

      // Update infoArea.
      if ( ( amount - dice.getResult() ) <= 0 )
      {  FGOS.message += ( "\n" + name + " the amount of damage dealt to you by " + boss.name + " was " + amount + " and the amount you resisted was " + dice.getResult() + ".  This means that you took no damage!\n\n" );
         updateInfo();
         fightThread.nap( 2 * 1050 );
      }
      else
      {  FGOS.message += ( "\n" + name + " the amount of damage dealt to you by " + boss.name + " was " + amount + " and the amount you resisted was " + dice.getResult() + ".  This means that you took " + ( amount - dice.getResult() ) + " damage!\n\n" );
         updateInfo();
         fightThread.nap( 2 * 1050 );
      }

      System.out.println( "" + name + ", the amount of damage was: " + amount + " and the amount resisted was: " + dice.getResult() + ".  This means you should have taken: " + ( amount - dice.getResult() ) + " damage." );
   }

   protected void rejuvenate()
   {  int burn;
      dice.rollDice( get_pl(), true );
      int ep_rejuvenated = dice.getResult();
      fightThread.setEP( true,  ep_rejuvenated, true );
      if ( get_pl() > ( base_pl + get_endurance() ) )
      {  burn = ( get_pl() - ( base_pl + get_endurance() ) );
         dice.rollDice( burn, true );
         fightThread.setHP( true, dice.getResult(), false );
      }

      dice.rollDice( boss.get_pl(), true );
      ep_rejuvenated = dice.getResult();
      FGOS.ms.fightThread.setEP( false, ep_rejuvenated, true );
      if ( boss.get_pl() > ( boss.base_pl + boss.get_endurance() ) )
      {  burn = ( boss.get_pl() - ( boss.base_pl + boss.get_endurance() ) );
         dice.rollDice( burn, true );
         FGOS.ms.fightThread.setHP( false, dice.getResult(), false );
      }

      update();
   }

   private int calculateTime( int epSpent )
   {  int numActions = 0;
      while ( epSpent > 0 )
      {  dice.rollDice( eStrength + get_skill() + get_pl(), false );
         epSpent -= dice.getResult();
         ++numActions;
      }
      if ( numActions == 0 )
      {  return 1;
      }
      else
      {  return numActions;
      }
   }

   protected void calculateSpeed()
   {  attacksMAX = ( ( get_pl() ) + ( base_attacks ) );
      attacks.setText( "" + attacksMAX );
      attacks.setBackground( Color.black );
      attacks.setForeground( Color.green );
      dice.rollDice( ( ( get_speed() ) + ( get_pl() ) ), false );
      initiative = ( dice.getResult() + attacksMAX + remainderTime );
      actionTime = ( initiative / attacksMAX );

      boss.attacksMAX  = ( ( boss.get_pl() ) + ( boss.base_attacks ) );
      boss.attacks.setText( "" + boss.attacksMAX );
      boss.attacks.setBackground( Color.black );
      boss.attacks.setForeground( Color.green );
      dice.rollDice( ( ( boss.get_speed() ) + ( boss.get_pl() ) ), false );
      boss.initiative = ( dice.getResult() + boss.attacksMAX + boss.remainderTime );
      boss.actionTime = ( boss.initiative / boss.attacksMAX );

      update();
      int results = initiative - boss.initiative;
      if ( results > 0 )
      {  System.out.println ( "Player goes first. " + results );
      }
      else if ( results == 0 )
      {  System.out.println ( "Tie. " + results );
      }
      else
      {  System.out.println ( "Boss goes first. " + results );
      }
   }

   private int explode()
   {  hp.setText( "" + 0 );
      hp.setBackground( Color.white );
      hp.setForeground( Color.black );
      FGOS.ms.hp.repaint( 0 );

      dice.rollDice( get_pl(), true );
      int returnValue = ( dice.getResult() + get_pl() + get_ep() );
      fightThread.setEP( true, 10000, false );
      return returnValue;
   }

   protected synchronized int get_hp()
   {  synchronized ( FGOS.ms.hp )
      {  return Integer.parseInt( hp.getText().trim() );
      }
   }

   protected synchronized int get_ep()
   {  synchronized ( FGOS.ms.ep )
      {  return Integer.parseInt( ep.getText().trim() );
      }
   }

   protected synchronized int get_pl()
   {  synchronized ( FGOS.ms.pl )
      {  return Integer.parseInt( pl.getText().trim() );
      }
   }

   protected synchronized int get_strength()
   {  return Integer.parseInt( strength.getText().trim() );
   }

   protected synchronized int get_endurance()
   {  return Integer.parseInt( endurance.getText().trim() );
   }

   protected synchronized int get_dexterity()
   {  return Integer.parseInt( dexterity.getText().trim() );
   }

   protected synchronized int get_speed()
   {  return Integer.parseInt( speed.getText().trim() );
   }

   protected synchronized int get_skill()
   {  return Integer.parseInt( skill.getText().trim() );
   }

   protected synchronized int get_attacks()
   {  synchronized ( FGOS.ms.attacks )
      {  return Integer.parseInt( attacks.getText().trim() );
      }
   }
}

class Boss extends JPanel
{  protected volatile static JTextField hp, ep, pl, strength, endurance, dexterity, speed, skill, attacks;
   protected volatile boolean enemyPowerUp, enemyChannelingSM, enemyDefend, powerMax;
   protected volatile static int hpMAX, epMAX, base_pl, base_attacks, attacksMAX, eStrength, initiative, actionTime, remainderTime, numActions_Spent;
   protected volatile String name, currentAction = "FS", strongestAttack;
   protected JLabel bossFace;
   protected volatile int pNA, pPA, pE, pEC, pEMC, px2P, px3P, px4P, px2E, px3E, px4E, pSA, ep_cost, temp_pD, temp_pPU;
   private final int pD, pPU;
   protected DiceRoller dice;
   private Sync sync;
   protected Image iNA, iPA, iD, iFS, iE, iEC, iEMC, ix2P, ix3P, ix4P, ix2E, ix3E, ix4E, iPU, iExplode, iWin, iLose;

   Boss( int bossNumber, int currentStage, Sync sync_in )
   {  sync = sync_in;
      try
      {  File bossData = new File( "Stage" + currentStage + File.separator + "Boss" + bossNumber + ".fgos" );
         BufferedReader in = new BufferedReader( new FileReader( bossData ) );
         String data = in.readLine();
         StringTokenizer tokenizedData = new StringTokenizer( data, "|" );
         name = tokenizedData.nextToken();
         hpMAX = Integer.parseInt( tokenizedData.nextToken() );
         epMAX = Integer.parseInt( tokenizedData.nextToken() );
         base_pl = Integer.parseInt( tokenizedData.nextToken() );
         strength = new JTextField( "" + tokenizedData.nextToken(), 3 );
         endurance = new JTextField( "" + tokenizedData.nextToken(), 3 );
         dexterity = new JTextField( "" + tokenizedData.nextToken(), 3 );
         speed = new JTextField( "" + tokenizedData.nextToken(), 3 );
         skill = new JTextField( "" + tokenizedData.nextToken(), 3 );
         base_attacks = Integer.parseInt( tokenizedData.nextToken() );
         eStrength = Integer.parseInt( tokenizedData.nextToken() );
         pNA = Integer.parseInt( tokenizedData.nextToken() );
         pPA = Integer.parseInt( tokenizedData.nextToken() );
         temp_pD = Integer.parseInt( tokenizedData.nextToken() );
         pE = Integer.parseInt( tokenizedData.nextToken() );
         pEC = Integer.parseInt( tokenizedData.nextToken() );
         pEMC = Integer.parseInt( tokenizedData.nextToken() );
         px2P = Integer.parseInt( tokenizedData.nextToken() );
         px3P = Integer.parseInt( tokenizedData.nextToken() );
         px4P = Integer.parseInt( tokenizedData.nextToken() );
         px2E = Integer.parseInt( tokenizedData.nextToken() );
         px3E = Integer.parseInt( tokenizedData.nextToken() );
         px4E = Integer.parseInt( tokenizedData.nextToken() );
         temp_pPU = Integer.parseInt( tokenizedData.nextToken() );
         strongestAttack = tokenizedData.nextToken();
         pSA = Integer.parseInt( tokenizedData.nextToken() );
         in.close();
      }
      catch ( Exception e )
      {  e.printStackTrace();
      }

      pD = temp_pD;
      pPU = temp_pPU;

      if ( pPA > 0 )
      {  iPA = Toolkit.getDefaultToolkit().getImage( "Stage" + FGOS.ms.currentStage + File.separator + name + "PA.gif" );
      }

      if ( pD > 0 )
      {  iD = Toolkit.getDefaultToolkit().getImage( "Stage" + FGOS.ms.currentStage + File.separator + name + "D.gif" );
      }

      if ( pE > 0 )
      {  iE = Toolkit.getDefaultToolkit().getImage( "Stage" + FGOS.ms.currentStage + File.separator + name + "E.gif" );
      }

      if ( pEC > 0 )
      {  iEC = Toolkit.getDefaultToolkit().getImage( "Stage" + FGOS.ms.currentStage + File.separator + name + "EC.gif" );
      }

      if ( pEMC > 0 )
      {  iEMC = Toolkit.getDefaultToolkit().getImage( "Stage" + FGOS.ms.currentStage + File.separator + name + "EMC.gif" );
      }

      if ( px2P > 0 )
      {  ix2P = Toolkit.getDefaultToolkit().getImage( "Stage" + FGOS.ms.currentStage + File.separator + name + "x2P.gif" );
      }

      if ( px2E > 0 )
      {  ix2E = Toolkit.getDefaultToolkit().getImage( "Stage" + FGOS.ms.currentStage + File.separator + name + "x2E.gif" );
      }

      if ( px3P > 0 )
      {  ix3P = Toolkit.getDefaultToolkit().getImage( "Stage" + FGOS.ms.currentStage + File.separator + name + "x3P.gif" );
      }

      if ( px3E > 0 )
      {  ix3E = Toolkit.getDefaultToolkit().getImage( "Stage" + FGOS.ms.currentStage + File.separator + name + "x3E.gif" );
      }

      if ( px4P > 0 )
      {  ix4P = Toolkit.getDefaultToolkit().getImage( "Stage" + FGOS.ms.currentStage + File.separator + name + "x4P.gif" );
      }

      if ( px4E > 0 )
      {  ix4E = Toolkit.getDefaultToolkit().getImage( "Stage" + FGOS.ms.currentStage + File.separator + name + "x4E.gif" );
      }

      if ( pPU > 0 )
      {  iPU = Toolkit.getDefaultToolkit().getImage( "Stage" + FGOS.ms.currentStage + File.separator + name + "PU.gif" );
         iExplode = Toolkit.getDefaultToolkit().getImage( "Stage" + FGOS.ms.currentStage + File.separator + name + "Explode.gif" );
      }

      iNA = Toolkit.getDefaultToolkit().getImage( "Stage" + FGOS.ms.currentStage + File.separator + name + "NA.gif" );
      iFS = Toolkit.getDefaultToolkit().getImage( "Stage" + FGOS.ms.currentStage + File.separator + name + "FS.gif" );
      iWin = Toolkit.getDefaultToolkit().getImage( "Stage" + FGOS.ms.currentStage + File.separator + name + "Win.gif" );
      iLose = Toolkit.getDefaultToolkit().getImage( "Stage" + FGOS.ms.currentStage + File.separator + name + "Lose.gif" );

      attacksMAX = ( base_pl + base_attacks );

      setLayout( null );
      setBackground( Color.black );

      bossFace = new JLabel( new ImageIcon( "Stage" + currentStage + File.separator + name + "Face.gif" ) );
      bossFace.setBounds( 713, 328, 52, 52 );

      /*
      100%
      green on black
      66%
      yellow on black
      33%
      red on black
      0
      black on white
      */
      hp = new JTextField( "" + hpMAX );
      hp.setFocusable( false );
      hp.setBackground( Color.black );
      hp.setForeground( Color.green );
      hp.setBounds( 671, 334, 28, 18 );

      ep = new JTextField( "" + epMAX );
      ep.setFocusable( false );
      ep.setBackground( Color.black );
      ep.setForeground( Color.green );
      ep.setBounds( 671, 358, 28, 18 );

      pl = new JTextField( "" + base_pl );
      pl.setFocusable( false );
      pl.setBackground( Color.black );
      pl.setForeground( Color.green );
      pl.setBounds( 734, 389, 28, 18 );

      strength.setFocusable( false );
      strength.setBackground( Color.black );
      strength.setForeground( Color.white );
      strength.setBounds( 734, 419, 28, 18 );

      endurance.setFocusable( false );
      endurance.setBackground( Color.black );
      endurance.setForeground( Color.white );
      endurance.setBounds( 734, 443, 28, 18 );

      dexterity.setFocusable( false );
      dexterity.setBackground( Color.black );
      dexterity.setForeground( Color.white );
      dexterity.setBounds( 734, 467, 28, 18 );

      speed.setFocusable( false );
      speed.setBackground( Color.black );
      speed.setForeground( Color.white );
      speed.setBounds( 734, 491, 28, 18 );

      skill.setFocusable( false );
      skill.setBackground( Color.black );
      skill.setForeground( Color.white );
      skill.setBounds( 734, 515, 28, 18 );

      attacks = new JTextField( "" + attacksMAX );
      attacks.setFocusable( false );
      attacks.setBackground( Color.black );
      attacks.setForeground( Color.green );
      attacks.setBounds( 734, 539, 28, 18 );

      remainderTime = 0;
      dice = new DiceRoller( 0, false );
      FGOS.ms.update();
   }

   protected synchronized void setFightModifiers()
   {  enemyPowerUp = false;
      enemyChannelingSM = false;
      enemyDefend = false;
      powerMax = false;

      if ( FGOS.ms.currentAction.equals( "PU" ) )
      {  enemyPowerUp = true;
      }
      else if ( ( FGOS.ms.currentAction.equals( "E" ) ) || ( FGOS.ms.currentAction.equals( "EC" ) ) || ( FGOS.ms.currentAction.equals( "EMC" ) ) || ( FGOS.ms.currentAction.equals( "x2P" ) ) || ( FGOS.ms.currentAction.equals( "x3P" ) ) || ( FGOS.ms.currentAction.equals( "x4P" ) ) || ( FGOS.ms.currentAction.equals( "x2E" ) ) || ( FGOS.ms.currentAction.equals( "x3E" ) ) || ( FGOS.ms.currentAction.equals( "x4E" ) ) )
      {  enemyChannelingSM = true;
      }
      else if ( FGOS.ms.currentAction.equals( "D" ) )
      {  enemyDefend = true;
      }

      if ( ( get_pl() + 1 ) > ( base_pl + ( get_endurance() * 2 ) ) )
      {  powerMax = true;
      }
   }

   protected synchronized void action()
   {  temp_pD = pD;
      temp_pPU = pPU;
      resetProbSAttack();
      setFightModifiers();

      if ( FGOS.ms.numActions_Spent == 0 )
      {  increaseProbSAttack( temp_pD );
         temp_pD = 0;
      }
      else if ( enemyPowerUp )
      {  increaseProbSAttack( ( temp_pD / 2 ) );
         temp_pPU += ( ( ( temp_pD + 1 ) / 2 ) );
         temp_pD = 0;
      }
      else if ( enemyChannelingSM )
      {  if ( ( FGOS.ms.get_attacks() + 1 ) >= get_attacks() )
         {  if ( currentAction.equals( "D" ) )
            {  FGOS.ms.waitForImage( iD, 35 );
               FGOS.message += ( "\n" + name + " maintains a defensive stance.\n\n\n\n" );
               FGOS.ms.updateInfo();
               FGOS.ms.fightThread.nap( 2 * 1050 );
               numActions_Spent = 1;
               FGOS.ms.fightThread.setActions( false, numActions_Spent );
               return;
            }
            else
            {  if ( !( FGOS.ms.currentStage == 4 && FGOS.ms.bossNum == 3 ) && !( FGOS.ms.currentStage == 10 && FGOS.ms.bossNum == 2 ) )
               {  temp_pD += ( halfProbSAttack() );
               }
            }
         }
      }
      else if ( enemyDefend )
      {  temp_pPU += temp_pD;
         temp_pD = 0;
      }

      if ( !( FGOS.ms.currentStage == 4 && FGOS.ms.bossNum == 3 ) && !( FGOS.ms.currentStage == 8 ) && !( FGOS.ms.currentStage == 10 && FGOS.ms.bossNum == 1 || FGOS.ms.bossNum == 2 ) )
      {  if ( ( FGOS.ms.get_attacks() + 1 ) >= get_attacks() )
         {  if ( FGOS.ms.currentAction.equals( "E" ) )
            {  if ( getProb() <= ( 4 * FGOS.ms.currentStage ) )
               {  if ( currentAction.equals( "D" ) )
                  {  FGOS.ms.waitForImage( iD, 35 );
                     FGOS.message += ( "\n" + name + " maintains a defensive stance.\n\n\n\n" );
                  }
                  else
                  {  currentAction = "D";
                     FGOS.ms.waitForImage( iD, 35 );
                     FGOS.message += ( "\n" + name + " assumes an active defensive position.\n\n\n\n" );
                  }

                  FGOS.ms.updateInfo();
                  FGOS.ms.fightThread.nap( 2 * 1050 );
                  numActions_Spent = 1;
                  FGOS.ms.fightThread.setActions( false, numActions_Spent );
                  return;
               }
            }
            else if ( FGOS.ms.currentAction.equals( "EC" ) )
            {  if ( getProb() <= ( 6 * FGOS.ms.currentStage ) )
               {  if ( currentAction.equals( "D" ) )
                  {  FGOS.ms.waitForImage( iD, 36 );
                     FGOS.message += ( "\n" + name + " maintains a defensive stance.\n\n\n\n" );
                  }
                  else
                  {  currentAction = "D";
                     FGOS.ms.waitForImage( iD, 36 );
                     FGOS.message += ( "\n" + name + " assumes an active defensive position.\n\n\n\n" );
                  }

                  FGOS.ms.updateInfo();
                  FGOS.ms.fightThread.nap( 2 * 1050 );
                  numActions_Spent = 1;
                  FGOS.ms.fightThread.setActions( false, numActions_Spent );
                  return;
               }
            }
            else if ( FGOS.ms.currentAction.equals( "EMC" ) )
            {  if ( getProb() <= ( 8 * FGOS.ms.currentStage ) )
               {  if ( currentAction.equals( "D" ) )
                  {  FGOS.ms.waitForImage( iD, 37 );
                     FGOS.message += ( "\n" + name + " maintains a defensive stance.\n\n\n\n" );
                  }
                  else
                  {  currentAction = "D";
                     FGOS.ms.waitForImage( iD, 37 );
                     FGOS.message += ( "\n" + name + " assumes an active defensive position.\n\n\n\n" );
                  }

                  FGOS.ms.updateInfo();
                  FGOS.ms.fightThread.nap( 2 * 1050 );
                  numActions_Spent = 1;
                  FGOS.ms.fightThread.setActions( false, numActions_Spent );
                  return;
               }
            }
         }
      }

      if ( !( FGOS.ms.currentStage == 10 && FGOS.ms.bossNum == 2 ) )
      {  if ( powerMax )
         {  increaseProbSAttack( ( ( int )( .75 * temp_pPU ) ) );
            temp_pPU -= ( ( ( int )( .75 * temp_pPU ) ) );
         }
         else if ( FGOS.ms.get_pl() > get_pl() )
         {  if ( ( get_pl() + 1 ) <= get_attacks() )
            {  if ( getProb() <= ( 5 * FGOS.ms.currentStage ) )
               {  currentAction = "PU";
                  FGOS.ms.waitForImage( iPU, 32 );
                  FGOS.message += ( "\n" + name + " rages in an attempt to power up!\n\n\n\n" );
                  FGOS.ms.updateInfo();
                  FGOS.ms.fightThread.nap( 2 * 1500 );
                  numActions_Spent = ( ( get_pl() + 1 ) );
                  FGOS.ms.fightThread.powerUp( false );
                  FGOS.ms.fightThread.setActions( false, numActions_Spent );
                  return;
               }
            }
         }
      }

      if ( get_pl() > ( FGOS.ms.get_pl() + 1 ) )
      {   increaseProbSAttack( temp_pPU );
          temp_pPU = 0;
      }

      int prob, count = 0;
      do
      {  prob = getProb();
         if ( prob <= pNA || count > 10000 )
         {  currentAction = "NA";
            numActions_Spent = 1;
            FGOS.ms.fightThread.setActions( false, numActions_Spent );
            return;
         }
         else if ( prob <= ( pNA + pPA ) )
         {  if ( get_attacks() >= 2 )
            {  currentAction = "PA";
               numActions_Spent = 2;
               FGOS.ms.fightThread.setActions( false, numActions_Spent );
               return;
            }
         }
         else if ( prob <= ( pNA + pPA + temp_pD ) )
         {  if ( currentAction.equals( "D" ) )
            {  FGOS.ms.waitForImage( iD, 33 );
               FGOS.message += ( "\n" + name + " maintains a defensive stance.\n\n\n\n" );
            }
            else
            {  currentAction = "D";
               FGOS.ms.waitForImage( iD, 33 );
               FGOS.message += ( "\n" + name + " assumes an active defensive position.\n\n\n\n" );
            }

            FGOS.ms.updateInfo();
            FGOS.ms.fightThread.nap( 2 * 1050 );
            numActions_Spent = 1;
            FGOS.ms.fightThread.setActions( false, numActions_Spent );
            return;
         }
         else if ( prob <= ( pNA + pPA + temp_pD + pE ) )
         {  if ( ( get_ep() ) >= ( eStrength ) )
            {  currentAction = "E";
               numActions_Spent = 1;
               FGOS.ms.fightThread.setActions( false, numActions_Spent );
               if ( ( get_ep() ) >= ( eStrength + get_skill() + get_pl() ) )
               {  ep_cost = ( eStrength + get_skill() + get_pl() );
               }
               else
               {  ep_cost = eStrength;
               }
               FGOS.ms.fightThread.setEP( false, ep_cost, false );
               return;
            }
         }
         else if ( prob <= ( pNA + pPA + temp_pD + pE + pEC ) )
         {  ep_cost = ( ( ( eStrength + get_skill() + get_pl() ) * 6 ) + ( eStrength + get_skill() + get_pl() ) );
            if ( ep_cost > epMAX )
            {  ep_cost = ( epMAX / 2 );
            }
            if ( ( get_ep() ) >= ep_cost )
            {  numActions_Spent = calculateTime( ep_cost );
               if ( get_attacks() >= numActions_Spent )
               {  currentAction = "EC";
                  FGOS.ms.fightThread.setActions( false, numActions_Spent );
                  FGOS.ms.fightThread.setEP( false, ep_cost, false );
                  return;
               }
            }
         }
         else if ( prob <= ( pNA + pPA + temp_pD + pE + pEC + pEMC ) )
         {  ep_cost = ( ( ( eStrength + get_skill() + get_pl() ) * 6 * 2 ) + ( eStrength + get_skill() + get_pl() ) );
            if ( ep_cost > epMAX )
            {  ep_cost = epMAX;
            }
            if ( ( get_ep() ) >= ep_cost )
            {  numActions_Spent = calculateTime( ep_cost );
               if ( get_attacks() >= numActions_Spent )
               {  currentAction = "EMC";
                  FGOS.ms.fightThread.setActions( false, numActions_Spent );
                  FGOS.ms.fightThread.setEP( false, ep_cost, false );
                  return;
               }
            }
         }
         else if ( prob <= ( pNA + pPA + temp_pD + pE + pEC + pEMC + px2P ) )
         {  if ( get_ep() >= 4 )
            {  if ( get_attacks() >= 2 )
               {  currentAction = "x2P";
                  numActions_Spent = 1;
                  FGOS.ms.fightThread.setActions( false, 2 );
                  FGOS.ms.fightThread.setEP( false, 4, false );
                  return;
               }
            }
         }
         else if ( prob <= ( pNA + pPA + temp_pD + pE + pEC + pEMC + px2P + px3P ) )
         {  if ( get_ep() >= 9 )
            {  if ( get_attacks() >= 3 )
               {  currentAction = "x3P";
                  numActions_Spent = 1;
                  FGOS.ms.fightThread.setActions( false, 3 );
                  FGOS.ms.fightThread.setEP( false, 9, false );
                  return;
               }
            }
         }
         else if ( prob <= ( pNA + pPA + temp_pD + pE + pEC + pEMC + px2P + px3P + px4P ) )
         {  if ( get_ep() >= 16 )
            {  if ( get_attacks() >= 4 )
               {  currentAction = "x4P";
                  numActions_Spent = 1;
                  FGOS.ms.fightThread.setActions( false, 4 );
                  FGOS.ms.fightThread.setEP( false, 16, false );
                  return;
               }
            }
         }
         else if ( prob <= ( pNA + pPA + temp_pD + pE + pEC + pEMC + px2P + px3P + px4P + px2E ) )
         {  ep_cost = calculate_ep_cost( 2 );
            if ( get_ep() >= ep_cost )
            {  if ( get_attacks() >= 2 )
               {  currentAction = "x2E";
                  numActions_Spent = 1;
                  FGOS.ms.fightThread.setActions( false, 2 );
                  FGOS.ms.fightThread.setEP( false, ep_cost, false );
                  return;
               }
            }
         }
         else if ( prob <= ( pNA + pPA + temp_pD + pE + pEC + pEMC + px2P + px3P + px4P + px2E + px3E ) )
         {  ep_cost = calculate_ep_cost( 3 );
            if ( get_ep() >= ep_cost )
            {  if ( get_attacks() >= 3 )
               {  currentAction = "x3E";
                  numActions_Spent = 1;
                  FGOS.ms.fightThread.setActions( false, 3 );
                  FGOS.ms.fightThread.setEP( false, ep_cost, false );
                  return;
               }
            }
         }
         else if ( prob <= ( pNA + pPA + temp_pD + pE + pEC + pEMC + px2P + px3P + px4P + px2E + px3E + px4E ) )
         {  ep_cost = calculate_ep_cost( 4 );
            if ( get_ep() >= ep_cost )
            {  if ( get_attacks() >= 4 )
               {  currentAction = "x4E";
                  numActions_Spent = 1;
                  FGOS.ms.fightThread.setActions( false, 4 );
                  FGOS.ms.fightThread.setEP( false, ep_cost, false );
                  return;
               }
            }
         }
         else if ( prob <= ( pNA + pPA + temp_pD + pE + pEC + pEMC + px2P + px3P + px4P + px2E + px3E + px4E + temp_pPU ) )
         {  if ( get_attacks() >= ( get_pl() + 1 ) )
            {  boolean poweringUp = true;
               if ( ( get_pl() + 1 ) > ( base_pl + ( get_endurance() * 2 ) ) )
               {  if ( ( get_hp() > ( hpMAX / 3 ) ) && ( get_hp() > FGOS.ms.get_hp() ) )
                  {  poweringUp = false;
                     return;
                  }
               }
               if ( poweringUp )
               {  currentAction = "PU";
                  FGOS.ms.waitForImage( iPU, 34 );
                  FGOS.message += ( "\n" + name + " rages in an attempt to power up!\n\n\n\n" );
                  FGOS.ms.updateInfo();
                  FGOS.ms.fightThread.nap( 2 * 1500 );
                  numActions_Spent = ( ( get_pl() + 1 ) );
                  FGOS.ms.fightThread.powerUp( false );
                  FGOS.ms.fightThread.setActions( false, numActions_Spent );
                  return;
               }
            }
         }
         else
         {  System.err.println( "Error, the probablities for the Boss's actions did not add up to 100%. " );
            System.err.println( "The prob rolled was: " + prob );
            System.exit( -1 );
         }
         System.err.println( "Loop count: " + count );
         ++count;
      } while ( true );
   }

   protected int explode()
   {  hp.setText( "" + 0 );
      hp.setBackground( Color.white );
      hp.setForeground( Color.black );
      FGOS.ms.boss.hp.repaint( 0 );

      dice.rollDice( get_pl(), true );
      int returnValue = ( dice.getResult() + get_pl() + get_ep() );
      FGOS.ms.fightThread.setEP( false, 10000, false );
      return returnValue;
   }

   protected void resistDamage( int amount )
   {  if ( currentAction.equals( "D" ) )
      {  dice.rollDice( ( get_endurance() + get_pl() + get_skill() ), true );
      }
      else
      {  dice.rollDice( ( get_endurance() + get_pl() ), true );
      }

      if ( ( amount - dice.getResult() ) > 0 )
      {  FGOS.ms.fightThread.setHP( false, ( amount - dice.getResult() ), false );
      }

      // Update infoArea.
      if ( ( amount - dice.getResult() ) <= 0 )
      {  FGOS.message += ( "\n" + FGOS.ms.name + " the amount of damage you dealt to " + name + " was " + amount + " and the amount " + name + " resisted was " + dice.getResult() + ".  This means that " + name + " has taken no damage!\n\n" );
         FGOS.ms.updateInfo();
         FGOS.ms.fightThread.nap( 2 * 1050 );
      }
      else
      {  FGOS.message += ( "\n" + FGOS.ms.name + " the amount of damage you dealt to " + name + " was " + amount + " and the amount " + name + " resisted was " + dice.getResult() + ".  This means that " + name + " has taken "  + ( amount - dice.getResult() ) + " damage!\n\n" );
         FGOS.ms.updateInfo();
         FGOS.ms.fightThread.nap( 2 * 1050 );
      }
      System.out.println( "" + name + ", the amount of damage was: " + amount + " and the amount resisted was: " + dice.getResult() + ".  This means you should have taken: " + ( amount - dice.getResult() ) + " damage." );
   }

   private synchronized int getProb()
   {  return ( ( int )( Math.random() * 100 + 1 ) );
   }

   private void increaseProbSAttack( int increase )
   {  if ( strongestAttack.equals( "EMC" ) )
      {  pEMC += increase;
      }
      else if ( strongestAttack.equals( "EC" ) )
      {  pEC += increase;
      }
      else if ( strongestAttack.equals( "E" ) )
      {  pE += increase;
      }
      else if ( strongestAttack.equals( "x4P" ) )
      {  px4P += increase;
      }
      else if ( strongestAttack.equals( "x3P" ) )
      {  px3P += increase;
      }
      else if ( strongestAttack.equals( "x2P" ) )
      {  px2P += increase;
      }
      else if ( strongestAttack.equals( "x4E" ) )
      {  px4E += increase;
      }
      else if ( strongestAttack.equals( "x3E" ) )
      {  px3E += increase;
      }
      else if ( strongestAttack.equals( "x2E" ) )
      {  px2E += increase;
      }
      else if ( strongestAttack.equals( "PA" ) )
      {  pPA += increase;
      }
      else if ( strongestAttack.equals( "NA" ) )
      {  pNA += increase;
      }
      else
      {  System.err.println( "The boss's strongest attack evaluated incorrectly!" );
         System.err.println( "The boss's strongest attack is: " + strongestAttack );
         System.exit( -1 );
      }
   }

   // In the following method, all numbers are rounded up to ensure
   // that the boss's attack probablity is still equal to 100%.
   private int halfProbSAttack()
   {  int returnValue = 0;
      if ( strongestAttack.equals( "EMC" ) )
      {  returnValue = ( pEMC - ( ( ( pEMC + 1 ) / 2 ) ) );
         pEMC =  ( ( ( pEMC + 1 ) / 2 ) );
      }
      else if ( strongestAttack.equals( "EC" ) )
      {  returnValue = ( pEC - ( ( ( pEC + 1 ) / 2 ) ) );
         pEC =  ( ( ( pEC + 1 ) / 2 ) );
      }
      else if ( strongestAttack.equals( "E" ) )
      {  returnValue = ( pE - ( ( ( pE + 1 ) / 2 ) ) );
         pE =  ( ( ( pE + 1 ) / 2 ) );
      }
      else if ( strongestAttack.equals( "x4P" ) )
      {  returnValue = ( px4P - ( ( ( px4P + 1 ) / 2 ) ) );
         px4P =  ( ( ( px4P + 1 ) / 2 ) );
      }
      else if ( strongestAttack.equals( "x3P" ) )
      {  returnValue = ( px3P - ( ( ( px3P + 1 ) / 2 ) ) );
         px3P =  ( ( ( px3P + 1 ) / 2 ) );
      }
      else if ( strongestAttack.equals( "x2P" ) )
      {  returnValue = ( px2P - ( ( ( px2P + 1 ) / 2 ) ) );
         px2P =  ( ( ( px2P + 1 ) / 2 ) );
      }
      else if ( strongestAttack.equals( "x4E" ) )
      {  returnValue = ( px4E - ( ( ( px4E + 1 ) / 2 ) ) );
         px4E =  ( ( ( px4E + 1 ) / 2 ) );
      }
      else if ( strongestAttack.equals( "x3E" ) )
      {  returnValue = ( px3E - ( ( ( px3E + 1 ) / 2 ) ) );
         px3E =  ( ( ( px3E + 1 ) / 2 ) );
      }
      else if ( strongestAttack.equals( "x2E" ) )
      {  returnValue = ( px2E - ( ( ( px2E + 1 ) / 2 ) ) );
         px2E =  ( ( ( px2E + 1 ) / 2 ) );
      }
      else if ( strongestAttack.equals( "PA" ) )
      {  returnValue = ( pPA - ( ( ( pPA + 1 ) / 2 ) ) );
         pPA =  ( ( ( pPA + 1 ) / 2 ) );
      }
      else if ( strongestAttack.equals( "NA" ) )
      {  returnValue = ( pNA - ( ( ( pNA + 1 ) / 2 ) ) );
         pNA =  ( ( ( pNA + 1 ) / 2 ) );
      }
      else
      {  System.err.println( "The boss's strongest attack evaluated incorrectly!" );
         System.err.println( "The boss's strongest attack is: " + strongestAttack );
         System.exit( -1 );
      }
      return returnValue;
   }


   private void resetProbSAttack()
   {  if ( strongestAttack.equals("EMC") )
      {  pEMC = pSA;
      }
      else if ( strongestAttack.equals("EC") )
      {  pEC = pSA;
      }
      else if ( strongestAttack.equals("E") )
      {  pE = pSA;
      }
      else if ( strongestAttack.equals("x4P") )
      {  px4P = pSA;
      }
      else if ( strongestAttack.equals("x3P") )
      {  px3P = pSA;
      }
      else if ( strongestAttack.equals("x2P") )
      {  px2P = pSA;
      }
      else if ( strongestAttack.equals("x4E") )
      {  px4E = pSA;
      }
      else if ( strongestAttack.equals("x3E") )
      {  px3E = pSA;
      }
      else if ( strongestAttack.equals("x2E") )
      {  px2E = pSA;
      }
      else if ( strongestAttack.equals("PA") )
      {  pPA = pSA;
      }
      else if ( strongestAttack.equals("NA") )
      {  pNA = pSA;
      }
      else
      {  System.err.println( "The boss's strongest attack evaluated incorrectly!" );
         System.err.println( "The boss's strongest attack is: " + strongestAttack );
         System.exit( -1 );
      }
   }

   private int calculateTime( int epSpent )
   {  int numActions = 0;
      while ( epSpent > 0 )
      {  dice.rollDice( Boss.eStrength + Boss.get_skill() + Boss.get_pl(), false );
         epSpent -= dice.getResult();
         ++numActions;
      }
      if ( numActions == 0 )
      {  return 1;
      }
      else
      {  return numActions;
      }
   }

   private int calculate_ep_cost( int multiplier )
   {  return ( ( multiplier * multiplier ) + ( multiplier * eStrength ) );
   }

   protected synchronized static int get_hp()
   {  synchronized ( FGOS.ms.boss )
      {  return ( Integer.parseInt( Boss.hp.getText().trim() ) );
      }
   }

   protected synchronized static int get_ep()
   {  synchronized ( FGOS.ms.boss )
      {  return Integer.parseInt( Boss.ep.getText().trim() );
      }
   }

   protected synchronized static int get_pl()
   {  synchronized ( FGOS.ms.boss )
      {  return Integer.parseInt( Boss.pl.getText().trim() );
      }
   }

   protected synchronized static int get_strength()
   {  return Integer.parseInt( Boss.strength.getText().trim() );
   }

   protected synchronized static int get_endurance()
   {  return Integer.parseInt( Boss.endurance.getText().trim() );
   }

   protected synchronized static int get_dexterity()
   {  return Integer.parseInt( Boss.dexterity.getText().trim() );
   }

   protected synchronized static int get_speed()
   {  return Integer.parseInt( Boss.speed.getText().trim() );
   }

   protected synchronized static int get_skill()
   {  return Integer.parseInt( Boss.skill.getText().trim() );
   }

   protected synchronized static int get_attacks()
   {  synchronized ( FGOS.ms.boss )
      {  return Integer.parseInt( Boss.attacks.getText().trim() );
      }
   }
}

class RankStack
{  private final int MAXSTACK = 10;
   private int count;
   private int[] entry;

   RankStack()
   {  count = 0;
      entry = new int[ MAXSTACK ];
   }

   protected boolean isEmpty()
   {  if ( count == 0 )
      {  return true;
      }
      else
      {  return false;
      }
   }

   protected void push( int item )
   {  if ( count >= ( MAXSTACK - 1 ) )
      {  // Overflow.
      }
      else
      {  ++count;
         entry[ count ] = item;
      }
   }

   protected int pop()
   {  if ( isEmpty() )
      {  return entry[ count ];
      }
      else
      {  int item = count;
         --count;
         return entry[ item ];
      }
   }

   protected int top()
   {  return entry[ count ];
   }

   protected void clear()
   {  count = 0;
   }
}

class NameStack
{  private final int MAXSTACK = 10;
   private int count;
   private String[] entry;

   NameStack()
   {  count = 0;
      entry = new String[ MAXSTACK ];
   }

   protected boolean isEmpty()
   {  if ( count == 0 )
      {  return true;
      }
      else
      {  return false;
      }
   }

   protected void push( String item )
   {  if ( count >= ( MAXSTACK - 1 ) )
      {  // Overflow.
      }
      else
      {  ++count;
         entry[ count ] = item;
      }
   }

   protected String pop()
   {  if ( isEmpty() )
      {  return entry[ count ];
      }
      else
      {  int item = count;
         --count;
         return entry[ item ];
      }
   }

   protected String top()
   {  return entry[ count ];
   }

   protected void clear()
   {  count = 0;
   }
}

// This is the general purpose dice roller class for the game.
// One simply specifies the number of dice to roll and whether or not ones are rerolled.
class DiceRoller
{  private int die, total;

   DiceRoller( int numberOfDice, boolean reroll1s )
   {  rollDice( numberOfDice, reroll1s );
   }

   protected void rollDice( int numberOfDice, boolean reroll1s )
   {  total = 0;
      int i = 0;

      if ( reroll1s = true )
      {  while ( i < numberOfDice )
         {  do
            {  die = ( int )( Math.random() * 6 + 1 );
            } while ( die < 2 );
            total += die;
            i++;
         }
      }
      else
      {  while ( i < numberOfDice )
         {  die = ( int )( Math.random() * 6 + 1 );
            total += die;
            i++;
         }
      }
   }

   protected int getResult()
   {  return total;
   }
}

// This class rolls up the Character Creation Points a player has to spend, as per the rules.
class CCPRoller
{  private int die, total, keep1, keep2, keep3;

   CCPRoller()
   {  int total1, total2, total3, highest;
      rollDice( 5 );
      total1 = getResult();

      rollDice( 5 );
      total2 = getResult();

      rollDice( 5 );
      total3 = getResult();

      highest = total1;
      if ( total2 > highest )
      {  highest = total2;
      }
      if ( total3 > highest )
      {  highest = total3;
      }
      total = highest;
   }

   private void rollDice( int numberOfDice )
   {  keep1 = 0;
      keep2 = 0;
      keep3 = 0;
      total = 0;
      int i = 0;
      int replaced = 0;

      while ( i < numberOfDice )
      {  do
         {  die = ( int )( Math.random() * 6 + 1 );
         } while ( die < 2 );
         if ( i == 0 )
         {  keep1 = die;
         }
         else if ( i == 1 )
         {  keep2 = die;
         }
         else if ( i == 2 )
         {  keep3 = die;
         }
         else if ( i == 3 )
         {  if ( die > keep1 )
            {  keep1 = die;
               replaced = 1;
            }
            else if ( die > keep2 )
            {  keep2 = die;
               replaced = 2;
            }
            else if ( die > keep3 )
            {  keep3 = die;
               replaced = 3;
            }
         }
         else
         {  if ( replaced == 0 || replaced == 3 )
            {  if ( die > keep1 )
               {  keep1 = die;
               }
               else if ( die > keep2 )
               {  keep2 = die;
               }
               else if ( die > keep3 )
               {  keep3 = die;
               }
            }
            else if ( replaced == 1 )
            {  if ( die > keep2 )
               {  keep2 = die;
               }
               else if ( die > keep3 )
               {  keep3 = die;
               }
               else if ( die > keep1 )
               {  keep1 = die;
               }
            }
            else
            {  if ( die > keep3 )
               {  keep3 = die;
               }
               else if ( die > keep1 )
               {  keep1 = die;
               }
               else if ( die > keep2 )
               {  keep2 = die;
               }
            }
         }
         i++;
      }
      total += ( keep1 + keep2 + keep3 + 6 );
   }

   protected int getResult()
   {  return total;
   }
}

/**
A document that can only hold valid positive integers or their substrings
i.e. a document that can only hold whole numbers
*/
class WholeNumberTextDocument extends PlainDocument
{  public void insertString( int offs, String str, AttributeSet a ) throws BadLocationException
   {  if ( str == null )
      {  return;
      }

      String oldString = getText( 0, getLength() );
      String newString = oldString.substring(0, offs) + str + oldString.substring( offs );

      if ( canBecomeValid( newString ) )
      {  super.insertString( offs, str, a );
      }
   }

   /**
   A helper function that tests whether a string is a valid whole number
   @param s a string
   @return true if s is a valid whole number
   */
   public static boolean isValid( String s )
   {  try
      {  int i = Integer.parseInt( s );
         if ( i >= 0 )
         {  return true;
         }
         else
         {  return false;
         }
      }
      catch( NumberFormatException e )
      {  return false;
      }
   }

   /**
   A helper function that tests whether a string is a substring of a valid whole number
   @param s a string
   @return true if s can be extended to a valid whole number
   */
   public static boolean canBecomeValid( String s )
   {  return s.equals( "" ) || isValid( s );
   }
}

/**
A text field for editing whole number values
*/
class WholeNumberTextField extends JTextField
{  /**
   Constructs an WholeNumberTextField.
   @param defval the default value
   @param size the field size
   */
   public WholeNumberTextField( int defval, int size )
   {  super( "" + defval, size );
      setInputVerifier( new WholeNumberTextFieldVerifier() );
   }

   protected Document createDefaultModel()
   {  return new WholeNumberTextDocument();
   }

   /**
   Checks if the contents of this field is a valid whole number.
   @return true of the field contents is valid
   */
   public boolean isValid()
   {  return WholeNumberTextDocument.isValid( getText() );
   }

   /**
   Gets the numeric value of the field contents.
   @param the number that the user typed into the field, or 0 if the field contents is not valid.
   */
   public int getValue()
   {  try
      {  return Integer.parseInt( getText() );
      }
      catch( NumberFormatException e )
      {  return 0;
      }
   }
}

/**
A verifier that checks if the contents of a text component is a valid whole number.
*/
class WholeNumberTextFieldVerifier extends InputVerifier
{  public boolean verify( JComponent component )
   {  String text = ( ( JTextComponent )component ).getText();
      return WholeNumberTextDocument.isValid( text );
   }
}