package mosaiccreator;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;

/**
 * <p>Title: Wait Window </p>
 * <p>Description: this window is used to display to the user the progress of some process </p>
 * @author Lance Finfrock
 * @version 1.0
 */
public class WaitWindow extends JFrame   {

  private JPanel jPanel1 = new JPanel();
  /**
   * the lable to display to the user
   */
  public JLabel Label = new JLabel();
  private BorderLayout borderLayout1 = new BorderLayout();
  private JPanel jProgressBarPanel = new JPanel();

  /**
   * to display the progress
   */
  public JProgressBar ProgressBar = new JProgressBar();

  public WaitWindow() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    this.setTitle("Processing...");
    this.setResizable(false);

    jPanel1.setBackground(new Color(245, 245, 245));
    jPanel1.setPreferredSize(new Dimension(150, 55));
    this.getContentPane().setBackground(new Color(245, 245, 245));
    this.setIconImage(null);
    this.setSize(300,150);
    jPanel1.setLayout(borderLayout1);
    Label.setToolTipText("");
    Label.setHorizontalAlignment(SwingConstants.CENTER);
    Label.setHorizontalTextPosition(SwingConstants.CENTER);
    Label.setText("Please Wait");
    Label.setVerticalAlignment(SwingConstants.CENTER);
    Label.setVerticalTextPosition(SwingConstants.CENTER);

    jProgressBarPanel.setBackground(new Color(245, 245, 245));
    jProgressBarPanel.setPreferredSize(new Dimension(160, 50));
    jPanel1.add(Label,  BorderLayout.CENTER);
    jPanel1.add(jProgressBarPanel, BorderLayout.SOUTH);
    jProgressBarPanel.add(ProgressBar, null);
    this.getContentPane().add(jPanel1, BorderLayout.CENTER);

    //Center the window
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize = this.getSize();
    if (frameSize.height > screenSize.height) {
      frameSize.height = screenSize.height;
    }
    if (frameSize.width > screenSize.width) {
      frameSize.width = screenSize.width;
    }
    this.setLocation( (screenSize.width - frameSize.width) / 2,
                     (screenSize.height - frameSize.height) / 2);

  }
  //Overridden so we can exit when window is closed
  protected void processWindowEvent(WindowEvent e) {


    if (!(e.getID() == WindowEvent.WINDOW_CLOSING)) {
      super.processWindowEvent(e);
    }

  }

}
