package mosaiccreator;

import java.awt.Color;
import java.awt.image.PixelGrabber;
import java.awt.Image;
import java.io.File;

/**
 *
 * <p>Title: Picture Pixels </p>
 * <p>Description: Stores the infomation of a image </p>
 * @author Lance Finfrock
 * @version 1.0
 */
class PicPixels{
  public int[] pixel;
  public int width;
  public int height;
  public String filePath;

  public PicPixels(String path,
                   int width1,
                   int height1) {

    this.filePath = path;
    this.width = width1;
    this.height = height1;
    if((new File(path)).isFile())
      this.GrabPixels();
  }

  /**
   * used to save
   * @return String
   */
  public String toString(){
    return  this.filePath + ";" + this.width + ";" + this.height;
  }

  /**
   * gets the pixels at x and y
   * @param x int
   * @param y int
   * @return int
   */
  public int getPixel(int x, int y) {  return pixel[y*width+x];  }

  /**
   * gets the color at x and y
   * @param x int
   * @param y int
   * @return Color
   */
  public Color getColor(int x, int y) { return new Color(getPixel(x,y)); }

  /**
   * grabs all the pixels from image
   */
  private void GrabPixels() {

    Image image = PictureTools.readImage(this.filePath, this.width,this.height, null);

    if(image != null){
      this.pixel = new int[this.width * this.height];
      PixelGrabber grabber = new PixelGrabber(image, 0, 0, this.width,
                                              this.height, this.pixel, 0,
                                              this.width);
      try {
        grabber.grabPixels();
      }
      catch (InterruptedException ex) {
        System.err.println("error grabing pixels in the picture");
      }
    }
  }
}
