package mosaiccreator;

import java.awt.*;

/**
 *
 * <p>Title: Mosaic Printer </p>
 * <p>Description: Prints the current mosaic </p>
 * @author Lance Finfrock
 * @version 1.0
 */
public class MosaicPrinter implements Runnable {
  private Frame windowCamefrom;
  private double BackgroundIntensity;

  /**
   *
   * @param w Frame window came from
   * @param backgroundInt double the blending level
   */
  public MosaicPrinter(Frame w, double backgroundInt) {
    this.windowCamefrom = w;
    this.BackgroundIntensity = backgroundInt;

    //create the local thread at a low priority to allow
    //the user to do other things while the program is running
    Thread local = new Thread(this);
    local.setPriority(Thread.MIN_PRIORITY);
    local.start();

  }

   public void run() {
     this.createPrintJob();
   }

  private void createPrintJob() {

    //create the print job
    PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(this.windowCamefrom,
        "Mosaic Print", null);

    Image image;

    //if the user cancels the print
    if (printJob != null) {

      Graphics g = printJob.getGraphics();

      int pageWidth = (int) printJob.getPageDimension().getWidth();
      int pageHeight = (int) printJob.getPageDimension().getHeight();

      //the image already created is smaller than the printer's page
      if(pageWidth > MainWindow.currentMosaic.image.getWidth() && pageHeight > MainWindow.currentMosaic.image.getHeight()){

        //resize mosaic to a large size
        MainWindow.currentMosaic.resizeMosaic(pageWidth, pageHeight, this.windowCamefrom);

        //create mosaic image
        image =  MainWindow.currentMosaic.createMosaicPicture(pageWidth, pageHeight, this.BackgroundIntensity, this.windowCamefrom);

        int borderHeight = (pageHeight - image.getHeight(null) ) / 2;
        int borderWidth = (pageWidth - image.getWidth(null) ) / 2;

        //draw the image to the page
        g.drawImage(image, borderWidth, borderHeight, null);

        //send the print job to the printer
        printJob.end();

      }
      else {//the image already created is larger than the printer's page

        int MosaicPictureHeight, MosaicPictureWidth;

        //get the max size possible for the printer page
        if ( ( (double)MainWindow.currentMosaic.OriginalPicture.width) /
            MainWindow.currentMosaic.OriginalPicture.height >
            ( (double) pageWidth) / pageHeight) {

          MosaicPictureWidth = pageWidth;
          MosaicPictureHeight = (MainWindow.currentMosaic.OriginalPicture.height *
                                 MosaicPictureWidth) /
              MainWindow.currentMosaic.OriginalPicture.width;
        }
        else {
          MosaicPictureHeight = pageHeight;
          MosaicPictureWidth = (MainWindow.currentMosaic.OriginalPicture.width *
                                MosaicPictureHeight) /
              MainWindow.currentMosaic.OriginalPicture.height;
        }

        //resize the current image created
        image = MainWindow.currentMosaic.image.getScaledInstance(MosaicPictureWidth, MosaicPictureHeight, Image.SCALE_AREA_AVERAGING);
        int borderHeight = (pageHeight - image.getHeight(null) ) / 2;
        int borderWidth = (pageWidth - image.getWidth(null) ) / 2;

        //draw the image to the page
        g.drawImage(image, borderWidth, borderHeight, null);

        //send the print job to the printer
        printJob.end();

      }
    }
  }
}
