package mosaiccreator;

import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.Icon;
import javax.swing.filechooser.FileView;

/**
 *
 * <p>Title: Mosaic File View</p>
 * <p>Description: the file view to find a mosaic file</p>
 * @author Lance Finfrock
 * @version 1.0
 */
public class MosaicFileView extends FileView {

    //setting the file icon to the Mosaic Creator icon
    ImageIcon MosaicIcon = createImageIcon("images/mosaicImage_small.png");

    public String getName(File f) {
        return null; //let the L&F FileView figure this out
    }

    public String getDescription(File f) {
        return null; //let the L&F FileView figure this out
    }

    public Boolean isTraversable(File f) {
        return null; //let the L&F FileView figure this out
    }

    /**
     *
     * @param f File
     * @return String
     */
    public String getTypeDescription(File f) {
        String type = null;

        if (f.getName().endsWith(".mosaic")) {
                type = "Mosaic Image";
        }
        return type;
    }

    /**
     *
     * @param f File
     * @return Icon
     */
    public Icon getIcon(File f) {
        Icon icon = null;
        if (f.getName().endsWith(".mosaic")) {
                icon = MosaicIcon;
        }
        return icon;
    }

    /**
     *
     * @param path String
     * @return ImageIcon
     */
    private ImageIcon createImageIcon(String path) {
          java.net.URL imgURL = MosaicFileView.class.getResource(path);
          if (imgURL != null) {
              return new ImageIcon(imgURL);
          } else {
              System.err.println("Couldn't find file: " + path);
              return null;
          }
      }
}
