package mosaiccreator;

import javax.swing.UIManager;
import java.awt.Dimension;
import java.awt.Toolkit;

/**
 * Starts the entire appilcation
 * <p>Title: Application Starter</p>
 * @author Lance Finfrock
 * @version 1.0
 */
public class ApplicationStarter {
  boolean packFrame = false;

  //Construct the application
  public ApplicationStarter() {
    MainWindow mainWindow = new MainWindow();
    //Validate frames that have preset sizes
    //Pack frames that have useful preferred size info, e.g. from their layout
    if (packFrame) {
      mainWindow.pack();
    }
    else {
      mainWindow.validate();
    }
    //Center the window
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize = mainWindow.getSize();
    if (frameSize.height > screenSize.height) {
      frameSize.height = screenSize.height;
    }
    if (frameSize.width > screenSize.width) {
      frameSize.width = screenSize.width;
    }
    mainWindow.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    mainWindow.setVisible(true);
  }

  //Main method
  public static void main(String[] args) {
    try {
      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    new ApplicationStarter();
  }
}
