#!/usr/bin/perl -w

#######################################################
# Name: Traffic_30_Reports.pm
# Purpose:
# Listen on a socket and capture data. Evaluate each
# line from each report, build a hash of each report
# and use build the parameters for Write2Database.pm.
# The current socket to listen on is the following:
# SADC_TS9 4039.
# The input parameters are the following:
# SADC_TS9 4039 SADC
# 
# Written By: 	Kristi Olson
# Date: 	4/5/2004
# Modifications:
# D Huvar	9/2/2004	Remove undef statements
# and use reinitializing statements instead to clear up
# run time errors.
#######################################################

#use FileHandle;
use IO::Socket;
use IO::Select;
use Write2Database7;
use Mail::Mailer;
use Net::FTP;
use A_R_T;
use lib '/opt/scripts/shared';
#use Exporter;
#@ISA = ('Exporter');
#@EXPORT = qw (&Handler_SigQuit);

#
#  Turn off Perl's buffering.
#

$| =1;	


#
#  Initalize of boolean constants.
#

my $FALSE = 0;
my $TRUE = 1;
my $WATCHED_SOCKETS = new IO::Select();
my $GLOBAL_SHUTDOWN = $FALSE;
my $SOCKET_HANDLE = "";
my $DATA = 0; #variable for each byte we read in.
my $LINE = ""; #variable for the concatonation of each byte up to a new line char.
my $SWITCH_NAME = SADC; #switch name.
my $REPORT_TYPE = REPORT; #default name of report if report starts writing before the full filename has been created.
my $HEADER_1 = "";
my $ARCHIVE_FILE = ""; #file for the entire 30 minute output.
my $REPORT_TIME = "";
my $REPORT_SECTION_NUMBER = 0; #global variable for each SECTION report
my $LAST_TIME = 0;
my $FINISH_TIME = 0;
my $HOUR = 0;
my $MINUTE = 0;
my $SUBJECT = "";
my $DATA_REPORT_DIRECTORY = '/opt/scripts/Multicast_scripts/Test_Report_Directory/';
my $DIRECTORY_FILE = "";
my $ROW_DATA_AIU = "";
my $KEY_AIU = 0;
my $MULTICAST_CONFIG = "";
my $MULTICAST_STATE = "";
my $FROM_ADDRESS = 'Traffic_30_Report_Error@gci.com';
my $TO_ADDRESS = 'kolson@gci.com';
#my $TO_ADDRESS = '#Ntwk Services NSG Service Provisioning Team@gci.com';
my $shutDown = $FALSE;
my $socket_state = 1;
my $socket_already_connected = 0;
my $current_time = 0;

#the Proc report repeats the first line on each subsection.
#$ITERATION_PROC keeps track of when we have already written
#the first line to the Proc hash.
my $ITERATION_PROC = FALSE; 

#There is some data in the PROC report that doesn't get
#written into the database.
my $BLOCK_DATA = 0; #flag to block data we don't want.

#multiple reports have subsections. Each subsection
#has a different number of columns, so we need
#to keep track of which subsection we are in, so that
#our hash is the correct size.
my $SUBSECTION = 0;

my $MONTH = 0;
my $DAY = 0;
my $YEAR = 0; #variables for the report_time.

#each report will have its own hash.
my %TRUNK_GROUP_HASH = ();
my %RDT_DNU_S_HASH = ();
my %CMP_HASH = ();
my %IRT_HASH = ();
my %MH_HASH = ();
my %ISLU_HASH = ();
my %IPIDB_HASH = ();
my %AIU_HASH = ();
my %IDPIDB_HASH = ();
my %PROC_HASH = ();
my %CTS_HASH = ();
my %CDN_HASH = ();
my %ISM_HASH = ();
my %TD_HASH = ();
my %HLSC_HASH = ();
my %MLHG_HASH = ();
my %DLTU_HASH = ();
my %SAD_HASH = ();
my %MOD1_HASH = ();
my %CT_HASH = ();

#each report will keep track of how many rows are in it. 
#This will be used in the "trfc30_processed_reports" table,
#which is a table that keeps track of each report that has
#been inserted into the database.
my $TG_ROW_COUNT = 0;
my $RDT_DNU_S_ROW_COUNT = 0;
my $CMP_ROW_COUNT = 0;
my $IRT_ROW_COUNT = 0;
my $ISLU_ROW_COUNT = 0;
my $IPIDB_ROW_COUNT = 0;
my $AIU_ROW_COUNT = 0;
my $ISM_ROW_COUNT = 0;
my $IDPIDB_ROW_COUNT = 0;
my $PROC_ROW_COUNT = 0;
my $CTS_ROW_COUNT = 0;
my $CDN_ROW_COUNT = 0;
my $TD_ROW_COUNT = 0;
my $HLSC_ROW_COUNT = 0;
my $MLHG_ROW_COUNT = 0;
my $MH_ROW_COUNT = 0;
my $DLTU_ROW_COUNT = 0;
my $SAD_ROW_COUNT = 0;
my $MOD1_ROW_COUNT = 0;
my $CT_ROW_COUNT = 0;

#a flag to prevent the script from making multiple calls to Write2Database 
# in between data feeds. Used in Main in  while($shutdown = false).
my $WRITE_FLAG = 0;

#*********************************************************
#**	ftpArchiveFile()
#**	Purpose: FTP the archived data file to the 
#**	file server.							                            
#**
#**	Written by: D Huvar
#**	Date:	8/23/2004
#**
#*********************************************************
sub ftpArchiveFile {
	
	#**
	#** Define constansts
	#**
	use constant DESTINATION_SERVER			 	=> 'phoenix.operations.gci.com';
	use constant DESTINATION_UID 				=> 'unix2winnt';
	use constant DESTINATION_PWD				=> 'unix2winnt';
	use constant DESTINATION_DIRECTORY			=> 'sadc-5e-traffic-testFTP';
	
	my $FTP_DEBUG = 0;

	#**
	#**	Establish a connection with archive file server.
	#**
	my $DESTINATION_FTP = Net::FTP -> new(DESTINATION_SERVER, Debug => $FTP_DEBUG, Timeout => 10);
	if (!defined $DESTINATION_FTP) {
	my $email_msg_1 = "TRFC30 script can't connect to FTP destination server.";
	Send_Email_Notification ("TRFC30 FTP Problem",$email_msg_1);
		print "ftpArchiveFile: FTP Connect Failure\n";
	}	#** end if


	#**
	#**	Log onto the archive file server.
	#**
	my $RESULT = $DESTINATION_FTP -> login(DESTINATION_UID, DESTINATION_PWD);
	if ($RESULT == 0) {
		my $email_msg_1 = "TRFC30 script can't login to FTP destination server.";
		Send_Email_Notification ("TRFC30 FTP Problem",$email_msg_1);
		$DESTINATION_FTP -> quit;
		print "ftpArchiveFile: FTP Login Failed\n";
	}	#** end if


	#**
	#**	Switch to binary transfer mode.
	#**
	$RESULT = $DESTINATION_FTP -> binary();
	if (uc($RESULT) ne 'A') {
		$DESTINATION_FTP -> quit;
		my $email_msg_1 = "TRFC30 script can't set FTP to binary mode.";
		Send_Email_Notification ("TRFC30 FTP Problem",$email_msg_1);
		print "ftpArchiveFile: FTP Binary mode not set\n";
	}	#** end if
	
	#**
	#**	Switch to the destination directory on the archive file server.
	#**
	$RESULT = $DESTINATION_FTP -> cwd(DESTINATION_DIRECTORY);
	if ($RESULT == 0) {
		$DESTINATION_FTP -> quit;
		my $email_msg_1 = "TRFC30 script can't connect to change to the destination directory.";
		Send_Email_Notification ("TRFC30 FTP Problem",$email_msg_1);
		print "ftpArchiveFile: FTP change to destination directory failed\n";
	}	#**	end if
	
	#**
	#** Put the file on the archive file server
	#**
	$RESULT = $DESTINATION_FTP -> put("$DATA_REPORT_DIRECTORY$ARCHIVE_FILE", "$ARCHIVE_FILE".".txt");
	if (!defined $RESULT) {
		$DESTINATION_FTP -> quit;
		my $email_msg_1 = "TRFC30 script can't put the file on the destination server.";
		Send_Email_Notification ("TRFC30 FTP Problem",$email_msg_1);
		print "ftpArchiveFile: FTP put file failed\n";
	}
	else {
		print "Transferred $ARCHIVE_FILE to " . DESTINATION_SERVER . "\n";
		print "Delete the source file: $DATA_REPORT_DIRECTORY$ARCHIVE_FILE\n";
		unlink ("$DATA_REPORT_DIRECTORY$ARCHIVE_FILE") || warn "Could not delete $DATA_REPORT_DIRECTORY$ARCHIVE_FILE\n";
	} #** end if

	#**
	#** Close the connection with the archive file server.
	#**
	$DESTINATION_FTP -> quit;

} #** end of ftpArchiveFile



#*********************************************************
#**  Written by: Doug Huvar				**
#**  Function Name: Handler_SigQuit					**
#**							**
#*********************************************************
sub Handler_SigQuit {

    print STDERR "Received a signal to shut down.  Shutting down.\n";
    
    $GLOBAL_SHUTDOWN = $TRUE;

    $SIG{STOP} = \&Handler_SigQuit;
    $SIG{INT}  = \&Handler_SigQuit; 
    $SIG{TERM} = \&Handler_SigQuit;
    $SIG{QUIT} = \&Handler_SigQuit;
    
    #** Send out email notification of socket problems
    my $message1 = "The Traffic 30 script has received a signal to shut down.\n";
    my $message2 = "SIGPIPE (Handler_SigQuit): Received a broken pipe signal (SIGPIPE).\n";
    my $message3 = "Please investigate this problem immediately.\n";
    Send_Email_Notification ("The Traffic30 Program Is Shutting Down", $message1, $message2, $message3);
    
    return;

} #end of Handler_SigQuit

#*********************************************************
#**  Written by: Doug Huvar				**
#**  Function Name: Handler_SigPipe					**
#**							**
#*********************************************************
sub Handler_SigPipe {

    print STDERR "SIGPIPE: Received a broken pipe signal (SIGPIPE)\n.";
    
    #** Send out email notification of socket problems
    my $message1 = "The Traffic 30 script has received a signal to shut down.\n";
    my $message2 = "SIGPIPE (Handler_SigPipe): Received a broken pipe signal (SIGPIPE).\n";
    my $message3 = "Please investigate this problem immediately.\n";
    Send_Email_Notification ("The Traffic30 Program Is Shutting Down", $message1, $message2, $message3);

    return;

} # end Handler_SigPipe

#*********************************************************
#**  Function Name: Write2Archive()
#    Written by: Doug Huvar
#    Description: Writes a date / time stamped file of the
#    input data. Used to archive report data as it comes
#    straight out of the switch.				**
#**  					**
#**							**
#*********************************************************
sub Write2Archive {
    my $INPUT_LINE = shift;
     
    #**						**
    #**  Create the file name of the log file.	**
    #**						**
    ($HOURS,$DAY,$MONTH,$YEAR) = (localtime)[2,3,4,5];
    $YEAR = $YEAR + 1900;
    $MONTH = $MONTH + 1;
    my $FILE_NAME_SUFFIX_ARCHIVE = sprintf("%02d-%02d-%04d-%02d",$MONTH,$DAY,$YEAR,$HOURS);
    $ARCHIVE_FILE = "$SWITCH_NAME-5e-traf_reports-$FILE_NAME_SUFFIX_ARCHIVE"; 
    
  
    #** DEBUG code
    #my $DATE_TIME_STAMP = localtime; 
    #my $DEBUG_MSG = "Write2Archive:$DATE_TIME_STAMP:$INPUT_LINE";
    #** End DEBUG Code
    
    $DIRECTORY_FILE = "$DATA_REPORT_DIRECTORY$ARCHIVE_FILE";	
    
    #**								**
    #**  Open the file for writing. **
    #**								**	
    open(FH,">>$DIRECTORY_FILE")|| warn "Error opening output file: $!";
    
    #** DEBUG Code	
    #print FH $DEBUG_MSG;
    #** End DEBUG Code
    print FH $INPUT_LINE;
    
    close(FH);
    
    return;

}	# end function Write2Archive()

#*********************************************************
#**  Function Name: connect_to_socket()
#    Date Written: July 2005
#    Written by: Kristi Olson				**
#**  
#    Description: 
#*********************************************************

sub connect_to_socket {


## SIGNAL HANDLERS AND GLOBALS
##

$SIG{PIPE} = \&Handler_SigPipe;
$SIG{STOP} = \&Handler_SigQuit;
$SIG{INT}  = \&Handler_SigQuit;
$SIG{TERM} = \&Handler_SigQuit;
$SIG{QUIT} = \&Handler_SigQuit;

$ELEMENTS{0}{"STATUS"} = "NEW";
$ELEMENTS{0}{"RECEIVE BUFFER"} = "";
$ELEMENTS{0}{'SOCKET CONNECTED'} = $FALSE;


	if ( $ELEMENTS{0}{"STATUS"} eq "NEW" ) {
	    $SOCKET_HANDLE = IO::Socket::INET -> new (
	    PeerAddr => $targetHost,
	    PeerPort => $targetPort,
	    Proto    => 'tcp',
	    );
		
	    if (defined $SOCKET_HANDLE) {
	    	$socket_already_connected = 1;
	        $ELEMENTS{0}{'SOCKET'} = $SOCKET_HANDLE;
		$ELEMENTS{0}{'SOCKET CONNECTED'} = $TRUE;
		$ELEMENTS{0}{'SOCKET CONNECT TIME'} = time;
		$WATCHED_SOCKETS->add($SOCKET_HANDLE);
		$ELEMENTS{0}{"STATUS"} = "RECEIVING";		
	    } # end if
		
	   else {
	    	#8/22: call eval pri here. may need a sleep function. 
	    	#Keep master call to eval pri where it is. For apps that don't
	    	#read streaming data, both ma and pa can call eval pri from same spot.
	    	
	    	if(time > ($B_CAST_IVAL+$current_time) && ($MULTICAST_STATE eq PASSIVE)) {
    		 	$MULTICAST_STATE = A_R_T::evaluate_priority;
				$current_time = time; #reset timer
				
			}
					
	    } #end else
		
       } #end if
     
       return;
} #end sub connect_to_socket	

#*********************************************************
#**							**
#**  Function Name: Send_Email_Notification_New_Report()
#    Written by: Kristi Olson
#    Date: 5/11/04
#
#    Description: Sends an email notification if a new report
#    has been turned on. 					**
#**  
#    Parameters: none					**
#*********************************************************
sub Send_Email_Notification_New_Report {
	$SUBJECT = "Traffic_30_Reports script has detected a new report";     
	my $MAILER = Mail::Mailer->new('smtp',Server => 'ops9.operations.gci.com');
	$MAILER->open({ From    => $FROM_ADDRESS, 
                        To      => $TO_ADDRESS, 
                        Subject => $SUBJECT, 
                      }) or die "Can't open: $!\n";
                  
        print $MAILER "Traffic_30_Reports has detected a new report:\n";
          
        $MAILER->close;
        return;
     } # end of Send_Email_Notification_New_Report

#*********************************************************
#**  Function Name: set_Hour()  
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#			**
#**  Description: The switch could output the Traffic 30 Reports
#    at any time between 59 minutes past the hour the data 
#    occured in, and 1 minute past the next hour ( a 2 minute
#    window). The database needs the time stamp of the report 
#    to be the hour after the data occured. The solution
#    is to evaluate the minute variable and add one to it. If the
#    resulting value is "60", the report was output at 59 minutes
#    past the hour and we will need to change the hour variable
#    to reflect the time stamp necessary for the database. 
#    If the resulting value is "00" or above, the report hour 
#    value will already be correct.
#
#    Parameters: None 						**
#*********************************************************
sub set_Hour {
	
	my $NEW_MINUTE = $MINUTE + 1;
	if ($NEW_MINUTE == 60) { #report was output at 59 minutes past the hour.
	    $HOUR = $HOUR+1;#set the report time to the current hour value.
	
	} # end if
} # end of set_Hour

#*********************************************************
#**  Function Name: get_Report_Time()
#    Data Written: March 2004
#    Written by: Kristi Olson
#    Description: set the report time stamp to the format
#    necessary to write it into the database.
#
#    Parameters: None.					**
#**							**
#*********************************************************

sub get_Report_Time {
	set_Hour;
	if($HOUR == 24) {
	    $REPORT_TIME = "12:00:00 AM";
	    
	} #end if ($HOUR == 24)
	
	elsif($HOUR == 1) {
            $REPORT_TIME = "1:00:00 AM";
            
        } #end elsif($HOUR == 1)
        
	elsif($HOUR == 2) {
            $REPORT_TIME = "2:00:00 AM";
            
        } #end elsif($HOUR == 2)
        
	elsif($HOUR == 3) {
	    $REPORT_TIME = "3:00:00 AM";
	    
	} #end elsif($HOUR == 3)
	
	elsif($HOUR == 4){
	    $REPORT_TIME = "4:00:00 AM";
	    
	} # end elsif($HOUR == 4)
	
	elsif($HOUR == 5){
	    $REPORT_TIME = "5:00:00 AM";
	    
	} # end elsif($HOUR == 5)
	
	elsif($HOUR == 6){
	    $REPORT_TIME = "6:00:00 AM";
	    
	} # end elsif($HOUR == 6)
	
	elsif($HOUR == 7){
	    $REPORT_TIME = "7:00:00 AM";
	    
	} # end elsif($HOUR == 7)
	
	elsif($HOUR eq "8") {
	    $REPORT_TIME = "8:00:00 AM";
	    
	} # end elsif($HOUR eq "8")
	
	elsif($HOUR eq "9") {
	    $REPORT_TIME = "9:00:00 AM";
	    
	} # end elsif($HOUR eq "9")
	
	elsif($HOUR == 10) {
	    $REPORT_TIME = "10:00:00 AM";
	    
	} # end elsif($HOUR == 10)
	
	elsif($HOUR == 11) {
	    $REPORT_TIME = "11:00:00 AM";
	    
	} # end elsif($HOUR == 11)
	
	elsif($HOUR == 12) {
	    $REPORT_TIME = "12:00:00 PM";
	    
	} # end elsif($HOUR == 12)
	
	elsif($HOUR == 13) {
	    $REPORT_TIME = "1:00:00 PM";
	    
	} # end elsif($HOUR == 13)
	
	elsif($HOUR == 14) {
	    $REPORT_TIME = "2:00:00 PM";
	    
	} # end elsif($HOUR == 14)
	
	elsif($HOUR == 15) {
	    $REPORT_TIME = "3:00:00 PM";
	    
	} # end elsif($HOUR == 15)
	
	elsif($HOUR == 16) {
	    $REPORT_TIME = "4:00:00 PM";
	    
	} # end elsif($HOUR == 16)
	
	elsif($HOUR == 17) {
	    $REPORT_TIME = "5:00:00 PM";
	    
	} # end elsif($HOUR == 17)
	
	elsif($HOUR == 18) {
	    $REPORT_TIME = "6:00:00 PM";
	    
	} # end elsif($HOUR == 18)
	
	elsif($HOUR == 19) {
	    $REPORT_TIME = "7:00:00 PM";
	    
	} # end elsif($HOUR == 19)
	
	elsif($HOUR == 20) {
	    $REPORT_TIME = "8:00:00 PM";
	    
	} # end elsif($HOUR == 20)
	
	elsif($HOUR == 21) {
	    $REPORT_TIME = "9:00:00 PM";
	    
	} # end elsif($HOUR == 21)
	
	elsif($HOUR == 22) {
	    $REPORT_TIME = "10:00:00 PM";
	    
	} # end elsif($HOUR == 22)
	
	elsif($HOUR == 23) {
	    $REPORT_TIME = "11:00:00 PM";
	    
	} # end elsif($HOUR == 23)
	#print "TRFC30 is processing $REPORT_TYPE at $REPORT_TIME\n";
	return;
} # end of get_Report_Time.

#*********************************************************
#**  Function Name: get_Date() 
#    Written by: Kristi Olson
#    Date Written: March 2004				**
#**  	
#    Description: Sets the format of the $DATE variable
#    for the database.
#
#    Parameters: the line containing date information.
#**							**
#*********************************************************
sub get_Date {
	my $INPUT_LINE = shift;
	my @SPLIT_ARRAY = split/ /,$INPUT_LINE;
	foreach $SPLIT_ARRAY_ELEMENT (@SPLIT_ARRAY) {
            if($SPLIT_ARRAY_ELEMENT =~ m/\d\d-\d\d-\d\d/) {
                my @DATE = split/-/, $SPLIT_ARRAY_ELEMENT;
                $YEAR = $DATE[0];
                $MONTH = $DATE[1];
                $DAY = $DATE[2];
                $DATE = "$MONTH/$DAY/$YEAR"; #format the variable $DATE for the database.
                    
                } #end if
	} # end foreach
	return;
} # end get_Date

#*********************************************************
#**  Function Name: get_Report_Type()
#    Written by: Kristi Olson				**
#**  Date Written: March 2004			**
#**  	
#    Description: Set the $REPORT_TYPE variable for each 
#    report. Note the RDT DNU-S report title has a space
#    in it and requires a special evaluation. 
#
#    Parameters: the line containing the report type 
#    informaiton.			**
#*********************************************************

sub get_Report_Type {
	my $REPORT = shift;
	
	if ($REPORT =~ m/(OFC)/) {
            $REPORT_TYPE = OFC;
            
        } # end if
        
        elsif ($REPORT =~ m/(SAD)/) {
            $REPORT_TYPE = SAD;
            
        } # end elsif
        
        elsif ( ($REPORT =~ m/(CT)/) && (!($REPORT =~ m/(CTS)/)) ) {
            $REPORT_TYPE = CT;
            
        } # end elsif 
            
        elsif ($REPORT =~ m/(TD)/) {
            $REPORT_TYPE = TD;
            
        } #end elsif
             
        elsif ($REPORT =~ m/(HLSC)/) {
            $REPORT_TYPE = HLSC;
            
        } # end elsif
        
        elsif ($REPORT =~ m/(TG)/) {
            $REPORT_TYPE = TG;
            
        } # end elsif
        
        elsif ($REPORT =~ m/(PROC)/) {
            $REPORT_TYPE = PROC;
            
        } # end elsif
        
        elsif ($REPORT =~ m/(MLHG)/) {
            $REPORT_TYPE = MLHG;
            
        } # end elsif
        
        elsif ($REPORT =~ m/(ISLU)/) {
            $REPORT_TYPE = ISLU;
            
        } # end elsif
        
        elsif ($REPORT =~ m/(MOD1)/) {
            $REPORT_TYPE = MOD1;
            
        } # end elsif
        
        elsif ($REPORT =~ m/(TX)/) {
            $REPORT_TYPE = TX;
            
        } # end elsif
        
        elsif ($REPORT =~ m/(OFA)/) {
            $REPORT_TYPE = OFA;
            
        } # end elsif
        
        elsif  ($REPORT =~ m/(CTS)/) {
            $REPORT_TYPE = CTS;
            
        } # end elsif
        
        elsif ($REPORT =~ m/(CMP)/) {
            $REPORT_TYPE = CMP;
            
        }# end elsif
        
        elsif ($REPORT =~ m/(ISM)/) {
            $REPORT_TYPE = ISM;
            
        } # end elsif
        elsif (  ($REPORT =~ m/(IPIDB)/) && (!($REPORT =~ m/(IDPIDB)/))  ) {
            $REPORT_TYPE = IPIDB;
            
        } # end elsif
        
        elsif   ($REPORT =~ m/(IDPIDB)/) {
            $REPORT_TYPE = IDPIDB;
            
        } # end elsif
         
        elsif ($REPORT =~ m/(DLTU)/) {
            $REPORT_TYPE = DLTU;
            
        } #
        
        elsif ($REPORT =~ m/(CDN)/) {
            $REPORT_TYPE = CDN;
            
        } # end elsif
        
        elsif ($REPORT =~ m/(IRT)/) {
            $REPORT_TYPE = IRT;
            
        } # end elsif
         
        elsif ($REPORT =~ m/(MH)/) {
            $REPORT_TYPE = MH;
            
        } # end elsif
        
        elsif ($REPORT =~ m/(AIU)/) {
            $REPORT_TYPE = AIU;
            
        } # end elsif
        
        elsif (  ($REPORT =~ m/(RDT)/) && (!($REPORT =~ m/(RDT DNU-S)/))  ) {
            $REPORT_TYPE = RDT;
            
        } # end elsif
        
        elsif   ($REPORT =~ m/(RDT DNU-S)/) {
            $REPORT_TYPE = RDT_DNU_S;
            
        } # end elsif
        
        elsif ($REPORT =~ m/(DR)/) {
            $REPORT_TYPE = DR;
            
        } # end elsif
	
	elsif ($REPORT =~ m/(DSLG)/) {
            $REPORT_TYPE = DSLG;
            
        } # end elsif
	
	elsif ($REPORT =~ m/(LASS)/) {
            $REPORT_TYPE = LASS;
            
        } # end elsif
  
  	elsif ($REPORT =~ m/(UCONF)/) {
            $REPORT_TYPE = UCONF;
            
        } # end elsif   
               
        else { 
            Send_Email_Notification_New_Report ($REPORT_TYPE);
	
	} # end else
return;
} # end get_Report_Type

##*********************************************************
#**  Function Name: Process_SAD_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the SAD SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "SAD".				**
#**							**
##*********************************************************
sub Process_SAD_hash {
        my $LINE = shift;
        if ($LINE =~ m/\d+/) {
            $SAD_ROW_COUNT = $SAD_ROW_COUNT+1;
            my @ROW_DATA = split(/ +/,$LINE);
            #the key for SAD is the "PROC" column value.
            my $KEY = $ROW_DATA[1];
            my @HASH_VALUE = @ROW_DATA[1..8];
            
            if(! defined $SAD_HASH{$KEY}) {
            		            
            	foreach $SAD_HASH_VALUE(@HASH_VALUE) {
                #add the values into the hash for this key.
                	push @{$SAD_HASH{$KEY}}, $SAD_HASH_VALUE; 
                } # end foreach
            
             } #end inner if
        
            else {
             	#send a notification there is already data for this key
             	print "SAD_HASH, key = $KEY, Data already exists in the array of values for this key!\n";
             	my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             	my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             	my $MESSAGE_3 = "SAD_HASH already has data for key $KEY\n";
             	#Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             	}#end else
           
        } # end outer if
        return;
} # end Process_SAD_hash

##*********************************************************
#**  Function Name: Process_MLHG_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the MLHG SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "MLHG".				**
#**							**
##*********************************************************
sub Process_MLHG_hash {
        my $LINE = shift;
        if ($LINE =~ m/\d+/) {
            $MLHG_ROW_COUNT = $MLHG_ROW_COUNT + 1;
            my @ROW_DATA = split(/ +/,$LINE);
            #the key for the MLHG hash is the "ID" value.
            my $KEY = $ROW_DATA[1]; 
            my @HASH_VALUE = @ROW_DATA[1..5];
            if(! defined $MLHG_HASH{$KEY}) {
            
            	foreach $MLHG_HASH_VALUE(@HASH_VALUE) {
                	#add the values into the hash for this key.
                	push @{$MLHG_HASH{$KEY}}, $MLHG_HASH_VALUE;
                 
            	} #end foreach
            
             } #end inner if
        
        else {
             	#send a notification there is already data for this key
             	print "MLHG_HASH, key is $KEY, Data already exists in the array of values for this key!\n";
             	my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             	my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             	my $MESSAGE_3 = "MLHG_HASH already has data for key $KEY\n";
             	#Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             	}#end else
                
        }#end outer if
  	return;
} # end Process_MLHG_hash


##*********************************************************
#**  Function Name: Process_MOD1_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the MOD1 SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "MOD1".				**
#**							**
##*********************************************************
sub Process_MOD1_hash {
        my $LINE = shift;
        if ($LINE =~ m/\d+/) {
            $MOD1_ROW_COUNT = $MOD1_ROW_COUNT + 1;
            my @ROW_DATA = split(/ +/,$LINE);
            #the key for MOD1 is the "SM" value.
            my $KEY = $ROW_DATA[1];
            my @HASH_VALUE = @ROW_DATA[1..8];
            
            if(! defined $MOD1_HASH{$KEY}) {
            
            	foreach $MOD1_HASH_VALUE(@HASH_VALUE) {
                	#add the values into the hash for this key.
                	push @{$MOD1_HASH{$KEY}}, $MOD1_HASH_VALUE; 
                
                } #end foreach
        
            } #end inner if
        
            else {
             	#send a notification there is already data for this key
             	print "MOD1_HASH, key = $KEY, Data already exists in the array of values for this key!\n";
             	my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             	my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             	my $MESSAGE_3 = "MOD1_HASH already has data for key $KEY\n";
             	#Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             	}#end else
             	
         } #end outer if
  	 return;
} # end Process_MOD1_hash

##*********************************************************
#**  Function Name: Process_CDN_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the CDN SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "CDN".				**
#**							**
##*********************************************************
sub Process_CDN_hash {
	my $LINE = shift;
	if ($LINE =~ m/\d+/) {#this is a row of data
	    $CDN_ROW_COUNT = $CDN_ROW_COUNT + 1;
	    my @ROW_DATA = split(/ +/,$LINE);
            shift @ROW_DATA;
            my $KEY = $ROW_DATA[0];
            my @HASH_VALUE = @ROW_DATA[0..8];
            
            if(! defined $CDN_HASH{$KEY}) {
            
            	foreach $CDN_HASH_VALUE (@HASH_VALUE) {
                	#add the values into the hash for this key.
                	push @{$CDN_HASH{$KEY}}, $CDN_HASH_VALUE; 
                
        	} # end foreach
        
            }#end inner if
            
            else {
             	#send a notification there is already data for this key
             	print "CDN_HASH, key = $KEY, Data already exists in the array of values for this key!\n";
             	my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             	my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             	my $MESSAGE_3 = "CDN_HASH already has data for key $KEY\n";
             	#Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             	}#end else
                            
	} #end outer if		
	return;
} #end Process_CDN_hash

##*********************************************************
#**  Function Name: Process_ISM_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the ISM SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "ISM".				**
#**							**
##*********************************************************
sub Process_ISM_hash {
        my $LINE = shift;
        if ($LINE =~ m/\d+/) {
            $ISM_ROW_COUNT = $ISM_ROW_COUNT + 1;
            my @ROW_DATA = split(/ +/,$LINE);
            #the key for the ISM hash is the "PROC" value.
            my $KEY = $ROW_DATA[1]; 
            my @HASH_VALUE = @ROW_DATA[1..4];
            
            if(! defined $ISM_HASH{$KEY}) {
            
            	foreach $ISM_HASH_VALUE(@HASH_VALUE) {
                	#add the values into the hash for this key.
                	push @{$ISM_HASH{$KEY}}, $ISM_HASH_VALUE; 
                
            	} # end foreach
            }#end inner if
            
             else {
             	#send a notification there is already data for this key
             	print "ISM_HASH, key = $KEY, Data already exists in the array of values for this key!\n";
             	my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             	my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             	my $MESSAGE_3 = "ISM_HASH already has data for key $KEY\n";
             	#Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             	}#end else
            
        } #end if
        
  	return;
}#end Process_ISM_hash
##*********************************************************
#**  Function Name: Process_HLSC_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the HLSC SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "HLSC".				**
#**							**
##*********************************************************
sub Process_HLSC_hash {
        my $LINE = shift;
        if ($LINE =~ m/\d+/) {
            $HLSC_ROW_COUNT = $HLSC_ROW_COUNT + 1;
            my @ROW_DATA = split(/ +/,$LINE);
            #the key for the HLSC hash is concatonated "PROC" and "LU" value.
            my $KEY = $ROW_DATA[1].$ROW_DATA[2]; 
            my @HASH_VALUE = @ROW_DATA[1..7];
            
            if(! defined $HLSC_HASH{$KEY}) {
            
           	 foreach $HLSC_HASH_VALUE(@HASH_VALUE) {
                	#add the values into the hash for this key.
                	push @{$HLSC_HASH{$KEY}}, $HLSC_HASH_VALUE; 
                
            	} #end foreach
            
            } #end inner if
            
            else {
             	#send a notification there is already data for this key
             	print "HLSC_HASH, key = $KEY, Data already exists in the array of values for this key!\n";
             	my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             	my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             	my $MESSAGE_3 = "HLSC_HASH already has data for key $KEY\n";
             	#Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             	}#end else
            
        } # end if
  	return;
} #end Process_HLSC_hash

##*********************************************************
#**  Function Name: Process_TD_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the TD SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "TD".				**
#**							**
##*********************************************************
sub Process_TD_hash {
        my $LINE = shift;
        if ($LINE =~ m/\d+/) {
            $TD_ROW_COUNT = $TD_ROW_COUNT + 1;
            my @ROW_DATA = split(/ +/,$LINE);
            #the key for the TD hash is the "PROC" value.
            my $KEY = $ROW_DATA[1]; 
            my @HASH_VALUE = @ROW_DATA[1..6];
            
            if(! defined $TD_HASH{$KEY}) {
            
           	 foreach $TD_HASH_VALUE(@HASH_VALUE) {
                	#add the values into the hash for this key.
                	push @{$TD_HASH{$KEY}}, $TD_HASH_VALUE; 
                
            	} # end foreach
            } #end inner if
            
            else {
             	#send a notification there is already data for this key
             	print "TD_HASH, key = $KEY, Data already exists in the array of values for this key!\n";
             	my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             	my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             	my $MESSAGE_3 = "TD_HASH already has data for key $KEY\n";
             	#Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             	}#end else
            
        } #end if
  
}# end Process_TD_hash

##*********************************************************
#**  Function Name: Process_DLTU_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the DLTU SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "DLTU".				**
#**							**
##*********************************************************
sub Process_DLTU_hash {
        my $LINE = shift;
        if ($LINE =~ m/\d+/) {
            $DLTU_ROW_COUNT = $DLTU_ROW_COUNT + 1;
            my @ROW_DATA = split(/ +/,$LINE);
            #the key for the DLTU hash is the "PROC" value.
            my $KEY = $ROW_DATA[1]; 
            my @HASH_VALUE = @ROW_DATA[1..3];
            
            if(! defined $DLTU_HASH{$KEY}) {
            
            	foreach $DLTU_HASH_VALUE(@HASH_VALUE) {
                	#add the values into the hash for this key.
                	push @{$DLTU_HASH{$KEY}}, $DLTU_HASH_VALUE;
                 
            	} # end foreach
            } #end inner if
            
            else {
             	#send a notification there is already data for this key
             	print "DLTU_HASH, key = $KEY, Data already exists in the array of values for this key!\n";
             	my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             	my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             	my $MESSAGE_3 = "DLTU_HASH already has data for key $KEY\n";
             	#Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             	}#end else
            
        } # end if
        
  	return;
} # end Process_DLTU_hash

##*********************************************************
#**  Function Name: Process_CMP_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the CMP SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "CMP".				**
#**							**
##*********************************************************

sub Process_CMP_hash {
        my $LINE = shift;	
	if ($LINE =~ m/VALID/) {#we are in the first subsection.
	    $SUBSECTION = 1;
	    
	} #end if
	
	elsif ($LINE =~ m/HPIN/) {#we are in the second subsection.
	    $SUBSECTION = 2;
	    
	} # end elsif
	
	elsif (($SUBSECTION eq 1) && ($LINE =~ m/\d+/)) {
	    $CMP_ROW_COUNT = $CMP_ROW_COUNT + 1;
            my @ROW_DATA = split(/ +/,$LINE);
            #the key for the CMP has is a composite of both the MSC and CMP.
            my $KEY = $ROW_DATA[1].$ROW_DATA[2];
            #get rid of the extra space at the begining, 
            my @HASH_VALUE = @ROW_DATA[1..8]; 
            if (keys %CMP_HASH < 1) {#add the first key into the hash.
            	
                foreach $CMP_HASH_VALUE (@HASH_VALUE) {
                    #add the values into the hash for this key.
                    push @{$CMP_HASH{$KEY}}, $CMP_HASH_VALUE;
                     
                } # end foreach
                
            } # end if
                
            #add the remaining values into the hash.     
              elsif(! defined $CMP_HASH{$KEY}[7]) {
              
              	foreach $CMP_HASH_VALUE1 (@HASH_VALUE) {
              		#add the values into the hash for this key.
                push @{$CMP_HASH{$KEY}}, $CMP_HASH_VALUE1;
                
              	} # end foreach
             }# end inner elsif
             
             else {
             	#send a notification there is already data for this key
             	print "CMP_HASH subsection 1, key = $KEY, Data already exists in the array of values for this key!\n";
             	my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             	my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             	my $MESSAGE_3 = "CMP_HASH subsection 1 already has data for key $KEY\n";
             	#Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             }#end else
                   
	 } # end elsif subsection 1
	    
	 elsif (($SUBSECTION eq 2 ) && ($LINE =~ m/\d+/)) {
             $CMP_ROW_COUNT = $CMP_ROW_COUNT + 1;
             my @ROW_DATA = split(/ +/,$LINE);
             #the key for the CMP has is a composite of both the MSC and CMP.
             my $KEY = $ROW_DATA[1].$ROW_DATA[2];
             #get rid of the extra space at the begining,also get rid of the extra MSC and CMP.  
             my @HASH_VALUE = @ROW_DATA[3..5]; 
             #add the values into the hash.   
             
              if(! defined $CMP_HASH{$KEY}[11]) {
              
              	foreach $CMP_HASH_VALUE2 (@HASH_VALUE) {
              		#add the values into the hash for this key.
                push @{$CMP_HASH{$KEY}}, $CMP_HASH_VALUE2;
                
              	} # end foreach
             }# end inner if
	
             else {
             #send a notification there is already data for this key
             print "CMP_HASH subsection 2, key = $KEY, Data already exists in the array of values for this key!\n";
             my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             my $MESSAGE_3 = "CMP_HASH subsection 2 already has data for key $KEY\n";
             #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             }#end else
          } # end if subsection 2
           

	return;
} #end Process_CMP_hash 
    
	
##*********************************************************
#**  Function Name: Process_TG_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the TG SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "TG".				**
#**							**
##*********************************************************
sub Process_TG_hash {
        my $LINE = shift;
                
        if ($LINE =~ m/(ID     TGNAME)/) {
            $SUBSECTION = 0;
            
	} # end if
	
	elsif ($LINE =~ m/(ID     IPC    OPC    OFL    MTU    USG    ITUSG  OTUSG)/) {
	    $SUBSECTION = 1;
	    
	        
        } # end elsif
        	
	elsif ($LINE =~ m/(ID     IPCTT  OPCTT  OFLTT  SILC   EAIPC  EAITU  FAOUT)/) {
	    $SUBSECTION = 2;
	        
        } #end elsif 
        
	elsif ($LINE =~ m/(ID     IAMRC  RELI   INSVC  OOS)/) {
	    $SUBSECTION = 3;
	    
        } # end elsif
          
        if ( ($LINE =~ m/[0123456789]/) &&($SUBSECTION eq  1)) {
            $TG_ROW_COUNT = $TG_ROW_COUNT + 1;
            my @ROW_DATA = split(/ +/,$LINE);
            #the first number of each line is TG ID, which will be the keys in the hash.
            my $KEY = ((@ROW_DATA) [1]); 
            #get rid of the extra space at the begining, also get rid of the extra TG ID.  
            my @HASH_VALUE = @ROW_DATA[2..8];
            	
              if(! defined $TRUNK_GROUP_HASH{$KEY}[7]) {
              
              	foreach $TG1_HASH_VALUE (@HASH_VALUE) {#add the values into the hash for this key.
                push @{$TRUNK_GROUP_HASH{$KEY}}, $TG1_HASH_VALUE;
                
              	} # end foreach
             }# end inner if
             
         else {
             #send a notification there is already data for this key
             print "TG_HASH subsection 1, key = $KEY, Data already exists in the array of values for this key!\n";
             my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             my $MESSAGE_3 = "TRUNK GROUP HASH subsection 1 already has data for key $KEY\n";
             #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             }#end else
          } # end if subsection 1
          
         elsif ( ($LINE =~ m/[0123456789]/) &&($SUBSECTION eq  2)) {
            $TG_ROW_COUNT = $TG_ROW_COUNT + 1;
            my @ROW_DATA = split(/ +/,$LINE);
            #the first number of each line is TG ID, which will be the keys in the hash.
            my $KEY = ((@ROW_DATA) [1]); 
            #get rid of the extra space at the begining, also get rid of the extra TG ID.  
            my @HASH_VALUE = @ROW_DATA[2..8];
            	
              if(! defined $TRUNK_GROUP_HASH{$KEY}[13]) {
              
              	foreach $TG2_HASH_VALUE (@HASH_VALUE) {#add the values into the hash for this key.
                push @{$TRUNK_GROUP_HASH{$KEY}}, $TG2_HASH_VALUE;
                
              	} # end foreach
             }# end inner if
             
         else {
             #send a notification there is already data for this key
             print "TG_HASH subsection 2, key = $KEY, Data already exists in the array of values for this key!\n";
             my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             my $MESSAGE_3 = "TRUNK GROUP HASH subsection 2 already has data for key $KEY\n";
             #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             }#end else
          } # end if subsection 2
            
       
        elsif ( ($LINE =~ m/[0123456789]/) && ($SUBSECTION eq 3)) {       
            my @ROW_DATA = split(/ +/,$LINE);
            #the first number of each line is TG ID, which will be the keys in the hash.
            my $KEY = ((@ROW_DATA) [1]); 
            #get rid of the extra space at the begining, also get rid of the extra TG ID.  
            my @HASH_VALUE = @ROW_DATA[2..5];
                        
              if(! defined $TRUNK_GROUP_HASH{$KEY}[16]) {
              
              	foreach $TG3_HASH_VALUE (@HASH_VALUE) {#add the values into the hash for this key.
                push @{$TRUNK_GROUP_HASH{$KEY}}, $TG3_HASH_VALUE;
                
              	} # end foreach
             }# end inner if
             
         else {
             #send a notification there is already data for this key
             print "TG_HASH subsection 3, key = $KEY, Data already exists in the array of values for this key!\n";
             my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             my $MESSAGE_3 = "TRUNK GROUP HASH subsection 3 already has data for key $KEY\n";
             #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             }#end else
          } # end if subsection 3
      return;
} # end Process_TG_hash

##*********************************************************
#**  Function Name: Process_MH_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the MH SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "MH".				**
#**							**
##*********************************************************
sub Process_MH_hash {
        my $LINE = shift;
        if ($LINE =~ m/\d+/) {
            $MH_ROW_COUNT = $MH_ROW_COUNT + 1;
            my @ROW_DATA = split(/ +/,$LINE);
            #the key for the MH hash is a concatonation of the first two values of each line. This is necessary
            #since the same SM and MH are repeated on mulitple lines of both subsections.
            my $KEY = $ROW_DATA[1].$ROW_DATA[2]; 
            #We need to keep track of the subsection, to eliminate the repeated values for SM and MH
            #from the second subsection. 
            if($SUBSECTION == 1) {
                my @HASH_VALUE = @ROW_DATA[1..7];
                
                if(! defined $MH_HASH{$KEY}[6]) {
                
                    foreach $MH1_HASH_VALUE(@HASH_VALUE) {#add the values into the hash for this key.
              	    push @{$MH_HASH{$KEY}}, $MH1_HASH_VALUE; 
                	
        	    } # end foreach	
        	    
        	} #end inner if 
        
        else {
             #send a notification there is already data for this key
             print "MH_HASH subsection 1, key = $KEY, Data already exists in the array of values for this key!\n";
             my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             my $MESSAGE_3 = "MH_HASH subsection 1 already has data for key $KEY\n";
             #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             }#end else
        
	    } # end if subsection 1
            
        elsif($SUBSECTION eq 2) {
            #adjust the values in the slice to eliminate the repeated values of SM, IDCU, RT.
            my @HASH_VALUE = @ROW_DATA[3..13];
            
            if(! defined $MH_HASH{$KEY}[14]) {
                        
            	foreach $MH2_HASH_VALUE(@HASH_VALUE){#add the values into the hash for this key.
                push @{$MH_HASH{$KEY}}, $MH2_HASH_VALUE; 
                
        			} # end foreach
	     			} #end inner if
	     
	         else {
             #send a notification there is already data for this key
             print "MH_HASH subsection 2, key = $KEY, Data already exists in the array of values for this key!\n";
             my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             my $MESSAGE_3 = "MH_HASH subsection 2 already has data for key $KEY\n";
             #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             }#end else
            
        } # end elsif
      }#end if
      
	elsif ($LINE =~ m/(MESSAGES)/) {
	    $SUBSECTION = 1;
	    
        } # end elsif
        	
	elsif ($LINE =~ m/(GEN)/) {
	    $SUBSECTION = 2;
	    
        } # end elsif
        
  	return;
  	    
} # end Process_MH_hash

##*********************************************************
#**  Function Name: Process_AIU_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the AIU SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "AIU".				**
#**							**
##*********************************************************
sub Process_AIU_hash {
        my $LINE = shift;
        if ($LINE =~ m/\d+/)
            {$AIU_ROW_COUNT = $AIU_ROW_COUNT + 1;
            my @ROW_DATA = split(/ +/,$LINE);
            
            #the key for the AIU hash is a concatonation of the
            #first two values of each line. This is necessary
            #since the same SM and AIU are repeated on multiple
            #lines of both subsections.
            my $KEY = $ROW_DATA[1].$ROW_DATA[2]; 
            
            
            #We need to keep track of the subsection, to
            #eliminate the repeated values for SM and AIU
            #from the second subsection. 
            if($SUBSECTION == 1){ 
            
            my @HASH_VALUE = @ROW_DATA[1..7];
                        
              if(! defined $AIU_HASH{$KEY}[6]) {
              
              	foreach $AIU_HASH_VALUE1 (@HASH_VALUE) {#add the values into the hash for this key.
                push @{$AIU_HASH{$KEY}}, $AIU_HASH_VALUE1;
                
              	} # end foreach
             }# end inner if
             
             else {
             #send a notification there is already data for this key
             print "AIU_HASH subsection 1, key = $KEY, Data already exists in the array of values for this key!\n";
             my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             my $MESSAGE_3 = "AIU_HASH subsection 1 already has data for key $KEY\n";
             #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             }#end else
          } # end if subsection 1
                    
           
            elsif($SUBSECTION == 2) {
            
            	#adjust the values in the slice to eliminate 
            	#the repeated values of SM, AIU.
            	my @HASH_VALUE = @ROW_DATA[3..5]; 
            	
              if(! defined $AIU_HASH{$KEY}[11]) {
              
              	foreach $AIU_HASH_VALUE2 (@HASH_VALUE) {#add the values into the hash for this key.
                push @{$AIU_HASH{$KEY}}, $AIU_HASH_VALUE2;
                
              	} # end foreach
             }# end inner if
             
                          else {
             #send a notification there is already data for this key
             print "AIU_HASH subsection 2, key = $KEY, Data already exists in the array of values for this key!\n";
             my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             my $MESSAGE_3 = "AIU_HASH subsection 2 already has data for key $KEY\n";
             #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             }#end else
            } #end elseif subsection 2
            
    }# end outer if
      
	elsif ($LINE =~ m/(TMATT)/)
	        {$SUBSECTION = 1;
            }	
	elsif ($LINE =~ m/(DIGATT)/)
	        {$SUBSECTION = 2;
            }
  
} #end Process_AIU  

##*********************************************************
#**  Function Name: Process_IPIDB_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the IPIDB SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "IPIDB".				**
#**							**
##*********************************************************
sub Process_IPIDB_hash {
    my $LINE = shift;
    if ($LINE =~ m/\d+/) {
        $IPIDB_ROW_COUNT = $IPIDB_ROW_COUNT + 1;
        my @ROW_DATA = split(/ +/,$LINE);
        #the key for the IPIDB hash is a concatonation of the first two values of each line. This is necessary
        #since the same SM and IDCU are repeated on multiple lines of both subSECTIONs.
        my $KEY = $ROW_DATA[1].$ROW_DATA[2]; 
        my @HASH_VALUE = @ROW_DATA[1..9];
        
        if(! defined $IPIDB_HASH{$KEY}) {
        	foreach $IPIDB_HASH_VALUE(@HASH_VALUE) {#add the values into the hash for this key.
                push @{$IPIDB_HASH{$KEY}}, $IPIDB_HASH_VALUE; 
            
        	} # end foreach
        
        }# end if
        
        else {
             	#send a notification there is already data for this key
             	print "IPIDB_HASH, key = $KEY, Data already exists in the array of values for this key!\n";
             	my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             	my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             	my $MESSAGE_3 = "IPIDB_HASH already has data for key $KEY\n";
             	#Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             	}#end else
    } # end if
    return;
} # end Process_IPIDB_hash
  
##*********************************************************
#**  Function Name: Process_IDPIDB_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the IDPIDB SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "IDPIDB".				**
#**							**
##*********************************************************
sub Process_IDPIDB_hash {
    my $LINE = shift;
    if ($LINE =~ m/\d+/) {
        $IDPIDB_ROW_COUNT = $IDPIDB_ROW_COUNT + 1;
        my @ROW_DATA = split(/ +/,$LINE);
        #the key for the IDPIDB hash is a concatonation of the first two values of each line. This is necessary
        #since the same SM and IDCU are repeated on multiple lines of both subsections.
        my $KEY = $ROW_DATA[1].$ROW_DATA[2]; 
        my @HASH_VALUE = @ROW_DATA[1..8];
        
        if(! defined $IDPIDB_HASH{$KEY}) {
        	foreach $IDPIDB_HASH_VALUE(@HASH_VALUE) {#add the values into the hash for this key.
           	 push @{$IDPIDB_HASH{$KEY}}, $IDPIDB_HASH_VALUE; 
            
        	} # end foreach
        }#end if
        
        else {
             	#send a notification there is already data for this key
             	print "IDPIDB_HASH, key = $KEY, Data already exists in the array of values for this key!\n";
             	my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             	my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             	my $MESSAGE_3 = "IDPIDB_HASH already has data for key $KEY\n";
             	#Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             	}#end else
    } # end if
    return;
} # end Process_IDPIDB_hash
   
##*********************************************************
#**  Function Name: Process_ISLU_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the ISLU SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "ISLU".				**
#**							**
##*********************************************************
sub Process_ISLU_hash {
    my $LINE = shift;
    if ($LINE =~ m/\d+/) {
        $ISLU_ROW_COUNT = $ISLU_ROW_COUNT + 1;
            my @ROW_DATA = split(/ +/,$LINE);
            #the key for the ISLU hash is a concatonation of the first two values of each line. This is necessary
            #since the same SM and IDCU are repeated on multiple lines of both subsections.
            my $KEY = $ROW_DATA[1].$ROW_DATA[2]; 
            
            my @HASH_VALUE = @ROW_DATA[1..7];
            
            if(! defined $ISLU_HASH{$KEY}) {
            	foreach $ISLU_HASH_VALUE(@HASH_VALUE) {#add the values into the hash for this key.
                push @{$ISLU_HASH{$KEY}}, $ISLU_HASH_VALUE; 
                
            	} # end foreach
            }# end if
            
           else {
             	#send a notification there is already data for this key
             	print "ISLU_HASH, key = $KEY, Data already exists in the array of values for this key!\n";
             	my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             	my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             	my $MESSAGE_3 = "ISLU_HASH already has data for key $KEY\n";
             	#Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             	}#end else
    } # end if
    return;
}# end Process_ISLU_hash      
        
##*********************************************************
#**  Function Name: Process_IRT_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the IRT SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "IRT".				**
#**							**
##*********************************************************
sub Process_IRT_hash {
    my $LINE = shift;
    if ($LINE =~ m/\d+/){
        $IRT_ROW_COUNT = $IRT_ROW_COUNT + 1;
	my @ROW_DATA = split(/ +/,$LINE);
        #the key for the IRT hash is a concatonation of the first three values of each line. This is necessary
	#since the same SM and IDCU are repeated on mulitple lines of both subsections.
	my $KEY = $ROW_DATA[1].$ROW_DATA[2].$ROW_DATA[3]; 
	
        #We need to keep track of the subsection, to eliminate the repeated values for SM, IDCU, and RT
	#from the second subsection. 
	if($SUBSECTION == 1){
	    my @HASH_VALUE = @ROW_DATA[1..8];
	    	    	
              if(! defined $IRT_HASH{$KEY}[7]) {
              
              	foreach $IRT_HASH_VALUE1 (@HASH_VALUE) {#add the values into the hash for this key.
                push @{$IRT_HASH{$KEY}}, $IRT_HASH_VALUE1;
                
              	} # end foreach
             }# end inner if
	
             else {
             #send a notification there is already data for this key
             print "IRT_HASH subsection 1, key = $KEY, Data already exists in the array of values for this key!\n";
             my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             my $MESSAGE_3 = "IRT_HASH subsection 1 already has data for key $KEY\n";
             #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             }#end else
          } # end if subsection 1
	
        elsif($SUBSECTION == 2){
            #adjust the values in the slice to eliminate the repeated values of SM, IDCU, RT.
	    my @HASH_VALUE = @ROW_DATA[4..7];
	    	
              if(! defined $IRT_HASH{$KEY}[14]) {
              
              	foreach $IRT_HASH_VALUE2 (@HASH_VALUE) {#add the values into the hash for this key.
                push @{$IRT_HASH{$KEY}}, $IRT_HASH_VALUE2;
                
              	} # end foreach
             }# end inner if
	
             else {
             #send a notification there is already data for this key
             print "IRT_HASH subsection 2, key = $KEY, Data already exists in the array of values for this key!\n";
             my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             my $MESSAGE_3 = "IRT_HASH subsection 2 already has data for key $KEY\n";
             #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             }#end else
          } # end if subsection 2
	    
           
    } #end of data row processing
    
    elsif ($LINE =~ m/(ATMPT)/){
        $SUBSECTION = 1;
        
    } # end elsif
    	
    elsif ($LINE =~ m/(TOT_TS)/){
        $SUBSECTION = 2;
        
    } # end elsif
    return;
} # end Process_IRT_hash subroutine
  
##*********************************************************
#**  Function Name: Process_PROC_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the PROC SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "PROC".				**
#**							**
##*********************************************************
sub Process_PROC_hash {
    my $LINE = shift;
    if ($LINE =~ m/SMPATM/) {#this row contains data we don't want.
        $BLOCK_DATA = 1;
        
    } # end if
    
    elsif ($LINE =~ m/OCCUP/) {
        $BLOCK_DATA = 0;
         
    } #end elsif
        	
    elsif (($LINE =~ m/\d+/) && ( ! ($LINE =~ m/AM/))&& ($BLOCK_DATA == 0)) {#this is a row of data
        $PROC_ROW_COUNT = $PROC_ROW_COUNT + 1;
        my @ROW_DATA = split(/ +/,$LINE);
        my $KEY = $ROW_DATA[1]; 
        my @HASH_VALUE = @ROW_DATA[1..8];
        
        if(! defined $PROC_HASH{$KEY}[7]) {
              
              	foreach $PROC1_HASH_VALUE (@HASH_VALUE) {#add the values into the hash for this key.
                push @{$PROC_HASH{$KEY}}, $PROC1_HASH_VALUE;
                
              	} # end foreach
             }# end inner if
             
         else {
             #send a notification there is already data for this key
             print "PROC_HASH subsection 1, key = $KEY, Data already exists in the array of values for this key!\n";
             my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             my $MESSAGE_3 = "PROC_S_HASH subsection 1 already has data for key $KEY\n";
             #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             }#end else
          } # end if subsection 1
        
    
    elsif (($LINE =~ m/AM/)&&($ITERATION_PROC eq FALSE) && ($BLOCK_DATA == 0)) {
         $ITERATION_PROC = TRUE;
         @ROW_DATA = split(/ +/,$LINE);
	 shift @ROW_DATA;
	 $KEY = $ROW_DATA[0]; 
         @HASH_VALUE = @ROW_DATA[0..7];
         
        if(! defined $PROC_HASH{$KEY}[10]) {
              
              	foreach $PROC2_HASH_VALUE (@HASH_VALUE) {#add the values into the hash for this key.
                push @{$PROC_HASH{$KEY}}, $PROC2_HASH_VALUE;
                
              	} # end foreach
             }# end inner if
             
         else {
             #send a notification there is already data for this key
             print "PROC_HASH subsection 2, key = $KEY, Data already exists in the array of values for this key!\n";
             my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             my $MESSAGE_3 = "PROC_HASH subsection 2 already has data for key $KEY\n";
             #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             }#end else
          } # end if subsection 2
         
    return;
} # end Process_PROC_hash      

##*********************************************************
#**  Function Name: Process_RDT_DNU_S_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the RDT_DNU_S SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "RDT_DNU_S".				**
#**							**
##*********************************************************

sub Process_RDT_DNU_S_hash {
    my $LINE = shift;
    if ($LINE =~ m/\d+/) {
        $RDT_DNU_S_ROW_COUNT = $RDT_DNU_S_ROW_COUNT+1;
         my @ROW_DATA = split(/ +/,$LINE);
         #the key of the RDT DNU-S hash is a concatonation of SM, DNUS and RDT.
         my $KEY = $ROW_DATA[1].$ROW_DATA[2].$ROW_DATA[3];
         
         #We need to keep track of the subsection, to eliminate the repeated values for SM, DNUS, RDT
         #from the second subsection.  
          if ($SUBSECTION == 1) {
              #get rid of the extra space at the begining. 
              my @HASH_VALUE = @ROW_DATA[1..9];
              
              if(! defined $RDT_DNU_HASH{$KEY}[8]) {
              
              	foreach $RDT_DNU_HASH_VALUE (@HASH_VALUE) {#add the values into the hash for this key.
                push @{$RDT_DNU_S_HASH{$KEY}}, $RDT_DNU_HASH_VALUE;
                
              	} # end foreach
             }# end inner if
             
         else {
             #send a notification there is already data for this key
             print "RDT_DNU_S_HASH subsection 1, key = $KEY, Data already exists in the array of values for this key!\n";
             my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             my $MESSAGE_3 = "RDT_DNU_S_HASH subsection 1 already has data for key $KEY\n";
             #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             }#end else
          } # end if subsection 1
                
        elsif ($SUBSECTION == 2) {
            #adjust the values in the slice to eliminate the repeated values of SM, DNUS, RDT.   
            my @HASH_VALUE = @ROW_DATA[4..7];
            
            if(! defined $RDT_DNU_HASH{$KEY}[15]) {
            	
            	foreach $RDT2_DNU_HASH_VALUE(@HASH_VALUE) { #add the values into the hash for this key.
                push @{$RDT_DNU_S_HASH{$KEY}}, $RDT2_DNU_HASH_VALUE;
                
            	} # end foreach
            
            }# end inner if
            
            else {
             #send a notification there is already data for this key
             print "RDT_DNU_S_HASH subsection 2, key = $KEY, Data already exists in the array of values for this key!\n";
             my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
             my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
             my $MESSAGE_3 = "RDT_DNU_S_HASH subsection 2 already has data for key $KEY\n";
             #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
             }#end else
        
        } # end elsif subsection 2
    } #end outer if
    
    elsif ($LINE =~ m/(BLKD)/) {
        $SUBSECTION = 1;
        
    } # end elsif

    elsif ($LINE =~ m/(TOT_TS)/) {
        $SUBSECTION = 2;
        
    } # end elsif
    return;	  
 } # end Process_RDT_DNU_S
##*********************************************************
#**  Function Name: Process_CT_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the CT SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "CT".				**
#**							**
##*********************************************************
sub Process_CT_hash {
    my $LINE = shift;
    my $KEY = "key";
    if($LINE =~ m/ORIGINAT/){
        $CT_ROW_COUNT = $CT_ROW_COUNT + 1;
	my @ROW_DATA = split(/ +/,$LINE);
	my @HASH_VALUE = @ROW_DATA[2..5];
	
	if(! defined $CT_HASH{$KEY}[3]) {
	    
	    foreach $CT1_HASH_VALUE(@HASH_VALUE) {
	    push @{$CT_HASH{$KEY}}, $CT1_HASH_VALUE;
	    	
	    } # end foreach
        }# end inner if
        
        else {
            #send a notification there is already data for this key
            print "CT_HASH, key = $KEY, Data already exists in the array of values for ORIGINAT\n";
            my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
            my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
            my $MESSAGE_3 = "CT_HASH is receiving duplicate data.\n";
            #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
            }#end else
} # end if

elsif  ($LINE =~ m/TERMINAT/) {
	$CT_ROW_COUNT = $CT_ROW_COUNT + 1;
	my @ROW_DATA = split(/ +/,$LINE);
	#my $KEY = "TERMINAT";
	my @HASH_VALUE = @ROW_DATA[2..5];
	
	if(! defined $CT_HASH{$KEY}[16]) {
	    
	    foreach $CT2_HASH_VALUE(@HASH_VALUE) {
	    push @{$CT_HASH{$KEY}}, $CT2_HASH_VALUE;
	   	
	    } # end foreach
        }# end inner if
        
        else {
            #send a notification there is already data for this key
            print "CT_HASH, key = $KEY, Data already exists in the array of values for TERMINAT!\n";
            my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
            my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
            my $MESSAGE_3 = "CT_HASH is receiving duplicate data.\n";
            #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
            }#end else
} # end if
	    
    elsif ($LINE =~ m/INCOMING/) {
        $CT_ROW_COUNT = $CT_ROW_COUNT + 1;
	my @ROW_DATA = split(/ +/,$LINE);
	my @HASH_VALUE = @ROW_DATA[2..4];
	
	if(! defined $CT_HASH{$KEY}[6]) {
		
	    foreach $CT3_HASH_VALUE(@HASH_VALUE) {
	    push @{$CT_HASH{$KEY}}, $CT3_HASH_VALUE;
	  	
	    } # end foreach
	}# end inner if	
	
	else {
            #send a notification there is already data for this key
            print "CT_HASH, key = $KEY, Data already exists in the array of values for INCOMING/INTRAOFF/OUTGOING/TANDEM!\n";
            my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
            my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
            my $MESSAGE_3 = "CT_HASH is receiving duplicate data.\n";
            #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
            }#end else
} # end elsif

elsif ($LINE =~ m/INTRAOFF/) {
        $CT_ROW_COUNT = $CT_ROW_COUNT + 1;
	my @ROW_DATA = split(/ +/,$LINE);
	my @HASH_VALUE = @ROW_DATA[2..4];
	
	if(! defined $CT_HASH{$KEY}[9]) {
		
	    foreach $CT4_HASH_VALUE(@HASH_VALUE) {
	   push @{$CT_HASH{$KEY}}, $CT4_HASH_VALUE;
	   	
	    } # end foreach
	}# end inner if	
	
	else {
            #send a notification there is already data for this key
            print "CT_HASH, key = $KEY, Data already exists in the array of values for INCOMING/INTRAOFF/OUTGOING/TANDEM!\n";
            my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
            my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
            my $MESSAGE_3 = "CT_HASH is receiving duplicate data.\n";
            #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
            }#end else
} # end elsif

elsif ($LINE =~ m/OUTGOING/) {
        $CT_ROW_COUNT = $CT_ROW_COUNT + 1;
	my @ROW_DATA = split(/ +/,$LINE);
	my @HASH_VALUE = @ROW_DATA[2..4];
	
	if(! defined $CT_HASH{$KEY}[12]) {
		
	    foreach $CT5_HASH_VALUE(@HASH_VALUE) {
	    push @{$CT_HASH{$KEY}}, $CT5_HASH_VALUE;
	   	
	    } # end foreach
	}# end inner if	
	
	else {
            #send a notification there is already data for this key
            print "CT_HASH, key = $KEY, Data already exists in the array of values for OUTGOING\n";
            my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
            my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
            my $MESSAGE_3 = "CT_HASH is receiving duplicate data.\n";
            #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
            }#end else
} # end elsif

elsif($LINE =~ m/TANDEM/){
	
        $CT_ROW_COUNT = $CT_ROW_COUNT + 1;
	my @ROW_DATA = split(/ +/,$LINE);
	my @HASH_VALUE = @ROW_DATA[2..4];
	if(! defined $CT_HASH{$KEY}[19]) {
		
	    foreach $CT6_HASH_VALUE(@HASH_VALUE) {
	    push @{$CT_HASH{$KEY}}, $CT6_HASH_VALUE;
	   	    
	    } # end foreach
	}# end if
	
	else {
            #send a notification there is already data for this key
            print "CT_HASH, key = $KEY, Data already exists in the array of values for this key!\n";
            my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
            my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
            my $MESSAGE_3 = "CT_HASH is receiving duplicate data.\n";
            #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
            }#end else
            
    } #end elsif
    
    elsif($LINE =~ m/\+/) {
    	$CT_ROW_COUNT = $CT_ROW_COUNT + 1;
	my @ROW_DATA = split(/ +/,$LINE);
	my @HASH_VALUE = $ROW_DATA[2];
	
	if(! defined $CT_HASH{$KEY}[20]) {
		
	    foreach $CT7_HASH_VALUE(@HASH_VALUE) {
	   push @{$CT_HASH{$KEY}}, $CT7_HASH_VALUE;
	   	    
	    } # end foreach
	}# end inner if
	
	else {
            #send a notification there is already data for this key
            print "CT_HASH, key = $KEY, Data already exists in the array of values for O+T!\n";
            my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
            my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
            my $MESSAGE_3 = "CT_HASH is receiving duplicate data.\n";
            #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
            }#end else
            
    } # end elsif
    
    elsif($LINE =~ m/IFFM/) {
        $CT_ROW_COUNT = $CT_ROW_COUNT + 1;
	my @ROW_DATA = split(/ +/,$LINE);
	my @HASH_VALUE = $ROW_DATA[2];
	
	if(! defined $CT_HASH{$KEY}[21]) {
		
	    foreach $CT8_HASH_VALUE(@HASH_VALUE) {
	    push @{$CT_HASH{$KEY}}, $CT8_HASH_VALUE;
	    
	    } # end foreach
	}# end inner if
	
	else {
            #send a notification there is already data for this key
            print "CT_HASH, key = $KEY, Data already exists in the array of values for IFFM!\n";
            my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
            my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
            my $MESSAGE_3 = "CT_HASH is receiving duplicate data.\n";
            #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
            }#end else
            
    } # end elsif
    return;	
} # end Process_CT_hash

##*********************************************************
#**  Function Name: Process_CTS_hash()	
#    Written by: Kristi Olson				**
#**  Date Written: March 2004
#    
#    Description: reads in the CTS SECTION report and builds
#    a hash of the values to be inserted into the database.
#
#    Parameters: each line of data while the $REPORT_TYPE
#    parameter is still "CTS".				**
#**							**
##*********************************************************
sub Process_CTS_hash {
    my $LINE = shift;
    if (($LINE =~ m/\d+/) && (!($LINE =~ m/0RCV/))) {#this is a row of data 
        $CTS_ROW_COUNT = $CTS_ROW_COUNT + 1;
	my @ROW_DATA = split(/ +/,$LINE);
        shift @ROW_DATA;
        my $KEY = $ROW_DATA[0];
        my @HASH_VALUE = @ROW_DATA[1..8];
        
        if(! defined $CTS_HASH{$KEY}) {
        	
            foreach $CTS_HASH_VALUE (@HASH_VALUE) {#add the values into the hash for this key.
            push @{$CTS_HASH{$KEY}}, $CTS_HASH_VALUE; 
        
	    } # end foreach
	
       }# end inner if 
       
       else {
            #send a notification there is already data for this key
            print "CTS_HASH, key = $KEY, Data already exists in the array of values for this key!\n";
            my $MESSAGE_1 = "There is a problem with the Traffic_30_Reports scripting.\n";
            my $MESSAGE_2 = "Script has detected duplicate data for a key.\n";
            my $MESSAGE_3 = "CTS_HASH already has data for key $KEY\n";
            #Send_Email_Notification("Problem with Traffic_30_Reports: duplicate data in a key", $MESSAGE_1, $MESSAGE_2, $MESSAGE_3);
            }#end else
            
    } # end if		
    return;
}# end Process_CTS_hash

#*********************************************************
#**  Function Name: process_Line()
#    Date Written: March 2004
#    Written by: Kristi Olson				**
#**  
#    Description: process_Line examines each line from the
#    socket connection. The header lines determines
#    $REPORT_TYPE and $REPORT_TIME. Once a header determines
#    $REPORT_TYPE, each subsequent line is processed by the
#    subroutine for that report, until the $REPORT_TYPE changes.
#    Also set a "WRITE_FLAG" while each line of known SECTION
#    reports are being processed. Without this write flag, 
#    garbage data or reports we are not interested in processing
#    will set of the timer in main and trigger the functions to 
#    write to the database.
#
#    Parameters: Each line from the socket connection.				**
#**							**
#*********************************************************

sub process_Line {
    my $LINE = shift;
    if($LINE =~ m/S570/) { #CHECK to see if $LINE is the first header line.
    $HEADER_1 = $LINE; #if it is, capture the first line.
    get_Date $HEADER_1;	
    $REPORT_TYPE = "";
    
    } # end if
		
    elsif($LINE =~ m/TRFC30/)  { #CHECK to see if $LINE is the second header line.
        get_Report_Type $LINE; #use the $LINE to get the report type.

        } # end elsif
		
    elsif($LINE =~ m/DR/) {
        $WRITE_FLAG = 0;
	$REPORT_TYPE = DR;
	
    } #end elsif
		
    elsif(($LINE =~ m/TIME/) && ( ! ($LINE =~ m/CONTROL/))) {
        my @SPLIT_ARRAY = split(/ /,$LINE); #split up the line with time information.
	my @SPLIT_TIME = split(/:/,$SPLIT_ARRAY[6]);
	$HOUR = $SPLIT_TIME[0]; #get the hour.
	$MINUTE = $SPLIT_TIME[1];
	get_Report_Time;
	
    } # end elsif
		
    elsif($LINE =~ m/SECTION/) {
        my @SECTION_ARRAY = split(/\b/,$LINE);
	$REPORT_SECTION_NUMBER = $SECTION_ARRAY[3];
	
    } # end elsif
    
    elsif($REPORT_TYPE eq TG) {
        Process_TG_hash $LINE;
        $WRITE_FLAG = 1;  
    
    } # end elsif

    elsif($REPORT_TYPE eq PROC) {
        Process_PROC_hash $LINE;
        $WRITE_FLAG = 1;
    
    } # end elsif

    elsif($REPORT_TYPE eq SAD) {
        Process_SAD_hash $LINE;
	$WRITE_FLAG = 1; 

    } # end elsif

    elsif($REPORT_TYPE eq MOD1) {
        Process_MOD1_hash $LINE;
	$WRITE_FLAG = 1;  
	
    } #end elsif
    
    elsif($REPORT_TYPE eq MLHG) {
        Process_MLHG_hash $LINE;
        $WRITE_FLAG = 1; 
        
     } #end elsif
     
     elsif($REPORT_TYPE eq CTS) {
         Process_CTS_hash $LINE;
         $WRITE_FLAG = 1;  
         
     } #end elsif
        
     elsif ($REPORT_TYPE eq CMP) {
         Process_CMP_hash $LINE;
         $WRITE_FLAG = 1;  
         
     } #end elsif
        
     elsif ($REPORT_TYPE eq ISM) {
         Process_ISM_hash $LINE;
         $WRITE_FLAG = 1;  
         
     } #end elsif
     
     elsif($REPORT_TYPE eq TD) {
         Process_TD_hash $LINE;
         $WRITE_FLAG = 1;  
         
     } #end elsif
     
     elsif($REPORT_TYPE eq HLSC) {
         Process_HLSC_hash $LINE;
         $WRITE_FLAG = 1;  
         
     } #end elsif
        
     elsif($REPORT_TYPE eq DLTU) {
         Process_DLTU_hash $LINE;
         $WRITE_FLAG = 1;  
         
     } #end elsif
     
     elsif ($REPORT_TYPE eq CDN) {
         Process_CDN_hash $LINE;
         $WRITE_FLAG = 1; 
         
     } #end elsif
            
     elsif ($REPORT_TYPE eq IRT) {
         Process_IRT_hash $LINE;
         $WRITE_FLAG = 1;  
         
     } #end elsif
     
     elsif($REPORT_TYPE eq IPIDB) {
         Process_IPIDB_hash $LINE;
         $WRITE_FLAG = 1;  
     
     } #end elsif

     elsif ($REPORT_TYPE eq MH) {
         Process_MH_hash $LINE;
         $WRITE_FLAG = 1;  
     
     } # end elsif

     elsif ($REPORT_TYPE eq AIU) {
         Process_AIU_hash $LINE;
         $WRITE_FLAG = 1;  
         
     } #end elsif
        
     elsif($REPORT_TYPE eq IDPIDB) {
         Process_IDPIDB_hash $LINE;
         $WRITE_FLAG = 1;  
         
     } #end elsif
        
     elsif ($REPORT_TYPE eq ISLU) { 
         Process_ISLU_hash $LINE;
         $WRITE_FLAG = 1;  
         
     } #end elsif
     
     elsif ($REPORT_TYPE eq CT) {
         Process_CT_hash $LINE;
         $WRITE_FLAG = 1;  
         
     } #end elsif
        
     elsif ($REPORT_TYPE  eq RDT_DNU_S) {
         Process_RDT_DNU_S_hash $LINE;
         $WRITE_FLAG = 1;
         
     } # end of elsif
        
     return;      
}#end of process line.
         
#*********************************************************
#**  Function Name: send_To_Database()
#    Date Written: April 2004
#    Written by: Kristi Olson				**
#**  
#    Description: Sends the required parameters for the
#    database to build SQL statements. Creates a referenc
#    for each hash and gets the time the report was processed
#    at. Sends the parameters necessary to build the insert
#    statements.
#
#    Parameters: None.			**
#*********************************************************
sub send_To_Database {
    if ($CTS_ROW_COUNT != 0) {
        my $CTS_HASH_REF = \%CTS_HASH;
        my $CTS_PROCESSED_TIME = set_Processed_Time;
        build_SQL_Statements("125", $SWITCH_NAME, "$DATE $REPORT_TIME", $CTS_HASH_REF);
        build_Processed_Reports("125", $CTS_ROW_COUNT, $CTS_PROCESSED_TIME);
        
    } # end if
    %CTS_HASH = ();
    $CTS_ROW_COUNT = 0;
        
    if ($CMP_ROW_COUNT != 0) {
       	my $CMP_HASH_REF = \%CMP_HASH;
       	my $CMP_PROCESSED_TIME = set_Processed_Time;
       	build_SQL_Statements("126", $SWITCH_NAME, "$DATE $REPORT_TIME", $CMP_HASH_REF);
        build_Processed_Reports("126", $CMP_ROW_COUNT,$CMP_PROCESSED_TIME );
            
    } #end if
    %CMP_HASH = ();
    $CMP_ROW_COUNT = 0;
       	
    if ($CDN_ROW_COUNT != 0) {
       	my $CDN_HASH_REF = \%CDN_HASH;
       	my $CDN_PROCESSED_TIME = set_Processed_Time;
       	build_SQL_Statements("128", $SWITCH_NAME, "$DATE $REPORT_TIME", $CDN_HASH_REF);
            build_Processed_Reports("128", $CDN_ROW_COUNT, $CDN_PROCESSED_TIME);
    } # end if
    %CDN_HASH = (); 
    $CDN_ROW_COUNT = 0; 
                
    if ($DLTU_ROW_COUNT != 0) {
        my $DLTU_HASH_REF = \%DLTU_HASH;
        my $DLTU_PROCESSED_TIME = set_Processed_Time;
        build_SQL_Statements ("16", $SWITCH_NAME, "$DATE $REPORT_TIME", $DLTU_HASH_REF);
        build_Processed_Reports("16", $DLTU_ROW_COUNT, $DLTU_PROCESSED_TIME); 
    } # end if
    %DLTU_HASH = ();
    $DLTU_ROW_COUNT = 0;
       
    if ($MLHG_ROW_COUNT != 0) {
        my $MLHG_HASH_REF = \%MLHG_HASH;
        my $MLHG_PROCESSED_TIME = set_Processed_Time;
        build_SQL_Statements ("34", $SWITCH_NAME, "$DATE $REPORT_TIME", $MLHG_HASH_REF);
        build_Processed_Reports("34", $MLHG_ROW_COUNT, $MLHG_PROCESSED_TIME);
    } # end if
    %MLHG_HASH = ();
    $MLHG_ROW_COUNT = 0;
        
    if ($IDPIDB_ROW_COUNT != 0) {
        my $IDPIDB_HASH_REF = \%IDPIDB_HASH;
        my $IDPIDB_PROCESSED_TIME = set_Processed_Time;
        build_SQL_Statements ("140", $SWITCH_NAME, "$DATE $REPORT_TIME", $IDPIDB_HASH_REF);
        build_Processed_Reports("140", $IDPIDB_ROW_COUNT, $IDPIDB_PROCESSED_TIME);
        } #end if
    %IDPIDB_HASH = ();
    $IDPIDB_ROW_COUNT = 0;
               
    if ($IPIDB_ROW_COUNT != 0) {
        my $IPIDB_HASH_REF = \%IPIDB_HASH;
        my $IPIDB_PROCESSED_TIME = set_Processed_Time;
        build_SQL_Statements ("139", $SWITCH_NAME, "$DATE $REPORT_TIME", $IPIDB_HASH_REF); 
       	build_Processed_Reports("139", $IPIDB_ROW_COUNT, $IPIDB_PROCESSED_TIME);
    } # end if
    %IPIDB_HASH = ();
    $IPIDB_ROW_COUNT = 0;
        
    if ($IRT_ROW_COUNT != 0) {
        my $IRT_HASH_REF = \%IRT_HASH; 
        my $IRT_PROCESSED_TIME = set_Processed_Time;
        build_SQL_Statements ("143", $SWITCH_NAME, "$DATE $REPORT_TIME", $IRT_HASH_REF);
        build_Processed_Reports("143", $IRT_ROW_COUNT, $IRT_PROCESSED_TIME);
        } # end if
    %IRT_HASH = ();
    $IRT_ROW_COUNT = 0;
        
    if ($PROC_ROW_COUNT != 0) {
        my $PROC_HASH_REF = \%PROC_HASH;
        my $PROC_PROCESSED_TIME = set_Processed_Time;
        build_SQL_Statements ("15", $SWITCH_NAME, "$DATE $REPORT_TIME", $PROC_HASH_REF);
        build_Processed_Reports("15", $PROC_ROW_COUNT, $PROC_PROCESSED_TIME);
    } # end if
    %PROC_HASH = ();
    $PROC_ROW_COUNT = 0;
        
    if ($MOD1_ROW_COUNT != 0) {
        my $MOD1_HASH_REF = \%MOD1_HASH;
        my $MOD1_PROCESSED_TIME = set_Processed_Time;
        build_SQL_Statements ("122", $SWITCH_NAME, "$DATE $REPORT_TIME", $MOD1_HASH_REF);
        build_Processed_Reports("122", $MOD1_ROW_COUNT, $MOD1_PROCESSED_TIME);
    } # end if
    %MOD1_HASH = ();
    $MOD1_ROW_COUNT = 0;
        
    if ($TG_ROW_COUNT != 0) {
        #write_To_Debug "TG", \%TRUNK_GROUP_HASH;
        my $TRUNK_GROUP_HASH_REF = \%TRUNK_GROUP_HASH;
        my $TG_PROCESSED_TIME = set_Processed_Time;
        build_SQL_Statements("12", $SWITCH_NAME, "$DATE $REPORT_TIME", $TRUNK_GROUP_HASH_REF);
        build_Processed_Reports("12", $TG_ROW_COUNT, $TG_PROCESSED_TIME);
    } # end if
    %TRUNK_GROUP_HASH = ();
    $TG_ROW_COUNT = 0;
        
    if ($AIU_ROW_COUNT != 0) {
        my $AIU_HASH_REF = \%AIU_HASH;
        my $AIU_PROCESSED_TIME = set_Processed_Time;
        build_SQL_Statements ("216", $SWITCH_NAME, "$DATE $REPORT_TIME", $AIU_HASH_REF, $AIU_ROW_COUNT);                   	
        build_Processed_Reports("216", $AIU_ROW_COUNT, $AIU_PROCESSED_TIME);
    } # end if
    %AIU_HASH = ();
    $AIU_ROW_COUNT = 0;
                
    if ($ISLU_ROW_COUNT != 0) {
        my $ISLU_HASH_REF = \%ISLU_HASH;
        my $ISLU_PROCESSED_TIME = set_Processed_Time;
        build_SQL_Statements ("49", $SWITCH_NAME, "$DATE $REPORT_TIME", $ISLU_HASH_REF);
        build_Processed_Reports("49", $ISLU_ROW_COUNT, $ISLU_PROCESSED_TIME);
    } # end if
    %ISLU_HASH= ();
    $ISLU_ROW_COUNT = 0;
        
    if ($SAD_ROW_COUNT != 0) {
        my $SAD_HASH_REF = \%SAD_HASH;
        my $SAD_PROCESSED_TIME = set_Processed_Time;
        build_SQL_Statements ("4", $SWITCH_NAME, "$DATE $REPORT_TIME", $SAD_HASH_REF);
        build_Processed_Reports("4", $SAD_ROW_COUNT, $SAD_PROCESSED_TIME);
    } # end if
    %SAD_HASH = ();
    $SAD_ROW_COUNT = 0;
        
    if ($RDT_DNU_S_ROW_COUNT != 0) {
        my $RDT_DNU_S_HASH_REF = \%RDT_DNU_S_HASH;
        my $RDT_DNU_S_PROCESSED_TIME = set_Processed_Time;
       	build_SQL_Statements ("225", $SWITCH_NAME, "$DATE $REPORT_TIME", $RDT_DNU_S_HASH_REF); 
        build_Processed_Reports("225", $RDT_DNU_S_ROW_COUNT, $RDT_DNU_S_PROCESSED_TIME);
    } # end if
    %RDT_DNU_S_HASH = ();
    $RDT_DNU_S_ROW_COUNT = 0;
       
    if ($HLSC_ROW_COUNT != 0) {
        my $HLSC_HASH_REF = \%HLSC_HASH;
        my $HLSC_PROCESSED_TIME = set_Processed_Time;
        build_SQL_Statements ("8", $SWITCH_NAME, "$DATE $REPORT_TIME", $HLSC_HASH_REF); 
        build_Processed_Reports("8", $HLSC_ROW_COUNT, $HLSC_PROCESSED_TIME);
    } # end if
    %HLSC_HASH = ();
    $HLSC_ROW_COUNT = 0;
        
    if ($TD_ROW_COUNT != 0) {
        my $TD_HASH_REF = \%TD_HASH;
        my $TD_PROCESSED_TIME = set_Processed_Time;
       	build_SQL_Statements ("7", $SWITCH_NAME, "$DATE $REPORT_TIME", $TD_HASH_REF); 
        build_Processed_Reports("7", $TD_ROW_COUNT, $TD_PROCESSED_TIME);
    } # end if   
    $TD_ROW_COUNT = 0;
    %TD_HASH = ();
        
    if ($MH_ROW_COUNT != 0) {
        my $MH_HASH_REF = \%MH_HASH;
        my $MH_PROCESSED_TIME = set_Processed_Time;
        build_SQL_Statements ("185", $SWITCH_NAME, "$DATE $REPORT_TIME", $MH_HASH_REF);
        build_Processed_Reports("185", $MH_ROW_COUNT, $MH_PROCESSED_TIME);
    } # end if   
    %MH_HASH = ();
    $MH_ROW_COUNT = 0;
        
    if ($ISM_ROW_COUNT != 0) {
        my $ISM_HASH_REF = \%ISM_HASH;
        my $ISM_PROCESSED_TIME = set_Processed_Time;
        build_SQL_Statements ("53", $SWITCH_NAME, "$DATE $REPORT_TIME", $ISM_HASH_REF);
        build_Processed_Reports("53", $ISM_ROW_COUNT, $ISM_PROCESSED_TIME);
    }
    %ISM_HASH = ();
    $ISM_ROW_COUNT = 0;
        
    if ($CT_ROW_COUNT != 0) {
        my $CT_HASH_REF = \%CT_HASH;
        my $CT_PROCESSED_TIME = set_Processed_Time;
        build_SQL_Statements ("5", $SWITCH_NAME, "$DATE $REPORT_TIME", $CT_HASH_REF);
        build_Processed_Reports("5", $CT_ROW_COUNT, $CT_PROCESSED_TIME);
    }#end if

    #We are now done with all these variables. Clean them up.  
    %CT_HASH = ();
    $CT_ROW_COUNT = 0;
    $TG_ROW_COUNT = 0;
    $RDT_DNU_S_ROW_COUNT = 0;
    $CMP_ROW_COUNT = 0;
    $ISLU_ROW_COUNT = 0;
    $IPIDB_ROW_COUNT = 0;
    $AIU_ROW_COUNT = 0;
    $IDPIDB_ROW_COUNT = 0;
    $PROC_ROW_COUNT = 0;
    $CTS_ROW_COUNT = 0;
    $CDN_ROW_COUNT = 0;
    $TD_ROW_COUNT = 0;
    $HLSC_ROW_COUNT = 0;
    $MLHG_ROW_COUNT = 0;
    $DLTU_ROW_COUNT = 0;
    $SAD_ROW_COUNT = 0;
    $MOD1_ROW_COUNT = 0;
    $CT_ROW_COUNT = 0;
	
    $REPORT_TIME = "";
    $MINUTE = "";
    $HOUR = "";
    
    #*********************************************************
    #  Now that the SQL statements have been written, 
    #  connect to the database, then prepare and execute
    #  each SQL statement.
    #*********************************************************

    connect_To_Database;
	
    #*********************************************************
    #  Reset "WRITE_FLAG" so that script will not try to 
    #  connect to the database in between data feeds. 
    #  Used in the "while($shutdown = False) loop.
    #*********************************************************
    $WRITE_FLAG = 0;
    return;
} #end of send_to_Database sub.
	
##**************************************************
##*******************  MAIN  ***********************
##**************************************************
#    Date Written: April 2004
#    Written by: Kristi Olson				**
#**  
#    Description: Listens on a socket connection for data.
#    Reads in a character at a time and builds the "$LINE"
#    parameter. When a carriage return is read, the "process_Line"
#    function is called.
#
#    Parameters: None.			**
#*********************************************************

# Process Args
#
$numArgs = $#ARGV + 1;

if ( $numArgs < 3 ) {
    print "Incorrect Usage - Fatal Error\n";
    print "Usage: Traffic_30_Reports TCPHost TCPPort Switch\n";
    exit 0;
    
} #end if

foreach $argnum (0 .. $#ARGV) {

	if ( $argnum == 0 ) {
		# Get Host
		$targetHost = $ARGV[0];
	} #end if
	
	if ( $argnum == 1 ) {
		# Get Port
		$targetPort = $ARGV[1];
	} #end if
	
	if ($argnum == 2) {
		#Get Switch
		$SWITCH_NAME = $ARGV[2];
	} #end if
	
		if ($argnum == 3) {
		#Get Switch
		$MULTICAST_CONFIG = $ARGV[3];
	} #end if
} #end foreach

$B_CAST_IVAL = A_R_T::get_config $MULTICAST_CONFIG;
A_R_T::create_multicast_objects;
if ($MULTICAST_STATE eq MASTER) {
		connect_to_socket;
		}

	
    while ($shutDown == $FALSE) {
    		
    	if(time > ($B_CAST_IVAL+$current_time)) {
    		$current_time = time; #reset timer
			$MULTICAST_STATE = A_R_T::evaluate_priority;

    		if (($MULTICAST_STATE eq PASSIVE) && ($socket_already_connected == 1)) {
        		$socket_already_connected = 0;
        		if ($SOCKET_HANDLE) {
        			$SOCKET_HANDLE -> close;
        			print "!-!-!-!-PASSIVE APP IS CLOSING SOCKET!-!-!-!-\n";
        			
        		}
        	}
    	if ($socket_already_connected == 0) {
    		if ($MULTICAST_STATE eq MASTER) {
    			sleep(5);
    			connect_to_socket;
    		}

 		}
 	}
    	

        ## "INFINITE" LOOP TASK #1:    
	## LOOK FOR ELEMENT RESPONSE BYTES EVERY SECOND
	##

	my @readySockets = $WATCHED_SOCKETS -> can_read(1);
	my $socketCount = scalar @readySockets;
	$ELEMENTS{0}{'CURRENT TIME'} = time; #capture the current time.	
	#print "sockets ready to be read: $socketCount\n";
	#*********************************************************
	# after a minute has passed since the last data byte was
	# received, the data stream has finished. Once the data
	# stream has finished we can connect to the database
	# and execute the SQL statements.
	#*********************************************************
	
	#*********************************************************
	# if the WRITE_FLAG has been set to 1 in process_Line,
	# and the current time has exceeded the finish time,
	# we are ready to connect to the database and execute
	# the SQL statments.
	#*********************************************************
	
	if (($WRITE_FLAG == 1) && ($ELEMENTS{0}{'CURRENT TIME'} > $FINISH_TIME) && ($REPORT_TYPE ne DR)) {

	    print "Sending report data to database for the current file, $DATE $REPORT_TIME\n";
#	    send_To_Database;
#	    ftpArchiveFile;
	} #end if
	
	if ($socketCount > 0) {
	  ## PROCESS ACTIVE SOCKETS
	  my $activeSocket;
    foreach $activeSocket (@readySockets) {
        ## PROCESS ELEMENT BYTES
		    if ( $ELEMENTS{0}{'SOCKET CONNECTED'} == $TRUE ) {	
						if ( $activeSocket == $ELEMENTS{0}{'SOCKET'} ) {
			    			## GET A CHARACTER 
			    			$activeSocket -> recv($DATA, 1, 0);
			        			if (length($DATA) == 0) {

				
										} #end if (length($DATA) == 0) 										
				
										else {
					
										# DATA RECEIVED, PUT IT IN THE RCV BUFFER FOR THIS CLIENT
										#
										$ELEMENTS{0}{"LAST DATA RECEIVED"} = time;
										$LAST_TIME = $ELEMENTS{0}{'LAST DATA RECEIVED'};
			    					if ( $ELEMENTS{0}{"STATUS"} eq "RECEIVING" ) {
												$LINE .= $DATA;
												#10/02/04: changed m/\015/ to read m/\012/. The archive files were
												#receiving a line feed in the middle of each line.
														
																									
														if ($LINE =~ m/\012/) { #look for end of line.
				    								$LINE =~ s/\021//g; #get rid of extra hex characters.
				    								
				    								Write2Archive $LINE;				    								
				    								
				    								#** Strip out the \r\n before we process the line
				    								$LINE =~ s/\015//g; #get rid of extra hex characters.
				    								$LINE =~ s/\012//g; #get rid of extra hex characters.
				    								#** Don't send a blank line to process line
				    										if ($LINE ne ""){
																		process_Line $LINE;
																		
																	print "line: $LINE\n";
																		
					
				    										} #end if ($LINE ne "")
							
														$LINE = "";
														$LAST_TIME = time;
														$FINISH_TIME = $ELEMENTS{0}{'LAST DATA RECEIVED'} + 300;
				
			        							} # if ($LINE =~ m/\015/)
			        							
			        						#}#end if mcast state master
												
			    					} #end of if (ELEMNTS) eq RECEIVING
						
										}#end of else					
			
			}#end of if ( $activeSocket == $ELEMENTS{0}{'SOCKET'} )
		    }#end of if ( $ELEMENTS{0}{'SOCKET CONNECTED'} == $TRUE )
													
			
           } # for each socket ready to be read

        } # if any sockets are ready to be read
	
	# See if element needs to be connected.
	if ( $GLOBAL_SHUTDOWN == $TRUE ) {
		$shutDown = $TRUE;
	}# end if
	
	
} # WHILE SHUTDOWN is still false

##
##  Close the connection to the tcp server.
##
print "(7) Close socket to Host:$targetHost Port:$targetPort\n";
$ELEMENTS{0}{'SOCKET'} -> close();
exit(0);