#!/usr/bin/perl -w

#
# Administration Package::user.plx
# User addition script 
# this script will take one action and one argument
# this script makes use of specific system commands
# 	useradd for adding users to the system
#	deluser for removing users from the system
#

# General Declarations
use strict;
use Getopt::Long;
use IO::File;


# SCRIPT GLOBAL DEFS
my $_BASE='/';
#my $_BASE='/proj/csci/cs470/enkidu/root';
my $_log = '/etc/cadmin/log/cadminlog';
#my $_log = "$_BASE/etc/cadmin/log/cadminlog";

#
# Adds user to system
# Function ADDUSER three arguments:
#	1. user name
#	2. domain for user extention striped
#	3. should we only pretend
#
sub ADDUSER {

	# lets set up some data to use
	my $_user = $_[0];
	my $_domain = $_[1];
	my $_iterate = $_[2];
	my $_login = "$_domain-$_user";
	my $_group = "1000";        		# used with -g
	my $_shell = "/bin/false";    		# used with -s
	my $_home = "/home/users/$_login";	# used with -m -d
	my $_pass = "$_user";

	# eventually i'd like to use pwgen to get a password !!
	#system ("pwgen -s > p1 && cat p1 && rm p1");
	#system ("mail admin -N -s \"$_user pass\" ");


	if($_iterate) {
		print ("/** SYSTEM INFO FROM USER.PLX **/ \n");
		print ("/**   ITERATE ONLY    **/\n");
		print ("useradd -g $_group -s $_shell -p $_pass -m -d $_home $_login\n");
		print "Added: $_login to system\n";
	} else {
		# open our log for append
		my $_LOGF = new IO::File ">> $_log";
		my $_t = localtime();
		print $_LOGF "\n\n$_t\n";

		#print ("useradd -g $_group -s $_shell -p $_pass -m -d $_home $_login\n");
		system ("useradd -g $_group -s $_shell -p $_pass -m -d $_home $_login") == 0
			or die "Couldn\'t adduser, FAILED!";

		# write what we just did to log
		print $_LOGF "/** SYSTEM INFO FROM USER.PLX **/ \n";
		print $_LOGF "Added: $_login to system\n";

		# write what we just did to stdout
		print "/** SYSTEM INFO FROM USER.PLX **/ \n";
		print "Added: $_login to system\n";

		$_LOGF->close;
	}

	
}


#
# Delets user from system after backing up
# home directory.
# Function DELETEUSER three arguments:
#	1. user name
#	2. domain for user extention striped
#	3. should we only pretend
#
sub DELETEUSER {

	# lets set up our data
	my $_login = "$_[1]-$_[0]";
	my $_iterate = $_[2];
	my $_backupdir = "/home/users/deleted";

	#chdir "$_backupdir";
	#system ("deluser --backup --remove-all-files $_login") == 0
	#	or die "Couldn\'t deluser: $_login\n";

	if($_iterate) {
		print ("/** SYSTEM INFO FROM USER.PLX **/ \n");
		print ("/**   ITERATE ONLY    **/\n");
		print ("cd $_backupdir\n");
		print ("deluser --backup --remove-all-files $_login\n");
		print ("Deleted: $_login from system\n");
	} else {
		# open our log for append
		my $_LOGF = new IO::File ">> $_log";
		my $_t = localtime();
		print $_LOGF "\n\n$_t\n";

		#print ("cd $_backupdir\n");
		#print ("deluser --backup --remove-all-files $_login\n");
		chdir "$_backupdir";
		system("deluser --backup --remove-all-files $_login");

		# write what we just did to log
		print $_LOGF "/** SYSTEM INFO FROM USER.PLX **/ \n";
		print $_LOGF "Deleted: $_login from system\n";

		# write what we just did to stdout
		print ("/** SYSTEM INFO FROM USER.PLX **/ \n");
		print ("Deleted: $_login from system\n");

		$_LOGF->close;
	}
	
}

my $_add = '';              # ALL VARS SET TO FLASE #
my $_delete = ''; 
my $_iterate = '';
my $_usr = '';
my $_domain = '';
my $_ext = '';
my $data = $ARGV[0];

## BEGIN MAIN ##
#
# lets check our incoming command
# --add		/* changes $_add to true */
#			/* this adds $ARGV[0] user */
# --delete	/* changes $_delete to true */
#			/* this deletes $ARGV[0] user */
# --iterate     /* should we just pretend to do our work */
#                       /* causes to print only. */
#                       /* no action taken on system */
#
GetOptions('add'	=>	\$_add,      # ok we are adding
           'delete'	=>	\$_delete,   # ok we are deleting
	   'iterate'	=>	\$_iterate   # lets only print
	   );

#($_site, $_suffix) = split /\.\s*/, $ARGV[0];

# ok lets parce ARGV[0]
($_usr,$_domain) = split /\@\s*/, $ARGV[0];
($_domain,$_ext) = split /\.\s*/, $_domain;

if($_add) {
	ADDUSER($_usr,$_domain,$_iterate);
	#print "added: $_usr for $_domain\n";
	#exit 0;
}

if($_delete) {
	DELETEUSER($_usr,$_domain,$_iterate);
	#print "deleting: $_usr for $_domain\n";
	#exit 0;
}

exit 0;

