#!/usr/bin/perl -w -U

#
# Administration Package::site.plx
# Site addition script 
# this script will take: one action /* this will be the argument */
# 						

use strict;
use Getopt::Long;
use IO::File;
use Fcntl;

# SCRIPT GLOBAL DEFS
my $_BASE='/';
#my $_BASE='/proj/csci/cs470/enkidu/root';
my $_log = '/etc/cadmin/log/cadminlog';
#my $_log = "$_BASE/etc/cadmin/log/cadminlog";

#
# Creates the www.<domain>-httpd.conf file for the virtual host
# Function MKCONF two arguments:
#	1. site name
#	2. site extention
#
sub MKCONF {
	# set up what i need variable wise
	my $_site = $_[0];
	my $_ext  = $_[1];
	my $_base = "$_BASE/etc/apache/virtuals/www.$_site.$_ext-httpd.conf";
	#my $_base = "/etc/apache/virtuals/www.$_site.$_ext-httpd.conf";
	
	my $_fh = IO::File->new($_base, O_WRONLY|O_CREAT)
		or die "Couldn\'t open $_base for write: $!\n";

	# lets select the file for our output
	my $_file = select($_fh);

	# virtual site-httpd.conf file
	print "#www.$_site.$_ext\n";
	print "<VirtualHost 216.57.204.122>\n";
	print "\tServerAdmin webmaster\@www.$_site.$_ext\n";
	print "\tDocumentRoot /home/httpd/virtuals/$_ext/$_site/www\n";
	print "\tServerName www.$_site.$_ext\n";
	print "\tServerAlias $_site.$_ext\n";
	print "\tCustomLog\tlogs/virtuals/www.$_site.$_ext-access.log combined\n";
	print "\tErrorLog\tlogs/virtuals/www.$_site.$_ext-err.log\n";
	print "\tCustomLog";
	print "\tlogs/virtuals/www.$_site.$_ext-referer.log \"%{referer}i\" \n";
	print "</VirtualHost>\n";

	# ok lets unselect the file now
	select($_file);

	# we are done now close file
	close($_fh)
		or die "Couldn\'t close file: $!";
}

#
# lets set up variables
#
my $_basedir="$_BASE/domains";    # base directory for virtuals
my $_add = '';                    # default value FALSE 
my $_delete = '';                 # default value FALSE
my $_suffix  = '';                # top level domain suffix FALSE
my $_site    = '';                # new site FALSE
my $_iterate = '';

#
# lets parse our string [simple]
#
#print "$ARGV[0]\n";
#($_site, $_suffix) = split /\.\s*/, $ARGV[0];
#print "$_site\n$_suffix\n";

## BEGIN MAIN ##
#
# lets check our incoming commands.
# --add=s    /* must be combined with a string */
#            /* this adds the site s to the system */
# --delete=s /* must be combined with a string */
#            /* this removes the site s from the system */
# --iterate  /* if we have this set only print actions */
#
GetOptions('add=s'	=>	\$_add,     # ok we are adding
           'delete=s' 	=>	\$_delete,  # ok we are deleting
	   'iterate'	=>	\$_iterate  # used to print only
	);

#
# we are adding a site
#
if ($_add) {

	# split out the information we need
	($_site, $_suffix) = split /\.\s*/, $_add;

	if($_iterate) {
		print "/** SYSTEM INFO FROM SITE.PLX **/ \n";
		print "/**   ITERATE ONLY    **/\n";
		print "chdir $_basedir/$_suffix \n";
		print "mkdir $_site \n";
		print "print 'creating directory \n $_basedir/$_suffix';\n";
		print "MKCONF($_site,$_suffix);\n";
	} else {
		# open our log for append
		my $_LOGF = new IO::File ">> $_log";
		my $_t = localtime();
		print $_LOGF "\n\n$_t\n";

		# move to the correct location in file system
		chdir "$_basedir/$_suffix" or die "Can't cd to $_basedir/$_suffix\n";
		mkdir $_site;
		# create the .conf file
		MKCONF($_site,$_suffix);

		# write what we just did to log
		print $_LOGF "/** SYSTEM INFO FROM SITE.PLX **/ \n";
		print $_LOGF "creating directory $_basedir/$_suffix/$_site \n";
		print $_LOGF "wrote conf file\n";

		# write what we just did to stdout 
		print "/** SYSTEM INFO FROM SITE.PLX **/ \n";
		print "creating directory $_basedir/$_suffix/$_site \n";
		print "wrote conf file\n";

		$_LOGF->close;
	}

	#print "leaving add\n";
}


if ($_delete) {

	# split out the information we need
	($_site, $_suffix) = split /\.\s*/, $_delete;

	if($_iterate) {
		print "/** SYSTEM INFO FROM SITE.PLX **/ \n";
		print "/**   ITERATE ONLY    **/\n";
		print "chdir '$_basedir/$_suffix';\n";
		print "rmdir $_site;\n";
		print "print 'deleting directory \n $_basedir/$_suffix/$_site';\n";
		print "chdir '$_BASE/etc/apache/virtuals';\n";
		print "system ('rm www.$_site.$_suffix-httpd.conf');\n";
		print "print 'removing www.$_site.$_suffix-httpd.conf file';\n";
	} else {
		# open our log for append
		my $_LOGF = new IO::File ">> $_log";
		my $_t = localtime();
		print $_LOGF "\n\n$_t\n";

		# move to the correct location in file system
		chdir "$_basedir/$_suffix" or die "Can't cd to $_basedir/$_suffix\n";
		rmdir $_site;
		#system ("mv $_site inop-$_site");  # instead of delete we will mark it
		chdir "$_BASE/etc/apache/virtuals";
		system ("rm www.$_site.$_suffix-httpd.conf");

		# write what we just did to log
		print $_LOGF "/** SYSTEM INFO FROM SITE.PLX **/ \n";
		print $_LOGF "moving to $_basedir/$_suffix\n";
		print $_LOGF "deleting directory $_basedir/$_suffix/$_site \n";
		print $_LOGF "moving to $_BASE/etc/apache/virtuals\n";
		print $_LOGF "removing www.$_site.$_suffix-httpd.conf file\n";

		# write what we just did to stdout 
		print "/** SYSTEM INFO FROM SITE.PLX **/ \n";
		print "moving to $_basedir/$_suffix\n";
		print "deleting directory: $_basedir/$_suffix/$_site \n";
		print "moving to $_BASE/etc/apache/virtuals\n";
		print "removing www.$_site.$_suffix-httpd.conf file\n";

		$_LOGF->close;
	}
}
	
## END MAIN
exit 0;

