#!/usr/bin/perl -w -U 

# main admin script for package
# this script drives other scripts
# this script will take: one command
# 						 one action 
# 						 one arguement

use strict;
use Getopt::Long;

sub USAGE {
	print "
Usage: admin.plx [option] [action] data ... 
Options:
	-u, --user	 	Creates a new user
	-s, --site 		Creates a new web site
	-r, --reload		Reload Daemons ( APACHE or BIND or SENDMAIL )
	-t, --test		Run in test mode (prints to stdout only)
	-h, --help 		Prints this info.
	
Actions:
	-a, --add		Add argument (site or user)
	-d, --delete	Delete perminatly (site or user)
Example:
	To add the web-site www.somesite.net to the server.
	  >> admin.plx --site --add somesite.net
	To add a user somesite-bill to the server.
	  >> admin.plx --user --add bill\@somesite.net
	To restart apache on the server.
	  >> admin.plx --reload apache
	\n"
}

my $_arg = '';   	# all variables set to FALSE
my $_user = '';
my $_site = '';
my $_reload = '';
my $_add = '';
my $_delete = '';
my $_help = '';
my $_test = '';
my $_location = "/etc/cadmin/exec";

$_arg = GetOptions("user"	=> \$_user,	#choose what option to use
		"site"		=> \$_site,	# 
		"reload"	=> \$_reload,
		"add" 		=> \$_add,	#choose what action to take
		"delete"	=> \$_delete,	#
		"test"		=> \$_test,
		"help"		=> \$_help);

unless ($_arg) {
	USAGE;
	die "$!: Unknown option!";
}

if ($_help) {
	USAGE;
	exit 0;
}

if ($_user && $_add) {

	if($_test) {
		system ("./user.plx --add --iterate $ARGV[0]");
	} else {	
		system ("./user.plx --add $ARGV[0]");
	}
	exit 0;
}

if ($_user && $_delete) {

	if($_test) {
		system ("$_location/user.plx --delete --iterate $ARGV[0]");
	} else {
		system ("$_location/user.plx --delete $ARGV[0]");
	}
	exit 0;
}

if ($_site && $_add) {

	if($_test) {
		system ("$_location/site.plx --iterate --add $ARGV[0]");
	} else {
		system ("$_location/site.plx --add $ARGV[0]");
	}
	exit 0;
}

if ($_site && $_delete) {

	if($_test) {
		system ("$_location/site.plx --iterate --delete $ARGV[0]");
	} else {
		system ("$_location/site.plx --delete $ARGV[0]");
	}
	exit 0;
}

if ($_reload) {
	#print "reload.plx $ARGV[0]\n";
	#print "reload all: httpd bind sendmail\n\n";
	if($_test) {
		system ("$_location/reload.plx --iterate $ARGV[0]");
	} else {
		system ("$_location/reload.plx $ARGV[0]");
	}
	exit 0;
}

