
/* 
   CxmlFactory method.
   Individual methods should be explained below
 */

// includes section
#include <iostream>
#include <stdlib.h>
#include <string>
#include "include/CxmlFactory.h"


// the do nothing constructor
CxmlFactory::CxmlFactory( )
{
	streamdef = "http://etherx.jabber.org/streams";
	from = "adminbot";
	to = "";
	data = "";
	element = "";
	action = "";
	nsp = "";
	X.erase();
	return;
}

// This Function resets the data in the string variables.
void CxmlFactory::Reset( )
{
	X.erase();
	to.erase();
	element.erase();
	action.erase();
	nsp.erase();
	streamdef = "http://etherx.jabber.org/streams";
	from = "adminbot";
	return;
}

// **** SPECIALIZED METHODS **** //
// This Function creates a specialized start-up message
void CxmlFactory::setInitDoc( string &_in )
{
	string _init = 
"<?xml version='1.0'?><stream:stream xmlns='jabber:component:accept' xmlns:stream='http://etherx.jabber.org/streams' to='localhost'>";

	X = _init;
	_in = X;
	X.erase();
	return;
}

// This Function is specialized to make a end document 
// message. 
void CxmlFactory::setEndDoc( string &_in )
{
	string _end = "</stream:stream>";
	X = _end;
	_in.erase();
	_in = X;
	X.erase();
	return;
}

// This Function to specialized to set up a handshake message. 
void CxmlFactory::setHandshake( string &_in, string &_m )
{
	string _hs = "<handshake id='1'>" + _in + "</handshake>";
	X = _hs;
	_m.erase();
	_m = X;
	X.erase();
	return;
}
// **** END SPECIALIZED METHODS **** //


// This Function to set the Element type of the XML
// Two parameters are given element and action.
// OPTIONS ARE:  iq / presence
// ARGUMENTS: 2 string
void CxmlFactory::setType( string &_el, string &_ac )
{
	element = _el;
	action = _ac;
	return;
}


// This Function to set the Element type of the XML 
// One parameter is given element.
// OPTIONS ARE: message
// ARGUMENTS: 1 string
void CxmlFactory::setType( string &_el )
{
	element = _el;
	return;
}


// This Function to set the NameSpace of the XML
// OPTIONS ARE:
// ARGUMENTS: 1 string
void CxmlFactory::setNS( string &_in )
{
	nsp = _in;
	return;
}

// This Function to set the Data portion of the XML
// OPTIONS: NONE
// ARGUEMNTS: 1 string
void CxmlFactory::setPayload( string &_dat )
{
	data = _dat;
	return; 
}

void CxmlFactory::setTo( string &_in )
{
	to = _in;
	return; 
}


// This Function returns the finalized XML message 
// through its passed in argument
void CxmlFactory::getIt( string &_inout )
{
	// ok lets combine everything 
	createMessage();
	_inout = X;
	return;
}

// This Function prints the XML string to stdout
void CxmlFactory::printIt( )
{
	createMessage();  // first we need to create the xml
	cout << "\n" << X << "\n";
	X.erase();
	return;
}


// This Function grabs the set string date and formulates them into a
// xml node
void CxmlFactory::createMessage( )
{
	string root;
	string eroot;
	string sub1;
	string esub1;
	//string sub2;
	//string esub2;
	string done;

	if( element == "iq" ) {
		root = "<" +element+ " type='" +action+ "' to='" +to+ \
			"' from='" +from+ "'>";
		eroot = "</" +element+ ">";

		sub1 = "<body>" +data;
		esub1 = "</body>"; 

		done = root + sub1 + esub1 + eroot; // combine all local strings
		X = done;               // set our xml data
	}

	if( element == "message" ) {
		root = "<" +element+ " to='" +to+ "' from='" +from+ "'>"; 
		eroot = "</" +element+ ">";

		sub1 = "<body>" +data;
		esub1 = "</body>";

		done = root + sub1 + esub1 + eroot;
		X = done;
	}

	return;
}
