using System;
using System.Collections;
using QCGM.Graphs2;
using QCGM.Boards;

namespace QCGM.Graphs2
{
	/// <summary>
	/// Summary description for Graph2.
	/// </summary>
	public class Graph2
	{
		private Hashtable nodeTable;

		public Graph2()
		{
			nodeTable = new Hashtable();
		}

		public ICollection Nodes
		{
			get
			{
				return nodeTable.Values;
			}
		}

		public void AddNode(Node2 node)
		{
			nodeTable.Add(node.Tile, node);
		}

		public void Clear()
		{
			nodeTable.Clear();
		}

		public bool Contains(Node2 u)
		{
			foreach(Node2 v in this.Nodes)
			{
				if(u == v)
				{
					return true;
				}
			}
			return false;
		}

		public Node2 GetNode(object key)
		{
			IDictionaryEnumerator myEnumerator = nodeTable.GetEnumerator();

			while ( myEnumerator.MoveNext() )
			{
				if(myEnumerator.Key == key)
				{
					return (Node2)myEnumerator.Value;
				}
			}
			throw new Exception("Wasn't in table!!");
		}

		public Tile GetTile(Node2 node)
		{
			IDictionaryEnumerator myEnumerator = nodeTable.GetEnumerator();

			while ( myEnumerator.MoveNext() )
			{
				if(myEnumerator.Value == node)
				{
					return (Tile)myEnumerator.Key;
				}
			}
			throw new Exception("Wasn't in table!!");
		}


	}
}
