using System;
using System.Collections;


namespace QCGM.Graphs
{
	/// <summary>
	/// AdjacencyList maintains a list of neighbors for a particular <see cref="Node"/>.  It is derived from CollectionBase
	/// and provides a strongly-typed collection of <see cref="EdgeToNeighbor"/> instances.
	/// </summary>
	public class AdjacencyList : CollectionBase
	{
		/// <summary>
		/// Adds a new <see cref="EdgeToNeighbor"/> instance to the AdjacencyList.
		/// </summary>
		/// <param name="e">The <see cref="EdgeToNeighbor"/> instance to add.</param>
		protected internal virtual void Add(EdgeToNeighbor e)
		{
			base.InnerList.Add(e);
		}

		protected internal virtual void UpdateCost(EdgeToNeighbor e, int cost)
		{
			if (base.InnerList.Contains(e))
			{
				EdgeToNeighbor g = (EdgeToNeighbor)base.InnerList[base.InnerList.IndexOf(e)];
				g.Cost = cost;
			}
		}

		/// <summary>
		/// Attempts to remove the offending edge. If the node is not found, the method returns without complaining.
		/// </summary>
		/// <param name="e">The edge to be removed.</param>
		public virtual void Remove(EdgeToNeighbor e)
		{
			if(base.InnerList.Contains(e))
			{
				base.InnerList.Remove(e);
			}
		}

		/// <summary>
		/// Returns a particular <see cref="EdgeToNeighbor"/> instance by index.
		/// </summary>
		public virtual EdgeToNeighbor this[int index]
		{
			get { return (EdgeToNeighbor) base.InnerList[index]; }
			set { base.InnerList[index] = value; }
		}
	}
}
