using System;
using System.Collections;
using QCGM.Boards;
using QCGM.Geometry;

namespace QCGM.Boards
{
	/// <summary>
	/// Class for a Player. (Not a Pawn, Client, or User!)
	/// </summary>
	public class Player
	{
		private Pawn MyPawn;	// The Player's Pawn
		private int MyWalls = 10;			// Number of walls the player has

		private Point2Di MyPosition;		// Position of the Player, in board units

		private ArrayList MyWallList = new ArrayList();

		public Player(Color4f color, Point2Di StartingPosition, string Name)
		{
			MyPawn = new Pawn(Name);
			MyPawn.Name = Name;
			MyPawn.Color = color;
			MyPawn.Dimension.X = 0.8f;
			MyPawn.Dimension.Y = 0.8f;
			MyPawn.Dimension.Z = 1.0f;
			MyPawn.MoveTo(new Point3Df(StartingPosition.X * 1.25f, StartingPosition.Y * 1.25f, 0.16f));
			MyPosition = StartingPosition;
		}

		public ArrayList WallList
		{
			get
			{
				return MyWallList;
			}
		}

		public Point2Di Position
		{
			get
			{
				return this.MyPosition;
			}
		}

		public int WallsRemaining
		{
			get
			{
				return MyWalls;
			}
			set
			{
				MyWalls = value;
			}
		}
	
		public Pawn Pawn
		{
			get
			{
				return MyPawn;
			}
			set
			{
				MyPawn = value;
			}
		}
/*
		public void MoveTo(int x, int y)
		{
			this.MyPosition.X = x;
			this.MyPosition.Y = y;
			this.Pawn.MoveTo(new Point3Df((float)MyPosition.X * 1.25f + 0.1f, (float)MyPosition.Y * 1.25f + 0.1f, 0.16f));
		}*/
		/*
		public bool MoveDown()
		{
			this.MyPosition.Y--;
			this.Pawn.MoveTo(new Point3Df((float)MyPosition.X * 1.25f + 0.1f, (float)MyPosition.Y * 1.25f + 0.1f, 0.16f));
			return true;
		}*/
/*
		public bool CanMoveUp()
		{
			if(this.MyPosition.X >= 0 && this.MyPosition.X < 8 && this.MyPosition.Y >=0 && this.MyPosition.Y < 8)
			{
				return true;
			}
			else
			{
				return false;
			}
		}*/
		
		public void MoveTo(int x, int y)
		{
			this.MyPosition.X = x;
			this.MyPosition.Y = y;
			this.Pawn.MoveTo(new Point3Df((float)MyPosition.X * 1.25f + 0.1f, (float)MyPosition.Y * 1.25f + 0.1f, 0.16f));
		}

		/*
		public bool MoveUp()
		{
			this.MyPosition.Y++;
			this.Pawn.MoveTo(new Point3Df((float)MyPosition.X * 1.25f + 0.1f, (float)MyPosition.Y * 1.25f + 0.1f, 0.16f));
			return true;
		}

		public bool MoveLeft()
		{
			this.MyPosition.X--;
			this.Pawn.MoveTo(new Point3Df((float)MyPosition.X * 1.25f + 0.1f, (float)MyPosition.Y * 1.25f + 0.1f, 0.16f));
			return true;
		}

		public bool MoveRight()
		{
			this.MyPosition.X++;
			this.Pawn.MoveTo(new Point3Df((float)MyPosition.X * 1.25f + 0.1f, (float)MyPosition.Y * 1.25f + 0.1f, 0.16f));
			return true;
		}*/
/*
		public bool PlaceWall()
		{
			if (MyWalls > 0)
			{
				this.MyWalls--;
				return true;
			}
			else
			{
				return false;
			}
		}*/
	}
}
