using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Text.RegularExpressions;

namespace QCGM.Forms
{
	/// <summary>
	/// Summary description for JoinGame.
	/// </summary>
	public class JoinGame : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox textBox1;
		private System.Windows.Forms.TextBox textBox2;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.TextBox textBox3;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Button buttonOK;
		private System.Windows.Forms.Button buttonCancel;
		private System.Windows.Forms.ErrorProvider errorProvider1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public JoinGame(Settings defaults)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			this.textBox3.Text = defaults.Player1Name;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.buttonOK = new System.Windows.Forms.Button();
			this.buttonCancel = new System.Windows.Forms.Button();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.textBox2 = new System.Windows.Forms.TextBox();
			this.label4 = new System.Windows.Forms.Label();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.textBox3 = new System.Windows.Forms.TextBox();
			this.label5 = new System.Windows.Forms.Label();
			this.errorProvider1 = new System.Windows.Forms.ErrorProvider();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.SuspendLayout();
			// 
			// buttonOK
			// 
			this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.buttonOK.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.buttonOK.Location = new System.Drawing.Point(256, 208);
			this.buttonOK.Name = "buttonOK";
			this.buttonOK.TabIndex = 7;
			this.buttonOK.Text = "OK";
			this.buttonOK.Click += new System.EventHandler(this.buttonOK_Click);
			// 
			// buttonCancel
			// 
			this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.buttonCancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.buttonCancel.Location = new System.Drawing.Point(8, 208);
			this.buttonCancel.Name = "buttonCancel";
			this.buttonCancel.TabIndex = 8;
			this.buttonCancel.Text = "Cancel";
			this.buttonCancel.Click += new System.EventHandler(this.buttonCancel_Click);
			// 
			// label2
			// 
			this.label2.Font = new System.Drawing.Font("Tahoma", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label2.Location = new System.Drawing.Point(16, 8);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(312, 56);
			this.label2.TabIndex = 10;
			this.label2.Text = "Enter the IP address / server name and port of a machine running a Quoridor Class" +
				"ic Game Manager server.";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(16, 16);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(96, 23);
			this.label3.TabIndex = 11;
			this.label3.Text = "IP Address:";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// textBox1
			// 
			this.textBox1.Location = new System.Drawing.Point(120, 16);
			this.textBox1.Name = "textBox1";
			this.textBox1.Size = new System.Drawing.Size(120, 20);
			this.textBox1.TabIndex = 12;
			this.textBox1.Text = "127.0.0.1";
			this.textBox1.TextChanged += new System.EventHandler(this.textBox1_TextChanged);
			// 
			// textBox2
			// 
			this.textBox2.Location = new System.Drawing.Point(120, 48);
			this.textBox2.Name = "textBox2";
			this.textBox2.Size = new System.Drawing.Size(40, 20);
			this.textBox2.TabIndex = 13;
			this.textBox2.Text = "8167";
			this.textBox2.TextChanged += new System.EventHandler(this.textBox2_TextChanged);
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(16, 48);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(96, 23);
			this.label4.TabIndex = 14;
			this.label4.Text = "Port:";
			this.label4.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.label4);
			this.groupBox1.Controls.Add(this.textBox1);
			this.groupBox1.Controls.Add(this.label3);
			this.groupBox1.Controls.Add(this.textBox2);
			this.groupBox1.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.groupBox1.Location = new System.Drawing.Point(8, 64);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(328, 80);
			this.groupBox1.TabIndex = 15;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Server Settings";
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.Add(this.textBox3);
			this.groupBox2.Controls.Add(this.label5);
			this.groupBox2.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.groupBox2.Location = new System.Drawing.Point(8, 152);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(328, 48);
			this.groupBox2.TabIndex = 16;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Player Profile";
			// 
			// textBox3
			// 
			this.textBox3.Location = new System.Drawing.Point(120, 16);
			this.textBox3.Name = "textBox3";
			this.textBox3.Size = new System.Drawing.Size(120, 20);
			this.textBox3.TabIndex = 0;
			this.textBox3.Text = "Anonymous";
			this.textBox3.TextChanged += new System.EventHandler(this.textBox3_TextChanged);
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(16, 16);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(96, 23);
			this.label5.TabIndex = 15;
			this.label5.Text = "Name:";
			this.label5.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// errorProvider1
			// 
			this.errorProvider1.ContainerControl = this;
			// 
			// JoinGame
			// 
			this.AcceptButton = this.buttonOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.SystemColors.Control;
			this.CancelButton = this.buttonCancel;
			this.ClientSize = new System.Drawing.Size(344, 240);
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.buttonCancel);
			this.Controls.Add(this.buttonOK);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "JoinGame";
			this.ShowInTaskbar = false;
			this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Hide;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Join A Game";
			this.TopMost = true;
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void buttonOK_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void buttonCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		public string PlayerName
		{
			get
			{
				return this.textBox3.Text;
			}
		}

		public string ServerName
		{
			get
			{
				return this.textBox1.Text;
			}
		}

		public int Port
		{
			get
			{
				return System.Convert.ToInt32(textBox2.Text, 10);
			}
		}

		private void textBox1_TextChanged(object sender, System.EventArgs e)
		{
			Control ctrl = (Control)sender;

			string IPAddressMatch = @"[0-9]+(\.[0-9]+){3}";
			string HostAddressMatch = @"(\w([\w\-]*\w)*\.)*[A-Za-z]([\w\-]*\w)*\.?";

			string [] splitaddr = ctrl.Text.Split('.');
			bool bad = false; // address contains too many letters per host name.
			foreach(string s in splitaddr)
			{
				if (s.Length > 22) // hostnames can only have 22 characters between .'s
				{
					bad = true;
				}
			}

			if (ctrl.Text == "")
			{
				this.errorProvider1.SetError(ctrl, "You must enter an IP Address or host name.");
			}
			else if ((Regex.IsMatch(ctrl.Text, IPAddressMatch) == false &&
				Regex.IsMatch(ctrl.Text, HostAddressMatch) == false) ||
				ctrl.Text.StartsWith("-"))
			{
				this.errorProvider1.SetError(ctrl, "Didn't match regex.");
			}
			else if (bad == true)
			{
				this.errorProvider1.SetError(ctrl, "Host names may only have 22 characters between dots.");
			}
			else
			{
				this.errorProvider1.SetError(ctrl, "");
			}

			CheckErrorsForOK();
		}

		private void textBox2_TextChanged(object sender, System.EventArgs e)
		{
			Control ctrl = (Control)sender;

			if (ctrl.Text == "")
			{
				errorProvider1.SetError(ctrl, "Please enter a port value.");
			}
			else
			{
				int val = System.Convert.ToInt32(ctrl.Text, 10);

				if (val < 0)
				{
					errorProvider1.SetError(ctrl, "Port must be a number larger than zero.");
				}
				else if (val > 65535)
				{
					errorProvider1.SetError(ctrl, "Port must be 65535 or smaller.");
				}
				else
				{
					errorProvider1.SetError(ctrl, "");
				}
			}

			CheckErrorsForOK();
		}

		private void textBox3_TextChanged(object sender, System.EventArgs e)
		{
			Control ctrl = (Control)sender;

			if (ctrl.Text == "")
			{
				errorProvider1.SetError(ctrl, "Please enter a name.");
			}
			else if (ctrl.Text.Length > 32)
			{
				errorProvider1.SetError(ctrl, "Names may have no more than 32 characters.");
			}
			else
			{
				errorProvider1.SetError(ctrl, "");
			}

			CheckErrorsForOK();
		}

		private void CheckErrorsForOK()
		{
			if (this.errorProvider1.GetError(this.textBox1) == "" &&
				this.errorProvider1.GetError(this.textBox2) == "" &&
				this.errorProvider1.GetError(this.textBox3) == "")
			{
				this.buttonOK.Enabled = true;
			}
			else
			{
				this.buttonOK.Enabled = false;
			}
		}
	}
}
