/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.server.net;

import com.enderak.procol.common.model.ProColUser;
import com.enderak.procol.common.net.MessageFactory;
import com.enderak.procol.common.net.PacketFactory;
import com.enderak.procol.common.net.ProColIncomingMessage;
import com.enderak.procol.common.net.ProColPacket;
import com.enderak.procol.common.util.ProColUtils;
import com.enderak.procol.server.RunProColServer;
import com.enderak.procol.server.net.ProColServer;
import com.enderak.procol.server.net.ServerConnection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class IncomingMessageHandler
extends Thread {
    protected ProColPacket tempPacket;
    protected boolean authenticated = false;
    private ServerConnection connection;
    private PacketFactory packetFactory;
    private MessageFactory messageFactory;
    private boolean isRunning = false;
    private URI tempURI;
    private StringTokenizer tokenizer;
    private String filePath;
    private URI fileURI;
    private int result;

    public IncomingMessageHandler(ServerConnection serverConnection) {
        this.connection = serverConnection;
        this.packetFactory = serverConnection.getPacketFactory();
        this.messageFactory = serverConnection.getMessageFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            MessageFactory messageFactory = this.messageFactory;
            synchronized (messageFactory) {
                while (!this.messageFactory.hasNext() && this.isRunning) {
                    try {
                        this.messageFactory.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.handleMessage(this.messageFactory.getNext());
            }
        }
    }

    public void close() {
        this.isRunning = false;
    }

    private void handleMessage(ProColIncomingMessage proColIncomingMessage) {
        if (proColIncomingMessage == null) {
            return;
        }
        ProColServer.printInfo("Handling message: " + proColIncomingMessage.toString());
        if (this.authenticated) {
            switch (proColIncomingMessage.requestCode) {
                case 197376: {
                    this.tokenizer = new StringTokenizer(new String(proColIncomingMessage.data), "\n");
                    this.fileURI = URI.create(this.tokenizer.nextToken());
                    this.connection.checkOutFiles(this.fileURI);
                    break;
                }
                case 131076: {
                    this.connection.closeProject();
                    break;
                }
                case 512: {
                    this.authenticated = false;
                    this.connection.close();
                    break;
                }
                case 196865: {
                    this.tokenizer = new StringTokenizer(new String(proColIncomingMessage.data), "\n");
                    this.fileURI = URI.create(this.tokenizer.nextToken());
                    this.connection.sendFiles(this.fileURI, 196865);
                    break;
                }
                case 196864: {
                    this.connection.sendSnapshot();
                    break;
                }
                case 131075: {
                    this.connection.openProject(new String(proColIncomingMessage.data));
                    this.connection.sendFileTree();
                    break;
                }
                case 198146: {
                    this.fileURI = URI.create(new String(proColIncomingMessage.data));
                    this.connection.sendFileHistory(this.fileURI);
                    break;
                }
                case 196608: {
                    this.connection.sendFileTree();
                    break;
                }
                case 131077: {
                    this.packetFactory.addToQueue(131079, RunProColServer.getServer().getProject(new String(proColIncomingMessage.data)).getProjectDescription(), 1);
                    break;
                }
                case 131072: {
                    Vector vector = RunProColServer.getServer().getAllowedProjects(this.connection.getUser());
                    if (vector.isEmpty()) {
                        this.packetFactory.addToQueue(131074, 1);
                        break;
                    }
                    this.packetFactory.addToQueue(131073, ProColUtils.vectorToString(vector), 1);
                    break;
                }
                case 65540: {
                    this.packetFactory.addToQueue(65541, this.connection.getUser().getUserInfo(), 2);
                    break;
                }
                case 65536: {
                    this.packetFactory.addToQueue(65537, ProColUtils.vectorToString(this.connection.getProject().getUserList()), 2);
                    break;
                }
                case 65792: {
                    this.packetFactory.addToQueue(65792, ProColUtils.vectorToString(this.connection.getProject().getAllowedUsers()), 2);
                    break;
                }
                case 1048544: {
                    RunProColServer.stopServer();
                    break;
                }
                case 262145: {
                    this.connection.getPrivateMessageList();
                    break;
                }
                case 262149: {
                    try {
                        String string = new String(proColIncomingMessage.data);
                        this.tokenizer = new StringTokenizer(string, "\n");
                        String string2 = this.tokenizer.nextToken();
                        String string3 = this.tokenizer.nextToken();
                        String string4 = this.tokenizer.nextToken();
                        StringBuffer stringBuffer = new StringBuffer();
                        while (this.tokenizer.hasMoreTokens()) {
                            stringBuffer.append(this.tokenizer.nextToken());
                            if (!this.tokenizer.hasMoreTokens()) continue;
                            stringBuffer.append("\n");
                        }
                        this.packetFactory.addToQueue(this.connection.addPrivateMessage(this.connection.getUser().getName(), string2, string3, string4, stringBuffer.toString()), string2, 1);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        this.packetFactory.addToQueue(-268173071, 2);
                    }
                    break;
                }
                case 262150: {
                    String string = new String(proColIncomingMessage.data);
                    this.packetFactory.addToQueue(this.connection.deletePrivateMessage(string), 1);
                    break;
                }
                case 262147: {
                    String string = new String(proColIncomingMessage.data);
                    this.packetFactory.addToQueue(262148, this.connection.getPrivateMessage(string), 1);
                    break;
                }
                case 262401: {
                    this.connection.getPublicMessageList();
                    break;
                }
                case 262405: {
                    try {
                        String string = new String(proColIncomingMessage.data);
                        this.tokenizer = new StringTokenizer(string, "\n");
                        String string5 = this.tokenizer.nextToken();
                        String string6 = this.tokenizer.nextToken();
                        StringBuffer stringBuffer = new StringBuffer();
                        while (this.tokenizer.hasMoreTokens()) {
                            stringBuffer.append(this.tokenizer.nextToken());
                            if (!this.tokenizer.hasMoreTokens()) continue;
                            stringBuffer.append("\n");
                        }
                        this.packetFactory.addToQueue(this.connection.addPublicMessage(this.connection.getUser().getName(), string5, string6, stringBuffer.toString()), 1);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        this.packetFactory.addToQueue(-268172815, 2);
                    }
                    break;
                }
                case 262406: {
                    String string = new String(proColIncomingMessage.data);
                    this.packetFactory.addToQueue(this.connection.deletePublicMessage(string), 1);
                    break;
                }
                case 262403: {
                    String string = new String(proColIncomingMessage.data);
                    this.packetFactory.addToQueue(262404, this.connection.getPublicMessage(string), 1);
                    break;
                }
                case 327681: {
                    this.connection.getTodoItemList();
                    break;
                }
                case 327685: {
                    try {
                        String string = new String(proColIncomingMessage.data);
                        this.tokenizer = new StringTokenizer(string, "\n");
                        String string7 = this.tokenizer.nextToken();
                        String string8 = this.tokenizer.nextToken();
                        String string9 = this.tokenizer.nextToken();
                        String string10 = this.tokenizer.nextToken();
                        String string11 = this.tokenizer.nextToken();
                        StringBuffer stringBuffer = new StringBuffer();
                        while (this.tokenizer.hasMoreTokens()) {
                            stringBuffer.append(this.tokenizer.nextToken());
                            if (!this.tokenizer.hasMoreTokens()) continue;
                            stringBuffer.append("\n");
                        }
                        this.packetFactory.addToQueue(this.connection.addTodoItem(this.connection.getUser().getName(), string7, string8, string9, string10, string11, stringBuffer.toString()), 1);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        this.packetFactory.addToQueue(-268107535, 2);
                    }
                    break;
                }
                case 327688: {
                    try {
                        String string = new String(proColIncomingMessage.data);
                        this.tokenizer = new StringTokenizer(string, "\n");
                        String string12 = this.tokenizer.nextToken();
                        String string13 = this.tokenizer.nextToken();
                        String string14 = this.tokenizer.nextToken();
                        String string15 = this.tokenizer.nextToken();
                        String string16 = this.tokenizer.nextToken();
                        String string17 = this.tokenizer.nextToken();
                        StringBuffer stringBuffer = new StringBuffer();
                        while (this.tokenizer.hasMoreTokens()) {
                            stringBuffer.append(this.tokenizer.nextToken());
                            if (!this.tokenizer.hasMoreTokens()) continue;
                            stringBuffer.append("\n");
                        }
                        this.packetFactory.addToQueue(this.connection.updateTodoItem(this.connection.getUser().getName(), string12, string13, string14, string15, string16, string17, stringBuffer.toString()), 1);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        this.packetFactory.addToQueue(-268107533, 2);
                    }
                    break;
                }
                case 327686: {
                    String string = new String(proColIncomingMessage.data);
                    this.packetFactory.addToQueue(this.connection.deleteTodoItem(string), 1);
                    break;
                }
                case 327683: {
                    String string = new String(proColIncomingMessage.data);
                    this.packetFactory.addToQueue(327684, this.connection.getTodoItem(string), 1);
                    break;
                }
                case 327937: {
                    this.connection.getBugItemList();
                    break;
                }
                case 327941: {
                    try {
                        String string = new String(proColIncomingMessage.data);
                        this.tokenizer = new StringTokenizer(string, "\n");
                        String string18 = this.tokenizer.nextToken();
                        String string19 = this.tokenizer.nextToken();
                        String string20 = this.tokenizer.nextToken();
                        String string21 = this.tokenizer.nextToken();
                        String string22 = this.tokenizer.nextToken();
                        StringBuffer stringBuffer = new StringBuffer();
                        while (this.tokenizer.hasMoreTokens()) {
                            stringBuffer.append(this.tokenizer.nextToken());
                            if (!this.tokenizer.hasMoreTokens()) continue;
                            stringBuffer.append("\n");
                        }
                        this.packetFactory.addToQueue(this.connection.addBugItem(this.connection.getUser().getName(), string18, string19, string20, string21, string22, stringBuffer.toString()), 1);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        this.packetFactory.addToQueue(-268107279, 2);
                    }
                    break;
                }
                case 327944: {
                    try {
                        String string = new String(proColIncomingMessage.data);
                        this.tokenizer = new StringTokenizer(string, "\n");
                        String string23 = this.tokenizer.nextToken();
                        String string24 = this.tokenizer.nextToken();
                        String string25 = this.tokenizer.nextToken();
                        String string26 = this.tokenizer.nextToken();
                        String string27 = this.tokenizer.nextToken();
                        String string28 = this.tokenizer.nextToken();
                        StringBuffer stringBuffer = new StringBuffer();
                        while (this.tokenizer.hasMoreTokens()) {
                            stringBuffer.append(this.tokenizer.nextToken());
                            if (!this.tokenizer.hasMoreTokens()) continue;
                            stringBuffer.append("\n");
                        }
                        this.packetFactory.addToQueue(this.connection.updateBugItem(this.connection.getUser().getName(), string23, string24, string25, string26, string27, string28, stringBuffer.toString()), 1);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        this.packetFactory.addToQueue(-268107277, 2);
                    }
                    break;
                }
                case 327942: {
                    String string = new String(proColIncomingMessage.data);
                    this.packetFactory.addToQueue(this.connection.deleteBugItem(string), 1);
                    break;
                }
                case 327939: {
                    String string = new String(proColIncomingMessage.data);
                    this.packetFactory.addToQueue(327940, this.connection.getBugItem(string), 1);
                    break;
                }
                case 197124: {
                    String string = new String(proColIncomingMessage.data);
                    this.tokenizer = new StringTokenizer(string, "\n");
                    this.filePath = this.tokenizer.nextToken();
                    this.result = this.connection.getProject().addDownloadFile(proColIncomingMessage.data, this.connection.getUser().getName());
                    this.sendUploadResult(this.result, this.filePath);
                    break;
                }
                case 197126: {
                    ProColServer.printInfo("got file data");
                    this.tokenizer = new StringTokenizer(new String(proColIncomingMessage.data), "\n");
                    this.filePath = this.tokenizer.nextToken();
                    this.result = this.connection.getProject().writeFile(this.filePath, proColIncomingMessage.data, this.connection.getUser().getName());
                    this.sendUploadResult(this.result, this.filePath);
                    break;
                }
                case 197634: {
                    this.tempURI = URI.create(new String(proColIncomingMessage.data));
                    int n = this.connection.getProject().checkIn(this.tempURI, this.connection.getUser());
                    this.packetFactory.addToQueue(n, new String(proColIncomingMessage.data), 1);
                    break;
                }
                case 197636: {
                    String string = new String(proColIncomingMessage.data);
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                    this.filePath = stringTokenizer.nextToken();
                    this.result = this.connection.getProject().addDownloadFile(proColIncomingMessage.data, this.connection.getUser().getName());
                    this.sendCheckInResult(this.result, this.filePath);
                    break;
                }
                case 197638: {
                    ProColServer.printInfo("got file data");
                    this.tokenizer = new StringTokenizer(new String(proColIncomingMessage.data), "\n");
                    this.filePath = this.tokenizer.nextToken();
                    this.result = this.connection.getProject().writeFile(this.filePath, proColIncomingMessage.data, this.connection.getUser().getName());
                    this.sendCheckInResult(this.result, this.filePath);
                    break;
                }
                case 197888: {
                    this.tempURI = URI.create(new String(proColIncomingMessage.data));
                    this.result = this.connection.getProject().deleteFile(this.tempURI);
                    this.sendDeleteResult(this.result, new String(proColIncomingMessage.data));
                    break;
                }
                case 197920: {
                    this.tokenizer = new StringTokenizer(new String(proColIncomingMessage.data), "\n");
                    String string = this.tokenizer.nextToken();
                    String string29 = this.tokenizer.nextToken();
                    URI uRI = URI.create(string);
                    URI uRI2 = URI.create(string29);
                    this.result = this.connection.getProject().moveFile(uRI, uRI2);
                    this.sendMoveResult(this.result, string, string29);
                    break;
                }
                case 197904: {
                    this.tokenizer = new StringTokenizer(new String(proColIncomingMessage.data), "\n");
                    String string = this.tokenizer.nextToken();
                    String string30 = this.tokenizer.nextToken();
                    URI uRI = URI.create(string);
                    URI uRI3 = URI.create(string30);
                    this.result = this.connection.getProject().moveFile(uRI, uRI3);
                    this.sendRenameResult(this.result, string, string30);
                    break;
                }
                case 197936: {
                    String string = new String(proColIncomingMessage.data);
                    URI uRI = URI.create(string);
                    int n = this.connection.getProject().newFile(uRI, false);
                    this.sendCreateResult(n, string);
                    break;
                }
                case 197937: {
                    String string = new String(proColIncomingMessage.data);
                    URI uRI = URI.create(string);
                    int n = this.connection.getProject().newFile(uRI, true);
                    this.sendCreateResult(n, string);
                    break;
                }
                default: {
                    ProColServer.printErr("Unknown client request: " + proColIncomingMessage.toString());
                    this.packetFactory.addToQueue(-2, Integer.toHexString(proColIncomingMessage.requestCode), 1);
                    break;
                }
            }
        } else {
            switch (proColIncomingMessage.requestCode) {
                case 256: {
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(new String(proColIncomingMessage.data)));
                    try {
                        String string = bufferedReader.readLine();
                        String string31 = bufferedReader.readLine();
                        int n = RunProColServer.getServer().authenticateUser(string, string31);
                        if (n == 257) {
                            this.authenticated = true;
                            this.connection.setUser(new ProColUser(string, RunProColServer.getServer().getUserProperty(string + ".fullname")));
                        }
                        this.packetFactory.addToQueue(n, string, 1);
                    }
                    catch (IOException iOException) {
                        this.packetFactory.addToQueue(-268435195, 1);
                    }
                    break;
                }
                case 0: {
                    this.packetFactory.addToQueue(0, RunProColServer.getServer().getProperty("options.procol.server.hellomessage", "Authenticate"), 1);
                    this.packetFactory.addToQueue(this.connection.checkProtocol(proColIncomingMessage), "0.1", 1);
                    break;
                }
                default: {
                    ProColServer.printErr("Unknown client request: " + proColIncomingMessage.toString());
                    this.packetFactory.addToQueue(-2, Integer.toHexString(proColIncomingMessage.requestCode), 1);
                }
            }
        }
    }

    private void sendCheckInResult(int n, String string) {
        if (n == 200449) {
            n = 197635;
        } else if (n == 200450) {
            n = 197637;
        } else if (n == 200451) {
            n = 197638;
        } else if (n == 200452) {
            n = 197639;
        } else if (n == -268234848) {
            n = -268237583;
        } else if (n == -268234832) {
            n = -268237582;
        } else if (n == -268234831) {
            n = -268237581;
        } else if (n == -268234830) {
            n = -268237580;
        } else if (n == -268234829) {
            n = -268237579;
        } else if (n == -268234827) {
            n = -268237578;
        } else if (n == -268234816) {
            n = -268237577;
        } else if (n == -268234753) {
            n = -268237569;
        }
        this.packetFactory.addToQueue(n, string, 1);
    }

    private void sendUploadResult(int n, String string) {
        if (n == 200449) {
            n = 197123;
        } else if (n == 200450) {
            n = 197125;
        } else if (n == 200451) {
            n = 197126;
        } else if (n == 200452) {
            n = 197127;
        } else if (n == -268234848) {
            n = -268238095;
        } else if (n == -268234830) {
            n = -268238094;
        } else if (n == -268234827) {
            n = -268238093;
        } else if (n == -268234816) {
            n = -268238092;
        } else if (n == -268234753) {
            n = -268238081;
        }
        this.packetFactory.addToQueue(n, string, 1);
    }

    private void sendMoveResult(int n, String string, String string2) {
        if (n == 200449) {
            n = 197921;
        } else if (n == -268234828) {
            n = 197922;
        } else if (n == -268234827) {
            n = -268237533;
        } else if (n == -268234846) {
            n = -268237532;
        } else if (n == -268234753) {
            n = -268237521;
        }
        this.packetFactory.addToQueue(n, string + "\n" + string2, 1);
    }

    private void sendRenameResult(int n, String string, String string2) {
        if (n == 200449) {
            n = 197905;
        } else if (n == -268234828) {
            n = -268237550;
        } else if (n == -268234827) {
            n = -268237549;
        } else if (n == -268234846) {
            n = -268237548;
        } else if (n == -268234753) {
            n = -268237537;
        }
        this.packetFactory.addToQueue(n, string + "\n" + string2, 1);
    }

    private void sendDeleteResult(int n, String string) {
        if (n == 200449) {
            n = 197889;
        } else if (n == -268234827) {
            n = -268237566;
        } else if (n == -268234846) {
            n = -268237565;
        } else if (n == -268234753) {
            n = -268237553;
        }
        this.packetFactory.addToQueue(n, string, 1);
    }

    private void sendCreateResult(int n, String string) {
        if (n == 200449) {
            n = 197938;
        } else if (n == -268234827) {
            n = 197940;
        } else if (n == -268234846) {
            n = 197941;
        } else if (n == -268234753) {
            n = 197951;
        }
        this.packetFactory.addToQueue(n, string, 1);
    }
}

