/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.common.net;

import com.enderak.procol.common.net.ProColOutgoingMessage;
import com.enderak.procol.common.net.ProColPacket;
import com.enderak.procol.common.util.ProColUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;

public class PacketFactory {
    public static final int MAX_PRIORITY = 2;
    public static final int MIN_PRIORITY = 0;
    public static final int NORMAL_PRIORITY = 1;
    private static final int MAX_PACKET_SIZE = 2048;
    private static final int HEADER_SIZE = 16;
    private static final int MAX_DATA_SIZE = 2032;
    private int messageID;
    private int dataRemaining;
    private int dataSize;
    private int read = 0;
    private boolean messageInProgress = false;
    private DataInputStream dataStream;
    private ProColOutgoingMessage message;
    private LinkedList[] messageQueue = new LinkedList[3];

    public PacketFactory() {
        for (int i = 0; i <= 2; ++i) {
            this.messageQueue[i] = new LinkedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(int n, int n2) {
        PacketFactory packetFactory = this;
        synchronized (packetFactory) {
            this.messageQueue[n2].add(new ProColOutgoingMessage(this.messageID++, n, new DataInputStream(new ByteArrayInputStream("".getBytes()))));
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(int n, String string, int n2) {
        PacketFactory packetFactory = this;
        synchronized (packetFactory) {
            this.messageQueue[n2].add(new ProColOutgoingMessage(this.messageID++, n, new DataInputStream(new ByteArrayInputStream(string.getBytes()))));
            this.notifyAll();
        }
    }

    public void addToQueue(int n, URI uRI, int n2) {
        this.addToQueue(n, uRI.toString(), n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(int n, byte[] byArray, int n2) {
        PacketFactory packetFactory = this;
        synchronized (packetFactory) {
            this.messageQueue[n2].add(new ProColOutgoingMessage(this.messageID++, n, new DataInputStream(new ByteArrayInputStream(byArray))));
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(int n, int n2, int n3) {
        PacketFactory packetFactory = this;
        synchronized (packetFactory) {
            this.messageQueue[n3].add(new ProColOutgoingMessage(this.messageID++, n, new DataInputStream(new ByteArrayInputStream(ProColUtils.intToByteArray(n2)))));
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(int n, File file, int n2) {
        PacketFactory packetFactory = this;
        synchronized (packetFactory) {
            this.messageQueue[n2].add(new ProColOutgoingMessage(this.messageID++, n, file));
            this.notifyAll();
        }
    }

    public void addToQueue(int n, URI uRI, File file, int n2) {
        this.addToQueue(n, uRI.toString(), file, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(int n, String string, File file, int n2) {
        PacketFactory packetFactory = this;
        synchronized (packetFactory) {
            string = string + "\n";
            this.messageQueue[n2].add(new ProColOutgoingMessage(this.messageID++, n, new DataInputStream(new ByteArrayInputStream(string.getBytes())), file));
            this.notifyAll();
        }
    }

    public ProColPacket getNext() {
        if (this.messageInProgress) {
            this.dataSize = 0;
            byte[] byArray = new byte[2032];
            try {
                do {
                    this.read = this.dataStream.read(byArray, this.dataSize, byArray.length - this.dataSize);
                    if (this.read <= 0) continue;
                    this.dataSize += this.read;
                } while (this.read >= 0 && this.dataSize < 2032);
                this.dataRemaining = this.dataStream.available() + this.dataSize;
            }
            catch (IOException iOException) {
                System.err.println("IOExeception reading message.dataStream in PacketFactory: " + iOException);
            }
            if (this.dataSize < 2032) {
                try {
                    this.dataStream.close();
                    this.dataStream = null;
                }
                catch (IOException iOException) {
                    System.err.println("IOExeception closing message.dataStream in PacketFactory: " + iOException);
                }
                this.messageInProgress = false;
            }
            return new ProColPacket(this.message.messageID, this.message.requestCode, this.dataRemaining, this.dataSize, byArray);
        }
        if (this.hasNext()) {
            for (int i = 2; i >= 0; --i) {
                if (this.messageQueue[i].isEmpty()) continue;
                this.message = (ProColOutgoingMessage)this.messageQueue[i].removeFirst();
                break;
            }
            this.dataStream = this.message.getDataInputStream();
            if (this.dataStream == null) {
                this.addToQueue(-268234827, 1);
                return null;
            }
            this.messageInProgress = true;
            return this.getNext();
        }
        return null;
    }

    public boolean hasNext() {
        if (this.messageInProgress) {
            return true;
        }
        for (int i = 0; i <= 2; ++i) {
            if (this.messageQueue[i].isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void resetMessageNum() {
        this.messageID = 0;
    }
}

