/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.common.net;

import com.enderak.procol.common.net.PacketFactory;
import com.enderak.procol.common.net.ProColPacket;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.net.ssl.SSLSocket;

public class OutgoingMessageHandler
extends Thread {
    private SSLSocket client;
    private boolean isRunning = false;
    private DataOutputStream out;
    private PacketFactory packetFactory;

    public OutgoingMessageHandler(SSLSocket sSLSocket, PacketFactory packetFactory) {
        this.client = sSLSocket;
        this.packetFactory = packetFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.out = new DataOutputStream(this.client.getOutputStream());
        }
        catch (IOException iOException) {
            System.err.println("getOutputStream failed");
            return;
        }
        this.isRunning = true;
        while (this.isRunning) {
            PacketFactory packetFactory = this.packetFactory;
            synchronized (packetFactory) {
                while (!this.packetFactory.hasNext() && this.isRunning) {
                    try {
                        this.packetFactory.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println(interruptedException);
                    }
                }
                if (this.packetFactory.hasNext()) {
                    this.send(this.packetFactory.getNext());
                }
                OutgoingMessageHandler outgoingMessageHandler = this;
                synchronized (outgoingMessageHandler) {
                    this.notifyAll();
                }
            }
        }
        System.out.println("Ending OMH run");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.isRunning = false;
        PacketFactory packetFactory = this.packetFactory;
        synchronized (packetFactory) {
            System.out.println("CLOSING OMH!");
            this.packetFactory.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ProColPacket proColPacket) {
        if (proColPacket == null) {
            return;
        }
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            try {
                this.out.writeInt(proColPacket.messageID);
                this.out.writeInt(proColPacket.requestCode);
                this.out.writeInt(proColPacket.dataRemaining);
                this.out.writeInt(proColPacket.dataSize);
                if (proColPacket.dataSize > 0) {
                    this.out.write(proColPacket.data, 0, proColPacket.dataSize);
                }
                this.out.flush();
            }
            catch (IOException iOException) {
                System.err.println("IOException in OMH: " + iOException);
            }
        }
    }
}

