/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.common.model;

import com.enderak.procol.common.model.ProColFile;
import com.enderak.procol.common.util.DownloadFile;
import com.enderak.procol.common.util.EnhancedObservable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class ProColProject
extends EnhancedObservable {
    protected static final int NUM_VERSIONS = 3;
    protected String name = "";
    protected DefaultMutableTreeNode projectFilesRootNode;
    protected Hashtable downloadingFiles = new Hashtable();
    protected URI projectURI;
    protected URI projectFilesURI;
    protected ProColFile projectDir;
    protected ProColFile projectFilesDir;
    protected int j = 0;

    public ProColProject(URI uRI, String string) {
        this.projectURI = uRI;
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public URI getProjectURI() {
        return this.projectURI;
    }

    public URI getProjectFilesURI() {
        return this.projectFilesURI;
    }

    public DefaultMutableTreeNode getProjectFilesRootNode() {
        return this.projectFilesRootNode;
    }

    public DefaultMutableTreeNode getNodeForFile(URI uRI) {
        System.out.println("URI");
        return this.getNodeForFile(uRI.getPath());
    }

    public DefaultMutableTreeNode getNodeForFile(String string) {
        System.out.println("String");
        System.out.println("Looking for file: '" + string + "'");
        if (string.equals("")) {
            return this.projectFilesRootNode;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String string2 = stringTokenizer.nextToken();
        DefaultMutableTreeNode defaultMutableTreeNode = this.getProjectFilesRootNode();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            ProColFile proColFile = (ProColFile)defaultMutableTreeNode2.getUserObject();
            if (!proColFile.getName().equals(string2)) continue;
            if (stringTokenizer.hasMoreTokens()) {
                defaultMutableTreeNode = defaultMutableTreeNode2;
                enumeration = defaultMutableTreeNode.children();
                string2 = stringTokenizer.nextToken();
                continue;
            }
            return defaultMutableTreeNode2;
        }
        return null;
    }

    public ProColFile getFileInTree(URI uRI) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getNodeForFile(uRI);
        if (defaultMutableTreeNode == null) {
            return null;
        }
        return (ProColFile)defaultMutableTreeNode.getUserObject();
    }

    public ProColFile getFileInTree(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getNodeForFile(string);
        if (defaultMutableTreeNode == null) {
            return null;
        }
        return (ProColFile)defaultMutableTreeNode.getUserObject();
    }

    public int createFile(URI uRI) {
        DownloadFile downloadFile = (DownloadFile)this.downloadingFiles.get(uRI);
        ProColFile proColFile = new ProColFile(downloadFile.destURI.getPath());
        System.out.println("createFile: " + proColFile);
        downloadFile.file = proColFile;
        if (proColFile == null) {
            proColFile = new ProColFile(this.projectFilesURI.resolve(uRI));
        }
        try {
            proColFile.getParentFile().mkdirs();
            proColFile.createNewFile();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return -268234848;
        }
        return 200450;
    }

    public int createFile(String string) {
        return this.createFile(URI.create(string));
    }

    public int writeFile(String string, byte[] byArray) {
        URI uRI = URI.create(string);
        string = uRI.getPath();
        System.out.println("WRITING FILE: " + string);
        DownloadFile downloadFile = (DownloadFile)this.downloadingFiles.remove(uRI);
        ProColFile proColFile = downloadFile.file;
        if (proColFile != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(proColFile);
                fileOutputStream.write(byArray, string.getBytes().length + 1, byArray.length - string.getBytes().length - 1);
                fileOutputStream.close();
                return 200452;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException);
                return -268234829;
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                return -268234827;
            }
        }
        return -268234816;
    }

    protected void printTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n;
        String string = "";
        for (n = 0; n < defaultMutableTreeNode.getLevel(); ++n) {
            string = string + "--";
        }
        System.out.println(string + ((ProColFile)defaultMutableTreeNode.getUserObject()).getName());
        for (n = 0; n < defaultMutableTreeNode.getChildCount(); ++n) {
            this.printTree((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n));
        }
    }
}

