/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.client.util;

import com.enderak.procol.client.gui.ProColClientDockable;
import com.enderak.procol.client.net.ProColClient;
import com.enderak.procol.common.net.ProColIncomingMessage;
import com.enderak.procol.common.util.ErrorHandler;

public class ClientErrorHandler
extends ErrorHandler {
    ProColClient client;

    public ClientErrorHandler(ProColClient proColClient) {
        this.client = proColClient;
    }

    public void handleMessage(ProColIncomingMessage proColIncomingMessage) {
        if (proColIncomingMessage == null) {
            return;
        }
        switch (proColIncomingMessage.requestCode) {
            case -268435453: {
                ProColClientDockable.displayError("Connection Failed", "The server does not support your client because it uses an old communication protocol.\nPlease upgrade to a newer client.\nServer protocol: " + new String(proColIncomingMessage.data) + "\nClient protocol: " + "0.1");
                this.client.close();
                break;
            }
            case -268435452: {
                ProColClientDockable.displayError("Connection Failed", "The server does not support your client because it uses a new communication protocol.\nPlease use an older client, or contact the server administrator to upgrade\nto a newer version of the ProCol server.\nServer protocol: " + new String(proColIncomingMessage.data) + "\nClient protocol: " + "0.1");
                this.client.close();
                break;
            }
            case -268237840: {
                ProColClientDockable.displayError("Checkout Error", "File is already checked out by " + new String(proColIncomingMessage.data) + "!");
                ProColClientDockable.proColPanel.stopProgress();
                break;
            }
            case -268237826: {
                ProColClientDockable.displayError("Checkout Error", "File was not found on server!");
                ProColClientDockable.proColPanel.stopProgress();
                break;
            }
            case -2: {
                ProColClientDockable.displayInfo("Invalid Message", new String("Server encountered an error handling message: " + new String(proColIncomingMessage.data)));
                break;
            }
            default: {
                ProColClientDockable.displayInfo("Unknown error", new String("Unknown error message: " + proColIncomingMessage));
            }
        }
    }
}

