/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.client.net;

import com.enderak.procol.client.gui.LoginFrame;
import com.enderak.procol.client.gui.ProColClientDockable;
import com.enderak.procol.client.net.ProColClient;
import com.enderak.procol.client.util.ClientErrorHandler;
import com.enderak.procol.common.net.MessageFactory;
import com.enderak.procol.common.net.ProColIncomingMessage;
import com.enderak.procol.common.util.EnhancedObservable;
import com.enderak.procol.common.util.ProColUtils;
import java.net.URI;
import java.util.StringTokenizer;

public class IncomingMessageHandler
extends EnhancedObservable
implements Runnable {
    private boolean isRunning = true;
    private ProColClient client;
    private MessageFactory messageFactory;
    private String filePath;
    private int clientMajorVersion;
    private int clientMinorVersion;
    private int serverMajorVersion;
    private int serverMinorVersion = 0;
    private ClientErrorHandler errorHandler;

    public IncomingMessageHandler(ProColClient proColClient) {
        this.client = proColClient;
        this.messageFactory = proColClient.getMessageFactory();
        this.errorHandler = new ClientErrorHandler(this.client);
        new Thread((Runnable)this.errorHandler, "ClientErrorHandler").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            MessageFactory messageFactory = this.messageFactory;
            synchronized (messageFactory) {
                while (!this.messageFactory.hasNext() && this.isRunning) {
                    try {
                        this.messageFactory.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.handleMessage(this.messageFactory.getNext());
            }
        }
        System.out.println("Ending IMH run");
    }

    public void close() {
        this.isRunning = false;
        this.client.getUser().setAuthenticated(false);
    }

    private void handleMessage(ProColIncomingMessage proColIncomingMessage) {
        if (proColIncomingMessage == null) {
            return;
        }
        System.out.println("Handling message: " + proColIncomingMessage.toString() + " " + proColIncomingMessage.isError());
        if (proColIncomingMessage.isError()) {
            this.errorHandler.addErrorMessage(proColIncomingMessage);
            return;
        }
        switch (proColIncomingMessage.requestCode) {
            case 131074: {
                ProColClientDockable.displayError("No Projects", this.client.getUser().getName() + " is not authorized to access any projects on this server.");
                this.client.close();
                break;
            }
            case 65537: {
                this.client.setUserList(ProColUtils.dataStringToVector(proColIncomingMessage.data));
                break;
            }
            case 196609: {
                this.client.addTree(proColIncomingMessage.data);
                break;
            }
            case 262144: {
                ProColClientDockable.proColPanel.userPanel.newPrivateMessage();
                this.forceNotify(proColIncomingMessage);
                break;
            }
            case 262400: {
                ProColClientDockable.proColPanel.userPanel.newPublicMessage();
                this.forceNotify(proColIncomingMessage);
                break;
            }
            case 327680: {
                ProColClientDockable.proColPanel.userPanel.newTodoListItem();
                this.forceNotify(proColIncomingMessage);
                break;
            }
            case 327936: {
                ProColClientDockable.proColPanel.userPanel.newBugListItem();
                this.forceNotify(proColIncomingMessage);
                break;
            }
            case 65541: {
                ProColClientDockable.displayInfo("User Info", new String(proColIncomingMessage.data));
                break;
            }
            case 513: {
                this.client.close();
                break;
            }
            case 0: {
                new LoginFrame(new String(proColIncomingMessage.data));
                break;
            }
            case 1: {
                this.getProtocolVersions(proColIncomingMessage);
                break;
            }
            case 2: {
                ProColClientDockable.displayError("Connection Warning", "The server communication protocol does not match your client.\nThe session will continue, however it is recommended that you install the newest version,\nor contact the server administrator to upgrade to the newest version.\nServer protocol: " + new String(proColIncomingMessage.data) + "\nClient protocol: " + "0.1");
                this.getProtocolVersions(proColIncomingMessage);
                break;
            }
            case 196865: {
                StringTokenizer stringTokenizer = new StringTokenizer(new String(proColIncomingMessage.data), "\n");
                this.filePath = stringTokenizer.nextToken();
                this.client.getProject().createFile(this.filePath);
                this.client.getProject().writeFile(this.filePath, proColIncomingMessage.data);
                break;
            }
            case 196868: {
                StringTokenizer stringTokenizer = new StringTokenizer(new String(proColIncomingMessage.data), "\n");
                this.filePath = stringTokenizer.nextToken();
                this.client.getProject().readyForDownload(URI.create(this.filePath), this.client.getSnapshotURI().resolve(this.filePath));
                this.client.getProject().createFile(this.filePath);
                this.client.getProject().writeFile(this.filePath, proColIncomingMessage.data);
                break;
            }
            case 197376: {
                StringTokenizer stringTokenizer = new StringTokenizer(new String(proColIncomingMessage.data), "\n");
                this.filePath = stringTokenizer.nextToken();
                System.out.println("FILEPATH: " + this.filePath);
                this.client.getProject().createFile(this.filePath);
                this.client.getProject().writeAndOpenFile(this.filePath, proColIncomingMessage.data);
                break;
            }
            case 196610: {
                this.client.getProject().updateFileInfo(proColIncomingMessage.data);
                break;
            }
            default: {
                this.forceNotify(proColIncomingMessage);
            }
        }
    }

    private void getProtocolVersions(ProColIncomingMessage proColIncomingMessage) {
        StringTokenizer stringTokenizer = new StringTokenizer("0.1", ".");
        this.clientMajorVersion = Integer.parseInt(stringTokenizer.nextToken());
        this.clientMinorVersion = Integer.parseInt(stringTokenizer.nextToken());
        stringTokenizer = new StringTokenizer(new String(proColIncomingMessage.data), ".");
        this.serverMajorVersion = Integer.parseInt(stringTokenizer.nextToken());
        this.serverMinorVersion = Integer.parseInt(stringTokenizer.nextToken());
    }
}

