/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.client.gui;

import com.enderak.procol.ProColPlugin;
import com.enderak.procol.client.gui.BugListPanel;
import com.enderak.procol.client.gui.PrivateMessageComposer;
import com.enderak.procol.client.gui.PrivateMessagePanel;
import com.enderak.procol.client.gui.PublicMessagePanel;
import com.enderak.procol.client.gui.TodoListPanel;
import com.enderak.procol.common.gui.ButtonPanel;
import com.enderak.procol.common.gui.RolloverOnOffButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;

public class UserPanel
extends JPanel
implements ActionListener {
    private ButtonPanel userButtonPanel;
    private JScrollPane userScrollPane;
    private JList userList;
    private RolloverOnOffButton privateMessageButton;
    private RolloverOnOffButton publicMessageButton;
    private RolloverOnOffButton calendarButton;
    private RolloverOnOffButton todoListButton;
    private RolloverOnOffButton bugListButton;

    public UserPanel(boolean bl) {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(jEdit.getProperty((String)"procol.client.users.toplabel")));
        this.userButtonPanel = new ButtonPanel(bl);
        this.userScrollPane = new JScrollPane();
        this.userList = new JList();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = UserPanel.this.userList.locationToIndex(mouseEvent.getPoint());
                UserPanel.this.userList.setSelectedIndex(n);
                if (mouseEvent.getButton() == 3) {
                    String string = (String)UserPanel.this.userList.getModel().getElementAt(n);
                    new UserPopupMenu(string).show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        this.userList.addMouseListener(mouseAdapter);
        this.userScrollPane.setViewportView(this.userList);
        this.add((Component)this.userScrollPane, "Center");
        this.privateMessageButton = this.userButtonPanel.createRolloverOnOffButton("privatemessages");
        this.privateMessageButton.addActionListener(this);
        this.publicMessageButton = this.userButtonPanel.createRolloverOnOffButton("publicmessages");
        this.publicMessageButton.addActionListener(this);
        this.todoListButton = this.userButtonPanel.createRolloverOnOffButton("todolist");
        this.todoListButton.addActionListener(this);
        this.bugListButton = this.userButtonPanel.createRolloverOnOffButton("buglist");
        this.bugListButton.addActionListener(this);
        if (bl) {
            this.add((Component)this.userButtonPanel, "South");
        } else {
            this.add((Component)this.userButtonPanel, "East");
        }
    }

    public void setConnected(boolean bl) {
        this.privateMessageButton.setEnabled(bl);
        this.publicMessageButton.setEnabled(bl);
        this.todoListButton.setEnabled(bl);
        this.bugListButton.setEnabled(bl);
        System.out.println(bl);
        if (bl) {
            if (jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.privatemessages") != null) {
                System.out.println("procol.client.dockable.privatemessages");
                ((PrivateMessagePanel)jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.privatemessages")).initNetworkCommunication();
            }
            if (jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.publicmessages") != null) {
                System.out.println("procol.client.dockable.publicmessages");
                ((PublicMessagePanel)jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.publicmessages")).initNetworkCommunication();
            }
            if (jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.todolist") != null) {
                ((TodoListPanel)jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.todolist")).initNetworkCommunication();
            }
            if (jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.buglist") != null) {
                ((BugListPanel)jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.buglist")).initNetworkCommunication();
            }
        } else {
            this.setUserList(new Vector());
        }
    }

    public void setUserList(Vector vector) {
        Collections.sort(vector);
        this.userList.setListData(vector);
    }

    public void newPrivateMessage() {
        if (!jEdit.getActiveView().getDockableWindowManager().isDockableWindowVisible("procol.client.dockable.privatemessages")) {
            this.privateMessageButton.turnOn();
        }
    }

    public void newPublicMessage() {
        if (!jEdit.getActiveView().getDockableWindowManager().isDockableWindowVisible("procol.client.dockable.publicmessages")) {
            this.publicMessageButton.turnOn();
        }
    }

    public void newTodoListItem() {
        if (!jEdit.getActiveView().getDockableWindowManager().isDockableWindowVisible("procol.client.dockable.todolist")) {
            this.todoListButton.turnOn();
        }
    }

    public void newBugListItem() {
        if (!jEdit.getActiveView().getDockableWindowManager().isDockableWindowVisible("procol.client.dockable.buglist")) {
            this.bugListButton.turnOn();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        String string2 = "procol.client.dockable." + string;
        DockableWindowManager dockableWindowManager = jEdit.getActiveView().getDockableWindowManager();
        if (!dockableWindowManager.isDockableWindowVisible(string2)) {
            dockableWindowManager.showDockableWindow(string2);
        } else {
            dockableWindowManager.hideDockableWindow(string2);
        }
        ((RolloverOnOffButton)((Object)actionEvent.getSource())).turnOff();
        if (string.equals("privatemessages")) {
            if (ProColPlugin.getClient().isConnected()) {
                ((PrivateMessagePanel)dockableWindowManager.getDockableWindow(string2)).initNetworkCommunication();
            }
        } else if (string.equals("publicmessages")) {
            if (ProColPlugin.getClient().isConnected()) {
                ((PublicMessagePanel)dockableWindowManager.getDockableWindow(string2)).initNetworkCommunication();
            }
        } else if (string.equals("todolist")) {
            if (ProColPlugin.getClient().isConnected()) {
                ((TodoListPanel)dockableWindowManager.getDockableWindow(string2)).initNetworkCommunication();
            }
        } else if (string.equals("buglist") && ProColPlugin.getClient().isConnected()) {
            ((BugListPanel)dockableWindowManager.getDockableWindow(string2)).initNetworkCommunication();
        }
    }

    private class UserPopupMenu
    extends JPopupMenu {
        private MenuHandler menuHandler = new MenuHandler();
        private String userSelected;

        public UserPopupMenu(String string) {
            this.userSelected = string;
            this.add(this.createMenuItem("privatemessages"));
            this.add(this.createMenuItem("userinfo"));
        }

        private JMenuItem createMenuItem(String string) {
            JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty((String)("procol.client." + string + ".label")));
            jMenuItem.setActionCommand(string);
            jMenuItem.addActionListener(this.menuHandler);
            return jMenuItem;
        }

        private class MenuHandler
        implements ActionListener {
            private MenuHandler() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("privatemessages")) {
                    Vector<String> vector = new Vector<String>();
                    vector.add(UserPopupMenu.this.userSelected);
                    new PrivateMessageComposer("null", UserPopupMenu.this.userSelected, "(No Subject)", vector);
                } else if (string.equals("userinfo")) {
                    ProColPlugin.getClient().getUserInfo(UserPopupMenu.this.userSelected);
                }
            }
        }
    }
}

