/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.client.gui;

import com.enderak.procol.ProColPlugin;
import com.enderak.procol.client.gui.GenericUploadPanel;
import com.enderak.procol.client.gui.ProColClientDockable;
import com.enderak.procol.common.gui.ButtonPanel;
import com.enderak.procol.common.model.ProColFile;
import com.enderak.procol.common.net.ProColIncomingMessage;
import com.enderak.procol.common.util.DownloadFile;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.Hashtable;
import java.util.Observable;
import javax.swing.DefaultListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class UploadPanel
extends GenericUploadPanel {
    protected static Hashtable waitingFiles = new Hashtable();
    protected static DefaultListModel listModel = new DefaultListModel();
    private RolloverButton uploadButton;

    public UploadPanel(View view, String string) {
        super(view, string, "upload");
        this.fileList.setModel(listModel);
        ButtonPanel buttonPanel = new ButtonPanel(this.isVerticalAlign);
        this.uploadButton = buttonPanel.createRolloverButton("upload.file");
        this.uploadButton.addActionListener((ActionListener)this);
        if (this.isVerticalAlign) {
            this.add((Component)buttonPanel, "North");
        } else {
            this.add((Component)buttonPanel, "West");
        }
    }

    public void addFile(ProColFile proColFile, URI uRI) {
        listModel.addElement(new DownloadFile(proColFile, uRI));
        this.fileList.setModel(listModel);
        this.fileList.setSelectedIndex(0);
    }

    public void removeFile(DownloadFile downloadFile) {
        listModel.removeElement(downloadFile);
        if (listModel.isEmpty()) {
            ProColPlugin.getClient().getIMH().deleteObserver(this);
            jEdit.getActiveView().getDockableWindowManager().hideDockableWindow("procol.client.dockable.upload");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("upload.file")) {
            this.newMajor = (Integer)this.major.getValue();
            this.newMinor = (Integer)this.minor.getValue();
            this.newRevision = (Integer)this.revision.getValue();
            this.changeLog = this.changeLogTextArea.getText();
            ProColPlugin.getClient().getIMH().addObserver(this);
            for (int i = 0; i < this.selectedFiles.length; ++i) {
                DownloadFile downloadFile = (DownloadFile)this.selectedFiles[i];
                int[] nArray = downloadFile.file.getVersionAsArray();
                System.out.println("::::: " + downloadFile.destURI);
                waitingFiles.put(downloadFile.destURI, downloadFile);
                if (this.incrementRadioButton.isSelected()) {
                    ProColPlugin.getClient().getPacketFactory().addToQueue(197124, downloadFile.destURI + "\n" + (this.newMajor + nArray[0]) + "." + (this.newMinor + nArray[1]) + "." + (this.newRevision + nArray[2]) + "\n" + this.changeLog, 0);
                    continue;
                }
                if (this.absoluteRadioButton.isSelected()) {
                    ProColPlugin.getClient().getPacketFactory().addToQueue(197124, downloadFile.destURI + "\n" + this.newMajor + "." + this.newMinor + "." + this.newRevision + "\n" + this.changeLog, 0);
                    continue;
                }
                if (!this.noChangeRadioButton.isSelected()) continue;
                ProColPlugin.getClient().getPacketFactory().addToQueue(197124, downloadFile.destURI + "\n" + nArray[0] + "." + nArray[1] + "." + nArray[2] + "\n" + this.changeLog, 0);
            }
        }
        this.validateVersionSpinners();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.selectedFiles = this.fileList.getSelectedValues();
        if (this.selectedFiles.length == 1) {
            this.uploadButton.setEnabled(true);
            this.newInfoPanel.setBorder(new TitledBorder(((DownloadFile)this.selectedFiles[0]).file.getName() + " v." + ((DownloadFile)this.selectedFiles[0]).file.getVersion()));
        } else if (this.selectedFiles.length > 1) {
            this.uploadButton.setEnabled(true);
            this.newInfoPanel.setBorder(new TitledBorder("(" + this.selectedFiles.length + " " + jEdit.getProperty((String)"procol.label.multiplefilesselected") + ")"));
        } else {
            this.uploadButton.setEnabled(false);
            this.newInfoPanel.setBorder(new TitledBorder("(" + jEdit.getProperty((String)"procol.label.nofilesselected") + ")"));
        }
        this.validateVersionSpinners();
    }

    public void update(Observable observable, Object object) {
        if (object instanceof ProColIncomingMessage) {
            ProColIncomingMessage proColIncomingMessage = (ProColIncomingMessage)object;
            switch (proColIncomingMessage.requestCode) {
                case 197125: {
                    URI uRI = URI.create(new String(proColIncomingMessage.data));
                    DownloadFile downloadFile = (DownloadFile)waitingFiles.get(uRI);
                    ProColPlugin.getClient().getPacketFactory().addToQueue(197126, uRI, (File)downloadFile.file, 0);
                    break;
                }
                case 197127: {
                    URI uRI = URI.create(new String(proColIncomingMessage.data));
                    DownloadFile downloadFile = (DownloadFile)waitingFiles.get(uRI);
                    waitingFiles.remove(downloadFile);
                    this.removeFile(downloadFile);
                    break;
                }
                case -268238095: {
                    ProColPlugin.getClient().getIMH().deleteObserver(this);
                    ProColClientDockable.displayError(jEdit.getProperty((String)"procol.client.error.upload.title"), jEdit.getProperty((String)"procol.client.error.filename"));
                    break;
                }
                case -268238094: {
                    ProColPlugin.getClient().getIMH().deleteObserver(this);
                    ProColClientDockable.displayError(jEdit.getProperty((String)"procol.client.error.upload.title"), jEdit.getProperty((String)"procol.client.error.versionioerror"));
                    break;
                }
                case -268238096: {
                    ProColPlugin.getClient().getIMH().deleteObserver(this);
                    ProColClientDockable.displayError(jEdit.getProperty((String)"procol.client.error.upload.title"), jEdit.getProperty((String)"procol.client.error.fileexists"));
                    break;
                }
                case -268238093: {
                    ProColPlugin.getClient().getIMH().deleteObserver(this);
                    ProColClientDockable.displayError(jEdit.getProperty((String)"procol.client.error.upload.title"), jEdit.getProperty((String)"procol.client.error.fileioerror"));
                    break;
                }
                case -268238081: {
                    ProColPlugin.getClient().getIMH().deleteObserver(this);
                    ProColClientDockable.displayError(jEdit.getProperty((String)"procol.client.error.upload.title"), jEdit.getProperty((String)"procol.client.error.undefined"));
                    break;
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        ProColPlugin.getClient().getIMH().deleteObserver(this);
    }
}

