/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.client.gui;

import com.enderak.procol.ProColPlugin;
import com.enderak.procol.client.gui.GenericListPanel;
import com.enderak.procol.client.gui.TodoItemComposer;
import com.enderak.procol.client.model.TodoItem;
import com.enderak.procol.common.gui.ButtonPanel;
import com.enderak.procol.common.net.ProColIncomingMessage;
import com.enderak.procol.common.util.ProColUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Observable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class TodoListPanel
extends GenericListPanel {
    protected static DefaultListModel listModel = new DefaultListModel();
    private RolloverButton newButton;
    private RolloverButton modifyButton;
    private RolloverButton deleteButton;
    private Vector allUsers;

    public TodoListPanel(View view, String string) {
        super(view, string, "todolist");
        listModel.clear();
        this.itemList.setModel(listModel);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = TodoListPanel.this.itemList.locationToIndex(mouseEvent.getPoint());
                TodoListPanel.this.itemList.setSelectedIndex(n);
                if (mouseEvent.getButton() == 3) {
                    new TodoListPopupMenu((TodoItem)TodoListPanel.this.itemList.getModel().getElementAt(n)).show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        this.itemList.addMouseListener(mouseAdapter);
        ButtonPanel buttonPanel = new ButtonPanel(this.isVerticalAlign);
        this.newButton = buttonPanel.createRolloverButton("todoitem.new");
        this.newButton.addActionListener((ActionListener)this);
        this.modifyButton = buttonPanel.createRolloverButton("todoitem.modify");
        this.modifyButton.addActionListener((ActionListener)this);
        buttonPanel.createRigidSpace();
        this.deleteButton = buttonPanel.createRolloverButton("todoitem.delete");
        this.deleteButton.addActionListener((ActionListener)this);
        if (this.isVerticalAlign) {
            this.add((Component)buttonPanel, "North");
        } else {
            this.add((Component)buttonPanel, "West");
        }
        this.initNetworkCommunication();
    }

    public final void initNetworkCommunication() {
        if (ProColPlugin.getClient() != null && ProColPlugin.getClient().isConnected()) {
            ProColPlugin.getClient().getIMH().addObserver(this);
            listModel.addElement(jEdit.getProperty((String)"procol.client.todolist.gettinglistinfo"));
            ProColPlugin.getClient().getPacketFactory().addToQueue(327681, 2);
            this.newButton.setEnabled(true);
            this.allUsers = ProColPlugin.getClient().getUserList();
            ProColPlugin.getClient().getPacketFactory().addToQueue(65792, 2);
        }
    }

    public void stopNetworkCommunication() {
        if (ProColPlugin.getClient() != null && !ProColPlugin.getClient().isConnected()) {
            ProColPlugin.getClient().getIMH().deleteObserver(this);
            listModel.clear();
            this.newButton.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.selectedItems = this.itemList.getSelectedValues();
        if (string.equals("todoitem.new")) {
            new TodoItemComposer(this.allUsers);
        } else if (string.equals("todoitem.modify")) {
            new TodoItemComposer((TodoItem)this.selectedItems[0], this.allUsers);
        } else if (string.equals("todoitem.delete")) {
            ProColPlugin.getClient().getPacketFactory().addToQueue(327686, ((TodoItem)this.selectedItems[0]).index, 2);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.selectedItems = this.itemList.getSelectedValues();
            if (this.selectedItems.length == 1) {
                ProColPlugin.getClient().getPacketFactory().addToQueue(327683, ((TodoItem)this.selectedItems[0]).index, 2);
                this.modifyButton.setEnabled(true);
                this.deleteButton.setEnabled(true);
            } else if (this.selectedItems.length == 0) {
                this.modifyButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
            }
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof ProColIncomingMessage) {
            ProColIncomingMessage proColIncomingMessage = (ProColIncomingMessage)object;
            switch (proColIncomingMessage.requestCode) {
                case 327680: {
                    ProColPlugin.getClient().getPacketFactory().addToQueue(327681, 2);
                    break;
                }
                case 327682: {
                    Properties properties = new Properties();
                    try {
                        properties.load(new ByteArrayInputStream(proColIncomingMessage.data));
                    }
                    catch (IOException iOException) {
                        System.out.println(iOException);
                    }
                    String string = properties.getProperty("current", "0");
                    listModel.clear();
                    while (!string.equals("0")) {
                        listModel.addElement(new TodoItem(string, properties.getProperty(string + ".subject", "(No Subject)"), properties.getProperty(string + ".duedate", "None"), properties.getProperty(string + ".priority", "5"), properties.getProperty(string + ".complete", "0"), properties.getProperty(string + ".assigned", "null")));
                        string = properties.getProperty(string + ".previous", "0");
                    }
                    if (!listModel.isEmpty()) break;
                    this.messageDisplayEditorPane.setText(jEdit.getProperty((String)"procol.client.todolist.nomessages"));
                    break;
                }
                case 327684: {
                    if (this.selectedItems.length != 1) break;
                    TodoItem todoItem = (TodoItem)this.selectedItems[0];
                    todoItem.description = new String(proColIncomingMessage.data);
                    this.messageDisplayEditorPane.setText("<font size=\"+1\"><b>" + todoItem.subject + "</b></font><br><b>Assigned to: " + todoItem.assignedTo + "<br>Priority: " + todoItem.priority + "<br>Complete: " + todoItem.complete + "%<br>Due: " + todoItem.dueDate + "</b><hr>" + todoItem.description);
                    break;
                }
                case -268107535: {
                    break;
                }
                case -268107534: {
                    break;
                }
                case 65792: {
                    this.allUsers = ProColUtils.dataStringToVector(proColIncomingMessage.data);
                    break;
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        ProColPlugin.getClient().getIMH().deleteObserver(this);
    }

    private class TodoListPopupMenu
    extends JPopupMenu {
        private MenuHandler menuHandler = new MenuHandler();
        private TodoItem itemSelected;

        public TodoListPopupMenu(TodoItem todoItem) {
            this.itemSelected = todoItem;
            this.add(this.createMenuItem("new"));
            this.add(this.createMenuItem("modify"));
            this.add(this.createMenuItem("delete"));
        }

        private JMenuItem createMenuItem(String string) {
            JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty((String)("procol.client." + string + ".label")));
            jMenuItem.setActionCommand(string);
            jMenuItem.addActionListener(this.menuHandler);
            return jMenuItem;
        }

        private class MenuHandler
        implements ActionListener {
            private MenuHandler() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("new")) {
                    new TodoItemComposer(TodoListPanel.this.allUsers);
                } else if (string.equals("modify")) {
                    new TodoItemComposer((TodoItem)((TodoListPopupMenu)TodoListPopupMenu.this).TodoListPanel.this.selectedItems[0], TodoListPanel.this.allUsers);
                } else if (string.equals("delete")) {
                    ProColPlugin.getClient().getPacketFactory().addToQueue(327686, ((TodoItem)((TodoListPopupMenu)TodoListPopupMenu.this).TodoListPanel.this.selectedItems[0]).index, 2);
                }
            }
        }
    }
}

