/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.client.gui;

import com.enderak.procol.ProColPlugin;
import com.enderak.procol.client.gui.ProjectPanel;
import com.enderak.procol.client.gui.UserPanel;
import com.enderak.procol.common.gui.ButtonPanel;
import com.enderak.procol.common.gui.ProColProgressBar;
import com.enderak.procol.common.gui.RolloverOnOffButton;
import com.enderak.procol.common.net.ProColIncomingMessage;
import com.enderak.procol.common.net.ProColPacket;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.help.HelpViewer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.PluginOptions;

public class ProColPanel
extends JPanel
implements Observer {
    private static final int NUM_BARS = 2;
    private static final int PRIMARY = 0;
    private static final int SECONDARY = 1;
    public ProjectPanel projectPanel;
    public UserPanel userPanel;
    private ButtonPanel topButtonPanel;
    private JSplitPane projectSplitPane;
    private ProColProgressBar[] progressBar = new ProColProgressBar[2];
    private JPanel progressPanel = new JPanel();
    private int progressID;
    private int totalListenFor;
    private RolloverOnOffButton connectButton;
    private RolloverButton changeProjectButton;
    private RolloverButton optionsButton;
    private RolloverButton helpButton;
    private RolloverButton projectInfoButton;

    public ProColPanel(boolean bl) {
        this.setLayout(new BorderLayout());
        this.setAlignmentX(0.5f);
        this.topButtonPanel = new ButtonPanel(bl);
        this.projectPanel = new ProjectPanel(bl);
        this.userPanel = new UserPanel(bl);
        for (int i = 0; i < this.progressBar.length; ++i) {
            this.progressBar[i] = new ProColProgressBar();
        }
        if (bl) {
            this.projectSplitPane = new JSplitPane(0, true, this.projectPanel, this.userPanel);
            this.add((Component)this.topButtonPanel, "North");
            this.progressBar[0].setOrientation(0);
            this.progressBar[1].setOrientation(0);
            this.progressPanel.setLayout(new BorderLayout());
            this.progressPanel.add((Component)this.progressBar[0], "North");
            this.progressPanel.add((Component)this.progressBar[1], "South");
            this.progressBar[1].setVisible(false);
            this.add((Component)this.progressPanel, "South");
        } else {
            this.projectSplitPane = new JSplitPane(1, true, this.projectPanel, this.userPanel);
            this.add((Component)this.topButtonPanel, "West");
            this.progressBar[0].setOrientation(1);
            this.progressBar[1].setOrientation(1);
            this.progressPanel.setLayout(new BorderLayout());
            this.progressPanel.add((Component)this.progressBar[0], "East");
            this.progressPanel.add((Component)this.progressBar[1], "West");
            this.progressBar[1].setVisible(false);
            this.add((Component)this.progressPanel, "East");
        }
        this.projectSplitPane.setOneTouchExpandable(true);
        this.projectSplitPane.setResizeWeight(0.5);
        this.projectSplitPane.setDividerLocation(0.75);
        this.add((Component)this.projectSplitPane, "Center");
        this.connectButton = this.topButtonPanel.createRolloverOnOffButton("connect");
        this.connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProColPlugin.connectToServer();
            }
        });
        this.connectButton.setEnabled(true);
        this.topButtonPanel.createRigidSpace();
        this.projectInfoButton = this.topButtonPanel.createButton("projectinfo");
        this.projectInfoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProColPlugin.getProjectInfo();
            }
        });
        this.changeProjectButton = this.topButtonPanel.createButton("changeproject");
        this.changeProjectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProColPlugin.changeProject();
            }
        });
        this.topButtonPanel.createRigidSpace();
        this.optionsButton = this.topButtonPanel.createButton("options");
        this.optionsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new PluginOptions(JOptionPane.getFrameForComponent(ProColPanel.this), jEdit.getProperty((String)"options.procol.client.buttonopen"));
            }
        });
        this.optionsButton.setEnabled(true);
        this.helpButton = this.topButtonPanel.createButton("help");
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new HelpViewer(this.getClass().getResource(jEdit.getProperty((String)"plugin.com.enderak.procol.ProColPlugin.docs")));
            }
        });
        this.helpButton.setEnabled(true);
    }

    public void startProgress() {
        this.progressBar[0].startProgress();
    }

    public void startProgress(String string) {
        this.progressBar[0].startProgress(string);
    }

    public void stopProgress() {
        this.progressBar[0].stopProgress();
    }

    public void update(Observable observable, Object object) {
        if (object == null || object instanceof String && ((String)object).equals("CONNECTION")) {
            this.setConnected(ProColPlugin.getClient().isConnected() && ProColPlugin.getClient().isAuthenticated());
            this.projectPanel.setConnected(ProColPlugin.getClient().isConnected() && ProColPlugin.getClient().isAuthenticated());
            this.userPanel.setConnected(ProColPlugin.getClient().isConnected() && ProColPlugin.getClient().isAuthenticated());
        }
        if (object == null || object instanceof String && ((String)object).equals("USERLIST")) {
            this.userPanel.setUserList(ProColPlugin.getClient().getUserList());
        }
        if (object == null || object instanceof String && ((String)object).equals("PROJECT")) {
            this.projectPanel.setProject(ProColPlugin.getClient().getProject());
        }
        if (object instanceof ProColPacket) {
            this.updateProgress(0, (ProColPacket)object);
        }
        if (object instanceof ProColIncomingMessage) {
            ProColIncomingMessage proColIncomingMessage = (ProColIncomingMessage)object;
            if (proColIncomingMessage.requestCode == this.totalListenFor) {
                this.progressBar[1].incrementProgress();
                return;
            }
            switch (proColIncomingMessage.requestCode) {
                case 196865: {
                    this.progressBar[0].setProgress(0, "");
                    break;
                }
                case 197376: {
                    this.progressBar[0].setProgress(0, "");
                    break;
                }
            }
        }
    }

    public void setConnected(boolean bl) {
        this.connectButton.setOnOff(bl);
        this.changeProjectButton.setEnabled(bl);
        this.projectInfoButton.setEnabled(bl);
    }

    private void updateProgress(int n, ProColPacket proColPacket) {
        if (proColPacket.dataRemaining == proColPacket.dataSize) {
            if (proColPacket.messageID == this.progressID) {
                this.progressBar[n].stopProgress();
            }
        } else {
            if (proColPacket.messageID != this.progressID) {
                this.progressID = proColPacket.messageID;
                this.progressBar[n].startProgress(0, proColPacket.dataRemaining);
            }
            this.progressBar[n].incrementProgress(proColPacket.dataSize);
        }
    }

    private void startDownloadProgress(int n, int n2, String string) {
        this.progressBar[1].setVisible(true);
        this.progressBar[1].startProgress(0, n, string);
        this.totalListenFor = n2;
    }

    private void stopDownloadProgress() {
        this.progressBar[0].stopProgress();
        this.progressBar[1].setVisible(false);
        this.progressBar[1].stopProgress();
        this.totalListenFor = -1;
    }
}

