/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.client.gui;

import com.enderak.procol.ProColPlugin;
import com.enderak.procol.client.gui.GenericListPanel;
import com.enderak.procol.client.gui.PrivateMessageComposer;
import com.enderak.procol.client.model.PrivateMessage;
import com.enderak.procol.common.gui.ButtonPanel;
import com.enderak.procol.common.net.ProColIncomingMessage;
import com.enderak.procol.common.util.ProColUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Observable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class PrivateMessagePanel
extends GenericListPanel {
    protected static DefaultListModel listModel = new DefaultListModel();
    private RolloverButton newButton;
    private RolloverButton replyButton;
    private RolloverButton deleteButton;
    private Vector allUsers;

    public PrivateMessagePanel(View view, String string) {
        super(view, string, "privatemessages");
        listModel.clear();
        this.itemList.setModel(listModel);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = PrivateMessagePanel.this.itemList.locationToIndex(mouseEvent.getPoint());
                PrivateMessagePanel.this.itemList.setSelectedIndex(n);
                if (mouseEvent.getButton() == 3) {
                    new PrivateMessagePopupMenu((PrivateMessage)PrivateMessagePanel.this.itemList.getModel().getElementAt(n)).show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        this.itemList.addMouseListener(mouseAdapter);
        ButtonPanel buttonPanel = new ButtonPanel(this.isVerticalAlign);
        this.newButton = buttonPanel.createRolloverButton("privatemessages.new");
        this.newButton.addActionListener((ActionListener)this);
        this.replyButton = buttonPanel.createRolloverButton("privatemessages.reply");
        this.replyButton.addActionListener((ActionListener)this);
        buttonPanel.createRigidSpace();
        this.deleteButton = buttonPanel.createRolloverButton("privatemessages.delete");
        this.deleteButton.addActionListener((ActionListener)this);
        if (this.isVerticalAlign) {
            this.add((Component)buttonPanel, "North");
        } else {
            this.add((Component)buttonPanel, "West");
        }
        this.initNetworkCommunication();
    }

    public final void initNetworkCommunication() {
        if (ProColPlugin.getClient() != null && ProColPlugin.getClient().isConnected()) {
            ProColPlugin.getClient().getIMH().addObserver(this);
            listModel.addElement(jEdit.getProperty((String)"procol.client.privatemessages.gettinglistinfo"));
            ProColPlugin.getClient().getPacketFactory().addToQueue(262145, 2);
            this.newButton.setEnabled(true);
            this.allUsers = ProColPlugin.getClient().getUserList();
            ProColPlugin.getClient().getPacketFactory().addToQueue(65792, 2);
        }
    }

    public void stopNetworkCommunication() {
        if (ProColPlugin.getClient() != null && !ProColPlugin.getClient().isConnected()) {
            ProColPlugin.getClient().getIMH().deleteObserver(this);
            listModel.clear();
            this.newButton.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("privatemessages.new")) {
            new PrivateMessageComposer("null", "null", "(No Subject)", this.allUsers);
        } else if (string.equals("privatemessages.reply")) {
            new PrivateMessageComposer(((PrivateMessage)this.selectedItems[0]).index, ((PrivateMessage)this.selectedItems[0]).sender, "Re: " + ((PrivateMessage)this.selectedItems[0]).subject, this.allUsers);
        } else if (string.equals("privatemessages.delete")) {
            ProColPlugin.getClient().getPacketFactory().addToQueue(262150, ((PrivateMessage)this.selectedItems[0]).index, 2);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.selectedItems = this.itemList.getSelectedValues();
            if (this.selectedItems.length == 1) {
                ProColPlugin.getClient().getPacketFactory().addToQueue(262147, ((PrivateMessage)this.selectedItems[0]).index, 2);
                this.replyButton.setEnabled(true);
                this.deleteButton.setEnabled(true);
            } else if (this.selectedItems.length == 0) {
                this.replyButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
            }
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof ProColIncomingMessage) {
            ProColIncomingMessage proColIncomingMessage = (ProColIncomingMessage)object;
            switch (proColIncomingMessage.requestCode) {
                case 262144: {
                    ProColPlugin.getClient().getPacketFactory().addToQueue(262145, 2);
                    break;
                }
                case 262146: {
                    Properties properties = new Properties();
                    try {
                        properties.load(new ByteArrayInputStream(proColIncomingMessage.data));
                    }
                    catch (IOException iOException) {
                        System.out.println(iOException);
                    }
                    String string = properties.getProperty("current", "0");
                    listModel.clear();
                    while (!string.equals("0")) {
                        listModel.addElement(new PrivateMessage(string, properties.getProperty(string + ".date", "(No Date)"), properties.getProperty(string + ".subject", "(No Subject)"), properties.getProperty(string + ".sender", "(No Sender)")));
                        string = properties.getProperty(string + ".previous", "0");
                    }
                    if (!listModel.isEmpty()) break;
                    this.messageDisplayEditorPane.setText(jEdit.getProperty((String)"procol.client.privatemessages.nomessages"));
                    break;
                }
                case 262148: {
                    if (this.selectedItems.length != 1) break;
                    PrivateMessage privateMessage = (PrivateMessage)this.selectedItems[0];
                    this.messageDisplayEditorPane.setText("<font size=\"+1\"><b>" + privateMessage.subject + "</b></font><br><b>From: " + privateMessage.sender + "<br>" + privateMessage.date + "</b><hr>" + new String(proColIncomingMessage.data));
                    break;
                }
                case -268173072: {
                    break;
                }
                case -268173071: {
                    break;
                }
                case -268173070: {
                    break;
                }
                case 65792: {
                    this.allUsers = ProColUtils.dataStringToVector(proColIncomingMessage.data);
                    break;
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        ProColPlugin.getClient().getIMH().deleteObserver(this);
    }

    private class PrivateMessagePopupMenu
    extends JPopupMenu {
        private MenuHandler menuHandler = new MenuHandler();
        private PrivateMessage itemSelected;

        public PrivateMessagePopupMenu(PrivateMessage privateMessage) {
            this.itemSelected = privateMessage;
            this.add(this.createMenuItem("new"));
            this.add(this.createMenuItem("reply"));
            this.add(this.createMenuItem("delete"));
        }

        private JMenuItem createMenuItem(String string) {
            JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty((String)("procol.client." + string + ".label")));
            jMenuItem.setActionCommand(string);
            jMenuItem.addActionListener(this.menuHandler);
            return jMenuItem;
        }

        private class MenuHandler
        implements ActionListener {
            private MenuHandler() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("new")) {
                    new PrivateMessageComposer("null", "null", "(No Subject)", PrivateMessagePanel.this.allUsers);
                } else if (string.equals("reply")) {
                    new PrivateMessageComposer(((PrivateMessage)((PrivateMessagePopupMenu)PrivateMessagePopupMenu.this).PrivateMessagePanel.this.selectedItems[0]).index, ((PrivateMessage)((PrivateMessagePopupMenu)PrivateMessagePopupMenu.this).PrivateMessagePanel.this.selectedItems[0]).sender, "Re: " + ((PrivateMessage)((PrivateMessagePopupMenu)PrivateMessagePopupMenu.this).PrivateMessagePanel.this.selectedItems[0]).subject, PrivateMessagePanel.this.allUsers);
                } else if (string.equals("delete")) {
                    ProColPlugin.getClient().getPacketFactory().addToQueue(262150, ((PrivateMessage)((PrivateMessagePopupMenu)PrivateMessagePopupMenu.this).PrivateMessagePanel.this.selectedItems[0]).index, 2);
                }
            }
        }
    }
}

