/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.client.gui;

import com.enderak.procol.ProColPlugin;
import com.enderak.procol.common.net.ProColIncomingMessage;
import com.enderak.procol.common.util.ProColUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.jEdit;

public class JoinProjectFrame
extends JFrame {
    private JoinProjectPanel joinProjectPanel;

    public JoinProjectFrame() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.setTitle("Join Project");
        this.joinProjectPanel = new JoinProjectPanel(this);
        this.getContentPane().add(this.joinProjectPanel);
        this.setSize(400, 300);
        this.setLocation(dimension.width / 2 - this.getWidth() / 2, dimension.height / 2 - this.getHeight() / 2);
        this.setVisible(true);
    }

    public void dispose() {
        super.dispose();
        ProColPlugin.getClient().getIMH().deleteObserver(this.joinProjectPanel);
    }

    private class JoinProjectPanel
    extends JPanel
    implements Observer {
        private JSplitPane splitPane;
        private JEditorPane projectInfo;
        private JScrollPane infoScrollPane;
        private JList projectList;
        private JScrollPane listScrollPane;

        public JoinProjectPanel(JoinProjectFrame joinProjectFrame2) {
            ProColPlugin.getClient().getIMH().addObserver(this);
            this.setBorder(new TitledBorder(jEdit.getProperty((String)"procol.client.joinproject.title")));
            this.projectList = new JList();
            this.projectList.setSelectionMode(0);
            this.listScrollPane = new JScrollPane(this.projectList);
            ListSelectionListener listSelectionListener = new ListSelectionListener(this){
                private final /* synthetic */ JoinProjectPanel this$1;
                {
                    this.this$1 = joinProjectPanel;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        ProColPlugin.getClient().getProjectInfo((String)((JList)listSelectionEvent.getSource()).getSelectedValue());
                    }
                }
            };
            this.projectList.addListSelectionListener(listSelectionListener);
            this.projectInfo = new JEditorPane("text/html", jEdit.getProperty((String)"procol.client.joinproject.waiting"));
            this.projectInfo.setEditable(false);
            this.infoScrollPane = new JScrollPane(this.projectInfo);
            JButton jButton = new JButton(jEdit.getProperty((String)"procol.label.ok"));
            jButton.addActionListener(new ActionListener(this, joinProjectFrame2){
                private final /* synthetic */ JoinProjectFrame val$parentFrame;
                private final /* synthetic */ JoinProjectPanel this$1;
                {
                    this.this$1 = joinProjectPanel;
                    this.val$parentFrame = joinProjectFrame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (JoinProjectPanel.access$000(this.this$1).getSelectedValue() != null) {
                        ProColPlugin.getClient().joinProject((String)JoinProjectPanel.access$000(this.this$1).getSelectedValue());
                    } else {
                        ProColPlugin.getClient().joinProject((String)JoinProjectPanel.access$000(this.this$1).getModel().getElementAt(0));
                    }
                    this.val$parentFrame.dispose();
                }
            });
            JButton jButton2 = new JButton(jEdit.getProperty((String)"procol.label.cancel"));
            jButton2.addActionListener(new ActionListener(this, joinProjectFrame2){
                private final /* synthetic */ JoinProjectFrame val$parentFrame;
                private final /* synthetic */ JoinProjectPanel this$1;
                {
                    this.this$1 = joinProjectPanel;
                    this.val$parentFrame = joinProjectFrame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ProColPlugin.getClient().getProject() == null) {
                        ProColPlugin.getClient().disconnect();
                    }
                    this.val$parentFrame.dispose();
                }
            });
            this.setLayout(new BorderLayout());
            this.splitPane = new JSplitPane(1, true, this.listScrollPane, this.infoScrollPane);
            this.splitPane.setOneTouchExpandable(true);
            this.splitPane.setResizeWeight(0.5);
            this.add((Component)this.splitPane, "Center");
            this.splitPane.setDividerLocation(0.2);
            JPanel jPanel = new JPanel();
            jPanel.add((Component)jButton, "West");
            jPanel.add((Component)jButton2, "East");
            this.add((Component)jPanel, "South");
            ProColPlugin.getClient().getProjectList();
        }

        public void update(Observable observable, Object object) {
            ProColIncomingMessage proColIncomingMessage = (ProColIncomingMessage)object;
            if (proColIncomingMessage.requestCode == 131073) {
                this.projectList.setListData(ProColUtils.dataStringToVector(proColIncomingMessage.data));
                this.projectList.setSelectedIndex(0);
            } else if (proColIncomingMessage.requestCode == 131079) {
                this.projectInfo.setText(new String(proColIncomingMessage.data));
            }
        }

        static /* synthetic */ JList access$000(JoinProjectPanel joinProjectPanel) {
            return joinProjectPanel.projectList;
        }
    }
}

