/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.client.gui;

import com.enderak.procol.ProColPlugin;
import com.enderak.procol.client.gui.ProColClientDockable;
import com.enderak.procol.common.model.ProColFile;
import com.enderak.procol.common.net.ProColIncomingMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.gjt.sp.jedit.jEdit;

public class FileInfoFrame
extends JFrame {
    private FileInfoPanel panel;

    public FileInfoFrame(ProColFile proColFile) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.setTitle(jEdit.getProperty((String)"procol.client.fileinfo.title"));
        this.panel = new FileInfoPanel(this, proColFile);
        this.getContentPane().add(this.panel);
        this.setSize(500, 400);
        this.setLocation(dimension.width / 2 - this.getWidth() / 2, dimension.height / 2 - this.getHeight() / 2);
        this.setVisible(true);
    }

    public void dispose() {
        super.dispose();
        ProColPlugin.getClient().getIMH().deleteObserver(this.panel);
    }

    private class FileInfoPanel
    extends JPanel
    implements Observer {
        private JLabel checkedOutInfoLabel;
        private JPanel fileInfoPanel;
        private JPanel leftPanel;
        private JPanel rightPanel;
        private JEditorPane historyEditPane;
        private JScrollPane historyScrollPane;
        private ProColFile file;
        private URI projectFilesURI = ProColPlugin.getClient().getProject().getProjectFilesURI();

        public FileInfoPanel(FileInfoFrame fileInfoFrame2, ProColFile proColFile) {
            ProColPlugin.getClient().getIMH().addObserver(this);
            this.file = proColFile;
            this.setBorder(new TitledBorder(null, this.file.getName() + " v." + this.file.getVersion(), 0, 0, new Font("Dialog", 1, 16)));
            this.setLayout(new BorderLayout());
            JButton jButton = new JButton(jEdit.getProperty((String)"procol.label.ok"));
            jButton.addActionListener(new ActionListener(this, fileInfoFrame2){
                private final /* synthetic */ FileInfoFrame val$parentFrame;
                private final /* synthetic */ FileInfoPanel this$1;
                {
                    this.this$1 = fileInfoPanel;
                    this.val$parentFrame = fileInfoFrame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$parentFrame.dispose();
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.add((Component)jButton, "Center");
            this.leftPanel = new JPanel();
            this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 1));
            this.leftPanel.add(new JLabel(jEdit.getProperty((String)"procol.client.fileinfo.checkedout")));
            this.leftPanel.add(new JLabel(jEdit.getProperty((String)"procol.client.fileinfo.changelog")));
            this.rightPanel = new JPanel();
            this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 1));
            this.checkedOutInfoLabel = new JLabel(this.file.getOwner());
            this.rightPanel.add(this.checkedOutInfoLabel);
            this.rightPanel.add(new JLabel(""));
            this.fileInfoPanel = new JPanel();
            this.fileInfoPanel.setLayout(new BoxLayout(this.fileInfoPanel, 0));
            this.fileInfoPanel.add(this.leftPanel);
            this.fileInfoPanel.add(Box.createHorizontalStrut(10));
            this.fileInfoPanel.add(this.rightPanel);
            this.historyScrollPane = new JScrollPane();
            this.historyEditPane = new JEditorPane();
            this.historyEditPane.setContentType("text/html");
            this.historyEditPane.setText(jEdit.getProperty((String)"procol.client.fileinfo.gettinginfo"));
            this.historyEditPane.setEditable(false);
            this.historyScrollPane.setViewportView(this.historyEditPane);
            this.add((Component)this.fileInfoPanel, "North");
            this.add((Component)this.historyScrollPane, "Center");
            this.add((Component)jPanel, "South");
            ProColPlugin.getClient().getFileHistory(this.projectFilesURI.relativize(this.projectFilesURI.resolve(this.file.toURI())).toString());
        }

        public void update(Observable observable, Object object) {
            if (object instanceof ProColIncomingMessage) {
                ProColIncomingMessage proColIncomingMessage = (ProColIncomingMessage)object;
                if (proColIncomingMessage.requestCode == 198147) {
                    Properties properties = new Properties();
                    try {
                        properties.load(new ByteArrayInputStream(proColIncomingMessage.data));
                    }
                    catch (IOException iOException) {
                        ProColClientDockable.displayError(jEdit.getProperty((String)"procol.client.error.fileinfo.title"), jEdit.getProperty((String)"procol.client.error.fileinfo.propertyload"));
                    }
                    StringBuffer stringBuffer = new StringBuffer(proColIncomingMessage.data.length);
                    String string = properties.getProperty("current");
                    while (!string.equals("null")) {
                        stringBuffer.append("<font size=\"+1\"><b>").append(string).append("</b></font><br>");
                        stringBuffer.append("<b>").append(properties.getProperty(string + ".date")).append("</b>");
                        if (!properties.getProperty(string + ".user").equals("")) {
                            stringBuffer.append(" by: <b>").append(properties.getProperty(string + ".user")).append("</b>");
                        }
                        stringBuffer.append("<br>").append(properties.getProperty(string + ".changelog")).append("<br><br><br>");
                        string = properties.getProperty(string + ".previous");
                    }
                    this.historyEditPane.setText(stringBuffer.toString());
                }
            }
        }
    }
}

