unit DoubleLinkedList;

interface
type
// Setup the two linked lists which will store the raw & interpolated data
  TCSurveyRpt = class(TObject)    // Holds important data from a station
    public
    next,prev	: TCSurveyRpt;
    sMD      	: real;
    sTVD     	: real;
    oMD      	: real;
    oTVD     	: real;
    aziTN    	: real;
    aziHS    	: real;
    ctr2ctr 	: real;
    allowDev 	: real;
    constructor create;
    destructor  destroy; override;
  end;
  TCWell = CLASS(TObject)      //
  Next : TCWell;// Link to next well
	Head : TCSurveyRpt; 	// data goes on this list
	Tail : TCSurveyRpt; 	// Pointer to last station of Raw list
  Size : integer;
  Name : String;
 	constructor create;
	destructor destroy; override;
  function AddStation(Sender: TObject;
			sMD : real; sTVD : real; oMD : real; oTVD : real; aziTN : real;
     	aziHS : real; ctr2ctr : real; allowDev : real): boolean;
  end;

implementation

uses SysUtils;

type EDoubleLinkedStuff = class(Exception);
/////////////////////////////////////////////////////////////////////////////
///////// Standard Linked List creation and destruction functions ///////////
/////////////////////////////////////////////////////////////////////////////
constructor TCSurveyRpt.create;  {-- Create Node ---------------------------}
	begin
  	inherited create; next:=nil; prev:=nil;
		sMD 			:= 0.0;
    sTVD 		 	:= 0.0;
   	oMD 			:= 0.0;
    oTVD 			:= 0.0;
   	aziTN 		:= 0.0;
    aziHS 		:= 0.0;
    ctr2ctr 	:= 0.0;
    allowDev 	:= 0.0;
	end;
destructor TCSurveyRpt.destroy;  {--  Destroy Node -------------------------}
	begin
  	inherited destroy;
	end;
constructor TCWell.create;       {--  Create List --------------------------}
	begin
	  inherited create;
      Head := nil;
      Tail:= nil;
      Next := nil;
      name := '';
      Size := 0;
	end;
destructor TCWell.destroy;       {-- Destroy List --------------------------}
	var q:TCSurveyRpt;
	begin
		while Head <> nil do
	  begin
	  	q:=Head; Head := Head.next; q.destroy;
	  end;
	end;
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
function TCWell.AddStation(Sender: TObject;
    	sMD : real; sTVD : real; oMD : real; oTVD : real; aziTN : real;
      aziHS : real; ctr2ctr : real; allowDev : real): boolean;
{------------------------------------------------------------------------------
Adds a survey station
------------------------------------------------------------------------------}
var
	TmpSrvy : TCSurveyRpt;
begin
	TmpSrvy:=TCSurveyRpt.create();
  // link everything properly
  TmpSrvy.prev := self.Tail;
  if self.Head = nil then self.Head := TmpSrvy else self.Tail.next := TmpSrvy;
  self.Tail := TmpSrvy;
  self.Size := self.Size +1;
  // set values
  TmpSrvy.next := nil;
  TmpSrvy.sMD := sMD;
  TmpSrvy.sTVD := sTVD;
  TmpSrvy.oMD := oMD;
  TmpSrvy.oTVD := oTVD;
  TmpSrvy.aziTN := aziTN;
  TmpSrvy.aziHS := aziHS;
  TmpSrvy.ctr2ctr := ctr2ctr;
  TmpSrvy.allowDev := allowDev;
  result := true;
end;
/////////////////////////////////////////////////////////////////////////////

end.
