<!--- services_data.cfm v1.0 --->
<!--- 

Name: services_data.cfm
Version: 1.0
Purpose: I query the database for all services summary pages. I use up to two different
   URL variables to modify how I extract information from the database. If I receive the URL 
	variable mapNumber, I get a list of all the services on a particular map. If I receive the
	URL variable srv, I get a list of all services of that type, regardless of which map they 
	are on. If I receive no URL variables, I return all services on all maps. 

Input parameters:
->	[URL.mapNumber]
-> [URL.srv]

Dataset
   getServices
	
Created by: Edward Wickham
Email: ewickham@gci.net
Create date: 2004/04/10

Last Edited by:
Email:
Last Edit date

Version notes:

 --->
<cfif isDefined ("URL.mapNumber") and URL.mapNumber GT "1">
	
	<cfif findnocase('x',URL.mapNumber) gt 0>
		<cfset searchField = "summary_map_id">
	<cfelse>
	   <cfset searchField = "map_id">
	</cfif>
	
	<cfquery name="getMaps" datasource="uaa_sgt">
	  select description
	  from map_tab
	  where #searchField# = <cfqueryparam value="#URL.mapNumber#" cfsqltype="cf_sql_varchar">
	</cfquery>
	
	<!--- Get service information specific to this map --->
		<cfquery name="getServices" datasource="uaa_sgt">
		select distinct a.name, b.service_location_id, b.location_name as location, b.map_id   
		from services_tab a, service_location_tab b, map_tab c
		where a.service_abbr = b.service_abbr
		  and b.map_id = c.map_id
		  and c.#searchField# = <cfqueryparam value="#URL.mapNumber#" cfsqltype="cf_sql_varchar">
		order by name
		</cfquery>
<cfelseif isDefined("URL.srv")>
	<!--- Get information about this service on all maps --->
	<cfquery name="getServices" datasource="uaa_sgt" >
		select a.name, b.map_id, b.service_location_id, b.location_name as location
		from services_tab a, service_location_tab b
		where a.service_abbr = b.service_abbr
			and a.service_abbr = <cfqueryparam value="#URL.srv#" cfsqltype="cf_sql_varchar">
		order by name, location_name
	</cfquery>
<cfelse>
	<!--- Get information about all services --->
	<cfquery name="getServices" datasource="uaa_sgt" >
		select distinct name, lcase(a.service_abbr) as abbr
		from services_tab a
		order by name
	</cfquery>
</cfif>

