<!-- departments_data.cfm v1.0 -->
<!--- 
	Name: departments_data.cfm
	Version: 1.0
	Purpose: I query the database for all department specific pages.

Input parameters:
->	[URL.mapNumber]

Dataset
   getDepts
	
Created by: Edward Wickham
Email: ewickham@gci.net
Create date: 2004/04/06

Last Edited by:
Email:
Last Edit date

Version notes:

 --->
<cfif isDefined ("URL.mapNumber") and URL.mapnumber GT "1">

	<cfif findnocase('x',URL.mapNumber) gt 0>
		<cfset searchField = "summary_map_id">
	<cfelse>
	   <cfset searchField = "map_id">
	</cfif>
	
	<cfquery name="getMaps" datasource="uaa_sgt">
	  select description
	  from map_tab
	  where #searchField# = <cfqueryparam value="#URL.mapNumber#" cfsqltype="cf_sql_varchar">
	</cfquery>
	
	<!--- Get points of interest information specific to this map --->
		<cfquery name="getPOIs" datasource="uaa_sgt">
		select c.poi_id, c.name, c.description, a.description, 
				 b.name, b.building_abbr, b.bldg_map_no, a.map_id
		from building_tab b right join (map_tab a inner join poi_tab c on a.map_id = c.map_id) 
				 on b.building_abbr = c.building_abbr
		where a.#searchField# = <cfqueryparam value="#URL.mapNumber#" cfsqltype="cf_sql_varchar">
		order by c.name
		</cfquery>		
<cfelse>
	<!--- Get information about all buildings --->
	<cfquery name="getPOIs" datasource="uaa_sgt" >
		select c.poi_id, c.name, c.description, a.description, 
				 b.name, b.building_abbr, b.bldg_map_no, a.map_id
		from building_tab b right join (map_tab a inner join poi_tab c on a.map_id = c.map_id) 
				 on b.building_abbr = c.building_abbr
		order by c.name
	</cfquery>
</cfif>
