<!-- agHTTPHeaders.cfm v1.0 -->
<!--- 
This CustomTag processes the HTTP Header information present in each AvantGo server request. 
These values give information about OS, OS Version, color depth and resolution. We use this information to determine which graphics library and page templates to choose when rendering each page.

For the first Self Guided Tour version, we're interested in four values. The two of most importance are ScreenSize and Color-Depth. 
  X-AvantGo-ScreenSize: This is the maximum pixel height and width we can use for images and text
     layout. For higher resolution screens, we may wish to present different images and different
	  table layouts. 
  X-AvantGo-ColorDepth: The values indicate the number of bits of different colors or shades of 			     gray that can be rendered.
	  2: 4 bit grey scale
	  4: 16 bit grey scale
	  8: 256 bit color
	  16: 65,536 colors
  X-AvantGo-DeviceOS: The OS of the Device requesting the Data (Palm OS, WinCE, Symbian, etc.)
  X-AvantGo-DeviceOSVersion: The OS version. Different OS versions may have different rendering 
     capabilities that we may wish to take advantage of. For example, the AvantGo Browser for
	  Palm OS Version 5 supports a broader range of HTML and Javascript functions than 4.0 and
	  prior. 	  
	  
While the Header names are plain text, the actual values are Base64 encrypted by the AvantGo Server. To get a useful value, these values must be decrypted. To decrypt the encoded string, we must first convert the value to binary, and convert that value back to a string.

The header information is read into a key=value data structure by using the GetHttpRequestData() function. When the structure is queried with the key, the value returned is decrypted and stored in a local variable. The combination of local variables are then processed to determine which graphics gallery to use.

Extract and save as local variables:
 ColorDepth
 DeviceOSVersion
 DeviceOS
 UserID
 ScreenSize
 DeviceID
 
 We will use a ColdFusion Server Mapping for '#request.avantgo_home#/' to always find the 
 img directory, regardless of how deep we are in the application
--->

<cfset x = GetHttpRequestData()>

<cfscript>
avantGoParams = "X-AvantGo-DeviceOSVersion,X-AvantGo-DeviceOS,X-AvantGo-UserID,X-AvantGo-ScreenSize,X-AvantGo-ColorDepth,X-AvantGo-DeviceID";
</cfscript>

<cfloop collection="#x.headers#" item="http_item">
	<cfif ListFindNoCase(avantGoParams, http_item) gt 0>
		<cfset shortName = right(http_item, find("-", reverse(http_item)) - 1)>
		<cfset temp = SetVariable("Variables."&#shortName#, ToString(toBinary(StructFind(x.headers, http_item))))>	
	</cfif>
</cfloop>

<cfparam name="Variables.ColorDepth" default="16">
<cfparam name="Variables.ScreenSize" default="320X320">
<cfparam name="Variables.DeviceOS" default="PALM_OS">

<!--- Convert ScreenSize and ColorDepth to graphics directories --->
<cfswitch expression="#Variables.ColorDepth#">
	<cfcase value="4">
		<cfset variables.graphics_dir = "#request.avantgo_home#/img/4bit">
		<!--- ScreenSize assumed 150x150 --->
	</cfcase>
	<cfcase value="8">
		<cfset variables.graphics_dir = "#request.avantgo_home#/img/8bit">
		<!--- Screen size assumed 150x150 --->
	</cfcase>
	<cfcase value="16">
		<cfif Variables.ScreenSize EQ "320x320">
			<cfset variables.graphics_dir = "#request.avantgo_home#/img/16bit/320">
		<cfelse>
		  <!--- ScreenSize assumed "240x320" for PocketPC--->
			<cfset variables.graphics_dir = "#request.avantgo_home#/img/16bit/240">
		</cfif>
	</cfcase>
	<cfdefaultcase>
		<!--- default to 4 bit grey scale (16 shades) --->
		<cfset variables.graphics_dir = "#request.avantgo_home#/img/4bit">
	</cfdefaultcase>
</cfswitch>



