<?php



include_once("sys_include.inc.php");

include_once("jpGraph/jpgraph.php");

include_once("jpGraph/jpgraph_scatter.php");



if(isset($_GET['assignmentID']))  //this is an assignment scattergram

{

	$grades = get_assignment_grades($_GET['assignmentID']);

	$graph_title = "Assignment Scattergram";

}

elseif(isset($_GET['courseID']))  //this is a course scattergram

{

	$grades = get_course_grades($_GET['courseID']);

	$graph_title = "Course Scattergram";

}



array_multisort($grades);  //put the grades in ascending order

$grade_count = count($grades);

$datay = array_values($grades);  //no x-scale is needed

//max-min used to set scale

$max_score = $datay[$grade_count - 1];

$min_score = $datay[0];

$total = array_sum($datay);  //used to calculate the average



$mean = number_format(($total/$grade_count), 1);

$x_pos = $grade_count - 1;

//show student's grade on graph

if(isset($_GET['highlight']))

{   

    $my_grade = $_GET['highlight'];

    $y_pos = $my_grade;

    //set color based on whether student's score is above or below the mean

    if($_GET['highlight'] > $mean)

    {

        $line_color = "green";

        $text_color = "darkgreen";

    }

    else

    {

       $line_color = "red";

       $text_color = "darkred";

    }

    $highlight_line = new PlotLine(HORIZONTAL, $my_grade, $line_color, 2);

    $highlight_label = new Text("Your score: " . $my_grade);

    $highlight_label->SetScalePos($x_pos, $y_pos);

    $highlight_label->SetColor($text_color);

}

//create the graph--automatically create cache names

$graph = new Graph(600,400,"auto");

$graph->SetScale("textlin", $min_score, $max_score);

//line indicating average score position

$mean_line = new PlotLine(HORIZONTAL, $mean, "yellow", 2);

$graph->img->SetMargin(60,110,40,40);

//add a drop shadow       

$graph->SetShadow();

$graph->xaxis->HideLabels();

$graph->SetMarginColor("lightblue");

$mean_label = new Text("Average: " . $mean);

$mean_label->SetColor('#918E00'); //slightly darker yellow



$mean_label->SetScalePos($x_pos, $mean);

//set titles

$graph->title->Set($graph_title);

$graph->yaxis->title->Set("Score");

$graph->yaxis->SetTitleMargin(40);

//set fonts

$graph->title->SetFont(FF_FONT1,FS_BOLD);

$graph->yaxis->title->SetFont(FF_FONT1,FS_BOLD);

$mean_label->SetFont(FF_FONT1,FS_BOLD);

//create the scatter

$sp1 = new ScatterPlot($datay);

$sp1->mark->SetType(MARK_FILLEDCIRCLE);

$sp1->mark->SetFillColor("blue");

$sp1->mark->SetWidth(8);

//add all the elements to the graph

$graph->Add($sp1);

$graph->Add($mean_line);

$graph->Add($mean_label);

if($highlight_line)

{

    $graph->Add($highlight_line);

    $graph->Add($highlight_label);

}

//draw the graph

$graph->Stroke();

?>

