<?PHP

include("sys_include.inc.php");



session_start();

//internal navigation

if(isset($_GET['assignmentID']))

{

	$_SESSION['assignmentID'] = $_GET['assignmentID'];

	header("Location:  assignment_details.php");

}

if(isset($_GET['studentID']))

{

	$_SESSION['studentID'] = $_GET['studentID'];

	header("Location:  student_details.php");

}

if(isset($_GET['delete']))

{

	remove_course($_SESSION['courseID']);

	header("Location:  faculty_home.php");

}

if(isset($_GET['classStats']))

{

	$_SESSION['viewedAs'] = "faculty";

	header("Location:  class_stats.php");

}

//existing course clicked by user from home page

if(isset($_SESSION['courseID'])) 

{

	$course_id = $_SESSION['courseID'];

	$grade_scheme = get_scheme($course_id);

	

	if(isset($_GET['editCourse'])) $done_with_course = false;

	else {

		$done_with_course = true;

		if(isset($_POST['doneWithCourse']))

		{

			$edit_course = true;

			include("validate_course.php");			

		}

	}

	if(isset($_GET['editScheme']) || isset($_POST['addType']))

	{

		$done_with_scheme = false;

		if(isset($_POST['addType']))

		{

			$grade_scheme = capture_scheme($_POST, false);

		}

	}

	else {

		$done_with_scheme = true;

		if(isset($_POST['doneWithScheme']))

		{

			$edit_scheme = true;

			include("validate_scheme.php");

			if($scheme_error)

			{

				$done_with_scheme = false;

				$grade_scheme = capture_scheme($_POST, true);

			}

			else $grade_scheme = get_scheme($course_id);		

		}

	}

	if(isset($_GET['addStudents']) || isset($_POST['addStudent']))

	{

		$done_with_students = false;

		//add the student to the course

		if(isset($_POST['addStudent']))

		{

			extract($_POST);	

			if (trim($_POST['username']) <> "") 

			{

				add_student($course_id, $username, $ldap);

			}

		}

	}

	else $done_with_students = true;

	if(isset($_GET['addAssignments']) || isset($_POST['addAssignment']))

	{

		$done_with_assignments = false;

		if(isset($_POST['addAssignment']))

		{

			$is_new = true;

			include("validate_assignment.php");

		}

	}

	else $done_with_assignments = true;

}

//Setup a new course

else

{	//user has finished entering course details

	if(isset($_POST['doneWithCourse'])) 

	{

		$done_with_course = true;

		$new_course = true;

		include("validate_course.php");

		$_SESSION['courseID'] = $course_id;

		$grade_scheme = get_scheme($course_id);

		$done_with_assignments = true;

		$done_with_students = true;

	}

	else //initial load from clicking 'Add Course' link from faculty_home

	{

		$done_with_course = false;

		$done_with_scheme = true;

		$done_with_students = true;

		$done_with_assignments = true;

	}

	

}

$course_details = get_course_details($course_id);

$page_title = $course_details['course_prefix'] . " " . $course_details['course_number'];



include("header.inc.php");



//the javascript is for popup confirmation on deletes

echo"		<script language=JavaScript>

			<!--

				function GP_popupConfirmMsg(msg) { //v1.0

				document.MM_returnValue = confirm(msg);

				}

			//-->

			</script>";



echo"<P></P><P>Click here to view statistics on <B>Course Grades</B><LI><A HREF=course_details.php?classStats=true>Course Statistics</LI></A></RIGHT></P>";

echo"

	<P></P><P>Click a student to <B>remove</B> or <B>veiw</B> a student's information or grades.</P>

	<P></P><P>Click an assignment's title to <B>veiw</B> or <B>change</B> an assignments's information or grades.</P>

	<P></P><P>Click <B>Add Assignment</B> to create new assignments for this course.</P>";

?>

</TD>

<TD>

	<TABLE width="100%">

		<TR>

			<TD width="50%" valign="top">

				<?PHP 

					include("course_table.php");

				?>

			</TD>

			<TD bgcolor="Blue" width="5"></TD>

			<TD valign="top">

				<?PHP

					include("grading_scheme.php");

				?>

			</TD>

		</TR>

		<TR>

			<?PHP

				if(!$done_with_course) echo"<TD></TD>";

				else echo"<TD align=center><A HREF=course_details.php?editCourse=1><B>Change Details</B></A></TD>";

				echo"<TD bgcolor=Blue width=2></TD>";

				if(!$done_with_scheme) echo"<TD></TD>";

				else echo"<TD align=center><A HREF=course_details.php?editScheme=1><B>Change Grading Scheme</B></A></TD>";

			?>

		</TR>

		<TR>

			<TD colspan="3" bgcolor="Blue" height="5"></TD>

		</TR>

		<TR>

			<TD valign="top">

				<?PHP

					include("student_list.php");

				?>

			</TD>

			<TD bgcolor="Blue" width="2"></TD>

			<TD valign="top">

				<?PHP

					include("assignment_list.php");

					if($done_with_assignments && $done_with_course && $done_with_scheme && $done_with_students)

					{

						echo"<TR><TD colspan=3 align=center height=40 valign=bottom><A HREF=course_details.php?delete=true onclick=\"GP_popupConfirmMsg('This course will be PERMENANTLY Deleted. \\r\\r All associated data will be lost. ');return document.MM_returnValue\"><H3>Remove this course</H3></A></TD></TR>";

					}

				?>

</TABLE>

<?PHP

    include("footer.inc.php");

?>



	

