<?PHP

session_start();

include("sys_include.inc.php");

$course_id = $_SESSION['courseID'];

$course_details = get_course_details($course_id);

$grades = get_course_grades($course_id);

$page_title = get_course_string($course_id) . " Statistics";

include("header.inc.php");

//determine the origination so appropriate 'back' link can be displayed

if($_SESSION['viewedAs'] == "student")

{

	echo "<LI><a href=student_course_details.php>Back to <B>" . get_course_string($course_id) . "</B></a></LI>";

	

}

else 

{

	echo "<LI><a href=course_details.php>Back to <B>" . get_course_string($course_id) . "</B></a></LI>";

}

?>



</TD>

<TD>

	<TABLE border="1" width="100%">

		<TR>

    		<TD width="50%" align="center">

    			<?PHP 

    				//disable edit links for details

					$student_only = true;

    				include("course_table.php");

    				if($_SESSION['viewedAs'] == "student")

					{	//highlight student grade

					    $my_grade = $grades[$_SESSION['userID']];

					    echo"<BR><CENTER><B>Your Overall Grade:  ";

					    if($my_grade == "") echo "<FONT COLOR=YELLOW>Pending</FONT>";

					    else echo $my_grade;

					    echo " %</B></CENTER></BR>";

					}	

    			?>

    		</TD>

    		<TD colspan="2" align="center">

        		<?PHP

        		    if($grades) echo"<IMAGE SRC=\"histogram.php?courseID=$course_id&large=true\"></IMAGE>";

        		?>

    		</TD>

		</TR>

		<TR>			

			<TD align="center">

				<TABLE>

					<TR>

						<TD colspan=2 align=center valign=top><H2>Course Statistics:</H2></TD>

					</TR>	

	<?PHP

	   if($grades)

	   {		

	   		$my_grade = $grades[$_SESSION['userID']];

			array_multisort($grades);

			$grade_count = count($grades);

			$total = array_sum($grades);

			$stats['low'] = $grades[0];

			$stats['high'] = $grades[$grade_count - 1];

			$stats['median'] = $grades[floor($grade_count/2)];

			$stats['mean'] = number_format(($total/$grade_count), 1);

			foreach ($grades as $key => $value)

			{

				$delta_square += pow(($value - $total/count($grades)), 2);

			}

			if($grade_count > 1)

			{

				$std_dev = sqrt($delta_square / ($grade_count - 1)); 

				$stats['std_dev'] = number_format($std_dev, 2);

			}

			else $stats['std_dev'] = "Need more data.";

			echo"	 <TR><TD><B>Number of Grades:</B></TD><TD>$grade_count</TD></TR>

					 <TR><TD><B>Total Possible Points:</B></TD><TD>" . get_course_max_points($course_id) . "</TD></TR>

					 <TR><TD><B>High Score:</B></TD><TD>" . $stats['high'] . " %</TD></TR>

					 <TR><TD><B>Low Score:</B></TD><TD>" . $stats['low'] . " %</TD></TR>

					 <TR><TD><B>Average Score:</B></TD><TD>" . $stats['mean'] . " %</TD></TR>

					 <TR><TD><B>Median Score:</B></TD><TD>" . $stats['median'] . " %</TD></TR>

					 <TR><TD><B>Standard Deviation:</B></TD><TD>" . $stats['std_dev'] . "</TD></TR>

				</TABLE>

			   </TD>	

			   <TD colspan=2 align=center>";

			if($grade_count > 1)

		    {

		        if($_SESSION['viewedAs'] == "student") echo"<IMAGE SRC=\"scatter.php?courseID=$course_id&highlight=$my_grade\"></IMAGE>";

				else echo" <IMAGE SRC=\"scatter.php?courseID=$course_id\"></IMAGE>";

		    }

		    else echo"<CENTER><B>Not enough grades for a scattergram.</CENTER>";			

			echo"</TD></TR>";

	   }

	   else 

	   {

	       echo"<TR><TD><CENTER><H3>No Grades have been loaded yet.</H3></CENTER></TD></TR></TABLE>";

	   }

	   

	?>

		</TABLE>

	

</TD>

<?PHP

    include("footer.inc.php");

?>