<?PHP

session_start();



include("sys_include.inc.php");

$assignment_id = $_SESSION['assignmentID'];

$assignment_details = get_assignment_details($assignment_id);

$course_id = $assignment_details['course_id'];

$grades = get_assignment_grades($assignment_id);

$page_title = $assignment_details['title'] . " Statistics";



include("header.inc.php");



if($_SESSION['viewedAs'] == "faculty")

{

	echo "<LI><a href=course_details.php>Back to <B>" . get_course_string($course_id) . "</B></a></LI>";

	echo "<LI><a href=assignment_details.php>Back to <B>" . $assignment_details['title'] . "</B></a></LI>";

}

else

{

	echo "<LI><a href=student_course_details.php>Back to <B>" . get_course_string($course_id) . "</B></a></LI>";

}

		

if(!$grades)

{

    echo"</TD><TD><CENTER><B><H2>No Grades Loaded for " . $assignment_details['title'];

    exit();

}

	

?>



</TD>

<TD>

	<TABLE border="1" width="100%">

		<TR>

		  <TD align="center">

			<TABLE border="0">

				<TR>

					<TD colspan="2" valign="top"><H3>Assignment Details:</H3></TD>

				</TR>

			<?PHP

				echo"<TR><TD width=30><B>Course:</B></TD><TD>" . get_course_string($course_id) . "</TD></TR>

					 <TR><TD><B>Title:</B></TD><TD>" . $assignment_details['title'] . "</TD></TR>

					 <TR><TD><B>Date Added:</B></TD><TD>" . $assignment_details['date_added'] . "</TD></TR>

					 <TR><TD><B>Date Due:</B></TD><TD>" . $assignment_details['date_due'] . "</TD></TR>

					 <TR><TD><B>Category:</B></TD><TD>" . $assignment_details['type'] . "</TD></TR>

					 <TR><TD><B>Points Possible:</B></TD><TD>" . $assignment_details['points_possible'] . "</TD></TR>

				  </TABLE>";

				if($_SESSION['viewedAs'] == "student")

				{

				    $my_grade = $grades[$_SESSION['userID']];

				    echo"<BR><CENTER><B>Your Score:  ";

				    if($my_grade == "") echo "<FONT COLOR=YELLOW>Pending</FONT>";

				    else echo $my_grade;

				    echo "</B></CENTER></BR>";

				}	

			?>

		  </TD>

		  <TD colspan="2" align="center">

		<?PHP

			echo"<IMAGE SRC=\"histogram.php?assignmentID=$assignment_id&large=true\"></IMAGE>";

		?>

			</TD>

			</TR>

		<TR>

			

			<TD align="center">

				<TABLE border="0">

					<TR>

						<TD colspan="2" valign="top"><H3>Assignment Statistics:</H3></TD>

					</TR>

				<?

				array_multisort($grades);

				$grade_count = count($grades);

				$stats['low'] = $grades[0];

				$stats['high'] = $grades[$grade_count - 1];

				$stats['median'] = $grades[floor(($grade_count)/2)];

				foreach ($grades as $key => $value)

				{

					$grade_square[$key] = pow($value, 2);

					$total += $value;

				}

				$stats['mean'] = number_format(($total/count($grades)), 2);

				$std_dev = sqrt(array_sum($grade_square) / $grade_count - pow((array_sum($grades) / $grade_count), 2)); 

				$stats['std_dev'] = number_format($std_dev, 2);

					

				echo"<TR><TD><B>Number of Scores:</B></TD><TD>" . count($grades) . "</TD></TR>

					 <TR><TD><B>High Score:</B></TD><TD>" . $stats['high'] . "</TD></TR>

					 <TR><TD><B>Low Score:</B></TD><TD>" . $stats['low'] . "</TD></TR>

					 <TR><TD><B>Average Score:</B></TD><TD>" . $stats['mean'] . "</TD></TR>

					 <TR><TD><B>Median Score:</B></TD><TD>" . $stats['median'] . "</TD></TR>

					 <TR><TD><B>Standard Deviation:</B></TD><TD>" . $stats['std_dev'] . "</TD></TR>";

				?>

				</TABLE>

			</TD>	

			<TD colspan="2" align="center">

		<?PHP

		    if($grade_count > 1)

		    {

		    	

		        if($_SESSION['viewedAs'] == "student") echo"<IMAGE SRC=\"scatter.php?assignmentID=$assignment_id&highlight=$my_grade\"></IMAGE>";

		        else echo"<IMAGE SRC=\"scatter.php?assignmentID=$assignment_id\"></IMAGE>";

		    }

		    else echo"<CENTER><B>Not enough grades for a scattergram.</CENTER>";

		?>

			</TD>

		</TR>

	</TABLE>

</TD>

<?PHP

    include("footer.inc.php");

?>