<?PHP

include("sys_include.inc.php");

session_start();

//user clicked a student name

if(isset($_GET['studentID']))

{	//store the studentID 

	$_SESSION['studentID'] = $_GET['studentID'];

	header("Location:  student_details.php");

}

$course_id = $_SESSION['courseID'];

$assignment_id = $_SESSION['assignmentID'];

$assignment_details = get_assignment_details($assignment_id);

$max_points = $assignment_details['points_possible'];

$grades = get_assignment_grades($assignment_id);

$done_with_assignment = true;

//user clicked the graph

if(isset($_GET['viewStats']))

{

	$_SESSION['viewedAs'] = "faculty";

	header("Location:  assignment_stats.php");

}

//user clicked the button to update the scores

if(isset($_POST['submit']))

{

	include("validate_grades.php");

}

//user clicked the link to remove this assignment

if(isset($_GET['delete']))

{

	remove_assignment($assignment_id);

	header("Location:  course_details.php");

}

//user clicked the link to edit the details

if(isset($_GET['edit']))

{

	$done_with_assignment = false;

}

//user is done editing the details

if(isset($_POST['doneWithAssignment']))

{

	$is_edit = true;

	include("validate_assignment.php");

	$done_with_assignment = true;

	//get the updated details

	$assignment_details = get_assignment_details($assignment_id);

	$max_points = $assignment_details['points_possible'];

	//make sure the scores are still valid if max points changed

	include("validate_grades.php");

}

$page_title = $assignment_details['title'];

include("header.inc.php");



$done_with_scheme = true; //this keeps the details in non-edit state

$grade_scheme = get_scheme($course_id);

$students = get_students($course_id);

$grades = get_assignment_grades($assignment_id);



echo "<LI><a href=course_details.php>Back to <B>" . get_course_string($course_id) . "</B></a></LI>";

//the javascript is for delete confirmations

?>

<script language="JavaScript">

<!--

	function GP_popupConfirmMsg(msg) { //v1.0

	document.MM_returnValue = confirm(msg);

	}

//-->

</script>



<P></P><P>Click the name of a <B>Student</B> to view <B>Student Grades</B></P>

<P></P><P>You can enter or change any of the grades for this assignment.  Click <B>Update</B> when finished.</P>

<P></P><P>Click the <B>graph</B> to view <B>Assignment Statistics</B>

		  (Available only when grades are loaded)</P>

</TD>

<TD>

	<TABLE border="1" width="100%">

		<TR>

			<TD width="50%" align="center">

				<TABLE border="0">

					<TR>

						<TD colspan="2" valign="top"><H2>Assignment Details:</H2></TD>

					</TR>

				<?PHP

					include("assignment_table.php");

				?></TABLE>

			</TD>	

			<TD valign="top">

				<?PHP

					include("grading_scheme.php");

				?>

			</TD>

		</TR>

		<TR>

			<TD align="center" valign="top">

				<?PHP

					if($students)

					{

						

						include("assignment_grades.php");

					}

					else echo"<H3>No students loaded</H3>";

				?>

			</TD>

			<TD align="center" valign="top">

				<CENTER><P><H2>Statistics:</H2></P></CENTER>

				<?PHP

					//make sure there are scores before creating the small histogram

					if($data = get_assignment_data($assignment_id))

					{

						echo"<A HREF=assignment_details.php?viewStats=true><IMAGE SRC=\"histogram.php?assignmentID=$assignment_id\"></IMAGE></A>";

					}

					$data = get_assignment_data($assignment_id);

				?>

			</TD>

		</TR>

		<TR><TD colspan="2" align="center">

				<?PHP

					echo"<A HREF=assignment_details.php?delete=1 onclick=\"GP_popupConfirmMsg('This assignment will be PERMENANTLY Deleted. \\r\\r You will lose any grades associated with it.');return document.MM_returnValue\"><H3>Remove this assignment</H3></A>";

				?>

		</TR>

	</TABLE>

</TD>



<?PHP

    include("footer.inc.php");

?>