class Forum < ActiveRecord::Base
	#Relational
	belongs_to :family
	belongs_to :software
	
	validates_length_of :name, :within => 1..40
	validates_uniqueness_of :name, :message => "already exists"
	
	def self.find_search_flagged
	  find_all("search_flag = 1", "name")
	end
	def self.find_search_unflagged
	  find_all("search_flag = 0", "name")
	end
end
