/*
 * MainWindow.java
 *
 * Created on April 27, 2005, 4:22 PM
 */

package terrain;

import javax.swing.JFileChooser;
import java.io.File;
import javax.swing.JFrame;
/**
 *
 * @author  Cliff
 */
public class MainWindow extends javax.swing.JFrame {
    public final static int PANEL_INDEX = 1;
    /** Creates new form MainWindow */
    public MainWindow() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        status = new javax.swing.JLabel();
        topMenu = new javax.swing.JMenuBar();
        fileMenu = new javax.swing.JMenu();
        saveJPG = new javax.swing.JMenuItem();
        genMenu = new javax.swing.JMenu();
        rag = new javax.swing.JMenuItem();
        dsg = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Terrain Generation");
        setBackground(new java.awt.Color(102, 102, 255));
        status.setBackground(new java.awt.Color(153, 255, 153));
        status.setText("Choose a type of generation from the the generation menu");
        getContentPane().add(status, java.awt.BorderLayout.SOUTH);

        topMenu.setBackground(new java.awt.Color(153, 255, 153));
        fileMenu.setText("File");
        saveJPG.setText("Save Image as JPG");
        saveJPG.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveJPGActionPerformed(evt);
            }
        });

        fileMenu.add(saveJPG);

        topMenu.add(fileMenu);

        genMenu.setText("Generation");
        rag.setText("Random Averaging");
        rag.setToolTipText("The results of random averaging may not be gorgeous, but the surfaces created make very interesting looking textures.");
        rag.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ragActionPerformed(evt);
            }
        });

        genMenu.add(rag);

        dsg.setText("Diamond Square");
        dsg.setToolTipText("The Diamond Square algorithm creates very realistic looking terrain.  Can also be used to make clouds.");
        dsg.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dsgActionPerformed(evt);
            }
        });

        genMenu.add(dsg);

        topMenu.add(genMenu);

        setJMenuBar(topMenu);

        pack();
    }//GEN-END:initComponents
    
    private void saveJPGActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveJPGActionPerformed
        if(getContentPane().getComponentCount()>1){
            try {
                ImagePanel iPanel = (ImagePanel)getContentPane().getComponent(1);
                JFileChooser chooser = new JFileChooser(new File(".").getCanonicalPath());//start the fileChooser with working directory, hopefully the user doesn't have to navigate to find the file.
                
                int returnVal = chooser.showSaveDialog(new JFrame());//this was swiped from the java.sun.com/API page... seemed useful.
                if(returnVal == JFileChooser.APPROVE_OPTION) {
                    String saveFileName = chooser.getSelectedFile().toString();//gets the file the user selected
                    HeightMap.writeJPG(iPanel.getImage(), saveFileName);
                } 
            } catch (Exception e)  {
                e.printStackTrace();
            }
        }
    }//GEN-LAST:event_saveJPGActionPerformed
    
    private void dsgActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dsgActionPerformed
        if(getContentPane().getComponentCount() > 0)
            getContentPane().removeAll();
        getContentPane().add(new DSPanel(), java.awt.BorderLayout.CENTER);
        this.pack();
    }//GEN-LAST:event_dsgActionPerformed
    
    private void ragActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ragActionPerformed
        if(getContentPane().getComponentCount() > 0)
            getContentPane().removeAll();
        getContentPane().add(new RAPanel(), java.awt.BorderLayout.CENTER);
        this.pack();
    }//GEN-LAST:event_ragActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new MainWindow().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem dsg;
    private javax.swing.JMenu fileMenu;
    private javax.swing.JMenu genMenu;
    private javax.swing.JMenuItem rag;
    private javax.swing.JMenuItem saveJPG;
    private javax.swing.JLabel status;
    private javax.swing.JMenuBar topMenu;
    // End of variables declaration//GEN-END:variables
    
}
