/*
 * ImagePanel.java
 *
 * Created on April 27, 2005, 4:50 PM
 */
package terrain;

import javax.swing.JPanel;
import javax.swing.JFrame;
import java.awt.image.BufferedImage;
import java.awt.Graphics;

/**
 *
 * @author  Cliff
 */
public class ImagePanel extends javax.swing.JPanel {
    
    private BufferedImage image;
    
    public void setImage(BufferedImage bi) {
        image = bi;
        this.setPreferredSize(new java.awt.Dimension(image.getWidth(), image.getHeight()));
        repaint();
    }
    
    public BufferedImage getImage() {
        return image;
    }
    
    public void paint(Graphics g) {
        if (image != null)
            g.drawImage(image, 0,0,this.getSize().width,this.getSize().height, this);
    }
    
    public static void main(String[] args)	{
        JFrame frame1 = new JFrame();
        ImagePanel imagePanel = new ImagePanel();
        imagePanel.setImage( HeightMap.makeBufferedImage(DiamondSquare.DS(2000, 0, 255, 513, 513)));
        frame1.add(imagePanel);
        frame1.setBounds(new java.awt.Rectangle(0,0,800,600));
        frame1.setVisible(true);
    }
    /** Creates new form ImagePanel */
    public ImagePanel() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        
        setLayout(new java.awt.BorderLayout());
        
    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    
}
