/*
 * Decompiled with CFR 0.152.
 */
package terrain;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import terrain.DSPanel;
import terrain.HeightMap;
import terrain.ImagePanel;
import terrain.RAPanel;

public class MainWindow
extends JFrame {
    public static final int PANEL_INDEX = 1;
    private JMenuItem dsg;
    private JMenu fileMenu;
    private JMenu genMenu;
    private JMenuItem rag;
    private JMenuItem saveJPG;
    private JLabel status;
    private JMenuBar topMenu;

    public MainWindow() {
        this.initComponents();
    }

    private void initComponents() {
        this.status = new JLabel();
        this.topMenu = new JMenuBar();
        this.fileMenu = new JMenu();
        this.saveJPG = new JMenuItem();
        this.genMenu = new JMenu();
        this.rag = new JMenuItem();
        this.dsg = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Terrain Generation");
        this.setBackground(new Color(102, 102, 255));
        this.status.setBackground(new Color(153, 255, 153));
        this.status.setText("Choose a type of generation from the the generation menu");
        this.getContentPane().add((Component)this.status, "South");
        this.topMenu.setBackground(new Color(153, 255, 153));
        this.fileMenu.setText("File");
        this.saveJPG.setText("Save Image as JPG");
        this.saveJPG.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.saveJPGActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveJPG);
        this.topMenu.add(this.fileMenu);
        this.genMenu.setText("Generation");
        this.rag.setText("Random Averaging");
        this.rag.setToolTipText("The results of random averaging may not be gorgeous, but the surfaces created make very interesting looking textures.");
        this.rag.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.ragActionPerformed(evt);
            }
        });
        this.genMenu.add(this.rag);
        this.dsg.setText("Diamond Square");
        this.dsg.setToolTipText("The Diamond Square algorithm creates very realistic looking terrain.  Can also be used to make clouds.");
        this.dsg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.dsgActionPerformed(evt);
            }
        });
        this.genMenu.add(this.dsg);
        this.topMenu.add(this.genMenu);
        this.setJMenuBar(this.topMenu);
        this.pack();
    }

    private void saveJPGActionPerformed(ActionEvent evt) {
        if (this.getContentPane().getComponentCount() > 1) {
            try {
                ImagePanel iPanel = (ImagePanel)this.getContentPane().getComponent(1);
                JFileChooser chooser = new JFileChooser(new File(".").getCanonicalPath());
                int returnVal = chooser.showSaveDialog(new JFrame());
                if (returnVal == 0) {
                    String saveFileName = chooser.getSelectedFile().toString();
                    HeightMap.writeJPG(iPanel.getImage(), saveFileName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void dsgActionPerformed(ActionEvent evt) {
        if (this.getContentPane().getComponentCount() > 0) {
            this.getContentPane().removeAll();
        }
        this.getContentPane().add((Component)new DSPanel(), "Center");
        this.pack();
    }

    private void ragActionPerformed(ActionEvent evt) {
        if (this.getContentPane().getComponentCount() > 0) {
            this.getContentPane().removeAll();
        }
        this.getContentPane().add((Component)new RAPanel(), "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MainWindow().setVisible(true);
            }
        });
    }
}

