/*
 * Decompiled with CFR 0.152.
 */
package terrain;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class HeightMap {
    public static int[][] fit(int[][] array, int minDesiredHeight, int maxDesiredHeight) {
        int xSize = array.length;
        int ySize = array[0].length;
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        int num = 0;
        for (int i = 0; i < ySize; ++i) {
            for (int j = 0; j < xSize; ++j) {
                num = array[i][j];
                if (num < min) {
                    min = num;
                }
                if (num <= max) continue;
                max = num;
            }
        }
        double scale = (double)(maxDesiredHeight - minDesiredHeight) / (double)(max - min);
        for (int i = 0; i < ySize; ++i) {
            for (int j = 0; j < xSize; ++j) {
                array[i][j] = (int)((double)(array[i][j] - min + minDesiredHeight) * scale);
            }
        }
        return array;
    }

    public static void writeJPG(int[][] array, String fileName) {
        int xSize = array.length;
        int ySize = array[0].length;
        BufferedImage image = new BufferedImage(xSize, ySize, 1);
        int temp = 0;
        for (int j = 0; j < ySize; ++j) {
            for (int i = 0; i < xSize; ++i) {
                temp = array[i][j];
                int temp2 = temp << 24 | temp << 16 | temp << 8 | temp;
                image.setRGB(i, j, temp2);
            }
        }
        try {
            ImageIO.write((RenderedImage)image, "jpg", new File(fileName + ".jpg"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeJPG(BufferedImage image, String fileName) {
        try {
            ImageIO.write((RenderedImage)image, "jpg", new File(fileName + ".jpg"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static BufferedImage makeBufferedImage(int[][] array) {
        int xSize = array.length;
        int ySize = array[0].length;
        BufferedImage image = new BufferedImage(xSize, ySize, 1);
        int temp = 0;
        for (int j = 0; j < ySize; ++j) {
            for (int i = 0; i < xSize; ++i) {
                temp = array[i][j];
                int temp2 = temp << 24 | temp << 16 | temp << 8 | temp;
                image.setRGB(i, j, temp2);
            }
        }
        return image;
    }
}

