/*
 * Decompiled with CFR 0.152.
 */
package terrain;

import terrain.HeightMap;

public class DiamondSquare {
    public static int[][] DS(int max_variation, int min_height, int max_height, int xSize, int ySize) {
        if (xSize != ySize) {
            System.out.println("xSize, the size of the heightmap in the x direction, and ySize, the size of the heightmap in the y direction must be identical.  They also must be a power of 2 + 1");
            System.exit(1);
        }
        int temp = xSize;
        --temp;
        while (temp != 1 && temp % 2 == 0) {
            temp /= 2;
        }
        if (temp != 1) {
            System.out.println("The dimensions of the array must a power of 2 + 1");
            System.exit(1);
        }
        int[][] array = new int[xSize][ySize];
        int maximumDifference = max_variation;
        array[array.length - 1][array[0].length - 1] = (int)(Math.random() * 256.0);
        array[0][0] = (int)(Math.random() * 256.0);
        array[0][array[0].length - 1] = (int)(Math.random() * 256.0);
        array[array.length - 1][0] = (int)(Math.random() * 256.0);
        for (int i = 1; i <= (int)(Math.log(array.length - 1) / Math.log(2.0)); ++i) {
            int iterationNumber = i;
            int widthOfSubsquare = (xSize - 1) / (int)Math.pow(2.0, iterationNumber - 1);
            int halfSubsquare = widthOfSubsquare / 2;
            int startX = 0;
            if (Math.pow(2.0, iterationNumber) > (double)xSize) {
                System.out.println("Can't do " + iterationNumber + " steps with a square size " + xSize);
                continue;
            }
            for (int startY = 0; startY < ySize - 1; startY += widthOfSubsquare) {
                while (startX < xSize - 1) {
                    array[startX + halfSubsquare][startY + halfSubsquare] = (array[startX][startY] + array[startX + widthOfSubsquare][startY] + array[startX][startY + widthOfSubsquare] + array[startX + widthOfSubsquare][startY + widthOfSubsquare]) / 4;
                    int[] nArray = array[startX + halfSubsquare];
                    int n = startY + halfSubsquare;
                    nArray[n] = (int)((double)nArray[n] + (Math.random() * (double)maximumDifference * 2.0 - (double)maximumDifference) / Math.pow(2.0, iterationNumber));
                    array[startX + halfSubsquare][startY] = (array[startX][startY] + array[startX + widthOfSubsquare][startY]) / 2;
                    array[startX][startY + halfSubsquare] = (array[startX][startY] + array[startX][startY + widthOfSubsquare]) / 2;
                    array[startX + widthOfSubsquare][startY + halfSubsquare] = (array[startX + widthOfSubsquare][startY] + array[startX + widthOfSubsquare][startY + widthOfSubsquare]) / 2;
                    array[startX + halfSubsquare][startY + widthOfSubsquare] = (array[startX][startY + widthOfSubsquare] + array[startX + widthOfSubsquare][startY + widthOfSubsquare]) / 2;
                    int[] nArray2 = array[startX + halfSubsquare];
                    int n2 = startY;
                    nArray2[n2] = (int)((double)nArray2[n2] + (Math.random() * (double)maximumDifference * 2.0 - (double)maximumDifference) / Math.pow(2.0, iterationNumber));
                    int[] nArray3 = array[startX];
                    int n3 = startY + halfSubsquare;
                    nArray3[n3] = (int)((double)nArray3[n3] + (Math.random() * (double)maximumDifference * 2.0 - (double)maximumDifference) / Math.pow(2.0, iterationNumber));
                    int[] nArray4 = array[startX + widthOfSubsquare];
                    int n4 = startY + halfSubsquare;
                    nArray4[n4] = (int)((double)nArray4[n4] + (Math.random() * (double)maximumDifference * 2.0 - (double)maximumDifference) / Math.pow(2.0, iterationNumber));
                    int[] nArray5 = array[startX + halfSubsquare];
                    int n5 = startY + widthOfSubsquare;
                    nArray5[n5] = (int)((double)nArray5[n5] + (Math.random() * (double)maximumDifference * 2.0 - (double)maximumDifference) / Math.pow(2.0, iterationNumber));
                    startX += widthOfSubsquare;
                }
                startX = 0;
            }
        }
        array = HeightMap.fit(array, min_height, max_height);
        return array;
    }

    public static void main(String[] args) {
        HeightMap.writeJPG(DiamondSquare.DS(2000, 0, 255, 513, 513), "DiamondSquare513");
    }
}

