#if !defined(AFX_WAVELETSETTINGS_H__5D0E2279_39AA_4493_A170_173B612A2F22__INCLUDED_)
#define AFX_WAVELETSETTINGS_H__5D0E2279_39AA_4493_A170_173B612A2F22__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// WaveletSettings.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CWaveletSettings dialog

class CWaveletSettings : public CDialog
{
// Construction
public:
	CWaveletSettings(CWnd* pParent = NULL);   // standard constructor

	void CWaveletTransform(double *Y, int width, int height);
	void CWaveletInverseTransform(double *Y[], int width, int height, int imageCount);
	void CWaveletInverseTransformGA(double *Y[], double *originalY[], int width, int height, int imageCount);
	void CQuantizeCoefficients(double *Y, int width, int height, int stepsize, int threshold);
	void CDequantizeCoefficients(double *Y, int width, int height, int stepsize);
	void CWaveletInverseTransformTarget (double *Y[], int width, int height, int imageCount);
	void CInitializeGH(void);
	void CWaveletCoEvolvedInverseTransformGA (double *Y[], double *originalY[], int width, int height, int imageCount, double *parentY, double *parentOriginalY, int parentWidth, int parentHeight);

	// Dialog Data
	//{{AFX_DATA(CWaveletSettings)
	enum { IDD = 130 };
	CString	m_wavelettype;
	int 	m_mrlevel;
	int 	m_stepsize;
	int 	m_threshold;

	int		m_popsize;
	int		m_maxgen;
	BOOL	m_evolving;
	BOOL	m_showresults;
	//}}AFX_DATA

	int m_waveletnumber;

	//h, g lengths. Note that hlen always equals glen (in this incarnation), and they apply to both forward and inverse transforms
	short hlen;
	short glen;

	//h1,g1 for forward transform
	double *h1;
	double *g1;
	//h2,h2 for inverse transform
	double *h2;
	double *g2;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWaveletSettings)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CWaveletSettings)
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_WAVELETSETTINGS_H__5D0E2279_39AA_4493_A170_173B612A2F22__INCLUDED_)
