// Results.cpp : implementation file
//

#include "stdafx.h"
#include "GAwavelet.h"
#include "Results.h"
#include "math.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CResults dialog


CResults::CResults(CWnd* pParent /*=NULL*/)
	: CDialog(CResults::IDD, pParent)
{
	//{{AFX_DATA_INIT(CResults)
	m_compratio = 0.0;
	m_compsize = 0;
	m_height = 0;
	m_mse = 0.0;
	m_origsize = 0;
	m_psnr = 0.0;
	m_width = 0;
	m_minutes = 0;
	m_seconds = 0;
	//}}AFX_DATA_INIT
}


void CResults::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CResults)
	DDX_Text(pDX, IDC_COMPRATIO, m_compratio);
	DDX_Text(pDX, IDC_COMPSIZE, m_compsize);
	DDX_Text(pDX, IDC_HEIGHT, m_height);
	DDX_Text(pDX, IDC_MSE, m_mse);
	DDX_Text(pDX, IDC_ORIGSIZE, m_origsize);
	DDX_Text(pDX, IDC_PSNR, m_psnr);
	DDX_Text(pDX, IDC_WIDTH, m_width);
	DDX_Text(pDX, IDC_MINUTES, m_minutes);
	DDX_Text(pDX, IDC_SECONDS, m_seconds);
	//}}AFX_DATA_MAP
}

void CResults::CComputeResults(unsigned char *image, unsigned char *image2, int width, int height, double *mse, double *PSNR)
{
	int x;

	// calculate the mse and psnr
	if((image!=NULL)&&(image2!=NULL))
	{
		m_mse = 0;
		for(x=0;x<width*height*3;x++)
			m_mse += ((double)image[x]-(double)image2[x])*((double)image[x]-(double)image2[x]);
		m_mse = m_mse/((double)(3*width*height));

		m_psnr = 20*log10((double)255/sqrt(m_mse));
	}
	else
	{
		m_mse = -1;
		m_psnr = -1;
	}
	*mse = m_mse;
	*PSNR = m_psnr;
}

BEGIN_MESSAGE_MAP(CResults, CDialog)
	//{{AFX_MSG_MAP(CResults)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CResults message handlers
