// GAwavelet.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "GAwavelet.h"

#include "MainFrm.h"
#include "GAwaveletDoc.h"
#include "GAwaveletView.h"

#include "Readfile.h"
#include "FileOpen.h"
#include "DIB.h"
#include "WaveletSettings.h"
#include "encode.h"
#include "Results.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

HWND imghandle;

double *Y[maxImageCount];
double *U[maxImageCount];
double *V[maxImageCount];

double *originalY[maxImageCount];
double *originalU[maxImageCount];
double *originalV[maxImageCount];


char originalFileName[256];

unsigned char *image = NULL;
unsigned char *originalimage = NULL;
double stretch;

int SEARCH_ITERATIONS = 25;

//necessitates same-dimension images to be loaded
//poor design
int width = 0;
int height = 0;
int compsize;
int imageCount = 0;

// Initialize wavelet settings
int mrlevels = 3;
int stepsize = 0;
int threshold = 0;
BOOL showresults = TRUE;

int maxgen = 50;
int popsize = 500;
int evolving = 1;

CString wavelettype;
int waveletnumber = 0;

//CWaveletSettings object used to maintain transform state
CWaveletSettings theWavelet = new CWaveletSettings(NULL);

// Boolean flag records whether a transform is memory-resident and ready for use
BOOL transformLoaded = FALSE;

//variables needed for coevolution against super image
//extension would be to make this more robust

double *parentY;
double *parentU;
double *parentV;
double *parentOriginalY;
unsigned char *parentImage = NULL;
int parentWidth = 0;
int parentHeight = 0;
BOOL parentLoaded = FALSE;


/////////////////////////////////////////////////////////////////////////////
// CGAwaveletApp

BEGIN_MESSAGE_MAP(CGAwaveletApp, CWinApp)
	//{{AFX_MSG_MAP(CGAwaveletApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_OPEN, OnOpen)
	ON_COMMAND(ID_SAVE, OnSave)
	ON_COMMAND(ID_SETTINGS, OnSettings)
	ON_COMMAND(ID_RETURNORIGINAL, OnReturnOriginal)
	//Handles event where user selects Save Current Transform option
	ON_COMMAND(ID_SAVETRANSFORM, OnSaveTransform)
	//Handles event where user selects Load Transform option
	ON_COMMAND(ID_LOADTRANSFORM, OnLoadTransform)
	//Handles event where user selects Evolve Transform option
	ON_COMMAND(ID_EVOLVETRANSFORM, OnEvolveTransform)
	//Handles event where user selects Apply Current Transform option
	ON_COMMAND(ID_APPLYTRANSFORM, OnApplyTransform)
	//Handles event where user selects Search Current Image option 1
	ON_COMMAND(ID_SEARCHIMAGEY1, OnSearchImageY1)
	//Handles event where user selects Search Current Image option 2
	ON_COMMAND(ID_SEARCHIMAGEY2, OnSearchImageY2)
	//Handles event where user selects Search Current Image option 3
	ON_COMMAND(ID_SEARCHIMAGEYUV1, OnSearchImageYUV1)
	//Handles event where user selects Search Current Image option 4
	ON_COMMAND(ID_SEARCHIMAGEYUV2, OnSearchImageYUV2)
	//Handles event where user selects Load Parent Image option
	ON_COMMAND(ID_LOADPARENTIMAGE, OnLoadParentImage)
	//Handles event where user selects Co-Evolve With Parent
	ON_COMMAND(ID_COEVOLVE, OnCoEvolve)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGAwaveletApp construction

CGAwaveletApp::CGAwaveletApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CGAwaveletApp object

CGAwaveletApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CGAwaveletApp initialization

BOOL CGAwaveletApp::InitInstance()
{
	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CGAwaveletDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CGAwaveletView));
	AddDocTemplate(pDocTemplate);

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The one and only window has been initialized, so show and update it.
	m_pMainWnd->ShowWindow(SW_SHOW);
	m_pMainWnd->UpdateWindow();

	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// OnLoadParentImage()
// Method contains logic to load a parent
// image (that is, a differently-sized
// image containing a desired subimage for
// later use in genetically evolving a search
// transform)

void CGAwaveletApp::OnLoadParentImage()
{
	CFileOpen open;
	char FileName[256];
	char FileTitle[256];
	char FileExt[10];
	FILE *fh;

	if(open.GetFileName(0,"*.bmp\n*.bmp\n*.ppm\n*.ppm\n*.wvf\n*.wvf\n",FileTitle,FileName,FileExt))
	{
		fh = fopen(FileTitle,"rb");
		if(strcmp(FileExt,".bmp\0")==0)
		{
			// Read BMP File
			if(parentImage != NULL)
				delete[] parentImage;
			parentImage = BMPFileRead(fh,&parentWidth,&parentHeight);

			parentY = new double[parentWidth*parentHeight];
			parentOriginalY = new double[parentWidth*parentHeight];
			parentU = new double[(parentWidth>>1)*(parentHeight>>1)];
			parentV = new double[(parentWidth>>1)*(parentHeight>>1)];

			// Convert Color to Luminance
			rgb_to_yuv(parentImage,parentY,parentU,parentV,parentWidth,parentHeight);
			memcpy(parentOriginalY, parentY, parentWidth*parentHeight*sizeof(double));
		}
		else
		{
			MessageBox(NULL,"Unable to Read File","File Read ERROR",MB_ICONQUESTION);
			return;
		}

		fclose(fh);

		// Mark parent image as loaded
		parentLoaded = TRUE;
		// We don't display the parent image after loading, so spawn a dialog to indicate success
		MessageBox(NULL,"Parent Image Successfully Loaded","File Read Success!",MB_ICONQUESTION);
	}

	return;
}

// App command to open a file
void CGAwaveletApp::OnOpen()
{
	CFileOpen open;

	char FileName[256];
	char FileTitle[256];
	char FileExt[10];
	FILE *fh;
	HWND hWnd;
	RECT rect;

	// Get the window handle
	hWnd = GetActiveWindow();
	imghandle = GetWindow(hWnd,GW_CHILD);

	if(open.GetFileName(0,"*.bmp\n*.bmp\n*.ppm\n*.ppm\n*.wvf\n*.wvf\n",FileTitle,FileName,FileExt))
	{
		fh = fopen(FileTitle,"rb");
		if(strcmp(FileExt,".bmp\0")==0)
		{
			// Read BMP File
			if(image != NULL)
				delete[] image;
			image = BMPFileRead(fh,&width,&height);

			Y[imageCount] = new double[width*height];
			originalY[imageCount] = new double[width*height];
			U[imageCount] = new double[(width>>1)*(height>>1)];
			originalU[imageCount] = new double[(width>>1)*(height>>1)];
			V[imageCount] = new double[(width>>1)*(height>>1)];
			originalV[imageCount] = new double[(width>>1)*(height>>1)];

			// Create Space for originalimage component
			if(originalimage != NULL)
				delete[] originalimage;
			originalimage = new unsigned char[width*height*3];

			// Convert Color to Luminance
			rgb_to_yuv(image,Y[imageCount],U[imageCount],V[imageCount],width,height);
			rgb_to_yuv(image,originalY[imageCount],originalU[imageCount],originalV[imageCount],width,height);

			//Seems superfluous...
			// Convert Luminance to color
			yuv_to_rgb(Y[imageCount],U[imageCount],V[imageCount],image,width,height);

			// copy into originalimage buffer
			memcpy(originalimage,image,width*height*3*sizeof(char));
		}
		else
		{
			MessageBox(NULL,"Unable to Read File","File Read ERROR",MB_ICONQUESTION);
			return;
		}

		fclose(fh);
		
		//why do this again?
		// Convert Luminance to color for display
		 yuv_to_rgb(Y[imageCount], U[imageCount], V[imageCount], image, width, height);
		 if(originalimage != NULL)
		 {
			 yuv_to_rgb(Y[imageCount], U[imageCount], V[imageCount], originalimage, width, height);
			 strcpy(originalFileName,FileName);
		 }


		// display window
		GetWindowRect(hWnd,&rect);
		stretch = 1;
		if(width > 270)
		{
			MoveWindow(hWnd, rect.left, rect.top, 
			width+12, height+95, TRUE);
		}
		else
		{
			MoveWindow(hWnd, rect.left, rect.top, 
			270+12, (int)(height*stretch)+95, TRUE);
		}

		// Dislay File Name on Window;
		SetWindowText(hWnd,FileName);

		// Load image onto window
		displayimage(image,width,height,imghandle,stretch);

		// Increment image count since another image has been loaded and transformed
		imageCount++;
	}
}



//OnSave seems to add two bytes to an image
//another bug???

// App command to save a file
void CGAwaveletApp::OnSave()
{
	CFileOpen open;
	char FileName[256];
	char FileTitle[256];
	char FileExt[10];
	FILE *fh;
	HWND hWnd;

	// Get the window handle
	hWnd = GetActiveWindow();

	if (imageCount == 0)
	{
		MessageBox(NULL,"No image is loaded to save!","File Save ERROR",MB_ICONEXCLAMATION);
		return;
	}

	if(open.GetFileName(1,"*.bmp\n*.bmp\n*.ppm\n*.ppm\n",FileTitle,FileName,FileExt))
	{
		fh = fopen(FileTitle,"wb");
		if(strcmp(FileExt,".bmp\0")==0)
		{
			yuv_to_rgb(Y[imageCount-1], U[imageCount-1], V[imageCount-1], image, width, height);
			BMPFileWrite(fh,image,width,height);
		}
		else
		{
			MessageBox(NULL,"You must input the proper file extension","File Write ERROR",MB_ICONEXCLAMATION);
			return;
		}
		fclose(fh);
		// Dislay File Name on Window;
		SetWindowText(hWnd,FileName);
	}
}


//OnSaveTransform()
//Saves current transforms to user-specified file

void CGAwaveletApp::OnSaveTransform()
{
	CFileOpen open;
	char FileName[256];
	char FileTitle[256];
	char FileExt[10];
	FILE *fh;
	int i = 0;

	//make sure a transform is loaded
	if (!transformLoaded)
	{
		MessageBox(NULL,"No transform is loaded to save!","File Save ERROR",MB_ICONEXCLAMATION);
		return;
	}
	//select the file to which we save
	else if(open.GetFileName(1,"*.ewt\n*.ewt\n",FileTitle,FileName,FileExt))
	{
		//if the improper extension is present, forcibly append it
		if(strcmp(FileExt,".ewt\0")!=0)
		{
			while(FileTitle[i] != '\0' && i < 251)
				i++;
			FileTitle[i] = '.';
			FileTitle[i+1] = 'e';
			FileTitle[i+2] = 'w';
			FileTitle[i+3] = 't';
			FileTitle[i+4] = '\0';
		}
		
		//write the contents of glen, hlen, g1, h1, g2, h2 to the file.

		fh = fopen(FileTitle,"wb");
		fwrite( &theWavelet.glen, sizeof( short ), 1, fh );
		fwrite( &theWavelet.hlen, sizeof( short ), 1, fh );
		fwrite( theWavelet.g1, sizeof( double ), theWavelet.glen, fh );
		fwrite( theWavelet.h1, sizeof( double ), theWavelet.hlen, fh );
		fwrite( theWavelet.g2, sizeof( double ), theWavelet.glen, fh );
		fwrite( theWavelet.h2, sizeof( double ), theWavelet.hlen, fh );
		fclose(fh);
	}
}

//OnLoadTransform()
//Loads transforms from a file into g, h

void CGAwaveletApp::OnLoadTransform()
{
	CFileOpen open;
	char FileName[256];
	char FileTitle[256];
	char FileExt[10];
	FILE *fh;
	int i = 0;

	//choose the file from which to load transforms
	if(open.GetFileName(0,"*.ewt\n*.ewt\n",FileTitle,FileName,FileExt))
	{
		fh = fopen(FileTitle,"rb");

		//check for proper extension
		if(strcmp(FileExt,".ewt\0")==0)
		{
			delete[] theWavelet.g1;
			delete[] theWavelet.h1;
			delete[] theWavelet.g2;
			delete[] theWavelet.h2;
			fread(&theWavelet.glen, sizeof ( short ), 1, fh);
			fread(&theWavelet.hlen, sizeof ( short ), 1, fh);
			theWavelet.g1 = new double[theWavelet.glen];
			theWavelet.h1 = new double[theWavelet.hlen];
			theWavelet.g2 = new double[theWavelet.glen];
			theWavelet.h2 = new double[theWavelet.hlen];
			fread(theWavelet.g1, sizeof ( double ), theWavelet.glen, fh);
			fread(theWavelet.h1, sizeof ( double ), theWavelet.hlen, fh);
			fread(theWavelet.g2, sizeof ( double ), theWavelet.glen, fh);
			fread(theWavelet.h2, sizeof ( double ), theWavelet.hlen, fh);
		}
		else
		{
			MessageBox(NULL,"Unable to Read File","File Read ERROR",MB_ICONQUESTION);
			fclose(fh);
			return;
		}
		fclose(fh);

		//set transform type to Custom, and note that it's loaded
		transformLoaded = TRUE;
		theWavelet.m_waveletnumber = 6;
	}
}

//OnCoEvolve()
//Logic for Co-Evolve With Parent option

void CGAwaveletApp::OnCoEvolve()
{
	CResults results;
	double mse = 0.0, psnr = 0.0;
	int beforetime, aftertime, i;

	//check that everything is loaded which should be
	
	if(imageCount <= 0)
	{
		MessageBox(NULL,"Search image must be loaded in order to train wavelet transform","Transform Evolution Error",MB_ICONEXCLAMATION);
		return;
	}
	if(theWavelet.m_waveletnumber == 6 && !transformLoaded)
	{
		MessageBox(NULL,"Transform must be loaded from file (no manual input at this time) in order to evolve based on custom wavelet","Transform Evolution Error",MB_ICONEXCLAMATION);
		return;
	}
	if(!transformLoaded)
	{
		MessageBox(NULL,"No transform loaded to evolve!","Transform Evolution Error",MB_ICONEXCLAMATION);
		return;
	}
	if(!parentLoaded)
	{
		MessageBox(NULL,"No parent-image loaded to coevolve with!","Transform Evolution Error",MB_ICONEXCLAMATION);
		return;
	}

	beforetime = GetTickCount();

		//transform and quantize all the subimages

		for (i = 0; i < imageCount; i++)
		{
			theWavelet.CWaveletTransform(U[i],width>>1,height>>1);
			theWavelet.CWaveletTransform(V[i],width>>1,height>>1);
			theWavelet.CWaveletTransform(Y[i],width,height);

			theWavelet.CQuantizeCoefficients(Y[i],width,height,stepsize,threshold);
			theWavelet.CQuantizeCoefficients(U[i],width>>1,height>>1,stepsize,threshold);
			theWavelet.CQuantizeCoefficients(V[i],width>>1,height>>1,stepsize,threshold);

			theWavelet.CDequantizeCoefficients(Y[i],width,height,stepsize);
			theWavelet.CDequantizeCoefficients(U[i],width>>1,height>>1,stepsize);
			theWavelet.CDequantizeCoefficients(V[i],width>>1,height>>1,stepsize);
		}

		//transform and quantize the parent image

		theWavelet.CWaveletTransform(parentY, parentWidth, parentHeight);
		theWavelet.CQuantizeCoefficients(parentY, parentWidth, parentHeight, stepsize, threshold);
		theWavelet.CDequantizeCoefficients(parentY, parentWidth, parentHeight, stepsize);

		//run the GA

		theWavelet.CWaveletCoEvolvedInverseTransformGA(Y,originalY,width,height,imageCount, parentY, parentOriginalY, parentWidth, parentHeight);

		//restore the original YUVs
		for(i = 0; i < imageCount; i++)
		{
			memcpy(Y[i],originalY[i],width*height*sizeof(double));
			memcpy(U[i],originalU[i],(width>>1)*(height>>1)*sizeof(double));
			memcpy(V[i],originalV[i],(width>>1)*(height>>1)*sizeof(double));
		}
		memcpy(parentY, parentOriginalY, parentWidth*parentHeight*sizeof(double));

		//set to Custom, and loaded
		transformLoaded = TRUE;
		theWavelet.m_waveletnumber = 6;

	//compute results

	aftertime = GetTickCount();
	results.m_minutes = (int)((aftertime-beforetime)/(1000*60));
	results.m_seconds = (int)((aftertime-beforetime)-(results.m_minutes*60*1000))/1000;
	results.m_width = width;
	results.m_height = height;
	results.m_origsize = width*height*3;
	//these are dummy results - we're not interested in them anyway
	results.m_compsize = 0;
	results.m_compratio = 0;

	//problem showing results box...
	if(showresults == TRUE)
		results.DoModal();
	else
		MessageBox(NULL,"Evolution Complete","Done...",MB_ICONEXCLAMATION);

	return;
}

//OnEvolveTransform()
//Logic for Evolve Transform option

void CGAwaveletApp::OnEvolveTransform()
{
	CResults results;
	double mse = 0.0, psnr = 0.0;
	int beforetime, aftertime, i;

	//check that everything is loaded which should be
	
	if(imageCount <= 0)
	{
		MessageBox(NULL,"Search image must be loaded in order to train wavelet transform","Transform Evolution Error",MB_ICONEXCLAMATION);
		return;
	}
	if(theWavelet.m_waveletnumber == 6 && !transformLoaded)
	{
		MessageBox(NULL,"Transform must be loaded from file (no manual input at this time) in order to evolve based on custom wavelet","Transform Evolution Error",MB_ICONEXCLAMATION);
		return;
	}
	if(!transformLoaded)
	{
		MessageBox(NULL,"No transform loaded to evolve!","Transform Evolution Error",MB_ICONEXCLAMATION);
		return;
	}


		beforetime = GetTickCount();

		//transform and quantize all the images

		for (i = 0; i < imageCount; i++)
		{
			theWavelet.CWaveletTransform(U[i],width>>1,height>>1);
			theWavelet.CWaveletTransform(V[i],width>>1,height>>1);
			theWavelet.CWaveletTransform(Y[i],width,height);

			theWavelet.CQuantizeCoefficients(Y[i],width,height,stepsize,threshold);
			theWavelet.CQuantizeCoefficients(U[i],width>>1,height>>1,stepsize,threshold);
			theWavelet.CQuantizeCoefficients(V[i],width>>1,height>>1,stepsize,threshold);

			theWavelet.CDequantizeCoefficients(Y[i],width,height,stepsize);
			theWavelet.CDequantizeCoefficients(U[i],width>>1,height>>1,stepsize);
			theWavelet.CDequantizeCoefficients(V[i],width>>1,height>>1,stepsize);
		}

		//run the GA

		theWavelet.CWaveletInverseTransformGA(Y,originalY,width,height,imageCount);

		//restore the original pictures
		for(i = 0; i < imageCount; i++)
		{
			memcpy(Y[i],originalY[i],width*height*sizeof(double));
			memcpy(U[i],originalU[i],(width>>1)*(height>>1)*sizeof(double));
			memcpy(V[i],originalV[i],(width>>1)*(height>>1)*sizeof(double));
		}

		//set to Custom, and loaded
		transformLoaded = TRUE;
		theWavelet.m_waveletnumber = 6;

	//compute the results

	aftertime = GetTickCount();
	results.m_minutes = (int)((aftertime-beforetime)/(1000*60));
	results.m_seconds = (int)((aftertime-beforetime)-(results.m_minutes*60*1000))/1000;
	results.m_width = width;
	results.m_height = height;
	results.m_origsize = width*height*3;

	//these are dummy results - we're not interested in them anyway
	
	results.m_compsize = 0;
	results.m_compratio = 0;

	if(showresults == TRUE)
		results.DoModal();
	else
		MessageBox(NULL,"Evolution Complete","Done...",MB_ICONEXCLAMATION);
}


//OnApplyTransform()
//Logic for Apply Current Transform option

void CGAwaveletApp::OnApplyTransform()
{
	CResults results;
	HWND hWnd;
	double mse, psnr;
	int beforetime, aftertime;
	
	// Get the window handle
	hWnd = GetActiveWindow();

	//check that everything is loaded

	if(imageCount <= 0)
	{
		MessageBox(NULL,"No image is loaded to transform!","File Save ERROR",MB_ICONEXCLAMATION);
		return;
	}
	if(!transformLoaded)
	{
		MessageBox(NULL,"No transform loaded!","File Save ERROR",MB_ICONEXCLAMATION);
		return;
	}

		beforetime = GetTickCount();

		//apply the forward transform

		theWavelet.CWaveletTransform(U[imageCount - 1],width>>1,height>>1);
		theWavelet.CWaveletTransform(V[imageCount - 1],width>>1,height>>1);
		theWavelet.CWaveletTransform(Y[imageCount - 1],width,height);

		//quantize the data

		theWavelet.CQuantizeCoefficients(Y[imageCount - 1],width,height,stepsize,threshold);
		theWavelet.CQuantizeCoefficients(U[imageCount - 1],width>>1,height>>1,stepsize,threshold);
		theWavelet.CQuantizeCoefficients(V[imageCount - 1],width>>1,height>>1,stepsize,threshold);

		//dequantize the data

		theWavelet.CDequantizeCoefficients(Y[imageCount - 1],width,height,stepsize);
		theWavelet.CDequantizeCoefficients(U[imageCount - 1],width>>1,height>>1,stepsize);
		theWavelet.CDequantizeCoefficients(V[imageCount - 1],width>>1,height>>1,stepsize);

		//apply the inverse transform

		theWavelet.CWaveletInverseTransformTarget(Y,width,height, imageCount);
		theWavelet.CWaveletInverseTransformTarget(U,width>>1,height>>1,imageCount);
		theWavelet.CWaveletInverseTransformTarget(V,width>>1,height>>1,imageCount);


	// Convert Luminance to color for display
	yuv_to_rgb(Y[imageCount-1], U[imageCount-1], V[imageCount-1], image, width, height);

	//compute results

	aftertime = GetTickCount();
	results.m_minutes = (int)((aftertime-beforetime)/(1000*60));
	results.m_seconds = (int)((aftertime-beforetime)-(results.m_minutes*60*1000))/1000;
	results.m_width = width;
	results.m_height = height;
	results.m_origsize = width*height*3;

	// calculate compression, etc.
	// compression is irrelevant for our purposes

	//results.m_compsize = compsize;
	//results.m_compratio = (double)results.m_origsize/(double)compsize;
	results.m_compsize = results.m_origsize;
	results.m_compratio = 1.0f;

	// Load image onto window
	displayimage(image,width,height,imghandle,stretch);

	results.CComputeResults(originalimage, image, width, height, &mse, &psnr);
	if(showresults == TRUE)
		results.DoModal();
}


//OnSearchImageY1()
//Logic for Search Current Image option
//Only applies transform to Y, doesn't do
//anything special about quantization

void CGAwaveletApp::OnSearchImageY1()
{
	CResults results;
	HWND hWnd;
	double mse, psnr;
	int i;
	if(imageCount == 0)
	{
		MessageBox(NULL,"No image to search loaded","File Save ERROR",MB_ICONEXCLAMATION);
		return;
	}
	if(!transformLoaded)
	{
		MessageBox(NULL,"No transform with which to search loaded","File Save ERROR",MB_ICONEXCLAMATION);
		return;
	}
	for(i = 0; i < 25; i++)
	{
		theWavelet.CWaveletTransform(U[imageCount - 1],width>>1,height>>1);
		theWavelet.CWaveletTransform(V[imageCount - 1],width>>1,height>>1);
		theWavelet.CWaveletTransform(Y[imageCount - 1],width,height);


		theWavelet.CQuantizeCoefficients(Y[imageCount - 1],width,height,stepsize,threshold);
		theWavelet.CQuantizeCoefficients(U[imageCount - 1],width>>1,height>>1,stepsize,threshold);
		theWavelet.CQuantizeCoefficients(V[imageCount - 1],width>>1,height>>1,stepsize,threshold);

		theWavelet.CDequantizeCoefficients(Y[imageCount - 1],width,height,stepsize);
		theWavelet.CDequantizeCoefficients(U[imageCount - 1],width>>1,height>>1,stepsize);
		theWavelet.CDequantizeCoefficients(V[imageCount - 1],width>>1,height>>1,stepsize);

		theWavelet.CWaveletInverseTransformTarget(Y,width,height, imageCount);
		theWavelet.CWaveletInverseTransformTarget(U,width>>1,height>>1,imageCount);
		theWavelet.CWaveletInverseTransformTarget(V,width>>1,height>>1,imageCount);
	}
	// Get the window handle
	hWnd = GetActiveWindow();
	// Convert Luminance to color for display
	yuv_to_rgb(Y[imageCount-1], U[imageCount-1], V[imageCount-1], image, width, height);
	// Load image onto window
	displayimage(image,width,height,imghandle,stretch);

	if(showresults == TRUE)
	{
		results.CComputeResults(originalimage, image, width, height, &mse, &psnr);
		results.DoModal();
	}
}

//OnSearchImageY2()
//Logic for Search Current Image option
//Only applies transform to Y, only applies
//quantization once

void CGAwaveletApp::OnSearchImageY2()
{
	CResults results;
	HWND hWnd;
	double mse, psnr;
	int i;
	if(imageCount == 0)
	{
		MessageBox(NULL,"No image to search loaded","File Save ERROR",MB_ICONEXCLAMATION);
		return;
	}
	if(!transformLoaded)
	{
		MessageBox(NULL,"No transform with which to search loaded","File Save ERROR",MB_ICONEXCLAMATION);
		return;
	}
	for(i = 0; i < 25; i++)
	{
		theWavelet.CWaveletTransform(Y[imageCount - 1],width,height);
	}

	theWavelet.CQuantizeCoefficients(Y[imageCount - 1],width,height,stepsize,threshold);
	theWavelet.CDequantizeCoefficients(Y[imageCount - 1],width,height,stepsize);

	for(i = 0; i < 25; i++)
	{
		theWavelet.CWaveletInverseTransformTarget(Y,width,height, imageCount);
	}

	// Get the window handle
	hWnd = GetActiveWindow();
	// Convert Luminance to color for display
	yuv_to_rgb(Y[imageCount-1], U[imageCount-1], V[imageCount-1], image, width, height);
	// Load image onto window
	displayimage(image,width,height,imghandle,stretch);

	if(showresults == TRUE)
	{
		results.CComputeResults(originalimage, image, width, height, &mse, &psnr);
		results.DoModal();
	}
}

//OnSearchImageYUV1()
//Logic for Search Current Image option
//Applies transform to Y,U,and V. Doesn't do
//anything special about quantization

void CGAwaveletApp::OnSearchImageYUV1()
{
	CResults results;
	HWND hWnd;
	double mse, psnr;
	int i;
	if(imageCount == 0)
	{
		MessageBox(NULL,"No image to search loaded","File Save ERROR",MB_ICONEXCLAMATION);
		return;
	}
	if(!transformLoaded)
	{
		MessageBox(NULL,"No transform with which to search loaded","File Save ERROR",MB_ICONEXCLAMATION);
		return;
	}
	for(i = 0; i < 25; i++)
	{
		theWavelet.CWaveletTransform(U[imageCount - 1],width>>1,height>>1);
		theWavelet.CWaveletTransform(V[imageCount - 1],width>>1,height>>1);
		theWavelet.CWaveletTransform(Y[imageCount - 1],width,height);

		theWavelet.CQuantizeCoefficients(Y[imageCount - 1],width,height,stepsize,threshold);
		theWavelet.CQuantizeCoefficients(U[imageCount - 1],width>>1,height>>1,stepsize,threshold);
		theWavelet.CQuantizeCoefficients(V[imageCount - 1],width>>1,height>>1,stepsize,threshold);

		theWavelet.CDequantizeCoefficients(Y[imageCount - 1],width,height,stepsize);
		theWavelet.CDequantizeCoefficients(U[imageCount - 1],width>>1,height>>1,stepsize);
		theWavelet.CDequantizeCoefficients(V[imageCount - 1],width>>1,height>>1,stepsize);

		theWavelet.CWaveletInverseTransformTarget(Y,width,height, imageCount);
		theWavelet.CWaveletInverseTransformTarget(U,width>>1,height>>1,imageCount);
		theWavelet.CWaveletInverseTransformTarget(V,width>>1,height>>1,imageCount);
	}

	// Get the window handle
	hWnd = GetActiveWindow();
	// Convert Luminance to color for display
	yuv_to_rgb(Y[imageCount-1], U[imageCount-1], V[imageCount-1], image, width, height);
	// Load image onto window
	displayimage(image,width,height,imghandle,stretch);

	if(showresults == TRUE)
	{
		results.CComputeResults(originalimage, image, width, height, &mse, &psnr);
		results.DoModal();
	}
}

//OnSearchImageYUV2()
//Logic for Search Current Image option
//Applies transform to Y,U, and V. Only
//quantizes once.

void CGAwaveletApp::OnSearchImageYUV2()
{
	CResults results;
	HWND hWnd;
	double mse, psnr;
	int i;
	if(imageCount == 0)
	{
		MessageBox(NULL,"No image to search loaded","File Save ERROR",MB_ICONEXCLAMATION);
		return;
	}
	if(!transformLoaded)
	{
		MessageBox(NULL,"No transform with which to search loaded","File Save ERROR",MB_ICONEXCLAMATION);
		return;
	}
	for(i = 0; i < SEARCH_ITERATIONS; i++)
	{
		theWavelet.CWaveletTransform(U[imageCount - 1],width>>1,height>>1);
		theWavelet.CWaveletTransform(V[imageCount - 1],width>>1,height>>1);
		theWavelet.CWaveletTransform(Y[imageCount - 1],width,height);
	}

	theWavelet.CQuantizeCoefficients(Y[imageCount - 1],width,height,stepsize,threshold);
	theWavelet.CQuantizeCoefficients(U[imageCount - 1],width>>1,height>>1,stepsize,threshold);
	theWavelet.CQuantizeCoefficients(V[imageCount - 1],width>>1,height>>1,stepsize,threshold);

	theWavelet.CDequantizeCoefficients(Y[imageCount - 1],width,height,stepsize);
	theWavelet.CDequantizeCoefficients(U[imageCount - 1],width>>1,height>>1,stepsize);
	theWavelet.CDequantizeCoefficients(V[imageCount - 1],width>>1,height>>1,stepsize);

	for(i = 0; i < SEARCH_ITERATIONS; i++)
	{
		theWavelet.CWaveletInverseTransformTarget(Y,width,height, imageCount);
		theWavelet.CWaveletInverseTransformTarget(U,width>>1,height>>1,imageCount);
		theWavelet.CWaveletInverseTransformTarget(V,width>>1,height>>1,imageCount);
	}

	// Get the window handle
	hWnd = GetActiveWindow();
	// Convert Luminance to color for display
	yuv_to_rgb(Y[imageCount-1], U[imageCount-1], V[imageCount-1], image, width, height);
	// Load image onto window
	displayimage(image,width,height,imghandle,stretch);

	if(showresults == TRUE)
	{
		results.CComputeResults(originalimage, image, width, height, &mse, &psnr);
		results.DoModal();
	}
}

// App command to transform / inverse transform a file
void CGAwaveletApp::OnSettings()
{
	theWavelet.DoModal();

	//get the new settings

	mrlevels = theWavelet.m_mrlevel;
	waveletnumber = theWavelet.m_waveletnumber;
	wavelettype = theWavelet.m_wavelettype;
	stepsize = theWavelet.m_stepsize;
	threshold = theWavelet.m_threshold;

	showresults = theWavelet.m_showresults;

	popsize = theWavelet.m_popsize;
	maxgen = theWavelet.m_maxgen;
	evolving = theWavelet.m_evolving;

	//update g, h to reflect new user options
	if(waveletnumber != 6)
	{
		theWavelet.CInitializeGH();
		transformLoaded = TRUE;
	}
}

void CGAwaveletApp::OnReturnOriginal()
{
	HWND hWnd;

	// Get the window handle
	hWnd = GetActiveWindow();

	if((image != NULL)&&(originalimage != NULL) && imageCount >= 1)
	{
		memcpy(image,originalimage,width*height*3*sizeof(char));
		memcpy(Y[imageCount-1],originalY[imageCount-1],width*height*sizeof(double));
		memcpy(U[imageCount-1],originalU[imageCount-1],(width>>1)*(height>>1)*sizeof(double));
		memcpy(V[imageCount-1],originalV[imageCount-1],(width>>1)*(height>>1)*sizeof(double));

		//changing this seems to fix the issue of broken MSEs after image reversion
		//rgb_to_yuv(image,Y[imageCount-1],U[imageCount-1],V[imageCount-1],width,height);
		yuv_to_rgb(Y[imageCount-1], U[imageCount-1], V[imageCount-1], image, width, height);

		// Load image onto window
		displayimage(image,width,height,imghandle,stretch);
		// Dislay File Name on Window;
		SetWindowText(hWnd,originalFileName);
	}
}

// App command to run the dialog
void CGAwaveletApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CGAwaveletApp message handlers

