<?php
/*
Copyright (C) 2004  Brian J. Mullen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
include_once("header.inc.php");

if($type_login != 2) {
	echo("You are not allowed to modify the database in this way");
	exit();
}

//create entries
$createDatabase_sql = "CREATE DATABASE IF NOT EXISTS $database_name;";

$selectDatabase_sql = "USE $database_name;";

//Collections Keeper required tables
$user_info_sql = "CREATE TABLE user_info (
  user_info_id int(10) unsigned NOT NULL auto_increment,
  lname varchar(255) NOT NULL default '',
  fname varchar(255) NOT NULL default '',
  mname varchar(255) NOT NULL default '',
  email varchar(255) NOT NULL default '',
  phone varchar(35) NOT NULL default '',
  icq varchar(20) NOT NULL default '',
  username varchar(20) NOT NULL default '',
  pass varchar(100) NOT NULL default '',
  joindate int NOT NULL default '0',
  num_entries int NOT NULL default '30',
  PRIMARY KEY (user_info_id),
  UNIQUE KEY (username)
);";

$user_settings_sql = "CREATE TABLE user_settings (
  user_info_id int(10) unsigned NOT NULL default '0',
  admin tinyint(1) unsigned NOT NULL default '0',
  privileged tinyint(1) unsigned NOT NULL default '0',
  active tinyint(1) unsigned NOT NULL default '0',
  KEY user_info (user_info_id)
);";

$session_settings_sql = "CREATE TABLE session_settings (
  user_info_id int(10) unsigned NOT NULL default '0',
  ip varchar(16) NOT NULL default '',
  last_access int(20) unsigned NOT NULL default '0',
  KEY user_info (user_info_id)
);";

//permission here is 1 for admin, 2 for priviliged, 3 for anonymous
$sql_bookmark_sql = "CREATE TABLE sql_bookmark (
  sql_bookmark_id int(10) unsigned NOT NULL default '0' auto_increment,
  name varchar(255) NOT NULL default '',
  query text NOT NULL default '',
  permission tinyint(1) unsigned NOT NULL default '1',
  PRIMARY KEY(sql_bookmark_id)
);";

$priTables_sql = "CREATE TABLE pri_tables (
  pri_tables_id int(10) unsigned NOT NULL default '0' auto_increment,
  name varchar(255) NOT NULL default '',
  key_name varchar(255) NOT NULL default '',
  order_by varchar(255) NOT NULL default '',
  PRIMARY KEY(pri_tables_id)
);";

$subTables_sql = "CREATE TABLE sub_tables (
  sub_tables_id int(10) unsigned NOT NULL default '0' auto_increment,
  name varchar(255) NOT NULL default '',
  key_name varchar(255) NOT NULL default '',
  order_by varchar(255) NOT NULL default '',
  PRIMARY KEY(sub_tables_id)
);";

$file_sql = "CREATE TABLE file (
  file_id INT(4) unsigned NOT NULL auto_increment,
  th_bin_data LONGBLOB NOT NULL default '',
  bin_data LONGBLOB NOT NULL default '',
  filename CHAR(50) NOT NULL default '',
  filesize CHAR(50) NOT NULL default '',
  filetype CHAR(50) NOT NULL default '',
  PRIMARY KEY (file_id)
);";

//Collections Keeper default data
$manufacturer_sql = "CREATE TABLE manufacturer (
  manufacturer_id int(10) unsigned NOT NULL auto_increment,
  name varchar(255) NOT NULL default '',
  address1 varchar(255) NOT NULL default '',
  address2 varchar(255) NOT NULL default '',
  city varchar(100) NOT NULL default '',
  state varchar(55) NOT NULL default '',
  zip varchar(12) NOT NULL default '',
  phone varchar(20) NOT NULL default '',
  PRIMARY KEY (manufacturer_id)
);";

$condition_sql = "CREATE TABLE condition (
  condition_id int(10) unsigned NOT NULL auto_increment,
  condition varchar(55) NOT NULL default '',
  PRIMARY KEY (condition_id)
);";

$lunch_box_sql = "CREATE TABLE lunch_box (
  lunch_box_id int(10) unsigned NOT NULL auto_increment,
  user_info_id int(10) unsigned NOT NULL default '0',
  condition_id int(10) unsigned NOT NULL default '0',
  manufacturer_id int(10) unsigned NOT NULL default '0',
  file_id int(10) unsigned NOT NULL default '0',
  name varchar(255) NOT NULL default '',
  material varchar(255) NOT NULL default '',
  number varchar(100) NOT NULL default '',
  variance varchar(55) NOT NULL default '',
  thermos varchar(255) NOT NULL default '',
  year year NOT NULL default '0000',
  date_acquired date NOT NULL default '0000-00-00',
  quantity int(10) unsigned NOT NULL default '0',
  value float NOT NULL default '0',
  comments text NOT NULL default '',
  PRIMARY KEY (lunch_box_id),
  INDEX user_info (user_info_id),
  INDEX condition (condition_id),
  INDEX manufacturer (manufacturer_id),
  INDEX file (file_id)
);";

$sports_card_sql = "CREATE TABLE sports_card (
  sports_card_id int(10) unsigned NOT NULL auto_increment,
  user_info_id int(10) unsigned NOT NULL default '0',
  condition_id int(10) unsigned NOT NULL default '0',
  manufacturer_id int(10) unsigned NOT NULL default '0',
  file_id int(10) unsigned NOT NULL default '0',
  name varchar(255) NOT NULL default '',
  sport varchar(255) NOT NULL default '',
  team varchar(255) NOT NULL default '',
  year varchar(255) NOT NULL default '',
  date_acquired date NOT NULL default '',
  number varchar(55) NOT NULL default '',
  variance varchar(55) NOT NULL default '0',
  quantity int(10) unsigned NOT NULL default '0',
  value float NOT NULL default '0',
  comments text NOT NULL default '',
  PRIMARY KEY (sports_card_id),
  INDEX user_info (user_info_id),
  INDEX condition (condition_id),
  INDEX manufacturer (manufacturer_id),
  INDEX file (file_id)
);";

$comic_sql = "CREATE TABLE comic (
  comic_id int(10) unsigned NOT NULL auto_increment,
  user_info_id int(10) unsigned NOT NULL default '0',
  condition_id int(10) unsigned NOT NULL default '0',
  manufacturer_id int(10) unsigned NOT NULL default '0',
  file_id int(10) unsigned NOT NULL default '0',
  name varchar(255) NOT NULL default '',
  date date NOT NULL default '0000-00-00',
  date_acquired date NOT NULL default '0000-00-00',
  number int(10) unsigned NOT NULL default '0',
  variance varchar(100) NOT NULL default '',
  value float NOT NULL default '0',
  quantity int(10) unsigned NOT NULL default '0',
  comments text NOT NULL default '',
  PRIMARY KEY (comic_id),
  INDEX user_info (user_info_id),
  INDEX condition (condition_id),
  INDEX manufacturer (manufacturer_id),
  INDEX file (file_id)
);";

//start creating database and tables

echo"Making collection keeper database...";
if (!mysql_query($createDatabase_sql)) {
	echo ("<b>Database not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error());
	echo ("<br>");
} else {
	echo ("<b>Database successfully created</b><br>");
	mysql_query($selectDatabase_sql);
	//mysql_select_db($database_name);
}
//drop all existing tables
$query = "SHOW TABLES";
$result = mysql_query($query);
while($table_info = mysql_fetch_array($result)) mysql_query("DROP TABLE " . $table_info[0]);

echo"Creating User Info table...";
if (!mysql_query($user_info_sql)) {
	echo"<b>Table not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();
	echo"<br>";
}
else {
	echo"<b>Table successfully created</b><br>";
}

echo"Creating User Settings table...";
if (!mysql_query($user_settings_sql)) {
	echo"<b>Table not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();
	echo"<br>";
}
else {
	echo"<b>Table successfully created</b><br>";
}

echo"Creating Session Settings table...";
if (!mysql_query($session_settings_sql)) {
	echo"<b>Table not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();
	echo"<br>";
}
else {
	echo"<b>Table successfully created</b><br>";
}

echo"Creating SQL bookmark table...";
if (!mysql_query($sql_bookmark_sql)) {
	echo"<b>Table not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();
	echo"<br>";
}
else {
	echo"<b>Table successfully created</b><br>";
}

echo"Creating Primary Tables table...";
if (!mysql_query($priTables_sql)) {
	echo"<b>Table not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();
	echo"<br>";
}
else {
	echo"<b>Table successfully created</b><br>";
}

echo"Creating SubTables table...";
if (!mysql_query($subTables_sql)) {
	echo"<b>Table not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();
	echo"<br>";
}
else {
	echo"<b>Table successfully created</b><br>";
}

echo"Creating Manufacturer table...";
if (!mysql_query($manufacturer_sql)) {
	echo"<b>Table not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();
	echo"<br>";
}
else {
	echo"<b>Table successfully created</b><br>";
}

echo"Creating Condition table...";
if (!mysql_query($condition_sql)) {
	echo"<b>Table not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();
	echo"<br>";
}
else {
	echo"<b>Table successfully created</b><br>";
}

echo"Creating file table...";
if (!mysql_query($file_sql)) {
	echo"<b>Table not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();
	echo"<br>";
}
else {
	echo"<b>Table successfully created</b><br>";
}
echo"Creating Lunch Box table...";
if (!mysql_query($lunch_box_sql)) {
	echo"<b>Table not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();
	echo"<br>";
}
else {
	echo"<b>Table successfully created</b><br>";
}

echo"Creating Sports Card table...";
if (!mysql_query($sports_card_sql)) {
	echo"<b>Table not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();
	echo"<br>";
}
else {
	echo"<b>Table successfully created</b><br>";
}

echo"Creating Comic table...";
if (!mysql_query($comic_sql)) {
	echo"<b>Table not created.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();
	echo"<br>";
}
else {
	echo"<b>Table successfully created</b><br>";
}

echo"<br>Inserting Values ...";
echo"<br>Inserting Values For User Info...";

mysql_query("INSERT INTO user_info VALUES (1, 'Admin', 'User', 'A', 'name@localhost.com', '907-555-1111', '', 'admin', 'admin', '1072800000', '30');");
mysql_query("INSERT INTO user_info VALUES (2, 'Smith', 'Bob', 'U', 'smithbu@asdf.com', '907-555-1211', '', 'smithy', 'pass', '1072800000', '30');");
mysql_query("INSERT INTO user_info VALUES (3, 'Brown', 'Chris', 'K', 'dog@aol.com', '408-555-1211', '', 'dadog', 'pass', '107280000', '30');");
echo"<br><b>Data successfully Inserted</b>";

echo"<p>Inserting Values For User Settings...";
mysql_query("INSERT INTO user_settings VALUES (1, 1, 1, 1);");  //admin account
for ($i = 2; $i <= 3; $i++) {
	$insertUserSettings_sql = "INSERT INTO user_settings VALUES ($i, 0, 1, 1);";
	if (!mysql_query($insertUserSettings_sql)) {
		echo"<b>Data not Inserted.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();
		echo"<br>";
	}
	else {
		echo"<br><b>Data successfully Inserted</b>";
	}
}

echo"<p>Inserting Values For Session Settings...";
mysql_query("INSERT INTO session_settings VALUES (1, 0, 0);");  //admin account //lifetime = 0 = never timeout
for ($i = 2; $i <= 3; $i++) {
	$insertSessionSettings_sql = "INSERT INTO session_settings VALUES ($i, 0, 0);"; //lifetime (in secs)
	if (!mysql_query($insertSessionSettings_sql)) {
		echo"<b>Data not Inserted.</b><br>MySQL Error: ".mysql_errno()." -> ".mysql_error();
		echo"<br>";
	}
	else {
		echo"<br><b>Data successfully Inserted</b>";
	}
}

echo"<p>Inserting Values For Manufacturer...";
mysql_query("INSERT INTO manufacturer VALUES (1, 'Aladdin Inc', 'P.O. Box 100960', '', 'Nashville', 'TN', '37224', '1-800-251-4535');");
mysql_query("INSERT INTO manufacturer VALUES (2, 'The Thermos Company', '300 N. Martingale Road, Suite 200', '', 'Schaumburg', 'IL', '60173', '1-800-831-9242');");
mysql_query("INSERT INTO manufacturer VALUES (3, 'Marvel', '10 East 40th St.', '', 'New York', 'NY', '10016', '1-800-217-9158');");
mysql_query("INSERT INTO manufacturer VALUES (4, 'DC Comics', '1700 Broadway', '', 'New York', 'NY', '10019', '');");
mysql_query("INSERT INTO manufacturer VALUES (5, 'Topps', 'One Whitehall Street', '', 'New York', 'NY', '10004', '212-376-0300');");
mysql_query("INSERT INTO manufacturer VALUES (6, 'Fleer/Skybox', '1120 Route 73 South', 'Suite 300', 'Mount Laurel', 'NJ', '08054', '1-800-343-6816');");
echo"<br><b>Data successfully Inserted</b>";

echo"<p>Inserting Values For Condition...";
mysql_query("INSERT INTO condition VALUES (1, 'MINT');");
mysql_query("INSERT INTO condition VALUES (2, 'MINT -');");
mysql_query("INSERT INTO condition VALUES (3, 'NEAR MINT +');");
mysql_query("INSERT INTO condition VALUES (4, 'NEAR MINT');");
mysql_query("INSERT INTO condition VALUES (5, 'NEAR MINT -');");
mysql_query("INSERT INTO condition VALUES (6, 'VERY FINE/NEAR MINT');");
mysql_query("INSERT INTO condition VALUES (7, 'VERY FINE +');");
mysql_query("INSERT INTO condition VALUES (8, 'VERY FINE');");
mysql_query("INSERT INTO condition VALUES (9, 'VERY FINE -');");
mysql_query("INSERT INTO condition VALUES (10, 'FINE/VERY FINE');");
mysql_query("INSERT INTO condition VALUES (11, 'FINE +');");
mysql_query("INSERT INTO condition VALUES (12, 'FINE');");
mysql_query("INSERT INTO condition VALUES (13, 'FINE -');");
mysql_query("INSERT INTO condition VALUES (14, 'VERY GOOD/FINE');");
mysql_query("INSERT INTO condition VALUES (15, 'VERY GOOD +');");
mysql_query("INSERT INTO condition VALUES (16, 'VERY GOOD');");
mysql_query("INSERT INTO condition VALUES (17, 'VERY GOOD -');");
mysql_query("INSERT INTO condition VALUES (18, 'GOOD/VERY GOOD');");
mysql_query("INSERT INTO condition VALUES (19, 'GOOD +');");
mysql_query("INSERT INTO condition VALUES (20, 'GOOD');");
mysql_query("INSERT INTO condition VALUES (21, 'FAIR/GOOD');");
mysql_query("INSERT INTO condition VALUES (22, 'FAIR');");
mysql_query("INSERT INTO condition VALUES (23, 'POOR');");
echo"<br><b>Data successfully Inserted</b>";

echo"<p>Inserting Values For Lunch Box...";
mysql_query("INSERT INTO lunch_box VALUES (1, 2, 12, 1, 0, 'Orginal Star Trek Lunch Box', 'metal', '', '', 'metal thermos present', '1968', '2000-04-12', 1, 20, 'minor rusting on edges and partial wear on bottom');");
mysql_query("INSERT INTO lunch_box VALUES (2, 2, 1, 2, 0, 'Pokemon', 'nylon, padded', 'AD-332D', '', 'has plastic thermos', '2001', '2002-01-02', 1, 9.99, 'new');");
mysql_query("INSERT INTO lunch_box VALUES (3, 2, 8, 2, 0, 'GI Joe', 'plastic', '', 'A', 'plastic thermos with scratches', '1986', '1999-10-01', 1, 12.50, 'I had this one back in elementary school, its good to get another one');");
mysql_query("INSERT INTO lunch_box VALUES (4, 2, 7, 3, 0, 'Spiderman', 'plastic', '', 'Spidey in black, variance B?', 'no thermos', '1999', '', 1, 4.95, 'minor scratches');");
mysql_query("INSERT INTO lunch_box VALUES (5, 3, 20, 4, 0, 'Superman', 'plastic', '', '', 'thermos present', '1984', '1999-10-22', 1, 15, 'crack on bottom');");
mysql_query("INSERT INTO lunch_box VALUES (6, 3, 4, 1, 0, 'Brady Bunch', 'metal', 'FA-112-AC', '', 'metal thermos present', '1978', '1999-05-12', 1, 99, 'minor rusting and partial wear on back');");
mysql_query("INSERT INTO lunch_box VALUES (7, 3, 19, 1, 0, 'Roy Rogers', 'metal', '', '', 'no thermos', '1954', '1969-01-12', 1, 75, 'rusting on front');");
mysql_query("INSERT INTO lunch_box VALUES (8, 3, 4, 2, 0, 'Transformers RiD', 'nylon, padded', '', '', 'plastic thermos', '2001', '2002-03-14', 1, 5.99, 'new');");
echo"<br><b>Data successfully Inserted</b>";

echo"<p>Inserting Values For Sports Card...";
mysql_query("INSERT INTO sports_card VALUES (1, 1, 1, 5, 0, 'Barry Bonds rookie', 'baseball', 'Pirates', '1986', '2002-03-14', '11T', '', 1, 400, 'BCCG rated mint, SN: 00000043221');");
mysql_query("INSERT INTO sports_card VALUES (2, 1, 5, 6, 0, 'Special Force Michael Jordan', 'Basketball', 'Wizards', '01-02', '2002-04-02', '2', 'd', 1, 100, 'First wizards card for Jordan');");
mysql_query("INSERT INTO sports_card VALUES (3, 1, 20, 5, 0, 'Legenary Cut Auto Harvey', 'Hockey', 'Mapel Leafs', '01-02', '2001-10-22', '#1/5', '', 1, 60, 'Autographed card with COA on front');");
mysql_query("INSERT INTO sports_card VALUES (4, 1, 4, 6, 0, 'Tiger Woods rookie', 'Golf', '', '1996', '1999-06-30', '536', '', 1, 15100, 'How sweet it is!');");
mysql_query("INSERT INTO sports_card VALUES (5, 3, 15, 5, 0, 'Mickey Mantle', 'Baseball', 'Yankees', '1958', '1999-05-12', '150', '', 1, 250, 'Prime card with minor gum residue on front');");
mysql_query("INSERT INTO sports_card VALUES (6, 3, 9, 5, 0, 'H. Verify', 'Cricket', 'Three swords', '1938', '1972-04-24', 'C', '', 1, 15, 'came with Players Cigarettes');");
mysql_query("INSERT INTO sports_card VALUES (7, 3, 23, 6, 0, 'Owen Nolan', 'Hockey', 'San Jose Sharks', '00-01', '2000-12-25', '158/375', '', 1, 5.95, 'Team Foundations card');");
mysql_query("INSERT INTO sports_card VALUES (8, 3, 12, 6, 0, 'Jeff Gordon', 'Racing', 'Team Du Pont', '1998', '1999-09-09', '74', '', 1, 12.75, 'MAXXIMUM IRON CLAD card');");
echo"<br><b>Data successfully Inserted</b>";

echo"<p>Inserting Values For Comic...";
mysql_query("INSERT INTO comic VALUES (1, 1, 4, 3, 0, 'Xmen', '1992-01-02', '1994-02-01', 100, 'A', 3.95, 1, 'This comic book is awesome');");
mysql_query("INSERT INTO comic VALUES (2, 1, 2, 3, 0, 'Hulk', '1986-11-16', '1992-06-12', 3, '', 2.95, 2, 'This is the issue where he becomes the grey hulk');");
mysql_query("INSERT INTO comic VALUES (3, 1, 1, 4, 0, 'Superman', '1965-07-04', '1994-02-01', 6, '', 55.00, 1, 'This comic book is awesome');");
mysql_query("INSERT INTO comic VALUES (4, 1, 18, 4, 0, 'Batman', '1956-03-24', '2001-10-22', 45, '', 26.00, 3, 'All three books have minor spine folding');");
mysql_query("INSERT INTO comic VALUES (5, 2, 10, 3, 0, 'Spiderman', '1998-10-02', '1989-03-01', 174, 'Dynamic Forces 1A', 12.50, 1, 'Has certificate of authenticity');");
mysql_query("INSERT INTO comic VALUES (6, 2, 3, 3, 0, 'Wolverine', '1990-07-02', '1997-01-01', 1, '', 1.25, 1, 'He looses his admantium.');");
mysql_query("INSERT INTO comic VALUES (7, 2, 5, 4, 0, 'Green Lantern', '1991-04-02', '1994-02-01', 95, 'B', 0.25, 1, 'Elseworlds issue');");
mysql_query("INSERT INTO comic VALUES (8, 2, 14, 5, 0, 'Donald Duck and his Nephews', '1974-09-02', '1994-02-10', 14, '', 10.75, 1, 'Book currently on sale at ebay');");
echo"<br><b>Data successfully Inserted</b>";

echo"<P>Inserting Values For Primary Tables...";
mysql_query("INSERT INTO pri_tables VALUES(1, 'comic', 'comic_id', ' ORDER BY user_info_id, name, number, variance, value');");
mysql_query("INSERT INTO pri_tables VALUES(2, 'sports_card', 'sports_card_id', '');");
mysql_query("INSERT INTO pri_tables VALUES(3, 'lunch_box', 'lunch_box_id', '');");
echo"<BR><B>Data successfully Inserted</B>";

echo"<P>Inserting Values For SubTables...";
mysql_query("INSERT INTO sub_tables VALUES(1, 'condition', 'condition_id', '');");
mysql_query("INSERT INTO sub_tables VALUES(2, 'manufacturer', 'manufacturer_id', '');");
echo"<BR><B>Data successfully Inserted</B>";

echo"<p><b>Install complete!.</b>";
include("footer.inc.php");
?>
