<?php
/*
Copyright (C) 2004  Brian J. Mullen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
include_once("header.inc.php");

if ($type_login != 2) {
	echo ("You may not create new collection tables");
	exit();
}
?>
<H2>Create a new collection table</H2>
<?php

//get the needed values for the subTables
$subTable = get_tables(2);

if (isset($_POST['submit'])) {

	$coll_name = $_POST['coll_name'];
	$num_fields = $_POST['num_fields'];
	$table_type = $_POST['table_type'];
	$field = $_POST['field'];
	$field_type = $_POST['field_type'];
	$file_id = $_POST['file_id'];
	$order = $_POST['order'];
	$order_desc = $_POST['order_desc'];

	if(!$coll_name) {
		echo ("The table must have a name.");
		echo ("<BR>Please use your back button and enter one.");
		exit();
	}

	$coll_name = ereg_replace (" ", "_", $coll_name);

	$pri_key_name = $coll_name . "_id";
	$new_coll_sql = "CREATE TABLE $coll_name (";
	$new_coll_sql .= "$pri_key_name int(10) unsigned NOT NULL auto_increment, ";
	//if this is a collection table then we have to include the user id
	if ($table_type == 1) {
		$new_coll_sql .= "user_info_id int(10) unsigned NOT NULL default '0', ";
		$new_coll_sql .= "INDEX user_info (user_info_id), ";
	}

	//this for loop is what sets up the subtables and puts them in as a key
  	for($i = 0; $i < count($subTable); $i++) {
  		if ($_POST[$subTable[$i][key]] == 1) {
  			$new_coll_sql .= "{$subTable[$i][key]} int(10) unsigned NOT NULL default '0', ";
  			$new_coll_sql .= "INDEX {$subTable[$i][name]} ({$subTable[$i][key]}), ";
  		}
  	}

	if ($file_id == 1) {
		$new_coll_sql .= "file_id int(10) unsigned NOT NULL default '0', ";
		$new_coll_sql .= "INDEX file(file_id), ";
	}
	$order_by = array();
  	for ($i = 0; $i < $num_fields; $i++) {
  		if ($field[$i]) {
  			if ($field_type[$i] == "int(10)" || $field_type[$i] == "float")
  				$default = "default '0'";
  			elseif ($field_type[$i] == "date")
  				$default = "default '0000-00-00'";
  			elseif ($field_type[$i] == "year")
  				$default = "default '0000'";
  			else
  				$default = "default ''";

			//make sure we replace spaces with underscores
  			$field[$i] = ereg_replace (" ", "_", $field[$i]);

  			$new_coll_sql .= "$field[$i] $field_type[$i] NOT NULL $default, ";
  			
  			//set up the order by info into the array
  			//if($order[$i][0] == 'd') $order_by[(substr($order[$i], 1))] = "$field[$i] DESC"; 
  			//else $order_by[$order[$i]] = "$field[$i]";
  			$order_by[$order[$i]] = "$field[$i]";
  			if(isset($order_desc[$i])) $order_by[$order[$i]] .= " DESC";
  		}
  	}
	//sort the array so it is in order
	ksort($order_by);
  	//and built the string for the order by
  	//we need the space infront of "ORDER" because this is just grabbed 
  	//and directly tacked onto the end of any query
  	if($table_type == 1) $order = " ORDER BY user_info_id";
  	else $order = "";
  	//here we have to go one extra since 0 is added to mean don't sort on
  	for($i = 1; $i <= $num_fields; $i++) {
  		if($order != "" && isset($order_by[$i])) {
  			$order .= ", " . $order_by[$i];
  		}
  		elseif($order == "" && isset($order_by[$i])) {
  			$order = " ORDER BY " . $order_by[$i];
  		}
  	}
  	echo("<BR>order string: $order");
	$new_coll_sql .= "PRIMARY KEY ($pri_key_name) ";
  	$new_coll_sql .= ");";

	if (mysql_query($new_coll_sql))
  		echo ($new_coll_sql);

  	else {
    	echo("<P>Error Creating Table: " . mysql_error() . "</P>");
    	echo("Please use your back button to fix the error.");
    	exit();
    }

    //update info in the appropriate table
	if ($table_type == 1) $table_name = "pri_tables";
	else $table_name = "sub_tables";
	$query = "INSERT INTO $table_name (name, key_name, order_by) VALUES ('$coll_name', '$pri_key_name', '$order')";
	if(mysql_query($query))
		echo ("<P>Added $coll_name to the tables");
	else {
		echo ("<P> There was an error attempting to add the table");
		echo ("<BR> " . mysql_error());
		exit();
	}

}

else {

	$action = $_GET['action'];

	if ($action == "") {
	    ?>
	    <P>Pick a number greater then the number of fields you will need.
	    <BR>For the sake of speed and the database I would recommend no greater then 20 fields.
	    <BR>Any field left blank will not be included in the final collection.
	    <BR><select name="num_fields" onchange="window.location=('<?php echo ($_SERVER['PHP_SELF']);?>?action=create&num_fields='+this.options[this.selectedIndex].value)">
	    <OPTION SELECTED VALUE="">Pick an amount:
	    <?php
	    for ($i = 10; $i <= 100; $i += 10) {
	    	echo("<OPTION VALUE='$i'>$i\n");
	    }
	    ?>
	    </select></p>
	    <?php
	}

	else {
		$num_fields = $_GET['num_fields'];
		?>
		<FORM ACTION="<?php echo($_SERVER['PHP_SELF']); ?>" METHOD=POST enctype="multipart/form-data">
		<?php
		echo ("$num_fields fields have been selected<BR>");
		?>
		<P>Collection Name:
		<INPUT TYPE=TEXT NAME=coll_name>
		<BR>Is this a collection table or a sub-table?
		<BR><input type = radio name = table_type value = "1" checked> Collection Table
		<input type = radio name = table_type value = "0"> Sub-table
		<P>Mandatory Fields: These are generated when the form is submitted.
		<BR><B>Do not include these in the creation of your collection.</B>
		<BR>Primary Key = Generated from Collection Name
		<BR>user_info_id =  User ID, owner of the collection entry (Only included in Collection Tables)
		<P>Which sub-tables would you like to include?
		<?php
		for ($i = 0; $i < count($subTable); $i++) {
			echo ("<BR>{$subTable[$i][name]}\n");
			echo ("<BR><input type = \"radio\" name = \"{$subTable[$i][key]}\" value = \"1\" checked> Yes\n");
			echo ("<input type = \"radio\" name = \"{$subTable[$i][key]}\" value = \"0\"> No\n");
		}
		//Because of the special nature of the file table it is not
		//included with other subtables.  Thus its inclusion here.
		if($allow_files == 1) {
		?>
		<BR>file
			<BR>
      <input type="radio" name="file_id" value="1" checked> Yes
    	<input type="radio" name="file_id" value="0"> No
  	<?php
  	}
  	?>
		<P>
		<TABLE BORDER=1>
		<TR>
		<TH>Field Name</TH>
		<TH>Field Type</TH>
		<TH>Sort order</TH>
		</TR>
		<?php
		for ($i = 0; $i < $num_fields; $i++) {
			echo ("\n<TR><TD><INPUT TYPE=TEXT NAME=field[$i]></TD>\n");
			echo ("<TD><SELECT NAME=field_type[$i] SIZE=1>");
			echo ("<OPTION VALUE=varchar(255)>Text (Any letters, single line)\n");
			echo ("<OPTION VALUE=text>Memo (Any letters, multiple lines)\n");
			echo ("<OPTION VALUE=int>Integer (Any whole numbers: 3, 49)\n");
			echo ("<OPTION VALUE=float>Decimal (Any decimal numbers: 1.50, 2.3)\n");
			echo ("<OPTION VALUE=date>Date (YYYY-MM-DD format)\n");
			echo ("<OPTION VALUE=year>Year (YYYY format)\n");
			echo ("</SELECT></TD>\n");
			echo ("\n<TD><SELECT NAME=order[$i]>\n");
			echo ("<OPTION VALUE=0>Don't sort on this field\n");
			for($j = 0; $j < $num_fields; $j++) {
				//get the number suffix
				$num_suf = "";
				switch($j + 1) {
					case 1:
						$num_suf = "st";
						break;
					case 2:
						$num_suf = "nd";
						break;
					case 3:
						$num_suf = "rd";
						break;
					default:
						$num_suf = "th";
				}					
				echo ("<OPTION VALUE=" . ($j + 1) . ">Sort on this " . ($j + 1) . "$num_suf\n");
				//echo ("<OPTION VALUE=d" . ($j + 1) . ">Sort on this " . ($j + 1) . "$num_suf decending\n");
			}
			echo("<INPUT TYPE=checkbox NAME=order_desc[$i]>Descending");
			echo("</TD></TR>");
		}
		?> </TABLE>
		<?php
		echo ("<INPUT TYPE=hidden name=num_fields value=$num_fields>");
		echo ("<center><INPUT TYPE=SUBMIT NAME=submit VALUE=Submit></center>");
		echo ("</FORM>");

	}
}
include("footer.inc.php");
?>
